/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cms.content;

import at.grid.cms.CmsApplication;
import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsUser;
import java.util.HashMap;
import java.util.List;

public class ElementCache {
    HashMap<String, HashMap<Long, CmsElement>> cache = new HashMap();
    boolean enabled = false;
    CmsApplication app;

    public ElementCache(CmsApplication app) {
        this.app = app;
    }

    public HashMap<Long, CmsElement> getUserCache(CmsUser user) {
        return this.cache.getOrDefault(user.getUsername(), new HashMap());
    }

    public void putUserCache(CmsUser user, HashMap<Long, CmsElement> usercache) {
        this.cache.put(user.getUsername(), usercache);
    }

    public void putUserCache(String username, HashMap<Long, CmsElement> usercache) {
        this.cache.put(username, usercache);
    }

    public CmsElement loadElement(long id, String lang, String elementtype, CmsUser user) {
        CmsElement e = null;
        HashMap<Long, CmsElement> usercache = null;
        if (this.enabled) {
            usercache = this.getUserCache(user);
            e = usercache.get(id);
        }
        if (e == null) {
            e = this.app.createElementWithoutId(elementtype, user);
            e.load(id, lang, true, user);
        }
        if (this.enabled) {
            usercache.put(id, e);
            this.putUserCache(user, usercache);
        }
        return e;
    }

    public void updateCache(long id, CmsElement e) {
        if (this.enabled) {
            for (String username : this.cache.keySet()) {
                HashMap<Long, CmsElement> usercache = this.cache.get(username);
                usercache.put(id, e);
                this.putUserCache(username, usercache);
            }
        }
    }

    public void clear() {
        this.cache.clear();
    }

    public void clear(CmsUser user) {
        HashMap<Long, CmsElement> usercache = this.cache.get(user.getUsername());
        if (usercache != null) {
            usercache.clear();
            this.putUserCache(user, usercache);
        }
    }

    public void removeElement(long id) {
        if (this.enabled) {
            for (String username : this.cache.keySet()) {
                HashMap<Long, CmsElement> usercache = this.cache.get(username);
                usercache.remove(id);
                this.putUserCache(username, usercache);
            }
        }
    }

    public void removeElement(List<Long> ids) {
        if (this.enabled && ids != null) {
            for (String username : this.cache.keySet()) {
                HashMap<Long, CmsElement> usercache = this.cache.get(username);
                for (long id : ids) {
                    usercache.remove(id);
                }
                this.putUserCache(username, usercache);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("GRID-ontology cache\n");
        for (String username : this.cache.keySet()) {
            sb.append("- ").append(username).append(": " + this.cache.get(username).size()).append("\n");
        }
        return sb.toString();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

