/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cms.content;

import at.grid.cms.CmsApplication;
import at.grid.cms.content.KeytableRecord;
import at.grid.cms.storage.DataRecord;
import at.grid.cms.storage.SearchResult;
import at.grid.util.Util;
import java.awt.Color;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.jdom.Content;
import org.jdom.DataConversionException;
import org.jdom.Element;

public class Keytable {
    private CmsApplication app;
    private String keycode;
    private HashMap<String, String> name;
    private HashMap<String, ArrayList<KeytableRecord>> keytable;
    private long lastId;

    public Keytable(CmsApplication app, String keycode) {
        this.app = app;
        this.keycode = keycode;
        this.lastId = -1L;
        this.initialise();
    }

    public CmsApplication getApplication() {
        return this.app;
    }

    public void verify() {
        if (!this.app.getDatastorage().hasTable("tkey" + this.keycode)) {
            this.initialise();
        }
    }

    private void initialise() {
        this.name = new HashMap();
        this.keytable = new HashMap();
        if (!this.app.getDatastorage().hasTable("tkey" + this.keycode)) {
            try {
                this.app.createDatabaseKeytables(this);
                return;
            }
            catch (SQLException ex) {
                this.getApplication().getLogger().log(Level.SEVERE, "Cannot create keytable '" + this.keycode + "': " + ex.getMessage(), ex);
            }
        }
        this.load();
    }

    public void load() {
        ArrayList<Object> tbl;
        this.name.clear();
        this.keytable.clear();
        ArrayList<String> languages = this.app.getLanguages();
        int countitem = 0;
        SearchResult dq = this.getApplication().getDatastorage().getKeytable(this.keycode);
        for (DataRecord row : dq.getResult()) {
            String lang = row.get("lang");
            if (!languages.contains(lang)) continue;
            KeytableRecord rec = new KeytableRecord(row.getLong("id" + this.keycode), row.get(this.keycode + "term"), row.getInt(this.keycode + "sort"));
            if (!row.isEmpty(this.keycode + "color")) {
                rec.color = row.getInt(this.keycode + "color");
            }
            if (rec.id > this.lastId) {
                this.lastId = rec.id;
            }
            if ((tbl = this.keytable.get(lang.toLowerCase())) == null) {
                tbl = new ArrayList();
                this.keytable.put(lang.toLowerCase(), tbl);
            }
            tbl.add(rec);
            ++countitem;
        }
        for (String l : languages) {
            if (this.keytable.containsKey(l)) continue;
            tbl = new ArrayList();
            this.keytable.put(l.toLowerCase(), tbl);
        }
        List<DataRecord> rows = this.getApplication().getDatastorage().getKeytable(this.keycode).getResult();
        for (DataRecord row : rows) {
            this.addName(row.getString("lang"), row.getString("term"));
        }
    }

    public void initialise(Element et) {
        this.clear();
        this.remove(this.lastId);
        List items = et.getChildren("item");
        for (Element item : items) {
            try {
                this.addTerm(item.getAttribute("id").getLongValue(), item.getAttributeValue("lang"), item.getAttributeValue("term"), item.getAttributeValue("color"));
            }
            catch (DataConversionException dataConversionException) {}
        }
        items = et.getChildren("name");
        for (Element item : items) {
            this.addName(item.getAttributeValue("lang"), item.getAttributeValue("term"));
        }
        this.save();
    }

    public HashMap<Long, Long> extend(Element et) {
        HashMap<Long, Long> mapping = new HashMap<Long, Long>();
        List items = et.getChildren("item");
        for (Element item : items) {
            try {
                long xmlId = item.getAttribute("id").getLongValue();
                String lang = item.getAttributeValue("lang");
                String term = item.getAttributeValue("term");
                String color = item.getAttributeValue("color");
                long tableId = this.getIdByTerm(term, lang, true);
                if (tableId < 0L) {
                    long newId = this.getNextId();
                    this.addTerm(newId, lang, term, color);
                    mapping.put(xmlId, newId);
                    this.save();
                    continue;
                }
                mapping.put(xmlId, tableId);
            }
            catch (DataConversionException dataConversionException) {}
        }
        return mapping;
    }

    public void update(Element et) {
        HashMap mapping = new HashMap();
        List items = et.getChildren("item");
        for (Element item : items) {
            try {
                long xmlId = item.getAttribute("id").getLongValue();
                String lang = item.getAttributeValue("lang");
                String term = item.getAttributeValue("term");
                String color = item.getAttributeValue("color");
                this.addOrReplaceTerm(xmlId, lang, term, color);
            }
            catch (DataConversionException dataConversionException) {}
        }
    }

    public void clear() {
        this.keytable.clear();
        this.lastId = -1L;
    }

    public ArrayList<String> getLanguages() {
        return this.app.getLanguages();
    }

    public void addName(String lang, String term) {
        this.name.put(lang, term);
    }

    public String getName(String lang) {
        String term = this.name.get(lang);
        if (term == null) {
            return this.getCode();
        }
        return term;
    }

    public String getName() {
        return this.getName("de");
    }

    public boolean hasName(String lang) {
        return this.name.get(lang) != null;
    }

    public KeytableRecord addTerm(long id, String lang, String term) {
        return this.addTerm(id, lang, term, null);
    }

    public KeytableRecord addTerm(long id, String lang, String term, String color) {
        ArrayList<KeytableRecord> tbl = this.keytable.get(lang.toLowerCase());
        if (tbl == null) {
            tbl = new ArrayList();
            this.keytable.put(lang.toLowerCase(), tbl);
        }
        int sort = 0;
        for (KeytableRecord rec : tbl) {
            if (rec.id == id) {
                this.getApplication().getLogger().log(Level.SEVERE, "ID " + id + " already in use in keytable '" + this.keycode + "'");
                return null;
            }
            if (rec.sort <= sort) continue;
            sort = rec.sort;
        }
        KeytableRecord rec = new KeytableRecord(id, term, sort + 1);
        if (color != null) {
            int c = Integer.MIN_VALUE;
            if (Util.isInteger((String)color)) {
                c = Util.parseInt((String)color, (int)Integer.MIN_VALUE);
            } else if (color.split(",").length == 3) {
                c = Util.getColorFromString((String)color).getRGB();
            }
            if (c != Integer.MIN_VALUE) {
                rec.color = c;
            }
        }
        tbl.add(rec);
        if (id > this.lastId) {
            this.lastId = id;
        }
        return rec;
    }

    public void addOrReplaceTerm(long id, String lang, String term) {
        this.addOrReplaceTerm(id, lang, term, null);
    }

    public void addOrReplaceTerm(long id, String lang, String term, String color) {
        ArrayList<KeytableRecord> tbl = this.keytable.get(lang.toLowerCase());
        if (tbl == null) {
            tbl = new ArrayList();
            this.keytable.put(lang.toLowerCase(), tbl);
        }
        int c = Integer.MIN_VALUE;
        if (color != null) {
            if (Util.isInteger((String)color)) {
                c = Util.parseInt((String)color, (int)Integer.MIN_VALUE);
            } else if (color.split(",").length == 3) {
                c = Util.getColorFromString((String)color).getRGB();
            }
        }
        int sort = 0;
        for (KeytableRecord rec : tbl) {
            if (rec.id == id) {
                rec.term = term;
                if (c != Integer.MIN_VALUE) {
                    rec.color = c;
                }
                return;
            }
            if (rec.sort <= sort) continue;
            sort = rec.sort;
        }
        KeytableRecord rec = new KeytableRecord(id, term, sort + 1);
        if (c != Integer.MIN_VALUE) {
            rec.color = c;
        }
        tbl.add(rec);
        if (id > this.lastId) {
            this.lastId = id;
        }
    }

    public void save() {
        if (!this.app.getDatastorage().hasTable("tkey" + this.getCode())) {
            this.getApplication().getDatastorage().createKeytable(this);
        }
        this.getApplication().getDatastorage().populateKeytable(this);
        this.getApplication().getDatastorage().setKeytableNames(this);
    }

    public int size() {
        Iterator<ArrayList<KeytableRecord>> it = this.keytable.values().iterator();
        if (it.hasNext()) {
            return it.next().size();
        }
        return 0;
    }

    public long getNextId() {
        ++this.lastId;
        return this.lastId;
    }

    public long createNewId() {
        if (this.keytable.values().isEmpty()) {
            return 1L;
        }
        ArrayList<KeytableRecord> recs = this.keytable.values().iterator().next();
        if (recs == null) {
            return 1L;
        }
        long result = -1L;
        for (KeytableRecord rec : recs) {
            result = Math.max(result, rec.id);
        }
        return ++result;
    }

    public HashMap<String, ArrayList<KeytableRecord>> getTable() {
        return this.keytable;
    }

    public String getTerm(long id, String lang) {
        ArrayList<KeytableRecord> tbl = this.keytable.get(lang.toLowerCase());
        if (tbl == null) {
            String error = "ERROR: language '" + lang + "' for table '" + this.getCode() + "' not defined";
            this.getApplication().getLogger().log(Level.SEVERE, error);
            return error;
        }
        for (KeytableRecord rec : tbl) {
            if (rec.id != id) continue;
            return rec.term;
        }
        String error = "Keytable error, ID " + id + " not found for language '" + lang + "' in table '" + this.getCode() + "'";
        this.getApplication().getLogger().log(Level.WARNING, error);
        return "";
    }

    public long getIdByTerm(String term, String lang) {
        return this.getIdByTerm(term, lang, false);
    }

    public long getIdByTerm(String term, String lang, boolean ignoreError) {
        ArrayList<KeytableRecord> tbl = this.keytable.get(lang.toLowerCase());
        if (tbl == null) {
            String error = "ERROR: language '" + lang + "' for table '" + this.getCode() + "' not defined (term '" + term + "')";
            this.getApplication().getLogger().log(Level.SEVERE, error);
            return -1L;
        }
        for (KeytableRecord rec : tbl) {
            if (rec.term == null || !rec.term.equalsIgnoreCase(term)) continue;
            return rec.id;
        }
        if (!ignoreError) {
            String error = "ERROR: Term '" + term + "' not found for attribute '" + this.getCode() + "'";
            this.getApplication().getLogger().log(Level.WARNING, error);
        }
        return -1L;
    }

    public long getIdByTermAndCreate(String term, String lang) {
        long id = this.getIdByTerm(term, lang, true);
        if (id < 0L) {
            id = this.createNewId();
            this.addTerm(id, lang, term);
            this.save();
        }
        return id;
    }

    public boolean hasId(long id, String lang) {
        ArrayList<KeytableRecord> tbl = this.keytable.get(lang.toLowerCase());
        if (tbl == null) {
            return false;
        }
        for (KeytableRecord rec : tbl) {
            if (rec.id != id) continue;
            return true;
        }
        return false;
    }

    public int getIndex(long id) {
        if (this.keytable.isEmpty()) {
            return -1;
        }
        ArrayList<KeytableRecord> records = this.keytable.values().iterator().next();
        int counter = 0;
        for (KeytableRecord rec : records) {
            if (rec.id == id) {
                return counter;
            }
            ++counter;
        }
        return -1;
    }

    public long getId(int idx) {
        if (this.keytable.isEmpty()) {
            throw new IndexOutOfBoundsException("Keytable '" + this.getCode() + "' is empty");
        }
        ArrayList<KeytableRecord> records = this.keytable.values().iterator().next();
        if (idx < 0 || idx > records.size()) {
            throw new IndexOutOfBoundsException("Keytable '" + this.getCode() + "' has only " + this.size() + " elements");
        }
        return records.get((int)idx).id;
    }

    public long getIdSafe(int idx) {
        if (this.keytable.isEmpty()) {
            return -1L;
        }
        ArrayList<KeytableRecord> records = this.keytable.values().iterator().next();
        if (idx < 0 || idx > records.size()) {
            return -1L;
        }
        return records.get((int)idx).id;
    }

    public long getId(String term) {
        if (term == null) {
            return -1L;
        }
        for (String lang : this.keytable.keySet()) {
            for (KeytableRecord rec : this.keytable.get(lang.toLowerCase())) {
                if (!term.equals(rec.term)) continue;
                return rec.id;
            }
        }
        return -1L;
    }

    public String getCode() {
        return this.keycode;
    }

    public String getIdsAsSql() {
        StringBuffer result = new StringBuffer();
        ArrayList<KeytableRecord> tbl = this.keytable.values().iterator().next();
        if (this.keytable.isEmpty()) {
            return "(-1)";
        }
        boolean first = true;
        result.append("(");
        for (KeytableRecord rec : tbl) {
            if (!first) {
                result.append(",");
            }
            result.append(rec.id);
            first = false;
        }
        result.append(")");
        return result.toString();
    }

    public ArrayList<Long> getIds() {
        ArrayList<Long> ids = new ArrayList<Long>();
        Iterator<ArrayList<KeytableRecord>> iter = this.keytable.values().iterator();
        if (iter.hasNext()) {
            ArrayList<KeytableRecord> tbl = this.keytable.values().iterator().next();
            for (KeytableRecord rec : tbl) {
                ids.add(rec.id);
            }
            Collections.sort(ids);
        }
        return ids;
    }

    public KeytableRecord getRecord(long id, String lang) {
        if (this.keytable == null) {
            return null;
        }
        ArrayList<KeytableRecord> recs = this.keytable.get(lang.toLowerCase());
        if (recs != null) {
            for (KeytableRecord rec : recs) {
                if (rec.id != id) continue;
                return rec;
            }
        }
        return null;
    }

    public Integer getColor(long id) {
        if (!this.keytable.values().iterator().hasNext()) {
            return null;
        }
        ArrayList<KeytableRecord> recs = this.keytable.values().iterator().next();
        if (recs != null) {
            for (KeytableRecord rec : recs) {
                if (rec.id != id) continue;
                return rec.color;
            }
        }
        return null;
    }

    public void moveUp(long id) {
        int idx = this.getIndex(id);
        if (idx > 0) {
            for (ArrayList<KeytableRecord> records : this.getTable().values()) {
                KeytableRecord record = records.get(idx);
                records.remove(idx);
                records.add(idx - 1, record);
            }
        }
    }

    public void moveDown(long id) {
        int idx = this.getIndex(id);
        if (idx < this.size() - 1) {
            for (ArrayList<KeytableRecord> records : this.getTable().values()) {
                KeytableRecord record = records.get(idx);
                records.remove(idx);
                records.add(idx + 1, record);
            }
        }
    }

    public void remove(long id) {
        int idx = this.getIndex(id);
        if (idx >= 0 && idx < this.size()) {
            for (ArrayList<KeytableRecord> records : this.getTable().values()) {
                records.remove(idx);
            }
        }
    }

    public void updateId(long oldId, long newId) {
        this.getApplication().getDatastorage().updateKeytableId(this.keycode, oldId, newId);
    }

    public String toString() {
        return this.getName();
    }

    public ArrayList<KeytableRecord> toList(String lang) {
        return this.toList(lang, false);
    }

    public ArrayList<KeytableRecord> toList(String lang, boolean addEmpty) {
        ArrayList<KeytableRecord> terms = new ArrayList<KeytableRecord>();
        ArrayList<KeytableRecord> tbl = this.keytable.get(lang.toLowerCase());
        if (tbl == null) {
            String error = "ERROR: language '" + lang.toLowerCase() + "' not defined for table '" + this.getCode() + "'";
            this.getApplication().getLogger().warning(error);
            tbl = new ArrayList();
        }
        if (addEmpty) {
            terms.add(new KeytableRecord(-1L, "-", -1));
        }
        for (KeytableRecord rec : tbl) {
            terms.add(rec);
        }
        return terms;
    }

    public String toHTMLselect(String id, String name, int size, long select, String lang, boolean multiple) {
        return this.toHTMLselect(id, name, size, select, lang, multiple, false);
    }

    public String toHTMLselect(String id, String name, int size, long select, String lang, boolean multiple, boolean addEmpty) {
        HashSet<Long> selects = new HashSet<Long>();
        selects.add(new Long(select));
        return this.toHTMLselect(id, name, size, selects, lang, multiple, addEmpty);
    }

    public String toHTMLselect(String id, String name, int size, ArrayList<String> select, String lang, boolean multiple, boolean isEmpty) {
        HashSet<Long> selects = new HashSet<Long>();
        for (String rec : select) {
            if ("".equals(rec)) continue;
            selects.add(Long.parseLong(rec));
        }
        return this.toHTMLselect(id, name, size, selects, lang, multiple, isEmpty);
    }

    public String toHTMLselect(String id, String name, int size, Set<Long> select, String lang, boolean multiple) {
        return this.toHTMLselect(id, name, size, select, lang, multiple, false);
    }

    public String toHTMLselect(String id, String name, int size, Set<Long> select, String lang, boolean multiple, boolean hasEmpty) {
        StringBuffer sb = new StringBuffer();
        ArrayList<KeytableRecord> tbl = this.keytable.get(lang.toLowerCase());
        if (tbl == null) {
            String error = "ERROR: language '" + lang.toLowerCase() + "' not defined";
            this.getApplication().getLogger().log(Level.SEVERE, error);
            tbl = new ArrayList();
        }
        sb.append("<select id=\"" + id + "\" name=\"" + name + "\" size=\"" + size + "\" " + (multiple ? "multiple" : "") + ">");
        if (hasEmpty) {
            sb.append("<option value=\"\"");
            if (select.isEmpty()) {
                sb.append(" selected=\"selected\"");
            }
            sb.append(">-</option>");
        }
        for (KeytableRecord rec : tbl) {
            sb.append("<option value=\"" + rec.id + "\"");
            if (select.contains(new Long(rec.id))) {
                sb.append(" selected=\"selected\"");
            }
            sb.append(">" + rec.term + "</option>");
        }
        sb.append("</select>");
        return sb.toString();
    }

    public String toHTMLedit() {
        StringBuffer sb = new StringBuffer();
        sb.append("<div><h3>EDIT KEYTABLE " + this.getCode().toUpperCase() + ": </h3></div>");
        sb.append("<form>");
        sb.append("<table border=\"0\"  cellspacing=\"0\">");
        sb.append("<tbody><tr>&nbsp;<td>&nbsp;</td> <td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>");
        for (String lang : this.getTable().keySet()) {
            sb.append("<td>" + lang + "</td><td>&nbsp;</td>");
        }
        int count = this.size();
        String img = this.app.getResourceUrl();
        ArrayList<String> systemKeytables = this.app.getSystemKeytables();
        ArrayList<String> languages = this.app.getLanguages();
        for (int ii = 0; ii < count; ++ii) {
            long id = this.getId(ii);
            sb.append("<tr>");
            sb.append("<td>" + id + "</td>");
            sb.append("<td><a onclick=\"gridelement.loadKeyTable('up',''," + id + ")\"><img border=\"0\" src=\"" + img + "buttons/move_up.gif\"></a></td>");
            sb.append("<td><a onclick=\"gridelement.loadKeyTable('down',''," + id + ")\"><img border=\"0\" src=\"" + img + "buttons/move_down.gif\"></a></td>");
            sb.append("<td>");
            if (!systemKeytables.contains(this.getCode())) {
                sb.append("<a onclick=\"gridelement.loadKeyTable('delete',''," + id + ")\"><img border=\"0\" src=\"" + img + "buttons/ele_delete.gif\"></a>");
            }
            sb.append("</td>");
            for (String lang : languages) {
                sb.append("<td><input name=\"keytable." + this.getCode() + "." + id + "." + lang + "\" value=\"" + this.getTerm(id, lang) + "\" type=\"text\"><td>");
            }
            sb.append("</tr>");
        }
        sb.append("</tbody> </table>");
        if (!systemKeytables.contains(this.getCode())) {
            sb.append("<button type=\"button\" value=\"add row\" onclick=\"gridelement.loadKeyTable('addrow','',-1)\" >add row</button>");
        }
        sb.append("<button type=\"button\" value=\"Save\" onclick=\"gridelement.saveKeyTable()\" >OK</button>");
        sb.append("</form>");
        return sb.toString();
    }

    public String toXML() {
        return Util.toXml((Element)this.toXMLElement());
    }

    public Element toXMLElement() {
        Element ele = new Element("keytable").setAttribute("table", this.getCode());
        Set<String> languages = this.getTable().keySet();
        for (String lang : languages) {
            ArrayList<KeytableRecord> records = this.getTable().get(lang);
            for (KeytableRecord rec : records) {
                Element item = new Element("item").setAttribute("id", Long.toString(rec.id)).setAttribute("lang", lang).setAttribute("term", rec.term);
                if (rec.color != null) {
                    item.setAttribute("color", Util.getStringFromColor((Color)new Color(rec.color)));
                }
                ele.addContent((Content)item);
            }
        }
        return ele;
    }
}

