/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cms.content;

import at.grid.cms.CmsApplication;
import at.grid.cms.element.CmsUser;
import at.grid.cms.storage.DataRecord;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Date;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom.Element;

public class UploadItem {
    public static final int WEBUPLOAD = 1;
    public static final int FILEREFERENCE = 2;
    public static final int REPOSITORY = 3;
    public static final String TABLE = "fileupload";
    private long id;
    private String name;
    private long filesize;
    private String contenttype;
    private Date uploaddate;
    private long idelement;
    private String elementtype;
    private File file;
    private int status;
    private long detail;
    private CmsApplication app;
    private String fileinfo;
    private String filecomment;
    private String attributecode;
    private boolean newupload = true;
    private boolean deleted = false;
    private String md5 = null;
    private Properties props = new Properties();

    public UploadItem(CmsApplication app, File parentfolder, String filename, String contenttype, long filesize, Date uploaddate, int status) {
        this(app, app.getDatastorage().createId("idfileupload"), parentfolder, filename, contenttype, filesize, uploaddate, status);
    }

    public UploadItem(CmsApplication app, long id, File parentfolder, String filename, String contenttype, long filesize, Date uploaddate, int status) {
        this.newupload = true;
        this.app = app;
        this.id = id;
        this.name = filename;
        this.filesize = filesize;
        this.contenttype = contenttype;
        this.uploaddate = uploaddate;
        this.idelement = -1L;
        this.elementtype = "";
        this.file = status == 1 ? new File(parentfolder, this.createFilename()) : new File(parentfolder, filename);
        this.status = status;
    }

    public UploadItem(CmsApplication app, DataRecord rs) {
        this.app = app;
        this.create(app, rs);
    }

    public UploadItem(CmsApplication app, long id) {
        this.app = app;
        app.getDatastorage().loadUploadItem(this, id);
    }

    public UploadItem(CmsApplication app) {
        this.app = app;
        this.id = -1L;
    }

    public UploadItem(CmsApplication app, long id, CmsUser u) {
        app.getDatastorage().loadUploadItem(this, id, u);
    }

    public void create(CmsApplication app, DataRecord rs) {
        try {
            this.setNew(false);
            this.setId(rs.getLong("idfileupload"));
            this.name = rs.getString("name");
            this.filesize = rs.getLong("filesize") == null ? 0L : rs.getLong("filesize");
            this.contenttype = rs.getString("contenttype");
            this.uploaddate = rs.getDate("uploaddate", TimeZone.getDefault());
            this.idelement = rs.getLong("idelement") == null ? -1L : rs.getLong("idelement");
            String et = "";
            et = rs.isEmpty("elementtype") ? app.getDatastorage().getElementtypeById(this.idelement) : rs.getString("elementtype");
            this.elementtype = et;
            this.file = app.getUploadFile(et, rs.getString("path"));
            this.status = 3;
            this.filecomment = rs.getString("comment");
            this.fileinfo = rs.getString("fileinfo");
            this.attributecode = rs.getString("code");
            this.deleted = rs.getBoolean("deleted", false);
            this.detail = rs.getLong("iduploaddetail") == null ? 0L : rs.getLong("iduploaddetail");
            this.props.clear();
        }
        catch (IOException ex) {
            this.setId(-1L);
            Logger.getLogger(UploadItem.class.getName()).log(Level.SEVERE, "Cannot access file at upload location", ex);
        }
    }

    public void setProperty(String key, String val) {
        this.props.setProperty(key, val);
    }

    public String getProperty(String key, String defaultValue) {
        return this.props.getProperty(key, defaultValue);
    }

    public void updateFile(File f) {
        this.file = f;
        this.name = f.getName();
    }

    public UploadItem copy(CmsApplication app) {
        File f = this.getFile();
        if (f == null) {
            return null;
        }
        UploadItem item = new UploadItem(app, app.getDatastorage().createId("idfileupload"), f.getParentFile(), this.getFilename(), this.getContenttype(), this.getFilesize(), this.getUploaddate(), 2);
        item.setAttributecode(this.getAttributeCode());
        item.setReference(this.idelement, this.elementtype);
        return item;
    }

    public boolean isValid() {
        return this.getId() >= 0L;
    }

    public boolean isNew() {
        return this.newupload;
    }

    public void setNew(boolean flag) {
        this.newupload = flag;
    }

    public void createId() {
        this.id = this.app.getDatastorage().createId("idfileupload");
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getElementtype() {
        return this.elementtype;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean flg) {
        this.deleted = flg;
    }

    @Deprecated
    public void setReference(long idelement) {
        this.setReference(idelement, this.app.getDatastorage().getElementtypeById(this.id));
    }

    public void setReference(long idelement, String elementtype) {
        if (elementtype == null) {
            elementtype = "";
        }
        this.idelement = idelement;
        this.elementtype = elementtype;
        try {
            File fld = new File(this.app.getFileLocation(), elementtype);
            fld.mkdirs();
        }
        catch (IOException ex) {
            this.setId(-1L);
            Logger.getLogger(UploadItem.class.getName()).log(Level.SEVERE, "Cannot access file at upload location", ex);
        }
    }

    public OutputStream getOutputStream() throws IOException {
        return new FileOutputStream(this.getFile());
    }

    public String getFileInfo() {
        return this.fileinfo;
    }

    public void setFileInfo(String fileinfo) {
        this.fileinfo = fileinfo;
    }

    public String getFileComment() {
        return this.filecomment;
    }

    public void setFileComment(String c) {
        this.filecomment = c;
    }

    public void setFile(File f) {
        this.file = f;
    }

    public File getFile() {
        if (this.file == null) {
            return null;
        }
        if (this.file.isFile()) {
            return this.file;
        }
        try {
            File f = this.app.getUploadFile(this.elementtype, this.file.getName());
            if (f.isFile()) {
                return f;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.file;
    }

    public String getFilename() {
        return this.getFile().getName();
    }

    public String getAbsolutePath() {
        return this.getFile().getAbsolutePath();
    }

    public String getAttributeCode() {
        return this.attributecode;
    }

    public void setAttributecode(String code) {
        this.attributecode = code;
    }

    public String getUrl(String urlbase) {
        return urlbase + "?action=file&meta_id=" + this.getId();
    }

    public UploadItem changeId(CmsApplication app, long newId) throws IOException {
        String oldPath = this.file.getAbsolutePath();
        this.setId(newId);
        this.file = new File(this.file.getParentFile(), this.createFilename());
        Files.move(Paths.get(oldPath, new String[0]), Paths.get(this.file.getAbsolutePath(), new String[0]), new CopyOption[0]);
        app.getDatastorage().updateUploadItem(this);
        return this;
    }

    public void save(CmsApplication app) {
        app.getDatastorage().saveUploadItem(this);
    }

    public void moveFile(File newFolder) {
        boolean success;
        newFolder.mkdirs();
        File newFile = new File(newFolder, this.createFilename());
        boolean deleteOriginal = false;
        boolean copyFile = true;
        if (this.status == 1) {
            boolean bl = copyFile = !this.app.getFileAccess().move(this.getFile(), newFile);
            if (copyFile) {
                deleteOriginal = true;
                this.app.getLogger().log(Level.WARNING, "File '" + this.getFile().getPath() + "' could not be moved to '" + newFolder.getPath() + "', trying to copy");
            }
        }
        if (copyFile && !(success = this.app.getFileAccess().copy(this.getFile(), newFile))) {
            this.app.getLogger().log(Level.SEVERE, "File '" + this.getFile().getPath() + "' could not be copied!");
        }
        if (deleteOriginal) {
            this.app.getFileAccess().delete(this.getFile());
        }
        this.file = newFile;
        this.status = 3;
    }

    public void deleteFile() {
        if (this.getFile().exists() && this.status == 3) {
            this.app.getFileAccess().delete(this.getFile());
        }
    }

    public long getFilesize() {
        return this.filesize;
    }

    public String createFilename() {
        return this.getId() + "_" + this.name;
    }

    public String getContenttype() {
        return this.contenttype;
    }

    public String getName() {
        return this.name;
    }

    public long getId() {
        return this.id;
    }

    public long getIdelement() {
        return this.idelement;
    }

    public Date getUploaddate() {
        return this.uploaddate;
    }

    public long getUploadDetail() {
        return this.detail;
    }

    public void setUploadDetail(long detail) {
        this.detail = detail;
    }

    public boolean isImage() {
        String fn = this.getName().toLowerCase();
        return fn.endsWith(".jpg") || fn.endsWith(".jpeg") || fn.endsWith(".tiff") || fn.endsWith(".tif") || fn.endsWith(".gif") || fn.endsWith(".png");
    }

    public boolean isAudio() {
        String fn = this.getName().toLowerCase();
        return fn.endsWith(".au") || fn.endsWith(".wav") || fn.endsWith(".mp3");
    }

    public boolean isInRepository() {
        return this.status == 3;
    }

    public String toString() {
        if (this.status != 3) {
            return "* " + this.getName();
        }
        return this.getName();
    }

    public Element toJDOMElement() {
        Element e = new Element("uploaditem");
        e.setAttribute("id", Long.toString(this.getId())).setAttribute("name", this.getName()).setAttribute("contenttype", this.getContenttype() == null ? "" : this.getContenttype()).setAttribute("filename", this.getFilename()).setAttribute("deleted", this.deleted ? "YES" : "NO").setAttribute("fileinfo", this.getFileInfo() == null ? "" : this.getFileInfo()).setAttribute("filecomment", this.getFileComment() == null ? "" : this.getFileComment()).setAttribute("filesize", Long.toString(this.getFilesize())).setAttribute("path", this.getFile().getParentFile().getAbsolutePath()).setAttribute("detail", Long.toString(this.getUploadDetail()));
        return e;
    }

    public void setId(long id) {
        this.id = id;
    }

    public boolean compareByNameAndSize(UploadItem item) {
        return this.getName() != null && this.getName().equals(item.getName()) && this.getFilesize() == item.getFilesize();
    }

    public boolean compareByFilename(UploadItem item) {
        return this.getFilename() != null && this.getFilename().equals(item.getFilename());
    }
}

