/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cms.element;

import at.grid.cms.CmsApplication;
import at.grid.cms.attribute.BooleanAttribute;
import at.grid.cms.attribute.ButtonAttribute;
import at.grid.cms.attribute.CmsAttribute;
import at.grid.cms.attribute.DateAttribute;
import at.grid.cms.attribute.FloatAttribute;
import at.grid.cms.attribute.IntegerAttribute;
import at.grid.cms.attribute.KeyAttribute;
import at.grid.cms.attribute.LongAttribute;
import at.grid.cms.attribute.MultikeyAttribute;
import at.grid.cms.attribute.RelationAttribute;
import at.grid.cms.attribute.SectionAttribute;
import at.grid.cms.attribute.TextAttribute;
import at.grid.cms.attribute.UploadAttribute;
import at.grid.cms.content.CmsPermission;
import at.grid.cms.content.Keytable;
import at.grid.cms.content.UploadItem;
import at.grid.cms.element.CmsComment;
import at.grid.cms.element.CmsElementPermission;
import at.grid.cms.element.CmsElementSummary;
import at.grid.cms.element.CmsUser;
import at.grid.cms.element.ElementUpdateListener;
import at.grid.cms.search.CmsBasicSearch;
import at.grid.cms.search.CmsSqlSearch;
import at.grid.cms.servlet.CmsRequest;
import at.grid.cms.storage.DataRecord;
import at.grid.util.Util;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.logging.Level;
import java.util.zip.ZipFile;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class CmsElement
implements CmsElementPermission,
Cloneable {
    public static final String META_ID = "meta_id";
    public static final String META_ELEMENTTYPE = "meta_elementtype";
    public static final String META_LANG = "meta_lang";
    public static final String META_CREATED = "meta_created";
    public static final String META_LASTEDIT = "meta_lastedit";
    public static final String META_LASTEDIT_USERNAME = "meta_lastedit_username";
    public static final String META_LASTEDITBY = "meta_lasteditby";
    public static final String META_STATUS = "meta_status";
    public static final String META_GROUPID = "meta_idgroup";
    public static final String META_GROUPNAME = "meta_idgroup_name";
    public static final String META_USERID = "meta_iduser";
    public static final String META_USERNAME = "meta_iduser_name";
    public static final String META_MIGRATEELEMENT = "meta_migrateelement";
    public static final String META_READACCESS = "meta_readaccess";
    public static final String META_WRITEACCESS = "meta_writeaccess";
    public static final String META_TRASH = "meta_trash";
    public static final String META_MASTERLANG = "meta_masterlang";
    public static final String META_ORIGMD5 = "meta_origmd5";
    public static final int PERMISSION_EVERYONE = 1;
    public static final int PERMISSION_AUTHENTICATED = 2;
    public static final int PERMISSION_GROUP = 3;
    public static final int PERMISSION_CREATOR = 4;
    protected CmsApplication app;
    private HashMap<String, CmsAttribute> map = new HashMap();
    private ArrayList<CmsAttribute> meta = new ArrayList();
    private ArrayList<CmsAttribute> attributes = new ArrayList();
    private long id;
    private long originalId;
    private UUID uuid;
    private String lang;
    private String title;
    private CmsUser currentUser;
    protected Element spec = new Element("elementtype");
    private String tablename;
    private String elementcode;
    private String hierarchyattributes;
    boolean removed = false;
    boolean newElement = false;
    boolean saved = false;
    boolean changed = false;
    ArrayList<Long> updateAfterSave = new ArrayList();
    public boolean ignoreRelationsDuringSave = false;
    ArrayList<ElementUpdateListener> updateListener = new ArrayList();
    protected String titlespec;
    protected String summaryspec;
    protected boolean allowcomments = false;
    protected ArrayList<CmsComment> comments = new ArrayList();
    private String statusmessage = null;
    private String warningmessage = null;
    private String errormessage = null;
    private String md5 = null;

    public CmsElement clone() {
        try {
            return (CmsElement)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            this.app.getLogger().log(Level.SEVERE, "CmsElement not clonable", ex);
            return null;
        }
    }

    public void initialise(CmsApplication app, CmsUser user, Element spec) {
        this.initialise(app, user, null, spec);
    }

    public CmsElement initialise(CmsApplication app, CmsUser user, Long idelement, Element spec) {
        this.app = app;
        this.spec = spec != null ? spec : this.getSpecification();
        this.newElement = true;
        this.currentUser = user;
        this.lang = user != null ? user.getCurrentLanguage() : this.app.getDefaultUser().getLang();
        if (this.spec != null) {
            this.tablename = this.spec.getAttributeValue("table");
            this.elementcode = this.spec.getAttributeValue("code");
            this.titlespec = this.spec.getAttributeValue("title");
            this.summaryspec = this.spec.getAttributeValue("summary");
            this.allowcomments = "true".equalsIgnoreCase(this.spec.getAttributeValue("comment"));
        }
        this.comments = new ArrayList();
        if (this.meta == null) {
            this.meta = new ArrayList();
        }
        if (this.attributes == null) {
            this.attributes = new ArrayList();
        }
        if (this.map == null) {
            this.map = new HashMap();
        }
        try {
            if (this.getAttribute("s_metadata") == null) {
                this.addMetaAttribute(new SectionAttribute(this.getApplication(), this, new Element("attribute").setAttribute("code", "s_metadata").setAttribute("type", "section")));
            }
            if (this.getAttribute(META_ID) == null) {
                this.addMetaAttribute(new LongAttribute(this.getApplication(), this, new Element("attribute").setAttribute("code", META_ID).setAttribute("type", "long").setAttribute("virtual", "true").setAttribute("readonly", "true")));
            }
            if (this.getAttribute(META_ELEMENTTYPE) == null) {
                this.addMetaAttribute(new TextAttribute(this.getApplication(), this, new Element("attribute").setAttribute("code", META_ELEMENTTYPE).setAttribute("type", "text").setAttribute("field", "elementtype").setAttribute("size", "100").setAttribute("readonly", "true")));
            }
            String hiddenlang = "true";
            if (this.getApplication().isMultilingual()) {
                hiddenlang = "false";
            }
            if (this.getAttribute(META_LANG) == null) {
                this.addMetaAttribute(new TextAttribute(this.getApplication(), this, new Element("attribute").setAttribute("code", META_LANG).setAttribute("type", "text").setAttribute("virtual", "true").setAttribute("readonly", "true").setAttribute("hidden", hiddenlang)));
            }
            if (this.getAttribute(META_CREATED) == null) {
                this.addMetaAttribute(new DateAttribute(this.getApplication(), this, new Element("attribute").setAttribute("code", META_CREATED).setAttribute("type", "date").setAttribute("field", "metacreated").setAttribute("format", Util.DATETIME_READ).setAttribute("readonly", "true")).forceMultilingual());
            }
            if (this.getAttribute(META_LASTEDIT) == null) {
                this.addMetaAttribute(new DateAttribute(this.getApplication(), this, new Element("attribute").setAttribute("code", META_LASTEDIT).setAttribute("type", "date").setAttribute("field", "metalastedit").setAttribute("format", Util.DATETIME_READ).setAttribute("readonly", "true")).forceMultilingual());
            }
            if (this.getAttribute(META_LASTEDITBY) == null) {
                this.addMetaAttribute(new RelationAttribute(this.getApplication(), this, new Element("attribute").setAttribute("code", META_LASTEDITBY).setAttribute("type", "relation").setAttribute("relationcode", "lasteditby").setAttribute("field", "metatranslator").setAttribute("elementcodes", "user").setAttribute("single", "true").setAttribute("readonly", "true")).forceMultilingual());
            }
            if (this.getAttribute(META_STATUS) == null) {
                this.addMetaAttribute(new KeyAttribute(this.getApplication(), this, new Element("attribute").setAttribute("code", META_STATUS).setAttribute("type", "key").setAttribute("field", "idworkflowstatus").setAttribute("table", "workflowstatus")).setHidden(this.app.supportWorkflow()));
            }
            if (this.getAttribute(META_GROUPID) == null) {
                this.addMetaAttribute(new LongAttribute(this.getApplication(), this, new Element("attribute").setAttribute("code", META_GROUPID).setAttribute("type", "long").setAttribute("field", "metaowner")));
                this.addMetaAttribute(new TextAttribute(this.getApplication(), this, new Element("attribute").setAttribute("code", META_GROUPNAME).setAttribute("type", "text").setAttribute("virtual", "true").setAttribute("size", "200").setAttribute("readonly", "true")));
            }
            if (this.getAttribute(META_USERID) == null) {
                this.addMetaAttribute(new LongAttribute(this.getApplication(), this, new Element("attribute").setAttribute("code", META_USERID).setAttribute("type", "long").setAttribute("field", "metacreator")));
                this.addMetaAttribute(new TextAttribute(this.getApplication(), this, new Element("attribute").setAttribute("code", META_USERNAME).setAttribute("type", "text").setAttribute("virtual", "true").setAttribute("size", "200").setAttribute("readonly", "true")));
            }
            if (this.getAttribute(META_MIGRATEELEMENT) == null) {
                this.addMetaAttribute(new RelationAttribute(this.getApplication(), this, new Element("attribute").setAttribute("code", META_MIGRATEELEMENT).setAttribute("type", "relation").setAttribute("field", "migrateelement").setAttribute("elementcodes", this.getElementcode()).setAttribute("single", "true").setAttribute("allowsearch", "true").setAttribute("relationcode", "migrateelement").setAttribute("show", "edit").setAttribute("group", "_meta")));
            }
            if (this.getAttribute("meta_migratebutton") == null) {
                this.addMetaAttribute(new ButtonAttribute(this.getApplication(), this, new Element("attribute").setAttribute("code", "meta_migratebutton").setAttribute("type", "button").setAttribute("show", "edit").setAttribute("group", "_meta")));
            }
            if (this.getAttribute(META_READACCESS) == null) {
                this.addMetaAttribute(new KeyAttribute(this.getApplication(), this, new Element("attribute").setAttribute("code", META_READACCESS).setAttribute("type", "key").setAttribute("field", "idreadaccess").setAttribute("table", "permissionlevel")));
            }
            if (this.getAttribute(META_WRITEACCESS) == null) {
                this.addMetaAttribute(new KeyAttribute(this.getApplication(), this, new Element("attribute").setAttribute("code", META_WRITEACCESS).setAttribute("type", "key").setAttribute("field", "idwriteaccess").setAttribute("table", "permissionlevel")));
            }
            if (this.getAttribute(META_TRASH) == null) {
                this.addMetaAttribute(new BooleanAttribute(this.getApplication(), this, new Element("attribute").setAttribute("code", META_TRASH).setAttribute("type", "boolean").setAttribute("field", "deleted")));
            }
            if (this.getAttribute(META_MASTERLANG) == null) {
                this.addMetaAttribute(new TextAttribute(this.getApplication(), this, new Element("attribute").setAttribute("code", META_MASTERLANG).setAttribute("type", "text").setAttribute("field", "metamasterlang").setAttribute("multilingual", "false").setAttribute("size", "5")).setHidden(this.app.isMultilingual()));
            }
            if (this.getAttribute(META_ORIGMD5) == null) {
                this.addMetaAttribute(new TextAttribute(this.getApplication(), this, new Element("attribute").setAttribute("code", META_ORIGMD5).setAttribute("type", "text").setAttribute("field", "origmd5").setAttribute("size", "250").setAttribute("hidden", "true").setAttribute("readonly", "true")));
            }
            this.setMetaAttributeValue("readaccess", Long.toString(this.getDefaultReadaccess()));
            this.setMetaAttributeValue("writeaccess", Long.toString(this.getDefaultWriteaccess()));
        }
        catch (JDOMException jDOMException) {
            // empty catch block
        }
        this.createAttributes(this.spec, false);
        if (idelement == null) {
            this.setId(-1L);
        } else {
            this.setId(idelement);
        }
        if (user != null) {
            this.setCreation(user);
        }
        this.setWorkflowStatus(this.getDefaultWorkflowstatus());
        return this;
    }

    public boolean isInitialised() {
        return this.elementcode != null;
    }

    public void initialiseFurtherAttributes(Element spec) {
        this.createAttributes(spec, true);
    }

    public void setCurrentUser(CmsUser user) {
        this.currentUser = user;
        if (user != null) {
            this.lang = user.getCurrentLanguage();
            this.setUserGroup(user);
        }
    }

    public void createAttributes(Element et, boolean include) {
        List atts = et.getChildren("attribute");
        for (Element att : atts) {
            String attcode = att.getAttributeValue("code");
            if (this.getAttribute(attcode) != null) continue;
            if (include) {
                Element newatt = new Element(att.getName());
                for (Object oldatt : att.getAttributes()) {
                    newatt.setAttribute(((Attribute)oldatt).getName(), ((Attribute)oldatt).getValue());
                }
                this.spec.addContent((Content)newatt);
            }
            String type = att.getAttributeValue("type");
            String attClass = att.getAttributeValue("class");
            if (attClass == null) {
                attClass = "at.grid.cms.attribute." + type.substring(0, 1).toUpperCase() + type.substring(1).toLowerCase() + "Attribute";
            }
            CmsAttribute a = null;
            try {
                Constructor<?> con = Class.forName(attClass).getConstructor(CmsApplication.class, CmsElement.class, Element.class);
                a = (CmsAttribute)con.newInstance(this.getApplication(), this, att);
            }
            catch (Exception ex) {
                this.getApplication().getLogger().log(Level.SEVERE, "FAILURE: " + ex.getMessage(), ex);
                throw new Error("Application error, unable to continue: " + ex.getMessage());
            }
            if (a == null) continue;
            this.addAttribute(a);
        }
    }

    public void create(DataRecord rs, CmsUser u, boolean loadfull) {
        try {
            long performanceMillis = new Date().getTime();
            if (this.elementcode.equalsIgnoreCase("location")) {
                boolean bl = false;
            }
            this.preLoad();
            this.setId(rs.getLong(META_ID));
            String readuuid = rs.getString("meta_uuid");
            this.uuid = readuuid == null || "".equals(readuuid) ? UUID.randomUUID() : UUID.fromString(readuuid);
            this.lang = rs.getString(META_LANG);
            rs.setMetaElementtype(this.getElementcode());
            for (CmsAttribute att : this.meta) {
                if (att.isVirtual()) continue;
                att.setValue(rs, true);
            }
            this.setAttributeValue(META_GROUPNAME, this.getApplication().getDatastorage().checkGroup(this.getLongAttribute(META_GROUPID).getLong()));
            this.setAttributeValue(META_USERNAME, this.getApplication().getDatastorage().checkUser(this.getLongAttribute(META_USERID).getLong()));
            for (CmsAttribute att : this.attributes) {
                try {
                    if (att.isVirtual()) continue;
                    att.setValue(rs, true);
                }
                catch (Exception e) {
                    this.getApplication().getLogger().log(Level.SEVERE, e.getMessage(), e);
                }
            }
            this.currentUser = u;
            this.postLoad();
            this.setSaved(true);
        }
        catch (Exception e) {
            this.clear();
            this.getApplication().getLogger().log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void update(CmsRequest request, CmsUser u, HashMap<Long, UploadItem> uploads) {
        this.currentUser = u;
        this.preUpdate();
        for (CmsAttribute cmsAttribute : this.attributes) {
            if (request.getParameter(cmsAttribute.getCode()) == null && !request.hasParameter(cmsAttribute.getCode() + "_checkbox") && !request.hasParameter(cmsAttribute.getCode() + "_subelement")) continue;
            if ((cmsAttribute.isOfType(15) || cmsAttribute.isOfType(16)) && uploads != null) {
                int counter = 1;
                String fileid = request.getParameter(cmsAttribute.getCode() + "." + counter);
                while (fileid != null && !"".equals(fileid)) {
                    ((UploadAttribute)cmsAttribute).addUpload(fileid, uploads);
                    fileid = request.getParameter(cmsAttribute.getCode() + "." + ++counter);
                }
                continue;
            }
            if (cmsAttribute.isOfType(10)) {
                ((MultikeyAttribute)cmsAttribute).setValue(request.getParameters(cmsAttribute.getCode()));
                continue;
            }
            if (cmsAttribute.isOfType(14) && !((RelationAttribute)cmsAttribute).isSingle()) {
                if (((RelationAttribute)cmsAttribute).isSubelement()) {
                    for (String param : request.getParameterNames()) {
                        if (!param.startsWith(cmsAttribute.getCode() + ".")) continue;
                        if (param.endsWith("_checkbox")) {
                            String p = param.substring(0, param.length() - 9);
                            String[] split = p.substring(cmsAttribute.getCode().length() + 1).split("\\.");
                            if (!request.hasParameter(p)) {
                                ((RelationAttribute)cmsAttribute).setElementAttribute(Long.parseLong(split[0]), split[1], "false");
                            }
                        }
                        String[] split = param.substring(cmsAttribute.getCode().length() + 1).split("\\.");
                        ((RelationAttribute)cmsAttribute).setElementAttribute(Long.parseLong(split[0]), split[1], request.getParameter(param));
                    }
                    continue;
                }
                cmsAttribute.setValue(request.getParameter(cmsAttribute.getCode()));
                continue;
            }
            cmsAttribute.setValue(request.getParameter(cmsAttribute.getCode()));
        }
        String relcode = request.getParameter("relationcode");
        if (relcode != null) {
            for (RelationAttribute att : this.getRelationAttributes()) {
                long relid;
                if (!relcode.equals(att.getRelationcode()) || (relid = Long.parseLong(request.getParameter("relationid", "-1"))) < 0L || !this.getApplication().hasElement(relid)) continue;
                att.add(relid);
            }
        }
        if (request.getParameter(META_GROUPID) != null) {
            this.getAttribute(META_GROUPID).setValue(request.getParameter(META_GROUPID));
        }
        if (request.getParameter(META_USERID) != null) {
            this.getAttribute(META_USERID).setValue(request.getParameter(META_USERID));
        }
        if (request.getParameter(META_READACCESS) != null) {
            this.getAttribute(META_READACCESS).setValue(request.getParameter(META_READACCESS));
        }
        if (request.getParameter(META_WRITEACCESS) != null) {
            this.getAttribute(META_WRITEACCESS).setValue(request.getParameter(META_WRITEACCESS));
        }
        try {
            int n = Integer.parseInt(request.getParameter(META_STATUS));
            this.setWorkflowStatus(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.postUpdateElement();
        this.setSaved(false);
        for (ElementUpdateListener listener : this.updateListener) {
            listener.elementUpdated(this);
        }
    }

    public void updateMeta(CmsRequest request, CmsUser u) {
        this.currentUser = u;
        for (CmsAttribute att : this.meta) {
            if (request.getParameter(att.getCode()) == null) continue;
            att.setValue(request.getParameter(att.getCode()));
        }
    }

    public void update(HashMap<String, String> map, CmsUser u) {
        this.currentUser = u;
        this.preUpdate();
        for (CmsAttribute att : this.attributes) {
            if (!map.containsKey(att.getCode())) continue;
            att.setValue(map.get(att.getCode()));
        }
        this.getAttribute(META_GROUPID).setValue(map.get(META_GROUPID));
        this.getAttribute(META_USERID).setValue(map.get(META_USERID));
        this.getAttribute(META_READACCESS).setValue(map.get(META_READACCESS));
        this.getAttribute(META_WRITEACCESS).setValue(map.get(META_WRITEACCESS));
        try {
            int newStatus = Integer.parseInt(map.get(META_STATUS));
            this.setWorkflowStatus(newStatus);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((DateAttribute)this.getAttribute(META_LASTEDIT)).setDate(new Date());
        ((RelationAttribute)this.getAttribute(META_LASTEDITBY)).set(u);
        this.postUpdateElement();
        this.setSaved(false);
        for (ElementUpdateListener listener : this.updateListener) {
            listener.elementUpdated(this);
        }
    }

    public void update(String xml) {
        try {
            SAXBuilder sb = new SAXBuilder();
            Document doc = sb.build((Reader)new StringReader(xml));
            this.update(doc);
        }
        catch (JDOMException ex) {
            this.app.getLogger().log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            this.app.getLogger().log(Level.SEVERE, null, ex);
        }
    }

    public void update(Document doc) {
        this.update(doc, null);
    }

    public void update(Document doc, ZipFile zip) {
        this.update(doc.getRootElement(), zip);
    }

    public void update_meta(Element root) {
        this.originalId = Util.parseLong((String)root.getAttributeValue("id", "0"), (long)0L);
        Element eleMeta = root.getChild("meta");
        if (eleMeta != null) {
            this.originalId = Long.parseLong(eleMeta.getChildText(META_ID));
            String content = eleMeta.getChildText(META_CREATED);
            Date dt = Util.parseDate((String)content, (String)Util.DATETIME_READ, (TimeZone)this.app.getTimeZone(), null);
            if (dt != null && this.isNew()) {
                this.getDateAttribute(META_CREATED).setDate(dt);
            }
            if ((dt = Util.parseDate((String)(content = eleMeta.getChildText(META_LASTEDIT)), (String)Util.DATETIME_READ, (TimeZone)this.app.getTimeZone(), (Date)dt)) != null) {
                this.getDateAttribute(META_LASTEDIT).setDate(dt);
            }
            content = eleMeta.getChildText(META_USERNAME);
            long iduser = this.app.getDatastorage().checkUser(content);
            if (iduser > 0L) {
                this.getLongAttribute(META_USERID).setValue(iduser);
                this.getAttribute(META_USERNAME).setValue(content);
            }
            if ((content = eleMeta.getChildText(META_TRASH)) != null && (content.equalsIgnoreCase("x") || content.equalsIgnoreCase("true") || content.equalsIgnoreCase("yes") || content.equalsIgnoreCase("wahr") || content.equalsIgnoreCase("ja"))) {
                this.setTrash(true);
            } else {
                this.setTrash(false);
            }
        }
    }

    public void update(Element root, ZipFile zip) {
        this.update(root, zip, null, true);
    }

    public void update(Element root, ZipFile zip, String ... ignoreAtts) {
        this.update(root, zip, Arrays.asList(ignoreAtts), true);
    }

    public void update(Element root, ZipFile zip, List<String> ignoreAtts, boolean applyUUID) {
        this.originalId = Util.parseLong((String)root.getAttributeValue("id", "0"), (long)0L);
        Element eleMeta = root.getChild("meta");
        if (eleMeta != null && eleMeta.getChildText(META_ID) != null) {
            this.originalId = Long.parseLong(eleMeta.getChildText(META_ID));
        }
        if (applyUUID && root.getAttributeValue("uuid") != null) {
            this.uuid = UUID.fromString(root.getAttributeValue("uuid"));
        }
        Element eleData = root.getChild("data");
        for (CmsAttribute att : this.attributes) {
            if (att.getCode() == null || att.isOfType(18) || att.isOfType(17) || att.isVirtual() || ignoreAtts != null && ignoreAtts.contains(att.getCode())) continue;
            if (att.isOfType(15) || att.isOfType(16)) {
                ((UploadAttribute)att).setValue(eleData.getChild(att.getCode()), zip);
                continue;
            }
            if (att.isOfType(14)) {
                ((RelationAttribute)att).setValue(eleData.getChild(att.getCode()), zip);
                continue;
            }
            att.setValue(eleData.getChild(att.getCode()));
        }
        this.postUpdateElement();
        this.setSaved(false);
        for (ElementUpdateListener listener : this.updateListener) {
            listener.elementUpdated(this);
        }
    }

    public void update(CmsElement source, ZipFile zip) {
        this.update(source, zip, false);
    }

    public void update(CmsElement source, ZipFile zip, boolean ignoreRelations) {
        this.originalId = source.getId();
        for (CmsAttribute att : this.attributes) {
            if (att.getCode() == null || att.isVirtual() || att.isOfType(18) || att.isOfType(17)) continue;
            if (att.isOfType(15) || att.isOfType(16)) {
                ((UploadAttribute)att).setValue(source.getAttribute(att.getCode()).toJDOMElement(), zip);
            } else if (att.isOfType(14)) {
                if (ignoreRelations) {
                    ((RelationAttribute)att).addTemporarily(source.getRelationAttribute(att.getCode()).getElements());
                } else if (((RelationAttribute)att).isSubelement()) {
                    for (CmsElement sub : source.getRelationAttribute(att.getCode()).getFullElements()) {
                        ((RelationAttribute)att).add(sub);
                    }
                } else {
                    ((RelationAttribute)att).add(source.getRelationAttribute(att.getCode()).getElements());
                }
            } else if (att.isOfType(8)) {
                ((KeyAttribute)att).setTerm(source.getAttributeValue(att.getCode()), true);
            } else if (att.isOfType(10)) {
                ((KeyAttribute)att).setTerm(source.getAttributeValue(att.getCode()), true);
            } else {
                att.setValue(source.getAttributeValue(att.getCode()));
            }
            boolean bl = false;
        }
        this.postUpdateElement();
        this.setSaved(false);
        for (ElementUpdateListener listener : this.updateListener) {
            listener.elementUpdated(this);
        }
    }

    public void update() {
        this.postUpdateElement();
    }

    public void addUpdateListener(ElementUpdateListener listener) {
        this.updateListener.add(listener);
    }

    public CmsApplication getApplication() {
        return this.app;
    }

    public void setApplication(CmsApplication app) {
        this.app = app;
    }

    public CmsUser getCurrentUser() {
        return this.currentUser;
    }

    public Element getSpecification() {
        return this.spec;
    }

    public String getName() {
        return this.app.getResourceText("app.element." + this.getElementcode(), this.getCurrentUser().getCurrentLocale());
    }

    public void setUser(CmsUser u) {
        this.getLongAttribute(META_USERID).setValue(u.getId());
    }

    public void setUserGroup(CmsUser u) {
        this.getLongAttribute(META_GROUPID).setValue(u.getMainGroupId());
        this.getLongAttribute(META_USERID).setValue(u.getId());
    }

    public void setCreation(CmsUser u) {
        this.setUserGroup(u);
        ((DateAttribute)this.getAttribute(META_CREATED)).setDate(new Date());
        ((DateAttribute)this.getAttribute(META_LASTEDIT)).setDate(new Date());
        this.setAttributeValue(META_MASTERLANG, this.lang);
    }

    @Override
    public long getCreatorId() {
        return this.getLongAttribute(META_USERID).getLong();
    }

    @Override
    public long getOwnerId() {
        return this.getLongAttribute(META_GROUPID).getLong();
    }

    public String getCreatedAsString() {
        return this.getAttributeValue(META_CREATED);
    }

    public String getLastEditAsString() {
        return this.getAttributeValue(META_LASTEDIT);
    }

    @Override
    public long getReadAccess() {
        return ((KeyAttribute)this.getAttribute(META_READACCESS)).getId();
    }

    @Override
    public long getWriteAccess() {
        return ((KeyAttribute)this.getAttribute(META_WRITEACCESS)).getId();
    }

    public boolean isTrash() {
        return ((BooleanAttribute)this.getAttribute(META_TRASH)).isSet();
    }

    public void workflowAction(int action) {
        this.preWorkflow();
        if (action == 1) {
            this.setWorkflowStatus(4);
        } else if (action == 2) {
            this.setWorkflowStatus(1);
        }
        this.postWorkflow();
    }

    public void setWorkflowStatus(int status) {
        this.preWorkflow();
        this.setAttributeValue(META_STATUS, Integer.toString(status));
        this.postWorkflow();
    }

    public String getWorkflowStatusText() {
        return this.getAttributeValue(META_STATUS);
    }

    public int getWorkflowStatus() {
        return Integer.parseInt(this.getAttribute(META_STATUS).getDatabaseValue());
    }

    public void clear() {
        for (CmsAttribute att : this.attributes) {
            att.clear();
        }
        this.setSaved(false);
    }

    public boolean doAllowComments() {
        return this.allowcomments;
    }

    public ArrayList<CmsComment> getComments() {
        return this.comments;
    }

    public void addComment(CmsComment cmsComment) {
        this.comments.add(cmsComment);
    }

    public boolean isNew() {
        return this.newElement;
    }

    public void setNew(boolean flg) {
        this.newElement = flg;
    }

    public void setSaved(boolean flg) {
        this.saved = flg;
        if (!flg) {
            this.setChanged(true);
        }
    }

    public boolean isSaved() {
        return this.saved;
    }

    public boolean hasContent() {
        for (CmsAttribute att : this.getDataAttributes()) {
            if (!att.hasValue()) continue;
            return true;
        }
        return false;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public String getStatusmessage() {
        return this.statusmessage;
    }

    public void setStatusmessage(String statusmessage) {
        this.statusmessage = statusmessage;
    }

    public void clearStatusmessage() {
        this.statusmessage = null;
    }

    public boolean hasStatusmessage() {
        return this.statusmessage != null;
    }

    public String getWarningmessage() {
        return this.warningmessage;
    }

    public void setWarningmessage(String msg) {
        this.warningmessage = msg;
    }

    public void clearWarningmessage() {
        this.warningmessage = null;
    }

    public boolean hasWarningmessage() {
        return this.warningmessage != null;
    }

    public String getErrormessage() {
        return this.errormessage;
    }

    public void setErrormessage(String msg) {
        this.errormessage = msg;
    }

    public void clearErrormessage() {
        this.errormessage = null;
    }

    public boolean hasErrormessage() {
        return this.errormessage != null;
    }

    public long createId() {
        return this.app.getDatastorage().createId("idelement");
    }

    @Override
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        if (id > 0L) {
            if (id != this.id) {
                this.newElement = true;
                for (CmsAttribute att : this.getAttributes()) {
                    att.setParent(this);
                }
            }
            this.getLongAttribute(META_ID).setValue(id);
        }
        this.id = id;
    }

    public long getOriginalId() {
        return this.originalId;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public String getUUIDasString() {
        return this.uuid == null ? "" : this.uuid.toString();
    }

    public UUID createNewUUID() {
        this.uuid = UUID.randomUUID();
        return this.uuid;
    }

    public void setUUID(String uuid) {
        if (uuid != null && !"".equals(uuid)) {
            this.uuid = UUID.fromString(uuid);
        }
    }

    public String getLang() {
        return this.lang.toLowerCase();
    }

    public void setLang(String lang) {
        this.lang = lang.toLowerCase();
    }

    public String getMD5() {
        return this.getMD5(new ArrayList<String>());
    }

    public String getMD5withoutMeta() {
        return this.getMD5withoutMeta(null);
    }

    public String getMD5withoutMeta(String ignoreAttributes) {
        ArrayList<String> attcodes = new ArrayList<String>();
        for (CmsAttribute meta : this.getMetaAttributes()) {
            attcodes.add(meta.getCode());
        }
        if (ignoreAttributes != null) {
            attcodes.addAll(new ArrayList<String>(Arrays.asList(ignoreAttributes.split(","))));
        }
        return this.getMD5(attcodes);
    }

    public String getMD5(String ignoreAttributes) {
        if (ignoreAttributes == null) {
            return this.getMD5(new ArrayList<String>());
        }
        return this.getMD5(new ArrayList<String>(Arrays.asList(ignoreAttributes.split(","))));
    }

    public String getMD5(ArrayList<String> ignoreAttributes) {
        StringBuilder sb = new StringBuilder();
        for (CmsAttribute att : this.getAttributes()) {
            if (att.isVirtual() || att.isOfType(17) || att.isOfType(18) || META_LASTEDIT.equals(att.getCode()) || ignoreAttributes != null && ignoreAttributes.contains(att.getCode())) continue;
            sb.append(att.getCode() + "=" + att.getValue());
        }
        return Util.md5((String)sb.toString());
    }

    public void updateMD5() {
        this.md5 = this.getMD5();
    }

    public void storeOriginalMD5() {
        this.setAttributeValue(META_ORIGMD5, this.getMD5());
    }

    public void setOriginalMD5(String origmd5) {
        this.setAttributeValue(META_ORIGMD5, origmd5);
    }

    public String getOriginalMD5() {
        return this.getAttributeValue(META_ORIGMD5);
    }

    public boolean compareContent(CmsElement e) {
        if (e == null) {
            return false;
        }
        if (!e.getElementcode().equals(this.getElementcode())) {
            return false;
        }
        for (CmsAttribute att : this.getDataAttributes()) {
            CmsAttribute att2;
            if (att.equals(att2 = e.getAttribute(att.getCode()))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CmsElement)) {
            return false;
        }
        return this.getMD5().equals(((CmsElement)o).getMD5());
    }

    public boolean equalsId(Object o) {
        if (!(o instanceof CmsElement)) {
            return false;
        }
        return this.getId() == ((CmsElement)o).getId();
    }

    public boolean equalsData(CmsElement o) {
        return this.getMD5withoutMeta().equals(o.getMD5withoutMeta());
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + Objects.hashCode(this.meta);
        hash = 47 * hash + Objects.hashCode(this.attributes);
        return hash;
    }

    public boolean hasChanged() {
        return this.changed || !this.getMD5().equals(this.md5);
    }

    public boolean hasChanged(String oldMD5) {
        return this.changed || !this.getMD5().equals(oldMD5);
    }

    private void addMetaAttribute(CmsAttribute att) {
        att.setMetdata();
        this.meta.add(att);
        this.map.put(att.getCode(), att);
    }

    public void addAttribute(CmsAttribute att) {
        this.attributes.add(att);
        this.map.put(att.getCode(), att);
    }

    protected void addAttribute(int idx, CmsAttribute att) {
        this.attributes.add(idx, att);
        this.map.put(att.getCode(), att);
    }

    public ArrayList<CmsAttribute> getMetaAttributes() {
        return this.meta;
    }

    public ArrayList<CmsAttribute> getDataAttributes() {
        return this.attributes;
    }

    public ArrayList<CmsAttribute> getDataAttributes(String group) {
        if ("_first".equals(group)) {
            group = this.getAttributeGroups().get(0);
        }
        ArrayList<CmsAttribute> result = new ArrayList<CmsAttribute>();
        for (CmsAttribute att : this.attributes) {
            if (group != null && !att.getAttributegroup().equals(group)) continue;
            result.add(att);
        }
        return result;
    }

    public ArrayList<CmsAttribute> getAttributes() {
        return this.getAttributes(null);
    }

    public boolean hasAttribute(String attcode) {
        return this.getAttribute(attcode) != null;
    }

    public boolean hasAttributeValue(String attcode) {
        String v = this.getAttributeValue(attcode);
        return v != null && !"".equals(v);
    }

    public ArrayList<CmsAttribute> getAttributes(String group) {
        if ("_first".equals(group)) {
            group = this.getAttributeGroups().get(0);
        }
        ArrayList<CmsAttribute> result = new ArrayList<CmsAttribute>();
        for (CmsAttribute att : this.meta) {
            if (group != null && !"meta".equals(group)) continue;
            result.add(att);
        }
        for (CmsAttribute att : this.attributes) {
            if (group != null && !att.getAttributegroup().equals(group)) continue;
            result.add(att);
        }
        return result;
    }

    public ArrayList<String> getAttributeGroups() {
        ArrayList<String> result = new ArrayList<String>();
        for (CmsAttribute att : this.attributes) {
            if (result.contains(att.getAttributegroup())) continue;
            result.add(att.getAttributegroup());
        }
        result.add("_meta");
        if (this.getApplication().supportWorkflow()) {
            result.add("_workflow");
        }
        if (this.doAllowComments()) {
            result.add("_comments");
        }
        return result;
    }

    public ArrayList<KeyAttribute> getKeyAttributes() {
        return this.getKeyAttributes(this.getAttributes());
    }

    public ArrayList<KeyAttribute> getMetaKeyAttributes() {
        return this.getKeyAttributes(this.getMetaAttributes());
    }

    public ArrayList<KeyAttribute> getDataKeyAttributes() {
        return this.getKeyAttributes(this.getDataAttributes());
    }

    private ArrayList<KeyAttribute> getKeyAttributes(ArrayList<CmsAttribute> all) {
        ArrayList<KeyAttribute> result = new ArrayList<KeyAttribute>();
        for (CmsAttribute att : all) {
            if (!att.isOfType(8)) continue;
            result.add((KeyAttribute)att);
        }
        return result;
    }

    public ArrayList<RelationAttribute> getRelationAttributes() {
        return this.getRelationAttributes(this.getAttributes());
    }

    public ArrayList<RelationAttribute> getRelationAttributes(ArrayList<CmsAttribute> all) {
        ArrayList<RelationAttribute> result = new ArrayList<RelationAttribute>();
        for (CmsAttribute att : all) {
            if (!att.isOfType(14)) continue;
            result.add((RelationAttribute)att);
        }
        return result;
    }

    public RelationAttribute getRelationAttribute(String code) {
        CmsAttribute att = this.map.get(code);
        if (att != null && att.isOfType(14)) {
            return (RelationAttribute)att;
        }
        this.getApplication().getLogger().log(Level.WARNING, "Attribute is not of type RELATION: '" + code + "'");
        return null;
    }

    public BooleanAttribute getBooleanAttribute(String code) {
        CmsAttribute att = this.map.get(code);
        if (att != null && att.isOfType(1)) {
            return (BooleanAttribute)att;
        }
        this.getApplication().getLogger().log(Level.WARNING, "Attribute is not of type BOOLEAN: '" + code + "'");
        return null;
    }

    public KeyAttribute getKeyAttribute(String code) {
        CmsAttribute att = this.map.get(code);
        if (att != null && att.isOfType(8)) {
            return (KeyAttribute)att;
        }
        this.getApplication().getLogger().log(Level.WARNING, "Attribute is not of type KEY: '" + code + "'");
        return null;
    }

    public LongAttribute getLongAttribute(String code) {
        CmsAttribute att = this.map.get(code);
        if (att != null && att.isOfType(9)) {
            return (LongAttribute)att;
        }
        this.getApplication().getLogger().log(Level.WARNING, "Attribute is not of type LONG: '" + code + "'");
        return null;
    }

    public IntegerAttribute getIntegerAttribute(String code) {
        CmsAttribute att = this.map.get(code);
        if (att != null && att.isOfType(7)) {
            return (IntegerAttribute)att;
        }
        this.getApplication().getLogger().log(Level.WARNING, "Attribute is not of type INTEGER: '" + code + "'");
        return null;
    }

    public FloatAttribute getFloatAttribute(String code) {
        CmsAttribute att = this.map.get(code);
        if (att != null && att.isOfType(3)) {
            return (FloatAttribute)att;
        }
        this.getApplication().getLogger().log(Level.WARNING, "Attribute is not of type FLOAT: '" + code + "'");
        return null;
    }

    public DateAttribute getDateAttribute(String code) {
        CmsAttribute att = this.map.get(code);
        if (att != null && att.isOfType(2)) {
            return (DateAttribute)att;
        }
        this.getApplication().getLogger().log(Level.WARNING, "Attribute is not of type DATE: '" + code + "'");
        return null;
    }

    public ArrayList<UploadAttribute> getUploadAttributes() {
        ArrayList<UploadAttribute> result = new ArrayList<UploadAttribute>();
        for (CmsAttribute att : this.getAttributes()) {
            if (!att.isOfType(15)) continue;
            result.add((UploadAttribute)att);
        }
        return result;
    }

    public UploadAttribute getUploadAttribute(String code) {
        CmsAttribute att = this.map.get(code);
        if (att != null && (att.isOfType(15) || att.isOfType(16))) {
            return (UploadAttribute)att;
        }
        this.getApplication().getLogger().log(Level.WARNING, "Attribute is not of type UPLOAD: '" + code + "'");
        return null;
    }

    public CmsAttribute getAttribute(String code) {
        return this.map.get(code);
    }

    public String getAttributeValue(String code) {
        if ("uuid".equalsIgnoreCase(code)) {
            return this.getUUIDasString();
        }
        CmsAttribute att = this.getAttribute(code);
        if (att != null) {
            return att.getValue();
        }
        return null;
    }

    public String getAttributeValue(String code, String defaultvalue) {
        CmsAttribute att = this.getAttribute(code);
        if (att != null) {
            if (att.getValue() == null) {
                return defaultvalue;
            }
            return att.getValue();
        }
        return defaultvalue;
    }

    public int getAttributeValueInt(String code) {
        String v = this.getAttributeValue(code);
        if (v == null || "".equalsIgnoreCase(v)) {
            return -9999;
        }
        return Integer.parseInt(v);
    }

    public long getAttributeValueLong(String code) {
        String v = this.getAttributeValue(code);
        if (v == null || "".equalsIgnoreCase(v)) {
            return -9999L;
        }
        return Long.parseLong(v);
    }

    public float getAttributeValueFloat(String code) {
        String v = this.getAttributeValue(code);
        if (v == null || "".equalsIgnoreCase(v)) {
            return 0.0f;
        }
        return Float.parseFloat(v);
    }

    public boolean getAttributeValueBoolean(String code) {
        String v = this.getAttributeValue(code);
        return v != null && !"".equals(v);
    }

    public void setAttributes(Properties props) {
        for (String string : props.keySet()) {
            String val = props.getProperty(string);
            CmsAttribute att = this.getAttribute(string);
            if (att == null) continue;
            if (att.isOfType(8)) {
                Keytable keytable = ((KeyAttribute)att).getKeytable();
                long id = keytable.getIdByTerm(val, this.getLang());
                if (id < 0L) {
                    id = keytable.createNewId();
                    keytable.addTerm(id, this.getLang(), val);
                    keytable.save();
                }
                ((KeyAttribute)att).setValue(id);
                continue;
            }
            if (att.isOfType(14)) {
                Set<String> elementtypes = ((RelationAttribute)att).getElementtypes();
                CmsBasicSearch s = new CmsBasicSearch(this.app, this.currentUser, elementtypes);
                s.addWhere("el.meta_title", "=", Util.toSqlString((String)val));
                List<DataRecord> recs = s.search().getResult();
                if (recs.size() != 1) continue;
                ((RelationAttribute)att).add(recs.get(0).getLong(META_ID));
                continue;
            }
            att.setValue(val);
        }
    }

    public void setAttributeValue(String code, String value) {
        CmsAttribute att = this.getAttribute(code);
        if (att != null) {
            att.setValue(value);
        } else {
            this.getApplication().getLogger().log(Level.WARNING, "Unknown attribute '" + code + "'");
        }
    }

    public void setAttributeValueByTerm(String code, String term) {
        CmsAttribute att = this.getAttribute(code);
        if (att != null && att.isOfType(8)) {
            KeyAttribute k = (KeyAttribute)att;
            k.setValueByTerm(term);
        } else {
            this.getApplication().getLogger().log(Level.WARNING, "Unknown key attribute '" + code + "'");
        }
    }

    public String[] getAttributeMultikeyValues(String code) {
        CmsAttribute att = this.getAttribute(code);
        if (att != null && att.isOfType(10)) {
            MultikeyAttribute mk = (MultikeyAttribute)att;
            String[] values = mk.getValues();
            return values;
        }
        this.getApplication().getLogger().log(Level.WARNING, "Unknown multikey attribute '" + code + "'");
        return null;
    }

    public Long[] getAttributeMultikeyValueIds(String code) {
        CmsAttribute att = this.getAttribute(code);
        if (att != null && att.isOfType(10)) {
            MultikeyAttribute mk = (MultikeyAttribute)att;
            Long[] values = mk.getIds();
            return values;
        }
        this.getApplication().getLogger().log(Level.WARNING, "Unknown multikey attribute '" + code + "'");
        return null;
    }

    public String[] getAttributeMultikeyKeys(String code) {
        CmsAttribute att = this.getAttribute(code);
        if (att != null && att.isOfType(10)) {
            MultikeyAttribute mk = (MultikeyAttribute)att;
            String[] terms = mk.getKeys(this.lang);
            return terms;
        }
        this.getApplication().getLogger().log(Level.WARNING, "Unknown multikey attribute '" + code + "'");
        return null;
    }

    public void setAttributeMultikeyValues(String code, long[] values) {
        CmsAttribute att = this.getAttribute(code);
        if (att != null && att.isOfType(10)) {
            MultikeyAttribute mk = (MultikeyAttribute)att;
            mk.setValuesByIds(values);
        } else {
            this.getApplication().getLogger().log(Level.WARNING, "Unknown multikey attribute '" + code + "'");
        }
    }

    public void setAttributeMultikeyTerms(String code, String[] terms) {
        CmsAttribute att = this.getAttribute(code);
        if (att != null && att.isOfType(10)) {
            MultikeyAttribute mk = (MultikeyAttribute)att;
            mk.setValuesByTerms(terms);
        } else {
            this.getApplication().getLogger().log(Level.WARNING, "Unknown multikey attribute '" + code + "'");
        }
    }

    public void setMetaAttributeValue(String code, String value) {
        CmsAttribute att;
        if (!code.startsWith("meta_")) {
            code = "meta_" + code;
        }
        if ((att = this.getAttribute(code)) != null) {
            att.setValue(value);
        } else {
            this.getApplication().getLogger().log(Level.WARNING, "Unknown meta attribute '" + code + "'");
        }
    }

    public String getAttributeLabel(String att) {
        if (META_ID.equals(att)) {
            return this.app.getResourceText("core.attribute.meta_id", this.getCurrentUser().getCurrentLocale());
        }
        if ("meta_title".equals(att)) {
            return this.app.getResourceText("core.attribute.meta_title", this.getCurrentUser().getCurrentLocale());
        }
        if ("meta_summary".equals(att)) {
            return this.app.getResourceText("core.attribute.meta_summary", this.getCurrentUser().getCurrentLocale());
        }
        return this.hasAttribute(att) ? this.getAttribute(att).getLabel() : att;
    }

    public String moveToTrash() {
        return this.setTrash(true);
    }

    public String restoreFromTrash() {
        return this.setTrash(false);
    }

    private String setTrash(boolean flg) {
        if (!CmsPermission.check(this, this.getCurrentUser(), 2)) {
            return this.app.getResourceText("core.message.no_permission", this.getCurrentUser().getCurrentLocale());
        }
        Object result = null;
        if (flg) {
            this.preTrash();
        } else {
            this.preUntrash();
        }
        this.setMetaAttributeValue("trash", flg ? "true" : "false");
        this.getApplication().getDatastorage().setElementTrash(this, flg);
        this.getApplication().getDatastorage().setElementLastEdit(this.id, this.getCurrentUser());
        if (result == null) {
            if (flg) {
                this.postTrash();
            } else {
                this.postUntrash();
            }
        }
        this.app.getLogger().info("element is " + (flg ? "moved to trash" : "restored"));
        return null;
    }

    public static void moveToTrash(CmsApplication app, long id, CmsUser u) {
        CmsElementSummary ele = app.getDatastorage().loadElementSummary(id, u);
        if (ele != null && CmsPermission.check(ele, u, 2)) {
            ele.getElement().moveToTrash();
        }
    }

    @Deprecated
    public static void moveToTrash(CmsElementSummary e) {
        CmsElement ele = e.getElement();
        if (ele == null) {
            return;
        }
        String out = ele.moveToTrash();
        if (out != null) {
            e.getApplication().getLogger().log(Level.WARNING, "An error occured during TRASH: " + out);
        }
    }

    public static void restoreFromTrash(CmsElementSummary e) {
        CmsElement ele = e.getElement();
        String out = ele.setTrash(false);
        if (out != null) {
            e.getApplication().getLogger().log(Level.WARNING, "An error occured during UNTRASH: " + out);
        }
    }

    public void setReadPermission(long permissionlevel) {
        if (permissionlevel >= 1L && permissionlevel <= 4L) {
            this.getKeyAttribute(META_READACCESS).setValue(permissionlevel);
        }
    }

    public void setWritePermision(long permissionlevel) {
        if (permissionlevel >= 1L && permissionlevel <= 4L) {
            this.getKeyAttribute(META_WRITEACCESS).setValue(permissionlevel);
        }
    }

    public void setOwner(String groupname) {
        long groupid = this.getApplication().getDatastorage().checkGroup(groupname);
        if (groupid >= 0L) {
            this.getLongAttribute(META_GROUPID).setValue(groupid);
            this.setAttributeValue(META_GROUPNAME, groupname);
        }
    }

    public void load(long id, CmsUser user) {
        this.load(id, user.getCurrentLanguage(), true, user);
    }

    public void load(long id, String lang, CmsUser user) {
        this.load(id, lang, true, user);
    }

    public void load(long id, boolean loadfull, CmsUser user) {
        this.load(id, user.getCurrentLanguage(), loadfull, user);
    }

    public void load(long id, String lang, boolean loadfull, CmsUser user) {
        this.getApplication().getDatastorage().loadElement(this, id, lang, loadfull, user);
        if (this.getId() > 0L) {
            this.newElement = false;
            this.md5 = this.getMD5();
        }
    }

    public void load(UUID uuid, String lang, boolean loadfull, CmsUser user) {
        this.getApplication().getDatastorage().loadElement(this, uuid, lang, loadfull, user);
        if (this.getId() > 0L) {
            this.newElement = false;
            this.md5 = this.getMD5();
        }
    }

    public void load(String condition, String lang, boolean loadfull, CmsUser user) {
        this.getApplication().getDatastorage().loadElement(this, condition, lang, loadfull, user);
        this.newElement = false;
        this.md5 = this.getMD5();
    }

    public void reload() {
        if (this.isRemoved()) {
            throw new IllegalAccessError("The element has been removed and is no longer available");
        }
        this.clear();
        this.load(this.getId(), this.currentUser);
    }

    public boolean save() {
        return this.save(false, false);
    }

    public boolean save(boolean forcesave) {
        return this.save(forcesave, false);
    }

    public boolean save(boolean forcesave, boolean ignoreRelations) {
        if (this.getId() <= 0L) {
            this.getApplication().getLogger().warning("Element cannot be saved, ID is not set");
            return false;
        }
        if (this.isRemoved()) {
            throw new IllegalAccessError("The element has been removed and is no longer available");
        }
        if (!CmsPermission.check(this, this.currentUser, 2) && !forcesave) {
            this.setStatusmessage(this.getApplication().getResourceText("core.message.save_no_permission", this.getCurrentUser().getCurrentLocale()));
            return false;
        }
        if (!this.checkPermission(2) && !forcesave) {
            this.setStatusmessage(this.getApplication().getResourceText("core.message.save_no_permission", this.getCurrentUser().getCurrentLocale()));
            return false;
        }
        this.ignoreRelationsDuringSave = ignoreRelations;
        ((DateAttribute)this.getAttribute(META_LASTEDIT)).setDate(new Date());
        ((RelationAttribute)this.getAttribute(META_LASTEDITBY)).set(this.currentUser);
        this.setAttributeValue(META_ELEMENTTYPE, this.getElementcode());
        this.getRelationAttribute(META_MIGRATEELEMENT).clear();
        this.preSave();
        if (forcesave || this.verify(null)) {
            this.getApplication().getDatastorage().saveElement(this, ignoreRelations);
            this.app.getCache().updateCache(this.getId(), this);
            this.newElement = false;
            this.postSave();
            this.clearStatusmessage();
            for (long eleId : this.updateAfterSave) {
                this.getApplication().loadElement(eleId, this.getUser()).save(true);
            }
            this.updateAfterSave.clear();
            this.md5 = this.getMD5();
            this.ignoreRelationsDuringSave = false;
            this.setChanged(ignoreRelations);
            return true;
        }
        return false;
    }

    public CmsElement copy() {
        return this.copy(new ArrayList<String>());
    }

    public CmsElement copy(String ignoreAttributes) {
        return this.copy(new ArrayList<String>(Arrays.asList(ignoreAttributes.split(","))));
    }

    public CmsElement copy(ArrayList<String> ignoreAttributes) {
        if (this.isRemoved()) {
            throw new IllegalAccessError("The element has been removed and is no longer available");
        }
        CmsElement copy = this.getApplication().createElement(this.getElementcode(), this.getCurrentUser());
        copy.preCopy();
        copy.setId(copy.createId());
        copy.uuid = UUID.randomUUID();
        for (CmsAttribute att : this.getDataAttributes()) {
            if (ignoreAttributes.contains(att.getCode()) || ignoreAttributes.contains(att.getCode())) continue;
            copy.getAttribute(att.getCode()).copyFrom(att);
        }
        copy.postCopy();
        return copy;
    }

    public long saveCopy() {
        CmsElement copy = this.copy();
        copy.save(true);
        return copy.getId();
    }

    public CmsElement saveCopyWithoutRelations() {
        if (this.isRemoved()) {
            throw new IllegalAccessError("The element has been removed and is no longer available");
        }
        CmsElement ele = this.getApplication().loadElement(this.getId(), this.getCurrentUser());
        ele.preCopy();
        ele.setId(this.createId());
        ele.uuid = UUID.randomUUID();
        if (ele.save()) {
            ele.setSaved(true);
        }
        for (RelationAttribute rel : ele.getRelationAttributes()) {
            boolean current = rel.deleteRemoved();
            rel.setDeleteRemoved(false);
            rel.clear();
            rel.setDeleteRemoved(current);
        }
        ele.save();
        return ele;
    }

    public void remove() {
        if (this.isNew()) {
            return;
        }
        this.preRemove();
        ArrayList<Long> idsToDelete = new ArrayList<Long>();
        for (CmsAttribute iterator : this.getRelationAttributes(this.getDataAttributes())) {
            if (!((RelationAttribute)iterator).deleteRemoved()) continue;
            for (CmsElementSummary e : ((RelationAttribute)iterator).getElements()) {
                idsToDelete.add(e.getId());
            }
        }
        boolean success = this.getApplication().getDatastorage().removeElement(this);
        if (success) {
            for (UploadAttribute att : this.getUploadAttributes()) {
                for (UploadItem item : att.getAllUploadItems()) {
                    item.deleteFile();
                }
            }
            Iterator iterator = idsToDelete.iterator();
            while (iterator.hasNext()) {
                long idDelete = (Long)iterator.next();
                CmsElement.remove(this.getApplication(), idDelete, this.getCurrentUser());
            }
            this.postRemove();
            this.removed = true;
        }
    }

    public static void remove(CmsApplication app, long id, CmsUser u) {
        CmsElement ele = app.loadElement(id, u);
        if (ele != null) {
            ele.remove();
        }
    }

    public ArrayList<Date> getHistory() {
        return this.app.getDatastorage().getElementHistoryDates(this.getId());
    }

    public void revertToHistory(Date dt) {
        String xml = this.app.getDatastorage().getElementHistory(this.getId(), dt);
        if (xml != null) {
            this.update(xml);
        }
    }

    public final void applyIdMapping(long oldId, long newId) {
        ArrayList<RelationAttribute> atts = this.getRelationAttributes(this.getDataAttributes());
        for (RelationAttribute att : atts) {
            ArrayList<Long> originalIds = att.getTemporaryElementIds();
            for (long id : originalIds) {
                if (id != oldId) continue;
                att.add(newId);
            }
        }
        this.applyIdMappingForElementtype(oldId, newId);
    }

    public void applyIdMappingForElementtype(long oldId, long newId) {
    }

    public ArrayList<CmsAttribute> getElementReferenceAttributes() {
        ArrayList<CmsAttribute> atts = new ArrayList<CmsAttribute>();
        for (CmsAttribute cmsAttribute : this.getRelationAttributes()) {
            atts.add(cmsAttribute);
        }
        return atts;
    }

    public Element toJDOMElement() {
        return this.toJDOMElement(true, true);
    }

    public Element toJDOMElement(boolean withMeta, boolean withData) {
        this.preShow("view");
        Element ele = new Element(this.getElementcode().toLowerCase()).setAttribute("id", Long.toString(this.getId())).setAttribute("uuid", this.getUUID().toString()).setAttribute("lang", this.lang);
        if (withMeta) {
            Element eleMeta = new Element("meta");
            eleMeta.addContent((Content)new Element("meta_title").setText(this.getTitle()));
            eleMeta.addContent((Content)new Element("meta_summary").setText(this.getSummary()));
            for (CmsAttribute att : this.meta) {
                if (att.getCode() == null || att.isOfType(18) || att.isOfType(17)) continue;
                eleMeta.addContent((Content)att.toJDOMElement());
            }
            eleMeta.addContent((Content)new Element(META_LASTEDIT_USERNAME).setText(this.getCurrentUser().getUsername()));
            eleMeta.addContent((Content)new Element("uuid").setText(this.getUUID().toString()));
            ele.addContent((Content)eleMeta);
        }
        if (withData) {
            Element eleData = new Element("data");
            for (CmsAttribute att : this.attributes) {
                if (att.getCode() == null || att.isOfType(18) || att.isOfType(17) || att.isVirtual()) continue;
                eleData.addContent((Content)att.toJDOMElement());
            }
            ele.addContent((Content)eleData);
        }
        this.postShow("view");
        return ele;
    }

    public String toXML() {
        return Util.toXml((Element)this.toJDOMElement());
    }

    private String getButtonsAsHtml(String js) {
        String img = this.app.getResourceUrl();
        StringBuffer html = new StringBuffer();
        html.append("<table width=\"100%\">");
        html.append("<tr style=\"background:#AAAAAA\">");
        html.append("<td align=\"right\" >");
        if (CmsPermission.check(this, this.currentUser, 2)) {
            html.append("<img style=\"float:right\" onclick=\"" + js + ".updateElement();" + js + ".show(" + this.getId() + ",'trash')\" src=\"" + img + "buttons/ele_trash.gif\">");
        }
        if (CmsPermission.check(this, this.currentUser, 2)) {
            html.append("<img style=\"float:right\" onclick=\"" + js + ".updateElement();" + js + ".show(" + this.getId() + ",'edit')\" src=\"" + img + "buttons/ele_edit.gif\">");
        }
        if (CmsPermission.check(this, this.currentUser, 1)) {
            html.append("<img style=\"float:right\" onclick=\"" + js + ".updateElement();" + js + ".show(" + this.getId() + ",'view')\" src=\"" + img + "buttons/ele_view.gif\">");
        }
        if (CmsPermission.check(this, this.currentUser, 2)) {
            html.append("<img style=\"float:right\" onclick=\"" + js + ".updateElement();" + js + ".show(" + this.getId() + ",'copy')\" src=\"" + img + "buttons/ele_copy.gif\">");
        }
        html.append("</td></tr>");
        html.append("</table>");
        return html.toString();
    }

    public String getAttributegroupsAsHtml(ArrayList<String> attgroups, String attributegroup, String js) {
        String img = this.app.getResourceUrl();
        StringBuffer groups = new StringBuffer();
        String servletUrl = this.app.getServletUrl();
        groups.append(attgroups.get(0));
        for (String s : attgroups.subList(1, attgroups.size())) {
            groups.append("," + s);
        }
        StringBuffer html = new StringBuffer();
        html.append("<table class=\"grid_ele_tab\"><tr>");
        html.append("<td class=\"grid_ele_tab_space\">&nbsp;</td>");
        Iterator<String> iterator = attgroups.subList(0, attgroups.size()).iterator();
        while (iterator.hasNext()) {
            String s;
            String tabtitle = s = iterator.next();
            String style = "grid_ele_tab_content";
            if (s.equals(attributegroup)) {
                style = "grid_ele_tab_sel";
            }
            tabtitle = "main".equals(s) ? this.app.getResourceText("core.attributegroup.main", this.getCurrentUser().getCurrentLocale()) : ("_meta".equals(s) ? this.app.getResourceText("core.attributegroup.meta", this.getCurrentUser().getCurrentLocale()) : ("_comments".equals(s) ? this.app.getResourceText("core.attributegroup.comments", this.getCurrentUser().getCurrentLocale()) : this.app.getResourceText("app.attribute." + this.getElementcode() + ".attributegroup." + s, this.getCurrentUser().getCurrentLocale())));
            html.append("<td id=\"" + this.getId() + "_gridcms_element_attgroup_" + s + "_tab\" class=\"" + style + "\" onclick=\"" + js + ".showElementAttributes('" + groups + "','" + s + "','" + this.getId() + "')\">" + tabtitle + "</td>");
            html.append("<td style=\"border-bottom: 1px solid black\">&nbsp;</td>");
        }
        html.append("<td class=\"grid_ele_tab_space\" width=\"100%\" align=\"right\">");
        if (this.getCurrentUser().isAuthenticated()) {
            if (!this.isTrash() && CmsPermission.check(this, this.currentUser, 2)) {
                html.append("<img style=\"float:right\" onclick=\"" + js + ".trash(" + this.getId() + ",'" + js + "')\" src=\"" + img + "buttons/ele_trash.gif\">");
            }
            if (!this.isTrash() && CmsPermission.check(this, this.currentUser, 2)) {
                html.append("<img style=\"float:right\" onclick=\"" + js + ".update(" + this.getId() + ",'edit','" + js + "')\" src=\"" + img + "buttons/ele_edit.gif\">");
            }
            if (CmsPermission.check(this, this.currentUser, 1)) {
                html.append("<img style=\"float:right\" onclick=\"" + js + ".update(" + this.getId() + ",'view','" + js + "')\" src=\"" + img + "buttons/ele_view.gif\">");
            }
            if (CmsPermission.check(this, this.currentUser, 1) && !this.isNew()) {
                html.append("<a href=\"" + servletUrl + "pdfexport?meta_id=" + this.getId() + "\" ><img border=\"0\" style=\"float:right\" src=\"" + img + "icons/pdf.gif\"> </a>");
            }
            if ("true".equalsIgnoreCase(this.getApplication().getProperty("mail.enable_element_mail", "true")) && CmsPermission.check(this, this.currentUser, 1)) {
                html.append("<img style=\"float:right\" onclick=\"" + js + ".sendElementAsEmail(" + this.getId() + ")\" src=\"" + img + "buttons/ele_email.gif\">");
            }
            if (CmsPermission.check(this, this.currentUser, 2)) {
                html.append("<img style=\"float:right\" onclick=\"" + js + ".copy(" + this.getId() + ",'" + js + "')\" src=\"" + img + "buttons/ele_copy.gif\">");
            }
            if (this.isTrash() && CmsPermission.check(this, this.currentUser, 2)) {
                html.append("<img style=\"float:right\" onclick=\"" + js + ".untrashElement(" + this.getId() + ")\" src=\"" + img + "buttons/ele_untrash.gif\">");
            }
            if (this.isTrash() && CmsPermission.check(this, this.currentUser, 3)) {
                html.append("<img style=\"float:right\" onclick=\"" + js + ".update(" + this.getId() + ",'remove','" + js + "')\" src=\"" + img + "buttons/ele_remove.gif\">");
            }
        }
        html.append("</td>");
        html.append("</tr></table>");
        return html.toString();
    }

    public String getFormFooter(String action) {
        StringBuffer html = new StringBuffer();
        html.append("<form action=\"" + this.app.getServletUrl() + "element\" id=\"gridelement_dlg_del_form\" method=\"POST\" enctype=\"multipart/form-data\" >");
        html.append("<input type=\"hidden\" name=\"meta_id\" value=\"" + this.getId() + "\" />");
        html.append("<input type=\"hidden\" name=\"meta_lang\" value=\"" + this.getLang() + "\" />");
        html.append("<input id=\"gridcms_dlg_element_form_action\" type=\"hidden\" name=\"action\" value=\"" + action + "\" />");
        html.append("</form>");
        return html.toString();
    }

    private CmsElement getElement() {
        return this;
    }

    public String toHTMLRelationView(long parentId, String attribute, String js, int includetype, boolean first, boolean last) {
        String img = this.app.getResourceUrl();
        StringBuffer buttons = new StringBuffer();
        buttons.append("<img src=\"" + img + "buttons/ele_edit.gif\" onclick=\"alert('edit')\">");
        buttons.append("<img src=\"" + img + "buttons/move_up.gif\" onclick=\"" + js + ".moveRelation(" + parentId + ",'" + attribute + "'," + this.getId() + ",'up')\"");
        if (first) {
            buttons.append(" style=\"visibility:hidden\"");
        }
        buttons.append(">");
        buttons.append("<img src=\"" + img + "buttons/move_down.gif\" onclick=\"" + js + ".moveRelation(" + parentId + ",'" + attribute + "'," + this.getId() + ",'down')\"");
        if (last) {
            buttons.append(" style=\"visibility:none\"");
        }
        buttons.append(">");
        buttons.append("<img src=\"" + img + "buttons/ele_trash.gif\" onclick=\"" + js + ".deleteRelation(" + parentId + ",'" + attribute + "'," + this.getId() + ")\">");
        StringBuffer html = new StringBuffer();
        if (includetype == 1) {
            boolean even = false;
            String bkg = "";
            html.append("<table width=\"100%\">");
            html.append("<tr><td colspan=\"2\">");
            html.append(buttons);
            html.append("</td></tr>");
            for (CmsAttribute att : this.attributes) {
                if (att.isGeoAttribute()) continue;
                bkg = even ? " background: #DDDDDD;" : "";
                html.append(att.toHTMLview(bkg, null));
                even = !even;
            }
            html.append("</table>");
        } else if (includetype == 3) {
            html.append(buttons);
            html.append(this.getTitle());
            html.append("<br>");
        }
        return html.toString();
    }

    public String toHTMLView(String attributegroup, String js) {
        if (!CmsPermission.check(this, this.getCurrentUser(), 1)) {
            return "no permission";
        }
        return this.toHtml(attributegroup, "view", js);
    }

    public String toHTMLEdit(String attributegroup, String js) {
        if (!CmsPermission.check(this, this.getCurrentUser(), 2)) {
            return this.app.getResourceText("core.message.no_permission", this.getCurrentUser().getCurrentLocale());
        }
        return this.toHtml(attributegroup, "edit", js);
    }

    public String toHtml(String attributegroup, String mode, String js) {
        String img = this.app.getResourceUrl();
        StringBuilder html = new StringBuilder();
        String bkg = "";
        ArrayList<String> attgroups = this.getAttributeGroups();
        this.preShow(mode);
        html.append("<form action=\"").append(this.app.getServletUrl()).append("element\" id=\"gridelement_dlg_form\" method=\"POST\" enctype=\"multipart/form-data\" >");
        if ("_first".equals(attributegroup)) {
            attributegroup = this.getAttributeGroups().get(0);
        }
        html.append(this.getAttributegroupsAsHtml(attgroups, attributegroup, js));
        for (String attgroup : attgroups.subList(0, attgroups.size())) {
            boolean even;
            String visible = "none";
            if (attgroup.equalsIgnoreCase(attributegroup)) {
                visible = "yes";
            }
            html.append("<table style=\"display: " + visible + " \" id=\"" + this.getId() + "_gridcms_element_attgroup_" + attgroup + "\" width=\"100%\">");
            if ("_meta".equalsIgnoreCase(attgroup) && this.getApplication().isShowMetadata()) {
                even = false;
                bkg = even ? " background: #DDDDDD;" : "";
                boolean bl = even = !even;
                if (this.app.isMultilingual()) {
                    bkg = even ? " background: #DDDDDD;" : "";
                    even = !even;
                }
                for (CmsAttribute att : this.meta) {
                    String string = bkg = even ? " background: #DDDDDD;" : "";
                    if ("edit".equalsIgnoreCase(mode) && CmsPermission.check(this, this.currentUser, 3)) {
                        html.append(att.toHTMLedit(bkg, js));
                    } else {
                        html.append(att.toHTMLview(bkg, null));
                    }
                    even = !even;
                }
            } else if ("_comments".equalsIgnoreCase(attgroup) && this.doAllowComments() && this.getCurrentUser().isAuthenticated()) {
                this.getApplication().getDatastorage().loadElementCommnets(this);
                for (CmsComment c : this.getComments()) {
                    if (this.getCurrentUser().getId() == (long)c.getIduser() || this.currentUser.isSuperadmin()) {
                        html.append(c.toHtml(js, c.getIdcomment(), true, this.getId(), this.getApplication()));
                        continue;
                    }
                    html.append(c.toHtml(js, c.getIdcomment(), false, this.getId(), this.getApplication()));
                }
                html.append(CmsComment.toHtmlEdit(this, js));
            } else if ("_workflow".equalsIgnoreCase(attgroup)) {
                if (this.getApplication().supportWorkflow()) {
                    even = false;
                    bkg = even ? " background: #DDDDDD;" : "";
                    CmsAttribute wrkflw = this.getAttribute(META_STATUS);
                    if ("edit".equalsIgnoreCase(mode)) {
                        html.append(wrkflw.toHTMLedit(bkg, js));
                    } else {
                        html.append(wrkflw.toHTMLview(bkg, null));
                    }
                }
            } else {
                for (CmsAttribute att : this.getDataAttributes(attgroup)) {
                    even = false;
                    if (att.isGeoAttribute() || att.isHidden()) continue;
                    String string = bkg = even ? " background: #DDDDDD;" : "";
                    if ("edit".equalsIgnoreCase(mode)) {
                        html.append(att.toHTMLedit(bkg, js));
                    } else {
                        html.append(att.toHTMLview(bkg, js));
                    }
                    even = !even;
                }
            }
            html.append("</table>");
        }
        html.append(this.getFormFooter("save"));
        html.append("</form>");
        this.postShow(mode);
        return html.toString();
    }

    public String toHTMLTrash(String js) {
        StringBuffer html = new StringBuffer();
        boolean even = false;
        String bkg = "";
        html.append("<p>" + this.app.getResourceText("core.message.move_to_trash", this.getCurrentUser().getCurrentLocale()) + "<br>");
        html.append("[" + this.getId() + "] '" + this.getTitle() + "'<br>");
        html.append(this.getFormFooter("trash"));
        return html.toString();
    }

    public String toHTMLUntrash(String js) {
        StringBuffer html = new StringBuffer();
        boolean even = false;
        String bkg = "";
        html.append("<p>" + this.app.getResourceText("core.message.remove_from_trash", this.getCurrentUser().getCurrentLocale()) + "<br>");
        html.append("[" + this.getId() + "] '" + this.getTitle() + "'<br>");
        html.append(this.getFormFooter("trash"));
        return html.toString();
    }

    public String toHTMLManage(String js) {
        StringBuffer html = new StringBuffer();
        boolean even = false;
        String bkg = "";
        html.append(this.getButtonsAsHtml(js));
        html.append("<table>");
        html.append(this.getAttribute(META_READACCESS).toHTMLedit("", js));
        html.append(this.getAttribute(META_WRITEACCESS).toHTMLedit("", js));
        html.append(this.getAttribute(META_GROUPID).toHTMLedit("", js));
        html.append(this.getAttribute(META_USERID).toHTMLedit("", js));
        html.append("</table>");
        html.append(this.getFormFooter("savemeta"));
        return html.toString();
    }

    public String toHTMLWorkflow() {
        return "not yet implemented";
    }

    public static String listAsSelect(CmsApplication app, String id, String name, Set<String> elementtypes, CmsUser user) {
        StringBuffer html = new StringBuffer();
        CmsSqlSearch s = new CmsSqlSearch(app, user);
        s.addSelectMeta();
        s.setElementtypes(elementtypes);
        List<DataRecord> recs = s.search().getResult();
        html.append("<select id=\"" + id + "\" name=\"" + name + "\">");
        for (DataRecord rec : recs) {
            html.append("<option value=" + rec.get(META_ID) + ">" + rec.get("meta_title") + "</option>");
        }
        html.append("</select>");
        return html.toString();
    }

    public String getSubelementCSS() {
        return "";
    }

    protected void preCreate() {
    }

    protected void postCreate() {
    }

    protected void preLoad() {
    }

    protected void postLoad() {
    }

    protected void preSave() {
    }

    protected void postSave() {
    }

    protected void preCopy() {
    }

    protected void postCopy() {
    }

    protected void preUpdate() {
    }

    public final void preUpdateElement() {
        this.preUpdate();
    }

    public final void postUpdateElement() {
        this.postUpdate();
        for (RelationAttribute att : this.getRelationAttributes()) {
            if (!att.isSubelement()) continue;
            for (CmsElement e : att.getFullElements()) {
                e.postUpdate();
            }
        }
    }

    protected void postUpdate() {
    }

    protected void preWorkflow() {
    }

    protected void postWorkflow() {
    }

    protected void preTrash() {
    }

    protected void postTrash() {
    }

    protected void preUntrash() {
    }

    protected void postUntrash() {
    }

    protected void preRemove() {
    }

    protected void postRemove() {
    }

    protected void preShow(String mode) {
    }

    protected void postShow(String mode) {
    }

    public final boolean verify(String prefix) {
        StringBuilder sb = new StringBuilder();
        if (prefix == null) {
            sb.append(this.getApplication().getResourceText("core.message.attribute_not_set", this.getCurrentUser().getCurrentLocale()));
        }
        boolean founderror = false;
        for (CmsAttribute att : this.getDataAttributes()) {
            if (att.isVirtual()) continue;
            if (att.isRequired() && !att.hasValue()) {
                sb.append("\n- '").append(prefix == null ? "" : prefix + ".").append(att.getLabel()).append("'");
                founderror = true;
            }
            if (att.isOfType(12)) {
                // empty if block
            }
            if (!att.isOfType(14) || !((RelationAttribute)att).isSubelement()) continue;
            for (long idsub : ((RelationAttribute)att).getElementIds()) {
                CmsElement sub = ((RelationAttribute)att).getFullElement(idsub);
                if (sub == null) {
                    sb.append("\n").append("Fehler bei '" + this.getTitle() + "' ... Sub-Element mit ID " + idsub + " nicht gefunden");
                    continue;
                }
                boolean verified = sub.verify(att.getLabel());
                if (verified) continue;
                sb.append("\n").append(sub.getStatusmessage());
                founderror = true;
            }
        }
        if (founderror) {
            this.setStatusmessage(sb.toString());
            this.getApplication().getLogger().warning(sb.toString());
            return false;
        }
        return this.verifyElement();
    }

    protected boolean verifyElement() {
        return true;
    }

    public boolean checkPermission(int action) {
        return true;
    }

    public ArrayList<ElementUpdateListener> getUpdateListener() {
        return this.updateListener;
    }

    protected int getDefaultReadaccess() {
        return this.getAccessLevel("conf.default.readaccess", "owner");
    }

    protected int getDefaultWriteaccess() {
        return this.getAccessLevel("conf.default.writeaccess", "creator");
    }

    protected int getAccessLevel(String type, String defaultvalue) {
        String level = this.getApplication().getProperty(type, defaultvalue);
        if ("public".equalsIgnoreCase(level)) {
            return 1;
        }
        if ("authenticated".equalsIgnoreCase(level)) {
            return 2;
        }
        if ("owner".equalsIgnoreCase(level)) {
            return 3;
        }
        if ("creator".equalsIgnoreCase(level)) {
            return 4;
        }
        this.getApplication().getLogger().warning("Cannot read identify access setting: " + level);
        return 3;
    }

    protected int getDefaultWorkflowstatus() {
        if (this.app.supportWorkflow()) {
            return 1;
        }
        return 4;
    }

    public CmsElement createNewInstance(CmsUser user, long idElement) {
        return this.createNewInstance(this.app, this.spec, user, idElement);
    }

    public CmsElement createNewInstance(CmsApplication app, Element xml, CmsUser user) {
        return this.createNewInstance(app, xml, user, this.createId());
    }

    public CmsElement createNewInstance(CmsApplication app, Element xml, CmsUser user, long idelement) {
        String classname = xml.getAttributeValue("class");
        if (classname == null) {
            classname = "at.grid.cms.element.CmsElement";
        }
        CmsElement e = null;
        try {
            e = (CmsElement)this.getClass().newInstance();
        }
        catch (InstantiationException ex) {
            this.getApplication().getLogger().log(Level.SEVERE, "Class '" + xml.getAttributeValue("class") + "' could not be instantiated", ex);
        }
        catch (IllegalAccessException ex) {
            this.getApplication().getLogger().log(Level.SEVERE, "Empty constructor for class '" + xml.getAttributeValue("class") + "' could not be accessed", ex);
        }
        e.initialise(app, user, idelement, this.spec);
        e.preCreate();
        e.uuid = UUID.randomUUID();
        e.setCurrentUser(user);
        e.setId(idelement);
        e.setCreation(user);
        e.postCreate();
        e.md5 = e.getMD5();
        return e;
    }

    public String getSummary() {
        if (this.summaryspec != null && !"".equals(this.summaryspec)) {
            StringBuffer sb = new StringBuffer();
            for (String s : this.summaryspec.split(",")) {
                if (this.getAttributeValue(s) == null) continue;
                sb.append(this.getAttributeValue(s)).append(" ");
            }
            return sb.toString().trim();
        }
        return "";
    }

    public String getTitle() {
        if (this.title != null) {
            return this.title;
        }
        if (this.titlespec == null || "".equals(this.titlespec)) {
            for (CmsAttribute att : this.getAttributes()) {
                if (!att.isOfType(12) && !att.isOfType(13)) continue;
                return att.getValue();
            }
            return this.app.getResourceText("core.message.no_title", this.getCurrentUser().getCurrentLocale());
        }
        StringBuffer sb = new StringBuffer();
        for (String s : this.titlespec.split(",")) {
            if (this.getAttributeValue(s) == null) continue;
            sb.append(this.getAttributeValue(s)).append(" ");
        }
        String result = sb.toString().trim();
        if (result.isEmpty()) {
            return this.app.getResourceText("core.message.no_title", this.getCurrentUser().getCurrentLocale());
        }
        return result;
    }

    public void setTitle(String t) {
        this.title = t;
        if (this.titlespec != null && !"".equals(this.titlespec)) {
            String attcode = this.titlespec.split(",")[0];
            this.setAttributeValue(attcode, t);
        }
    }

    public String getElementcode() {
        if (this.elementcode != null) {
            return this.elementcode;
        }
        throw new UnsupportedOperationException("No elementcode defined!");
    }

    public String getTablename() {
        if (this.tablename != null) {
            return this.tablename;
        }
        throw new UnsupportedOperationException("No table name defined!");
    }

    public String toString() {
        return "< " + this.getId() + ", " + this.getTitle() + " >";
    }

    public boolean isSameElement(CmsElement ele) {
        if (this.uuid == null) {
            return false;
        }
        return this.uuid.equals(ele.getUUID());
    }

    public static Comparator<CmsElement> titleComparator() {
        return new Comparator<CmsElement>(){

            @Override
            public int compare(CmsElement o1, CmsElement o2) {
                return this.prep(o1.getTitle()).compareToIgnoreCase(this.prep(o2.getTitle()));
            }

            private String prep(String s) {
                return s.toLowerCase().replace('\u00e4', 'a').replace('\u00f6', 'o').replace('\u00fc', 'u').replace('\u00df', 's').replace('\u00e9', 'e').replace('\u00e8', 'e');
            }
        };
    }

    public static Comparator<CmsElement> idComparator() {
        return new Comparator<CmsElement>(){

            @Override
            public int compare(CmsElement o1, CmsElement o2) {
                return new Long(o1.getId()).compareTo(new Long(o2.getId()));
            }
        };
    }

    public static Comparator<CmsElement> attributeComparator(String attcode) {
        return new AttributeComparator(attcode);
    }

    public CmsUser getUser() {
        return this.currentUser;
    }

    public void setDefaultAttributes() {
    }

    public final void actionButton(String buttoncode) {
        long idMigrate;
        if ("meta_migratebutton".equals(buttoncode) && (idMigrate = this.getRelationAttribute(META_MIGRATEELEMENT).getFirstElementId()) >= 0L) {
            CmsElement migrate = this.getApplication().loadElement(idMigrate, this.getCurrentUser());
            for (RelationAttribute att : this.getRelationAttributes()) {
                RelationAttribute migrateAtt = migrate.getRelationAttribute(att.getCode());
                ArrayList<Long> removeFromMigrate = new ArrayList<Long>();
                if (migrateAtt == null || !att.isEmpty() && (att.isSingle() || att.isSizeOne())) continue;
                for (CmsElementSummary ele : migrateAtt.getElements()) {
                    att.add(ele);
                    removeFromMigrate.add(ele.getId());
                    if (this.updateAfterSave.contains(ele.getId())) continue;
                    this.updateAfterSave.add(ele.getId());
                }
                Iterator<CmsElementSummary> iterator = removeFromMigrate.iterator();
                while (iterator.hasNext()) {
                    long eleid = (Long)((Object)iterator.next());
                    migrateAtt.delete(eleid);
                }
            }
            migrate.save(true);
        }
        this.actionButtonLocal(buttoncode);
    }

    public void actionButtonLocal(String buttoncode) {
    }

    public void addAttributesFromParent(CmsElement parent) {
        this.app.getLogger().log(Level.INFO, "Method addAttributeFromParent not implemented!");
    }

    static class AttributeComparator
    implements Comparator<CmsElement> {
        String attcode;

        public AttributeComparator(String attcode) {
            this.attcode = attcode;
        }

        @Override
        public int compare(CmsElement o1, CmsElement o2) {
            if (o1 == null || o2 == null) {
                return 0;
            }
            if (!o1.getElementcode().equals(o2.getElementcode())) {
                return o1.getElementcode().compareTo(o2.getElementcode());
            }
            if (o1.hasAttributeValue(this.attcode)) {
                if (!o2.hasAttributeValue(this.attcode)) {
                    return 1;
                }
                if (o1.getAttribute(this.attcode).isOfType(2) && o2.getAttribute(this.attcode).isOfType(2)) {
                    return ((DateAttribute)o1.getAttribute(this.attcode)).getDate().compareTo(((DateAttribute)o2.getAttribute(this.attcode)).getDate());
                }
                if (o1.getAttribute(this.attcode).isNumber() && o2.getAttribute(this.attcode).isNumber()) {
                    Double v1 = Util.parseDouble((String)o1.getAttributeValue(this.attcode), (double)0.0);
                    Double v2 = Util.parseDouble((String)o2.getAttributeValue(this.attcode), (double)0.0);
                    return v1.compareTo(v2);
                }
                return o1.getAttributeValue(this.attcode).compareToIgnoreCase(o2.getAttributeValue(this.attcode));
            }
            return o2.hasAttributeValue(this.attcode) ? -1 : 0;
        }
    }
}

