/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cms.element;

import at.grid.cms.CmsApplication;
import at.grid.cms.attribute.CmsAttribute;
import at.grid.cms.attribute.ImageAttribute;
import at.grid.cms.attribute.MultikeyAttribute;
import at.grid.cms.attribute.RelationAttribute;
import at.grid.cms.attribute.UploadAttribute;
import at.grid.cms.content.UploadItem;
import at.grid.cms.element.CmsComment;
import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsElementSummary;
import at.grid.cms.element.CmsUser;
import at.grid.cms.search.AbstractWebSearch;
import at.grid.util.Util;
import com.lowagie.text.BadElementException;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfPageEventHelper;
import com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.Date;
import java.util.logging.Level;

public class CmsElementPdfExport {
    ByteArrayOutputStream fos = new ByteArrayOutputStream();
    AbstractWebSearch aws = null;
    String[] ids = null;
    CmsApplication app = null;
    CmsUser user = null;
    Document document = null;
    PageEvent pageEvent = new PageEvent();
    int fontFamily = 1;
    ParagraphFormat formatTitle = new ParagraphFormat(new Font(this.fontFamily, 14.0f, 1), 0.0f, 10.0f);
    ParagraphFormat formatSection = new ParagraphFormat(new Font(this.fontFamily, 12.0f, 4), 10.0f, 8.0f);
    ParagraphFormat formatCommentTitle = new ParagraphFormat(new Font(this.fontFamily, 10.0f, 4), 5.0f, 3.0f);
    ParagraphFormat formatAttribute = new ParagraphFormat(new Font(this.fontFamily, 10.0f, 0), 0.0f, 0.0f);

    public CmsElementPdfExport(String[] ids, CmsApplication app, CmsUser user) throws DocumentException, FileNotFoundException {
        this.ids = ids;
        this.app = app;
        this.user = user;
    }

    public void setFontSize(float sizeTitle, float sizeSection, float sizeAttribute) {
        this.formatTitle.font.setSize(sizeTitle);
        this.formatAttribute.font.setSize(sizeAttribute);
        this.formatSection.font.setSize(sizeSection);
    }

    public void createPdf() throws DocumentException {
        this.document = new Document(PageSize.A4);
        this.fos = new ByteArrayOutputStream();
        PdfWriter writer = PdfWriter.getInstance((Document)this.document, (OutputStream)this.fos);
        writer.setPageEvent((PdfPageEvent)this.pageEvent);
        this.document.open();
        for (String id : this.ids) {
            CmsElement element = this.app.loadElement(Long.parseLong(id), this.user);
            try {
                this.writeElementToPdf(element);
            }
            catch (Exception ex) {
                this.app.getLogger().log(Level.SEVERE, "Error while creating PDF for element ID " + id + ", " + ex.toString());
            }
        }
        this.document.close();
    }

    public byte[] getByteArrayOfPdf() throws DocumentException {
        this.createPdf();
        return this.fos.toByteArray();
    }

    public void writeToFile(File outputfile) throws FileNotFoundException, IOException, DocumentException {
        this.createPdf();
        FileOutputStream file = new FileOutputStream(outputfile);
        this.fos.writeTo(file);
        file.close();
    }

    private Paragraph createParagraph(String content, ParagraphFormat fmt) {
        Paragraph paragraph = new Paragraph(content, fmt.font);
        paragraph.setSpacingBefore(fmt.spacingBefore);
        paragraph.setSpacingAfter(fmt.spacingAfter);
        return paragraph;
    }

    private void writeElementToPdf(CmsElement element) throws DocumentException, BadElementException, MalformedURLException, IOException {
        this.pageEvent.setHeader(element.getTitle());
        this.document.add((Element)this.createParagraph(element.getTitle(), this.formatTitle));
        for (CmsAttribute att : element.getDataAttributes()) {
            this.addAttributeToDocument(att);
        }
        if (element.doAllowComments()) {
            this.document.add((Element)this.createParagraph(this.app.getResourceText("core.element.comment", element.getCurrentUser().getCurrentLocale()), this.formatSection));
            element.getApplication().getDatastorage().loadElementCommnets(element);
            for (CmsComment comment : element.comments) {
                this.document.add((Element)this.createParagraph(comment.getName() + " (" + Util.formatDate((Date)comment.getIssuedate(), (String)Util.DATETIME_READ) + "):", this.formatCommentTitle));
                this.document.add((Element)this.createParagraph(comment.getComment(), this.formatAttribute));
            }
        }
        this.document.add((Element)this.createParagraph("Metadata", this.formatSection));
        for (CmsAttribute att : element.getMetaAttributes()) {
            if (!"meta_id".equals(att.getCode()) && !"meta_lastedit".equals(att.getCode()) && !"meta_lasteditby".equals(att.getCode())) continue;
            this.addAttributeToDocument(att);
        }
        this.document.add((Element)this.createParagraph(" ", this.formatAttribute));
        this.document.add((Element)this.createParagraph("Generated by: " + this.user.getUsername() + ", " + Util.formatDate((Date)new Date(System.currentTimeMillis()), (String)Util.DATETIME_READ), this.formatAttribute));
        this.document.newPage();
        if (this.document.getPageNumber() % 2 == 0) {
            this.document.newPage();
        }
    }

    private void addAttributeToDocument(CmsAttribute att) throws DocumentException, BadElementException, MalformedURLException, IOException {
        if (att.isShowView() && !att.isHidden()) {
            if (att.getType() == 17) {
                this.document.add((Element)this.createParagraph("", this.formatSection));
                this.document.add((Element)this.createParagraph(att.getLabel(), this.formatSection));
            } else if (att.getType() != 18) {
                if (att.getType() == 14) {
                    boolean first = true;
                    if (((RelationAttribute)att).isSubelement()) {
                        int count = 1;
                        for (CmsElement sub : ((RelationAttribute)att).getFullElements()) {
                            this.insertSubelement(att.getLabel() + " " + count, sub);
                            ++count;
                        }
                    } else {
                        RelationAttribute relation = (RelationAttribute)att;
                        for (CmsElementSummary e : relation.getElements()) {
                            if (e.isTrash()) continue;
                            String content = e.getTitle();
                            if (relation.getIncludeType() == 2) {
                                content = content + "\n" + e.getSummary();
                            }
                            this.insertLabelAndText(first ? att.getLabel() : "", content);
                            first = false;
                        }
                    }
                } else if (att.getType() == 10) {
                    boolean first = true;
                    MultikeyAttribute multikey = (MultikeyAttribute)att;
                    for (String s : multikey.getValues()) {
                        this.insertLabelAndText(first ? att.getLabel() : "", s);
                        first = false;
                    }
                } else if (att.getType() == 15) {
                    boolean first = true;
                    UploadAttribute uploadAttribute = (UploadAttribute)att;
                    for (UploadItem item : uploadAttribute.getUploadItems()) {
                        this.insertLabelAndText(first ? att.getLabel() : "", item.getFilename());
                        first = false;
                    }
                } else if (att.getType() == 16) {
                    boolean first = true;
                    ImageAttribute imageAttribute = (ImageAttribute)att;
                    for (UploadItem item : imageAttribute.getUploadItems()) {
                        Image image = Image.getInstance((String)item.getAbsolutePath());
                        image.scaleAbsoluteWidth(70.0f);
                        if (first) {
                            this.insertImage(att.getLabel(), image);
                            continue;
                        }
                        this.insertImage("", image);
                    }
                } else {
                    this.insertLabelAndText(att.getLabel(), att.getValue());
                }
            }
        }
    }

    private void insertLabelAndText(String label, String title) throws DocumentException {
        PdfPTable table = new PdfPTable(2);
        table.setWidths(new int[]{25, 70});
        PdfPCell cell = new PdfPCell();
        cell.setBorder(0);
        cell.setPhrase(new Phrase(label, this.formatAttribute.font));
        table.addCell(cell);
        cell.setPhrase(new Phrase(title, this.formatAttribute.font));
        table.addCell(cell);
        table.completeRow();
        table.setHorizontalAlignment(0);
        this.document.add((Element)table);
    }

    private void insertSubelement(String lbl, CmsElement ele) throws DocumentException {
        PdfPTable table = new PdfPTable(3);
        table.setWidths(new int[]{25, 20, 50});
        boolean first = true;
        for (CmsAttribute att : ele.getDataAttributes()) {
            if (att.isHidden() || !att.isShowView() || att.isOfType(18)) continue;
            PdfPCell cell = new PdfPCell();
            cell.setBorder(0);
            cell.setPhrase(new Phrase(first ? lbl : "", this.formatAttribute.font));
            table.addCell(cell);
            cell.setPhrase(new Phrase(att.getLabel(), this.formatAttribute.font));
            table.addCell(cell);
            cell.setPhrase(new Phrase(att.getValue(), this.formatAttribute.font));
            table.addCell(cell);
            table.completeRow();
            table.setHorizontalAlignment(0);
            first = false;
        }
        this.document.add((Element)table);
    }

    private void insertImage(String label, Image image) throws DocumentException {
        PdfPTable table = new PdfPTable(2);
        table.setWidths(new int[]{25, 70});
        PdfPCell cell = new PdfPCell();
        cell.setBorder(0);
        cell.setPhrase(new Phrase(label, this.formatAttribute.font));
        table.addCell(cell);
        cell.setImage(image);
        table.addCell(cell);
        table.completeRow();
        table.setHorizontalAlignment(0);
        this.document.add((Element)table);
    }

    class ParagraphFormat {
        Font font;
        float spacingBefore = 0.0f;
        float spacingAfter = 0.0f;

        public ParagraphFormat(Font f, float spaceBefore, float spaceAfter) {
            this.font = f;
            this.spacingAfter = spaceAfter;
            this.spacingBefore = spaceBefore;
        }
    }

    class PageEvent
    extends PdfPageEventHelper {
        String header = "";

        public void setHeader(String h) {
            this.header = h;
        }

        public void onEndPage(PdfWriter writer, Document document) {
            PdfContentByte cb = writer.getDirectContent();
            ColumnText.showTextAligned((PdfContentByte)cb, (int)1, (Phrase)new Phrase(this.header), (float)((document.right() - document.left()) / 2.0f + document.leftMargin()), (float)(document.top() + 10.0f), (float)0.0f);
            ColumnText.showTextAligned((PdfContentByte)cb, (int)1, (Phrase)new Phrase("Seite " + document.getPageNumber()), (float)((document.right() - document.left()) / 2.0f + document.leftMargin()), (float)(document.bottom() - 10.0f), (float)0.0f);
        }
    }
}

