/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cms.element;

import at.grid.cms.CmsApplication;
import at.grid.cms.attribute.CmsAttribute;
import at.grid.cms.attribute.DateAttribute;
import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsElementPermission;
import at.grid.cms.element.CmsUser;
import at.grid.cms.storage.DataRecord;
import at.grid.cms.swing.CmsBasicElement;
import java.util.Date;
import java.util.TimeZone;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom.Content;
import org.jdom.Element;

public class CmsElementSummary
implements CmsElementPermission {
    private CmsApplication app;
    private long id;
    private UUID uuid;
    private String title;
    private String summary;
    private String lang;
    private String elementtype;
    private long workflowStatus;
    private boolean trash;
    private CmsElement parent;
    private long ownerId;
    private long creatorId;
    private Date lastedit;
    private long lasteditbyId;
    private long readAccess;
    private long writeAccess;
    private int oppositesortorder;
    private boolean saved;
    private CmsElement referenceElement;
    private CmsUser currentUser = null;
    private String iconFilePath = null;

    public CmsElementSummary() {
        throw new UnsupportedOperationException("Empty constructor not supported");
    }

    public CmsElementSummary(CmsElement summary) {
        this(null, summary);
    }

    public CmsElementSummary(CmsElement parent, CmsElement summary) {
        this.parent = parent;
        this.referenceElement = summary;
        this.app = parent != null ? parent.getApplication() : summary.getApplication();
        try {
            this.id = summary.getId();
            this.uuid = summary.getUUID();
            this.lang = summary.getLang();
            this.title = summary.getTitle();
            this.summary = summary.getSummary();
            this.elementtype = summary.getElementcode();
            this.saved = !summary.isNew();
            this.currentUser = summary.getCurrentUser();
            this.ownerId = summary.getOwnerId();
            this.creatorId = summary.getCreatorId();
            this.lastedit = ((DateAttribute)summary.getAttribute("meta_lastedit")).getDate();
            this.lasteditbyId = summary.getAttributeValueLong("meta_lasteditbyid");
            this.readAccess = summary.getReadAccess();
            this.writeAccess = summary.getWriteAccess();
            this.workflowStatus = summary.getWorkflowStatus();
            this.trash = summary.getAttributeValue("meta_trash").equalsIgnoreCase("true") || summary.getAttributeValue("meta_trash").equalsIgnoreCase("t");
            this.oppositesortorder = summary.getAttributeValue("oppositesortorder") != null ? summary.getAttributeValueInt("oppositesortorder") : (summary.getAttributeValue("oppositesortordermax") != null ? summary.getAttributeValueInt("oppositesortordermax") + 1 : 1);
        }
        catch (Exception ex) {
            Logger.getLogger(CmsElementSummary.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public CmsElementSummary(CmsElement parent, DataRecord rec) {
        this.parent = parent;
        this.app = parent.getApplication();
        try {
            this.id = rec.getLong("meta_id");
            String readuuid = rec.getString("meta_uuid");
            this.uuid = readuuid == null || "".equals(readuuid) ? UUID.randomUUID() : UUID.fromString(readuuid);
            this.lang = rec.getString("meta_lang");
            this.title = rec.getString("meta_title");
            this.summary = rec.getString("meta_summary");
            this.elementtype = rec.getString("meta_elementtype");
            this.saved = true;
            this.ownerId = rec.getLong("meta_idgroup");
            this.creatorId = rec.getLong("meta_iduser");
            this.lastedit = rec.getDate("meta_lastedit", TimeZone.getDefault());
            this.lasteditbyId = rec.getLong("idmeta_lasteditby");
            this.readAccess = rec.getLong("idmeta_readaccess");
            this.writeAccess = rec.getLong("idmeta_writeaccess");
            this.workflowStatus = rec.getLong("idmeta_status");
            this.trash = rec.getString("meta_trash").equalsIgnoreCase("true") || rec.getString("meta_trash").equalsIgnoreCase("t");
            this.oppositesortorder = 1;
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public CmsElementSummary(long id, String title, String lang, CmsApplication app, CmsUser u) {
        this.id = id;
        this.title = title;
        this.lang = lang;
        this.uuid = null;
        this.app = app;
        this.currentUser = u;
    }

    public CmsElementSummary(CmsElement parent, long id, String title, String lang) {
        this.parent = parent;
        this.app = parent.getApplication();
        this.id = id;
        this.title = title;
        this.saved = true;
        this.trash = false;
        this.summary = "";
        this.lang = lang;
        this.elementtype = this.app.getDatastorage().getElementtypeById(id);
        this.uuid = this.app.getDatastorage().getElementUUIDById(id);
    }

    public CmsElementSummary(CmsElement parent, long id, String title, String lang, UUID uuid, boolean trash) {
        this.parent = parent;
        this.app = parent.getApplication();
        this.id = id;
        this.title = title;
        this.saved = true;
        this.trash = trash;
        this.summary = "";
        this.lang = lang;
        this.elementtype = this.app.getDatastorage().getElementtypeById(id);
        this.uuid = uuid;
    }

    public CmsElementSummary(CmsElement parent, String elementtype, String title) {
        this.parent = parent;
        this.app = parent.getApplication();
        this.id = parent.createId();
        this.uuid = UUID.randomUUID();
        this.lang = parent.getLang();
        this.title = title;
        this.summary = "";
        this.saved = false;
        this.elementtype = elementtype;
        this.workflowStatus = parent.getApplication().supportWorkflow() ? 1L : 4L;
        this.trash = false;
        this.ownerId = parent.getOwnerId();
        this.creatorId = parent.getCurrentUser().getId();
        this.lastedit = new Date();
        this.lasteditbyId = parent.getCurrentUser().getId();
        this.readAccess = parent.getReadAccess();
        this.writeAccess = parent.getWriteAccess();
        this.oppositesortorder = -1;
    }

    @Deprecated
    public CmsElementSummary(CmsApplication app, DataRecord rec) {
        this(app, rec, null);
    }

    public CmsElementSummary(CmsApplication app, DataRecord rec, CmsUser u) {
        this.app = app;
        this.currentUser = u;
        this.id = rec.getLong("meta_id");
        String readuuid = rec.getString("meta_uuid");
        this.uuid = readuuid == null || "".equals(readuuid) ? UUID.randomUUID() : UUID.fromString(readuuid);
        this.lang = rec.getString("meta_lang");
        this.title = rec.getString("meta_title");
        this.summary = rec.getString("meta_summary");
        this.elementtype = rec.getString("meta_elementtype");
        this.saved = true;
        this.ownerId = rec.getLong("meta_idgroup");
        this.creatorId = rec.getLong("meta_iduser");
        this.lastedit = rec.getDate("meta_lastedit", app.getTimeZone());
        this.lasteditbyId = rec.getLong("idmeta_lasteditby");
        this.readAccess = rec.getLong("idmeta_readaccess");
        this.writeAccess = rec.getLong("idmeta_writeaccess");
        this.workflowStatus = rec.getLong("idmeta_status");
        this.trash = rec.getString("meta_trash", "false").equalsIgnoreCase("true") || rec.getString("meta_trash", "false").equalsIgnoreCase("t");
        this.oppositesortorder = rec.getString("oppositesortorder") != null ? rec.getInt("oppositesortorder") : (rec.getString("oppositesortordermax") != null ? rec.getInt("oppositesortordermax") + 1 : 1);
    }

    public void update(CmsElementSummary summary) {
        if (summary.getId() == this.getId() && summary.getElementtype().equals(this.getElementtype())) {
            this.uuid = summary.getUUID();
            this.lang = summary.getLang();
            this.title = summary.getTitle();
            this.summary = summary.getSummary();
            this.ownerId = summary.getOwnerId();
            this.creatorId = summary.getCreatorId();
            this.lastedit = summary.getLastEdit();
            this.lasteditbyId = summary.getLastEditById();
            this.readAccess = summary.getReadAccess();
            this.writeAccess = summary.getWriteAccess();
            this.workflowStatus = summary.getWorkflowStatus();
            this.trash = summary.isTrash();
            this.oppositesortorder = summary.getOppositeOrder();
        }
    }

    public void update(CmsElement summary) {
        if (summary.getId() == this.getId() && summary.getElementcode().equals(this.getElementtype())) {
            this.uuid = summary.getUUID();
            this.lang = summary.getLang();
            this.title = summary.getTitle();
            this.summary = summary.getSummary();
            this.ownerId = summary.getOwnerId();
            this.creatorId = summary.getCreatorId();
            this.readAccess = summary.getReadAccess();
            this.writeAccess = summary.getWriteAccess();
            this.workflowStatus = summary.getWorkflowStatus();
            this.trash = summary.isTrash();
        }
    }

    public CmsApplication getApplication() {
        return this.app;
    }

    public String getElementcode() {
        return this.elementtype;
    }

    @Override
    public long getId() {
        return this.id;
    }

    public void setId(long newId) {
        this.id = newId;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public String getLang() {
        return this.lang;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String t) {
        this.title = t;
    }

    public long getWorkflowStatus() {
        return this.workflowStatus;
    }

    @Override
    public long getOwnerId() {
        return this.ownerId;
    }

    @Override
    public long getCreatorId() {
        return this.creatorId;
    }

    public long getLastEditById() {
        return this.lasteditbyId;
    }

    public Date getLastEdit() {
        return this.lastedit;
    }

    @Override
    public long getReadAccess() {
        return this.readAccess;
    }

    @Override
    public long getWriteAccess() {
        return this.writeAccess;
    }

    public boolean isTrash() {
        return this.trash;
    }

    public void setTrash(boolean f) {
        this.trash = f;
    }

    public boolean isNew() {
        return !this.saved;
    }

    public void setSaved(boolean saved) {
        this.saved = saved;
    }

    public int getOppositeOrder() {
        return this.oppositesortorder;
    }

    public String getElementtype() {
        return this.elementtype;
    }

    public void setCurrentUser(CmsUser u) {
        this.currentUser = u;
    }

    public CmsUser getCurrentUser() {
        if (this.parent != null) {
            return this.parent.getCurrentUser();
        }
        return this.currentUser;
    }

    public CmsElement getElement() {
        return this.getApplication().loadElement(this.getId(), this.getLang(), this.getCurrentUser());
    }

    public CmsElement getElement(CmsUser u) {
        return this.getApplication().loadElement(this.getId(), this.getLang(), u);
    }

    public CmsAttribute getAttribute(String code) {
        CmsElement e = this.app.getDefaultElement(this.elementtype);
        CmsAttribute att = e.getAttribute(code);
        att.readFromDatabase(this.id);
        return att;
    }

    public CmsBasicElement toBasicElement() {
        return new CmsBasicElement(this);
    }

    public void save() {
        if (!this.isNew()) {
            return;
        }
        if (this.referenceElement != null && !this.referenceElement.isNew()) {
            return;
        }
        CmsElement e = this.getApplication().createElement(this);
        e.save(true);
        this.saved = true;
        this.id = e.getId();
        if (this.referenceElement != null) {
            this.referenceElement.setSaved(true);
        }
    }

    public void setIconFile(String filepath) {
        this.iconFilePath = filepath;
    }

    public String getIconFile() {
        return this.iconFilePath;
    }

    public Element toJDOMElement() {
        String l = this.lang;
        if (l == null) {
            l = "";
        }
        String elementcode = this.getElementcode();
        String uuid = "";
        if (this.getUUID() != null) {
            uuid = this.getUUID().toString();
        } else if (this.app.getDatastorage().getElementUUIDById(this.getId()) != null) {
            uuid = this.app.getDatastorage().getElementUUIDById(this.getId()).toString();
        }
        Element ele = new Element(elementcode.toLowerCase()).setAttribute("id", Long.toString(this.getId())).setAttribute("uuid", uuid).setAttribute("lang", l);
        String t = this.getTitle();
        if (t == null) {
            t = "";
        }
        ele.addContent((Content)new Element("title").setText(t));
        String s = this.getSummary();
        if (s == null) {
            s = "";
        }
        ele.addContent((Content)new Element("summary").setText(s));
        return ele;
    }

    public String toString() {
        return this.getTitle();
    }
}

