/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cms.element;

import at.grid.cms.CmsApplication;
import at.grid.cms.attribute.CmsAttribute;
import at.grid.cms.attribute.LongAttribute;
import at.grid.cms.attribute.RelationAttribute;
import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsUser;
import at.grid.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.zip.ZipFile;
import org.jdom.Content;
import org.jdom.Element;

public class CmsElementXml {
    Element xml;
    CmsApplication app;
    CmsUser user;
    UUID originalUUID = null;
    long originalID = -1L;
    CmsElement ele;
    boolean ignoreElement = false;
    ArrayList<String> ignoreUpdateAttributes = new ArrayList();

    public CmsElementXml(CmsElement e, CmsApplication app, CmsUser user) {
        if (e == null) {
            throw new IllegalArgumentException("Constructor does not allow for null objects");
        }
        this.xml = e.toJDOMElement(true, true);
        this.app = app;
        this.user = user;
    }

    public CmsElementXml(Element e, CmsApplication app, CmsUser user) {
        this.xml = e;
        this.app = app;
        this.user = user;
        if (e.getChild("meta") == null) {
            e.addContent((Content)new Element("meta"));
        }
        if (e.getChild("data") == null) {
            e.addContent((Content)new Element("data"));
        }
    }

    public boolean isValid() {
        return this.getElementCode() != null;
    }

    public boolean isIgnored() {
        return this.ignoreElement;
    }

    public void setIgnored() {
        this.ignoreElement = true;
    }

    public Element getXml() {
        return this.xml;
    }

    public void createNewUUID() {
        this.originalUUID = this.getUUID();
        UUID newUUID = UUID.randomUUID();
        this.xml.setAttribute("uuid", newUUID.toString());
        this.getMeta().removeChild("uuid");
        this.getMeta().addContent((Content)new Element("uuid").setText(newUUID.toString()));
    }

    public void setNewId(long id) {
        this.originalID = this.getId();
        this.xml.setAttribute("id", Long.toString(id));
        this.getMeta().removeChild("meta_id");
        this.getMeta().addContent((Content)new Element("meta_id").setText(Long.toString(id)));
    }

    public boolean isElementIDInDatabase() {
        return this.app.getDatastorage().hasElement(this.getId());
    }

    public boolean isElementUUIDInDatabase() {
        return this.app.getDatastorage().hasElement(this.getUUID());
    }

    public CmsElement getElementBasedOnUUID() {
        return this.app.loadElement(this.getUUID(), this.user);
    }

    public UUID getUUID() {
        String uuid = this.xml.getAttributeValue("uuid");
        return uuid == null ? null : UUID.fromString(uuid);
    }

    public UUID getOriginalUUID() {
        return this.originalUUID == null ? this.getUUID() : this.originalUUID;
    }

    public long getId() {
        String id = this.xml.getAttributeValue("id");
        return id == null ? -1L : Util.parseLong((String)id, (long)-1L);
    }

    public long getOriginalId() {
        return this.originalID < 0L ? this.getId() : this.originalID;
    }

    public boolean isModified() {
        String v = this.getRootAttribute("modified", "false");
        return "true".equalsIgnoreCase(v) || "x".equalsIgnoreCase(v);
    }

    public CmsElement getElement() {
        if (this.ele != null) {
            return this.ele;
        }
        this.ele = this.getElementBasedOnUUID();
        if (this.ele == null) {
            this.ele = this.app.createElement(this.getElementCode(), this.user);
        }
        this.setNewId(this.ele.getId());
        return this.ele;
    }

    public void setIgnoreAttributeForUpdate(String attcode) {
        this.ignoreUpdateAttributes.add(attcode);
    }

    public CmsElement updateElement(ZipFile zip) {
        this.getElement().update_meta(this.xml);
        this.getElement().update(this.xml, zip, this.ignoreUpdateAttributes, true);
        return this.getElement();
    }

    public void updateMapping(HashMap<Long, Long> map) {
        ArrayList<CmsAttribute> atts = this.getElement().getElementReferenceAttributes();
        for (CmsAttribute att : atts) {
            Element e = this.getData().getChild(att.getCode());
            if (att instanceof RelationAttribute) {
                List items = e.getChildren();
                for (Element item : items) {
                    long xmlId = Util.parseLong((String)item.getAttributeValue("id", "-1"), (long)-1L);
                    if (!map.containsKey(xmlId)) continue;
                    item.setAttribute("id", Long.toString(map.get(xmlId)));
                }
                continue;
            }
            if (att instanceof LongAttribute) {
                long xmlId = ((LongAttribute)att).getLong();
                if (!map.containsKey(xmlId)) continue;
                ((LongAttribute)att).setValue(map.get(xmlId));
                continue;
            }
            long xmlId = Util.parseLong((String)att.getValue(), (long)-1L);
            if (!map.containsKey(xmlId)) continue;
            att.setValue(Long.toString(map.get(xmlId)));
        }
    }

    public HashMap<Long, Long> getSubelementIdMapping() {
        HashMap<Long, Long> map = new HashMap<Long, Long>();
        for (RelationAttribute att : this.getElement().getRelationAttributes()) {
            if (!att.isSubelement()) continue;
            for (CmsElement e : att.getFullElements()) {
                map.put(e.getOriginalId(), e.getId());
            }
        }
        return map;
    }

    public void saveElementWithoutRelations() {
        CmsElement eleToBeSaved = this.getElement();
        eleToBeSaved.save(true, true);
    }

    public void applyIdMapping(HashMap<Long, Long> map) {
        for (Map.Entry<Long, Long> entry : map.entrySet()) {
            this.getElement().applyIdMapping(entry.getKey(), entry.getValue());
        }
    }

    public Element getData() {
        return this.xml.getChild("data");
    }

    public String getRootAttribute(String code, String defaultValue) {
        String v = this.xml.getAttributeValue(code);
        return v == null ? defaultValue : v;
    }

    public String getDataValue(String code) {
        String v = this.getData().getChildText(code);
        return v;
    }

    public String getDataValue(String code, String defaultValue) {
        String v = this.getData().getChildText(code);
        return v == null ? defaultValue : v;
    }

    public ArrayList<Element> getUploadElements() {
        return null;
    }

    public Element getMeta() {
        return this.xml.getChild("meta");
    }

    public Element addMeta(String elementtype, String username) {
        Element eleMeta = new Element("meta");
        eleMeta.addContent((Content)new Element("meta_elementtype").setText(elementtype));
        this.xml.addContent((Content)eleMeta);
        return eleMeta;
    }

    public String getMetaValue(String code) {
        String v = this.getMeta().getChildText(code);
        return v;
    }

    public String getTitle() {
        return this.getMetaValue("meta_title");
    }

    public String getElementCode() {
        return this.getMetaValue("meta_elementtype");
    }

    public String getUsername() {
        return this.getMetaValue("meta_lastedit_username");
    }

    public String toString() {
        String t = this.getTitle();
        return this.getOriginalId() + " -> " + this.getId() + (t == null ? "" : ": " + t);
    }
}

