/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cms.element;

import at.grid.cms.attribute.CmsAttribute;
import at.grid.cms.attribute.KeyAttribute;
import at.grid.cms.attribute.RelationAttribute;
import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsGroup;
import at.grid.util.Util;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.MultiPartEmail;
import org.jdom.Content;
import org.jdom.Element;

public class CmsUser
extends CmsElement {
    public static final long CMS_ROLE_NONE = 0L;
    public static final long CMS_ROLE_GUEST = 1L;
    public static final long CMS_ROLE_AUTHOR = 2L;
    public static final long CMS_ROLE_EDITOR = 3L;
    public static final long CMS_ROLE_ADMIN = 4L;
    private Properties settings;
    private boolean authenticated;
    private CmsGroup maingroup;

    @Override
    public Element getSpecification() {
        Element ele = new Element("elementtype");
        ele.setAttribute("class", "at.grid.cms.element.CmsUser").setAttribute("code", "user").setAttribute("table", "tdtauser").setAttribute("title", "username").setAttribute("summary", "sirname,firstname");
        ele.addContent((Content)new Element("attribute").setAttribute("code", "s_contact").setAttribute("type", "section").setAttribute("group", "kontakt"));
        ele.addContent((Content)new Element("attribute").setAttribute("code", "username").setAttribute("type", "text").setAttribute("size", "40").setAttribute("field", "username").setAttribute("group", "kontakt").setAttribute("required", "true"));
        ele.addContent((Content)new Element("attribute").setAttribute("code", "email").setAttribute("type", "text").setAttribute("size", "250").setAttribute("field", "email").setAttribute("group", "kontakt").setAttribute("required", "true"));
        ele.addContent((Content)new Element("attribute").setAttribute("code", "organisation").setAttribute("type", "text").setAttribute("size", "250").setAttribute("field", "organisation").setAttribute("group", "kontakt"));
        ele.addContent((Content)new Element("attribute").setAttribute("code", "firstname").setAttribute("type", "text").setAttribute("size", "250").setAttribute("field", "firstname").setAttribute("group", "kontakt"));
        ele.addContent((Content)new Element("attribute").setAttribute("code", "sirname").setAttribute("type", "text").setAttribute("size", "250").setAttribute("field", "sirname").setAttribute("group", "kontakt").setAttribute("required", "true"));
        ele.addContent((Content)new Element("attribute").setAttribute("code", "s_credentials").setAttribute("type", "section").setAttribute("group", "kontakt"));
        ele.addContent((Content)new Element("attribute").setAttribute("code", "password").setAttribute("type", "text").setAttribute("size", "100").setAttribute("field", "password").setAttribute("password", "true").setAttribute("hidden", "true").setAttribute("group", "kontakt"));
        ele.addContent((Content)new Element("attribute").setAttribute("code", "passwordinput1").setAttribute("type", "text").setAttribute("virtual", "true").setAttribute("field", "password1").setAttribute("size", "100").setAttribute("password", "true").setAttribute("group", "kontakt"));
        ele.addContent((Content)new Element("attribute").setAttribute("code", "passwordinput2").setAttribute("type", "text").setAttribute("virtual", "true").setAttribute("field", "password2").setAttribute("size", "100").setAttribute("password", "true").setAttribute("group", "kontakt"));
        ele.addContent((Content)new Element("attribute").setAttribute("code", "question").setAttribute("type", "text").setAttribute("size", "250").setAttribute("field", "question").setAttribute("group", "kontakt"));
        ele.addContent((Content)new Element("attribute").setAttribute("code", "answer").setAttribute("type", "text").setAttribute("size", "250").setAttribute("field", "answer").setAttribute("group", "kontakt"));
        ele.addContent((Content)new Element("attribute").setAttribute("code", "s_status").setAttribute("type", "section").setAttribute("group", "status"));
        ele.addContent((Content)new Element("attribute").setAttribute("code", "inactive").setAttribute("type", "boolean").setAttribute("field", "inactive").setAttribute("group", "status"));
        ele.addContent((Content)new Element("attribute").setAttribute("code", "superadmin").setAttribute("type", "boolean").setAttribute("field", "superadmin").setAttribute("hidden", "true").setAttribute("group", "status"));
        ele.addContent((Content)new Element("attribute").setAttribute("code", "loggedin").setAttribute("type", "boolean").setAttribute("field", "loggedin").setAttribute("hidden", "true").setAttribute("group", "status"));
        ele.addContent((Content)new Element("attribute").setAttribute("code", "lastlogin").setAttribute("type", "date").setAttribute("format", "dd.MM.yyyy hh:mm:ss").setAttribute("field", "lastlogin").setAttribute("group", "status"));
        ele.addContent((Content)new Element("attribute").setAttribute("code", "loginip").setAttribute("type", "text").setAttribute("size", "250").setAttribute("field", "loginip").setAttribute("group", "status"));
        ele.addContent((Content)new Element("attribute").setAttribute("code", "settings").setAttribute("type", "textarea").setAttribute("field", "settings").setAttribute("group", "status"));
        ele.addContent((Content)new Element("attribute").setAttribute("code", "s_groups").setAttribute("type", "section").setAttribute("group", "gruppen"));
        ele.addContent((Content)new Element("attribute").setAttribute("code", "maingroup").setAttribute("type", "long").setAttribute("field", "maingroup").setAttribute("group", "gruppen").setAttribute("required", "true"));
        ele.addContent((Content)new Element("attribute").setAttribute("code", "groupadmin").setAttribute("type", "relation").setAttribute("relationcode", "groupadmin").setAttribute("elementcodes", "group").setAttribute("group", "gruppen"));
        ele.addContent((Content)new Element("attribute").setAttribute("code", "groupeditor").setAttribute("type", "relation").setAttribute("relationcode", "groupeditor").setAttribute("elementcodes", "group").setAttribute("group", "gruppen"));
        ele.addContent((Content)new Element("attribute").setAttribute("code", "groupauthor").setAttribute("type", "relation").setAttribute("relationcode", "groupauthor").setAttribute("elementcodes", "group").setAttribute("group", "gruppen"));
        ele.addContent((Content)new Element("attribute").setAttribute("code", "groupguest").setAttribute("type", "relation").setAttribute("relationcode", "groupguest").setAttribute("elementcodes", "group").setAttribute("group", "gruppen"));
        ele.addContent((Content)new Element("attribute").setAttribute("code", "membership").setAttribute("type", "relation").setAttribute("relationcode", "membership").setAttribute("elementcodes", "group").setAttribute("virtual", "true").setAttribute("group", "gruppen"));
        return ele;
    }

    @Override
    public String getTitle() {
        return CmsUser.getFullname(this.getAttributeValue("sirname"), this.getAttributeValue("firstname"), this.getUsername());
    }

    public static String getFullname(String sirname, String firstname, String username) {
        String n = "";
        if (sirname != null && !"".equals(sirname)) {
            n = sirname;
        }
        if (firstname != null && !"".equals(firstname)) {
            if (!"".equals(n)) {
                n = n + ", ";
            }
            n = n + firstname;
        }
        n = !"".equals(n) ? n + " (" + username + ")" : username;
        return n;
    }

    public String getCurrentLanguage() {
        KeyAttribute att = null;
        if (this.hasAttribute("sprache")) {
            att = this.getKeyAttribute("sprache");
        }
        String lang = null;
        if (att != null) {
            lang = ((CmsAttribute)att).getValue().toLowerCase();
        }
        if (lang == null || "".equals(lang)) {
            return this.getSettings().getProperty("user.language", this.getApplication().getDefaultUserSettings().getProperty("user.language", "de")).toLowerCase();
        }
        return lang;
    }

    public String getCurrentCountry() {
        return this.getSettings().getProperty("user.country", this.getApplication().getDefaultUserSettings().getProperty("user.country", "de")).toUpperCase();
    }

    public Locale getCurrentLocale() {
        String lang = this.getCurrentLanguage();
        String country = this.getCurrentCountry();
        return new Locale(lang, country);
    }

    public ResourceBundle getResourceBundle() {
        return ResourceBundle.getBundle("/at/grid/kai/bundle", this.getCurrentLocale());
    }

    public Properties getSettings() {
        if (this.isAnonymous()) {
            return this.getApplication().getDefaultUserSettings();
        }
        Properties p = new Properties();
        String attvalue = this.getAttributeValue("settings");
        if (attvalue != null) {
            StringReader r = new StringReader(attvalue);
            try {
                p.load(r);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return p;
    }

    public String getSettingsAsString() {
        String userSettings = "";
        try {
            StringWriter sw = new StringWriter();
            this.getSettings().store(sw, null);
            userSettings = sw.toString();
        }
        catch (IOException ex) {
            this.getApplication().getLogger().log(Level.SEVERE, "Cannot transform user settings into a string", ex);
        }
        return userSettings;
    }

    public boolean login(String username, String password) {
        return this.login(username, password, null);
    }

    public boolean login(String username, String password, String ip) {
        long userid = this.getApplication().getDatastorage().checkUser(username);
        this.load(userid, this.getApplication().getAdminUser());
        this.setAttributeValue("loginip", ip);
        if (this.isAnonymous()) {
            this.getApplication().getLogger().log(Level.WARNING, "Cannot authenticate user with username " + username + ", user not found");
        } else if (this.getBooleanAttribute("inactive").isSet()) {
            this.getApplication().getLogger().log(Level.WARNING, "Cannot authenticate user with username " + username + ", user inactive");
            this.setAnonymous();
        } else if (!this.app.getAuthenticationModule().authenticate(this.app, this.getUsername(), password)) {
            this.setAnonymous();
        } else {
            this.setAuthenticated(true);
            this.getApplication().getDatastorage().updateLastLogin(this, ip);
        }
        return this.isAuthenticated();
    }

    public void logout() {
        this.getApplication().getDatastorage().updateLogout(this);
        this.setAnonymous();
    }

    public boolean isAnonymous() {
        return "anonymous".equals(this.getUsername());
    }

    public void setAnonymous() {
        this.setId(-1L);
        this.setAttributeValue("username", "anonymous");
        this.setAttributeValue("sirname", "Anonymous");
        this.setAttributeValue("organisation", "");
        this.setAttributeValue("email", "");
        this.getRelationAttribute("groupadmin").clear();
        this.getRelationAttribute("groupeditor").clear();
        this.getRelationAttribute("groupauthor").clear();
        this.getRelationAttribute("groupguest").clear();
        this.setAttributeValue("maingroup", "-1");
        this.setAttributeValue("lastlogin", null);
        this.setAttributeValue("loginip", null);
        this.settings = this.getApplication().getDefaultUserSettings();
        this.setAttributeValue("settings", this.getSettingsAsString());
        this.setLang(this.app.getPrimaryLang());
        this.setAuthenticated(false);
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public void setAuthenticated(boolean authenticated) {
        this.authenticated = authenticated;
    }

    public String getUsername() {
        return this.getAttributeValue("username");
    }

    public boolean isSuperadmin() {
        return this.getBooleanAttribute("superadmin").isSet();
    }

    public CmsGroup getMainGroup() {
        long groupid = this.getLongAttribute("maingroup").getLong();
        if (groupid > 0L) {
            if (this.maingroup == null) {
                this.maingroup = (CmsGroup)this.app.loadElement(groupid, this);
            }
            if (this.maingroup.isNew()) {
                this.getApplication().getLogger().warning("Cannot load maingroup for user '" + this.toString() + "' with groupID " + groupid);
                return null;
            }
            return this.maingroup;
        }
        return null;
    }

    public long getMainGroupId() {
        return this.getLongAttribute("maingroup").getLong();
    }

    public void setMainGroup(long id) {
        this.setMainGroup(id, this);
    }

    public void setMainGroup(long id, CmsUser u) {
        this.getLongAttribute("maingroup").setValue(id);
        this.maingroup = (CmsGroup)this.app.loadElement(id, u);
        if (this.maingroup != null && this.maingroup.isNew()) {
            this.getLongAttribute("maingroup").setValue(-1L);
            this.maingroup = null;
            this.getApplication().getLogger().warning("Cannot set maingroup for user '" + this.toString() + "', group not found");
        }
    }

    public void addGroup(long idgroup, long role) {
        switch ((int)role) {
            case 4: {
                this.getRelationAttribute("groupadmin").add(idgroup);
                break;
            }
            case 2: {
                this.getRelationAttribute("groupauthor").add(idgroup);
                break;
            }
            case 3: {
                this.getRelationAttribute("groupeditor").add(idgroup);
                break;
            }
            case 1: {
                this.getRelationAttribute("groupguest").add(idgroup);
            }
        }
    }

    public String resetPassword() {
        String mailaddress = this.getAttributeValue("email");
        if (mailaddress == null || "".equals(mailaddress) || mailaddress.indexOf("@") < 0) {
            String msg = "Cannot reset password, no email address provided";
            this.getApplication().getLogger().warning(msg);
            return msg;
        }
        String chLetter = "abcdefghijklmnopqrstuvwxyzABCDEFGHJKLMNOPQRSTUVWXYZ";
        String chNumber = "1234567890";
        String chOther = "-_!\u00a7$%&/=?+*#.:,;";
        String[] chSelect = new String[]{chLetter, chLetter, chLetter, chLetter, chLetter, chNumber, chNumber, chOther};
        int pwdLength = 10;
        StringBuilder pwd = new StringBuilder();
        for (int counter = 0; counter < pwdLength; ++counter) {
            int idx = (int)(Math.random() * (double)chSelect.length);
            String ch = chSelect[idx];
            idx = (int)(Math.random() * (double)ch.length());
            pwd.append(ch.substring(idx, idx + 1));
        }
        try {
            MultiPartEmail email = new MultiPartEmail();
            email.setHostName(this.getApplication().getProperty("mail.smtp", ""));
            email.setFrom(mailaddress);
            email.addTo(mailaddress);
            email.setSubject("New password");
            this.setAttributeValue("passwordinput1", pwd.toString());
            this.setAttributeValue("passwordinput2", pwd.toString());
            this.save();
            email.setMsg("Das neue Passwort lautet\n  " + pwd.toString());
            email.send();
            this.getApplication().getLogger().info("Password reset for user '" + this.getUsername() + "'");
        }
        catch (EmailException ex) {
            String msg = "Cannot reset password, error while sending email: " + ex.getMessage();
            this.getApplication().getLogger().warning(msg);
            Logger.getLogger(CmsUser.class.getName()).log(Level.SEVERE, null, ex);
            return msg;
        }
        return "";
    }

    public boolean isGuest(long idgroup) {
        return this.getRelationAttribute("groupguest").contains(idgroup) || this.getRelationAttribute("groupauthor").contains(idgroup) || this.getRelationAttribute("groupeditor").contains(idgroup) || this.getRelationAttribute("groupadmin").contains(idgroup);
    }

    public boolean isGuest(String group) {
        return this.getRelationAttribute("groupguest").contains(group) || this.getRelationAttribute("groupauthor").contains(group) || this.getRelationAttribute("groupeditor").contains(group) || this.getRelationAttribute("groupadmin").contains(group);
    }

    public boolean isAuthor(long idgroup) {
        return this.getRelationAttribute("groupauthor").contains(idgroup) || this.getRelationAttribute("groupeditor").contains(idgroup) || this.getRelationAttribute("groupadmin").contains(idgroup);
    }

    public boolean isAuthor(String group) {
        return this.getRelationAttribute("groupauthor").contains(group) || this.getRelationAttribute("groupeditor").contains(group) || this.getRelationAttribute("groupadmin").contains(group);
    }

    public boolean isEditor(long idgroup) {
        return this.getRelationAttribute("groupeditor").contains(idgroup) || this.getRelationAttribute("groupadmin").contains(idgroup);
    }

    public boolean isEditor(String group) {
        return this.getRelationAttribute("groupeditor").contains(group) || this.getRelationAttribute("groupadmin").contains(group);
    }

    public boolean isAdmin(long idgroup) {
        return this.getRelationAttribute("groupadmin").contains(idgroup);
    }

    public boolean isAdmin(String group) {
        return this.getRelationAttribute("groupadmin").contains(group);
    }

    public List<Long> getGroupIds() {
        List<Long> ids = this.getRelationAttribute("groupguest").getElementIds();
        ids.addAll(this.getRelationAttribute("groupauthor").getElementIds());
        ids.addAll(this.getRelationAttribute("groupeditor").getElementIds());
        ids.addAll(this.getRelationAttribute("groupadmin").getElementIds());
        ids.add(this.getLongAttribute("maingroup").getLong());
        return ids;
    }

    public static String getRolename(CmsUser u, long role) {
        if (role == 0L) {
            return u.getApplication().getResourceText("core.role.none", u.getCurrentLocale());
        }
        if (role == 1L) {
            return u.getApplication().getResourceText("core.role.guest", u.getCurrentLocale());
        }
        if (role == 2L) {
            return u.getApplication().getResourceText("core.role.author", u.getCurrentLocale());
        }
        if (role == 3L) {
            return u.getApplication().getResourceText("core.role.editor", u.getCurrentLocale());
        }
        if (role == 4L) {
            return u.getApplication().getResourceText("core.role.admin", u.getCurrentLocale());
        }
        return u.getApplication().getResourceText("core.role.undefined", u.getCurrentLocale());
    }

    @Override
    protected void postLoad() {
        boolean forcemaingroup = this.getApplication().getProperty("user.forcemaingroup", "false").equalsIgnoreCase("true");
        if (forcemaingroup) {
            this.getAttribute("maingroup").setReadonly(true);
        }
        if (this.getCurrentUser().isSuperadmin()) {
            this.getAttribute("superadmin").setHidden(false);
            ((RelationAttribute)this.getAttribute("groupadmin")).setAllowSearch(true);
            ((RelationAttribute)this.getAttribute("groupeditor")).setAllowSearch(true);
            ((RelationAttribute)this.getAttribute("groupauthor")).setAllowSearch(true);
            ((RelationAttribute)this.getAttribute("groupguest")).setAllowSearch(true);
            ((RelationAttribute)this.getAttribute("membership")).setAllowSearch(true);
        } else {
            this.getAttribute("inactive").setReadonly(true);
            this.getAttribute("maingroup").setReadonly(true);
            this.getAttribute("groupadmin").setReadonly(true);
            this.getAttribute("groupeditor").setReadonly(true);
            this.getAttribute("groupauthor").setReadonly(true);
            this.getAttribute("groupguest").setReadonly(true);
            this.getAttribute("membership").setReadonly(true);
        }
    }

    @Override
    protected void postCreate() {
        long ownerid;
        String owner;
        long creatorid;
        String creator;
        String maingroup = this.getApplication().getProperty("user.maingroup", "");
        long maingroupid = -1L;
        if (!"".equals(maingroup)) {
            maingroupid = this.getApplication().getDatastorage().checkGroup(maingroup);
        }
        if (maingroupid >= 0L) {
            this.getLongAttribute("maingroup").setValue(maingroupid);
            boolean forcemaingroup = this.getApplication().getProperty("user.forcemaingroup", "false").equalsIgnoreCase("true");
            if (forcemaingroup) {
                this.getAttribute("maingroup").setReadonly(true);
            }
        }
        if ((creator = this.getApplication().getDefaultUserSettings().getProperty("user.creator", null)) != null && !"self".equals(creator) && (creatorid = this.getApplication().getDatastorage().checkUser(creator)) > 0L) {
            this.getLongAttribute("meta_iduser").setValue(creatorid);
        }
        if ((owner = this.getApplication().getDefaultUserSettings().getProperty("user.forceowner", null)) != null && (ownerid = this.getApplication().getDatastorage().checkGroup(owner)) > 0L) {
            this.getLongAttribute("meta_idgroup").setValue(ownerid);
        }
        if (this.getCurrentUser().isSuperadmin()) {
            this.getAttribute("superadmin").setHidden(false);
            ((RelationAttribute)this.getAttribute("groupadmin")).setAllowSearch(true);
            ((RelationAttribute)this.getAttribute("groupeditor")).setAllowSearch(true);
            ((RelationAttribute)this.getAttribute("groupauthor")).setAllowSearch(true);
            ((RelationAttribute)this.getAttribute("groupguest")).setAllowSearch(true);
            ((RelationAttribute)this.getAttribute("membership")).setAllowSearch(true);
        } else {
            this.getAttribute("inactive").setReadonly(true);
            this.getAttribute("maingroup").setReadonly(true);
            this.getAttribute("groupadmin").setReadonly(true);
            this.getAttribute("groupeditor").setReadonly(true);
            this.getAttribute("groupauthor").setReadonly(true);
            this.getAttribute("groupguest").setReadonly(true);
            this.getAttribute("membership").setReadonly(true);
        }
    }

    @Override
    protected void preSave() {
        String pwd1 = this.getAttributeValue("passwordinput1");
        if (pwd1 != null && !"".equals(pwd1)) {
            this.setAttributeValue("password", Util.md5((String)pwd1));
        }
        StringWriter w = new StringWriter();
        Properties defaults = this.getApplication().getDefaultUserSettings();
        Properties storesettings = new Properties();
        for (String k : this.getSettings().stringPropertyNames()) {
            if (this.getSettings().get(k).equals(defaults.get(k))) continue;
            storesettings.put(k, this.getSettings().get(k));
        }
        try {
            storesettings.store(w, null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.setAttributeValue("settings", w.toString());
    }

    @Override
    public boolean verifyElement() {
        if (this.getMainGroupId() <= 0L) {
            if (!this.getRelationAttribute("groupadmin").isEmpty()) {
                this.setMainGroup(this.getRelationAttribute("groupadmin").getFirstElementId());
                this.getApplication().getLogger().warning("No maingroup defined, set to ID=" + this.getMainGroupId());
            } else if (!this.getRelationAttribute("groupeditor").isEmpty()) {
                this.setMainGroup(this.getRelationAttribute("groupeditor").getFirstElementId());
                this.getApplication().getLogger().warning("No maingroup defined, set to ID=" + this.getMainGroupId());
            } else if (!this.getRelationAttribute("groupauthor").isEmpty()) {
                this.setMainGroup(this.getRelationAttribute("groupauthor").getFirstElementId());
                this.getApplication().getLogger().warning("No maingroup defined, set to ID=" + this.getMainGroupId());
            } else {
                this.getApplication().getLogger().warning("Cannot save user, no maingroup defined");
                return false;
            }
        }
        String pwd1 = this.getAttributeValue("passwordinput1");
        String pwd2 = this.getAttributeValue("passwordinput2");
        if (pwd1 != null) {
            if (!pwd1.equals(pwd2)) {
                this.getApplication().getLogger().warning("Password mismatch, cannot save user");
                return false;
            }
        } else if (pwd2 != null) {
            this.getApplication().getLogger().warning("Password mismatch, cannot save user");
            return false;
        }
        return true;
    }

    @Override
    public boolean checkPermission(int action) {
        CmsUser u = this.getCurrentUser();
        if (u.isSuperadmin()) {
            return true;
        }
        if (action == 1) {
            return true;
        }
        if (action == 2) {
            return u.getId() == this.getId();
        }
        return action == 3;
    }
}

