/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cms.observer;

import at.grid.cms.observer.FolderListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;

public class FolderObserver
extends Thread {
    private static int COUNTER = 1;
    private int observerID = 1;
    private File folder;
    private boolean running = false;
    private boolean terminated = false;
    private ArrayList<String> filenames = new ArrayList();
    private ArrayList<String> newfilenames = new ArrayList();
    public boolean newfiles = false;
    FolderListener listener;
    Logger logger = null;

    public FolderObserver(Logger l, File f) {
        this.logger = l;
        this.observerID = COUNTER++;
        this.initialise(f);
    }

    public FolderObserver(File f) {
        this(null, f);
    }

    public FolderObserver(String fn) {
        this(null, new File(fn));
    }

    public void initialise(File f) {
        this.running = false;
        this.folder = f;
        this.filenames.clear();
        this.newfilenames.clear();
        this.newfiles = false;
        if (this.folder.exists() && !this.folder.isDirectory()) {
            throw new IllegalArgumentException("The defined folder '" + f.getAbsolutePath() + "' is a file");
        }
        this.folder.mkdirs();
    }

    public void setFolder(File folder) {
        this.folder = folder;
    }

    public File getFolder() {
        return this.folder;
    }

    public void setRunning(boolean r) {
        this.running = r;
    }

    public void stopRunning() {
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public boolean hasNewfiles() {
        return this.newfiles;
    }

    public synchronized ArrayList<String> getFilenames() {
        this.newfiles = false;
        return this.filenames;
    }

    public synchronized void registerListener(FolderListener l) {
        this.listener = l;
    }

    public synchronized void unregisterListener() {
        this.listener = null;
    }

    public int getNumberOfFiles() {
        return this.filenames.size();
    }

    @Override
    public void run() {
        String[] fns = this.folder.list();
        if (fns == null) {
            fns = new String[]{};
        }
        this.filenames = new ArrayList();
        this.filenames.addAll(Arrays.asList(fns));
        this.newfilenames = new ArrayList();
        this.running = true;
        this.newfiles = false;
        if (this.logger != null) {
            this.logger.info("FolderObserver #" + this.observerID + " THREAD '" + this.folder.getAbsolutePath() + "' started (" + this.filenames.size() + " files) ...");
        }
        while (this.running) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                this.running = false;
                break;
            }
            if (this.listener == null) continue;
            for (String fn : fns = this.folder.list()) {
                if (this.filenames.contains(fn)) continue;
                this.newfilenames.add(fn);
                this.newfiles = true;
            }
            if (this.logger != null) {
                this.logger.fine("FolderObserver #" + this.observerID + " found " + this.newfilenames.size() + " new files in '" + this.folder.getAbsolutePath() + "' with previously " + this.filenames.size() + " files ...");
            }
            if (this.newfilenames.size() <= 0) continue;
            if (this.listener != null) {
                this.listener.onNewFiles(this, this.newfilenames);
            }
            this.filenames.addAll(this.newfilenames);
            this.newfilenames.clear();
        }
        if (this.logger != null) {
            this.logger.info("FolderObserver #" + this.observerID + " THREAD '" + this.folder.getAbsolutePath() + "' stopped!");
        }
        this.terminated = true;
    }
}

