/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cms.search;

import at.grid.cms.CmsApplication;
import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsUser;
import at.grid.cms.search.CmsSqlSearch;
import at.grid.cms.search.ListColumn;
import at.grid.cms.servlet.CmsRequest;
import at.grid.cms.storage.DataRecord;
import at.grid.cms.storage.DataStorage;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public abstract class AbstractWebSearch {
    private CmsSqlSearch search;
    private CmsApplication app;
    private CmsUser user;
    private boolean runsearch = false;
    private ArrayList<String> searchcriteria = new ArrayList();
    protected List<DataRecord> result = new ArrayList<DataRecord>();
    private ArrayList<String> errors = new ArrayList();
    public String sortfield = "meta_title";
    public String sortdirection = "ASC";
    private String urlprefix = "";
    private String requesturl = "";
    protected CmsRequest request = null;
    private String baseurl;
    private ArrayList<ListColumn> columns = new ArrayList();
    protected boolean showSort = true;
    protected boolean showSearchcriteria = true;
    protected boolean autosearch = false;

    public AbstractWebSearch(CmsApplication app, CmsUser u) {
        this.app = app;
        this.user = u;
    }

    public final void initialise(CmsRequest req) {
        this.urlprefix = req.getContextPath();
        this.requesturl = req.getRequest().getRequestURI();
        String url = req.getRequest().getRequestURL().toString();
        this.baseurl = url.substring(0, url.length() - this.requesturl.length());
        if (req.hasParameter("reset")) {
            this.reset();
        } else if (req.hasParameter("resort")) {
            if (this.didSearch()) {
                this.setSort(req);
                this.runSearch();
            } else {
                this.addError("Neue Sortierung erst nach erstmaliger Suche m\u00f6glich");
            }
        } else if (req.hasParameter("runsearch") || this.doAutosearch()) {
            this.request = req;
            this.getSearch().clear();
            this.searchcriteria.clear();
            this.errors.clear();
            this.result.clear();
            this.columns.clear();
            this.setSort(req);
            this.createSelect(req);
            this.createWhere(req);
            this.createTableLayout(req);
            this.runSearch();
            this.runsearch = true;
        }
    }

    protected void runSearch() {
        this.result = this.getSearch().search().getResult();
    }

    public void setSort(CmsRequest req) {
        if (!req.hasParameterValue("sort")) {
            this.getSearch().setSort(this.getDefaultSort());
        } else {
            this.sortfield = req.getParameter("sort", "meta_title");
            this.sortdirection = req.getParameter("sortdirection", "ASC");
            this.getSearch().setSort(this.sortfield + " " + this.sortdirection);
        }
    }

    protected String getDefaultSort() {
        return "meta_title ASC";
    }

    protected boolean doAutosearch() {
        return this.autosearch;
    }

    protected void createSelect(CmsRequest req) {
        this.getSearch().addSelectMeta();
        if (this.getAttributes() != null && this.getElementtype() != null) {
            CmsElement ele = this.getApplication().getDefaultElement(this.getElementtype());
            for (String att : this.getAttributes().split(",")) {
                this.getSearch().addSelectAttribute(ele.getAttribute(att));
            }
        }
    }

    protected void createWhere(CmsRequest req) {
        if (this.getElementtype() != null) {
            this.getSearch().setElementtypes(this.getElementtype());
        }
    }

    protected void createTableLayout(CmsRequest req) {
        if (this.getAttributes() != null && this.getElementtype() != null) {
            boolean first = true;
            for (String att : this.getAttributes().split(",")) {
                if (first) {
                    this.addColumn(att, "{" + att + "}").setLink(att, "meta_id");
                } else {
                    this.addColumn(att, "{" + att + "}");
                }
                first = false;
            }
        }
    }

    protected String getAttributes() {
        return null;
    }

    protected String getElementtype() {
        return null;
    }

    public CmsApplication getApplication() {
        return this.app;
    }

    public CmsUser getUser() {
        return this.user;
    }

    public void setRequestUrl(String url) {
        this.requesturl = url;
    }

    public void setUrlPrefix(String url) {
        this.urlprefix = url;
    }

    public String getUrlprefix() {
        return this.urlprefix;
    }

    public String getBaseURL() {
        return this.baseurl;
    }

    protected DataStorage getDatastorage() {
        return this.getApplication().getDatastorage();
    }

    protected CmsSqlSearch getSearch() {
        if (this.search == null) {
            this.search = new CmsSqlSearch(this.getApplication(), this.getUser(), this.searchMultipleElementTypes());
        }
        return this.search;
    }

    public String getSearchSql() {
        return this.getSearch().getSql();
    }

    protected boolean searchMultipleElementTypes() {
        return false;
    }

    public List<DataRecord> getResult() {
        return this.result;
    }

    public boolean isEmpty() {
        return this.result.isEmpty();
    }

    public boolean didSearch() {
        return this.runsearch;
    }

    public String getParameter(String param, String defaultvalue) {
        if (this.request == null) {
            return defaultvalue;
        }
        return this.request.getParameter(param, defaultvalue);
    }

    public ArrayList<String> getParameters(String param) {
        if (this.request == null) {
            return new ArrayList<String>();
        }
        return this.request.getParameters(param);
    }

    public ArrayList<String> getParameters(String param, String defaultvalue) {
        ArrayList<String> defval = new ArrayList<String>();
        defval.add(defaultvalue);
        if (this.request == null) {
            return defval;
        }
        if (this.request.hasParameter(param)) {
            return this.request.getParameters(param);
        }
        return defval;
    }

    public ArrayList<String> getParameters(String param, ArrayList<String> defaultvalue) {
        if (this.request == null) {
            return defaultvalue;
        }
        if (this.request.hasParameter(param)) {
            return this.request.getParameters(param);
        }
        return defaultvalue;
    }

    public boolean hasParameterValue(String param) {
        if (this.request == null) {
            return false;
        }
        return this.request.hasParameterValue(param);
    }

    public boolean doShowSearchcriteria() {
        return this.showSearchcriteria;
    }

    public boolean doShowSort() {
        return this.showSort;
    }

    public void reset() {
        this.request = null;
        this.search = null;
        this.result.clear();
    }

    public double getSum(String field) {
        double sum = 0.0;
        if (this.getResult() == null) {
            return sum;
        }
        for (DataRecord rec : this.getResult()) {
            if (rec.isEmpty(field)) continue;
            sum += (double)rec.getFloat(field).floatValue();
        }
        return sum;
    }

    public String getSumAsString(String field, NumberFormat format) {
        double s = this.getSum(field);
        if (s == 0.0) {
            return "";
        }
        return format.format(s);
    }

    protected void addSearchCriteria(String s) {
        this.searchcriteria.add(s);
    }

    public ArrayList<String> getSearchCriteria() {
        return this.searchcriteria;
    }

    protected void addError(String s) {
        this.errors.add(s);
    }

    public ArrayList<String> getErrors() {
        return this.errors;
    }

    public boolean hasErrors() {
        return !this.getErrors().isEmpty();
    }

    public String getSearchInfo() {
        StringBuilder sb = new StringBuilder();
        Locale loc = this.getUser().getCurrentLocale();
        sb.append(this.app.getResourceText("app.searchinfo.numberofresults", loc)).append(": <b>");
        if (this.getResult() != null) {
            sb.append(this.getResult().size());
        } else {
            sb.append("-");
        }
        sb.append("</b>").append("&nbsp;&nbsp;&nbsp;");
        sb.append(this.app.getResourceText("app.searchinfo.searchtime", loc)).append(": ").append(this.getSearch().getSearchTime()).append("&nbsp;&nbsp;&nbsp;");
        return sb.toString();
    }

    public String getDownloadLinks() {
        return this.getDownloadLinks("xls,pdf");
    }

    public String getDownloadLinks(String types) {
        StringBuilder sb = new StringBuilder();
        Locale loc = this.getUser().getCurrentLocale();
        sb.append(this.app.getResourceText("app.searchinfo.download", loc)).append(":  ");
        if ("true".equalsIgnoreCase(this.getApplication().getProperty("web.export.xls", "false")) && types.indexOf("xls") >= 0) {
            sb.append("<a href=\"").append(this.app.getServletUrl()).append("/export?exporttype=excel&topic=" + this.getApplication().getResourceText("app.topic." + this.getClass().getSimpleName(), loc) + "\">").append("<img border=\"0\" src=\"").append(this.app.getResourceUrl()).append("icons/excel.gif\" /><a/> ");
        }
        if ("true".equalsIgnoreCase(this.getApplication().getProperty("web.export.pdf", "false")) && types.indexOf("pdf") >= 0) {
            sb.append("<a href=\"").append(this.app.getServletUrl()).append("/export?exporttype=pdf&topic=" + this.getApplication().getResourceText("app.topic." + this.getClass().getSimpleName(), loc) + "\" > ").append("<img border=\"0\" src=\"").append(this.app.getResourceUrl()).append("icons/pdf.gif\"> <a/>");
            sb.append("&nbsp;&nbsp;&nbsp;");
        }
        return sb.toString();
    }

    public String getSortInfo() {
        StringBuilder sb = new StringBuilder();
        Locale loc = this.getUser().getCurrentLocale();
        sb.append(this.app.getResourceText("app.sort.intro", loc));
        if (this.sortfield.equals("meta_title")) {
            sb.append("\n").append("Standard");
        } else {
            sb.append("\n").append(this.getApplication().getResourceText("app.list." + this.getClass().getSimpleName() + "." + this.sortfield, loc));
        }
        sb.append(" ").append(this.app.getResourceText("app.sort.direction." + this.sortdirection, loc));
        return sb.toString();
    }

    public String getSortLink(String newsort) {
        String newdirection = "ASC";
        if (newsort.equals(this.sortfield)) {
            newdirection = "DESC";
        }
        return this.requesturl + "?resort&sort=" + newsort + "&sortdirection=" + newdirection;
    }

    public String getRedirectLink(String newsort, String sortdirection) {
        return this.requesturl + "?resort&sort=" + newsort + "&sortdirection=" + sortdirection;
    }

    public String getCriteriaInfo() {
        StringBuilder sb = new StringBuilder();
        Locale loc = this.getUser().getCurrentLocale();
        sb.append(this.getApplication().getResourceText("app.search.criteria", loc)).append(":");
        for (String s : this.getSearchCriteria()) {
            sb.append("\n").append(s);
        }
        return sb.toString();
    }

    public String getErrorInfo() {
        StringBuilder sb = new StringBuilder();
        Locale loc = this.getUser().getCurrentLocale();
        sb.append(this.getApplication().getResourceText("app.search.errors", loc)).append(": ");
        for (String s : this.getErrors()) {
            sb.append("\n").append(s);
        }
        return sb.toString();
    }

    public ListColumn addColumn(ListColumn col) {
        if (this.columns == null) {
            this.columns = new ArrayList();
        }
        this.columns.add(col);
        return col;
    }

    public ArrayList<ListColumn> getColumns() {
        return this.columns;
    }

    public int getColumnCount() {
        if (this.columns == null) {
            return 0;
        }
        return this.columns.size();
    }

    public ListColumn addColumn(String code, String template) {
        ListColumn c = new ListColumn(code, template, this);
        this.addColumn(c);
        return c;
    }

    public ListColumn addColumn(String code, String template, int size, boolean outputVisibilty) {
        ListColumn c = new ListColumn(code, template, size, this, outputVisibilty);
        this.addColumn(c);
        return c;
    }

    public ListColumn addColumn(String code, String template, String name) {
        ListColumn c = new ListColumn(code, template, name, this);
        this.addColumn(c);
        return c;
    }

    public String getSortfield() {
        return this.sortfield;
    }

    public boolean hasSumFields() {
        for (ListColumn col : this.columns) {
            if (col.sumField == null) continue;
            return true;
        }
        return false;
    }
}

