/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cms.search;

import at.grid.cms.CmsApplication;
import at.grid.cms.element.CmsUser;
import at.grid.cms.storage.SearchResult;
import at.grid.util.Util;
import java.util.Date;
import java.util.Set;

public abstract class CmsSearch {
    public static final int NOTRASHONLY = 1;
    public static final int TRASHONLY = 2;
    public static final int IGNORETRASH = 3;
    protected CmsApplication app;
    protected CmsUser user;
    protected String lang;
    protected int trashSearch = 1;
    protected String elementtypes;
    protected String sort = null;
    String sql;
    protected boolean error = false;
    private long searchtime;

    public CmsSearch(CmsApplication app, CmsUser u) {
        this.app = app;
        this.user = u;
    }

    public void clear() {
        this.trashSearch = 1;
        this.lang = null;
        this.elementtypes = null;
        this.sql = null;
    }

    public CmsApplication getApplication() {
        return this.app;
    }

    public CmsUser getUser() {
        return this.user;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public boolean doSearchTrashOnly() {
        return this.trashSearch == 2;
    }

    public boolean doSearchNoTrashOnly() {
        return this.trashSearch == 1;
    }

    public void setSearchTrash(boolean searchTrash) {
        this.trashSearch = searchTrash ? 2 : 1;
    }

    public void setIgnoreTrash() {
        this.trashSearch = 3;
    }

    public void setElementtypes(String elementtypes) {
        this.elementtypes = elementtypes;
    }

    public void setElementtypes(Set<String> elementtypes) {
        this.elementtypes = Util.toString(elementtypes);
    }

    public String getSort() {
        return this.sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public String getSql() {
        return this.sql;
    }

    public boolean hasError() {
        return this.error;
    }

    public long getSearchTime() {
        return this.searchtime;
    }

    protected abstract SearchResult runSearch();

    public SearchResult search() {
        long time1 = new Date().getTime();
        SearchResult r = this.runSearch();
        r.setUser(this.getUser());
        this.sql = r.getSql();
        this.error = r.hasError();
        this.searchtime = new Date().getTime() - time1;
        return r;
    }
}

