/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cms.search;

import at.grid.cms.CmsApplication;
import at.grid.cms.attribute.CmsAttribute;
import at.grid.cms.attribute.KeyAttribute;
import at.grid.cms.attribute.MultikeyAttribute;
import at.grid.cms.attribute.RelationAttribute;
import at.grid.cms.content.CmsPermission;
import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsUser;
import at.grid.cms.search.CmsSearch;
import at.grid.cms.search.SearchForm;
import at.grid.cms.storage.DataRecord;
import at.grid.cms.storage.DataStorage;
import at.grid.cms.storage.SearchResult;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class CmsSqlSearch
extends CmsSearch
implements Serializable {
    ArrayList<String> selects = new ArrayList();
    ArrayList<String> fields = new ArrayList();
    ArrayList<String> aggregates = new ArrayList();
    ArrayList<String> froms = new ArrayList();
    HashMap<Integer, ArrayList<String>> wheres;
    String limit = "";
    private SearchForm searchform;
    private boolean useElementcodeInAlias = true;
    private ArrayList<CmsAttribute> selectRelationAttributes = new ArrayList();

    public CmsSqlSearch(CmsApplication app, CmsUser u) {
        super(app, u);
        this.wheres = new HashMap();
        this.wheres.put(1, new ArrayList());
        this.clear();
        this.useElementcodeInAlias = true;
    }

    public CmsSqlSearch(CmsApplication app, CmsUser u, boolean elementcodeInAlias) {
        super(app, u);
        this.wheres = new HashMap();
        this.wheres.put(1, new ArrayList());
        this.clear();
        this.useElementcodeInAlias = elementcodeInAlias;
    }

    @Override
    public void clear() {
        super.clear();
        this.selects.clear();
        this.aggregates.clear();
        this.fields.clear();
        this.froms.clear();
        this.wheres.clear();
        this.sql = null;
        this.addInnerJoin("tdtaElementLng AS el ON e.idelement = el.idelement");
        this.addWhere(CmsPermission.getWhereClause(this.user, "e"));
    }

    public void clearWhere() {
        this.wheres.clear();
        this.sql = null;
        this.addWhere(CmsPermission.getWhereClause(this.user, "e"));
    }

    public String createSql(String order) {
        boolean first = true;
        if (this.doSearchTrashOnly()) {
            this.addWhere("e.deleted");
        } else if (this.doSearchNoTrashOnly()) {
            this.addWhere("NOT e.deleted");
        }
        if (this.getApplication().isMultilingual() && this.getLang() != null) {
            this.addWhere("lower(el.lang) = '" + this.getLang().toLowerCase() + "'");
        }
        if (this.elementtypes != null) {
            this.addWhere("e.elementtype IN ('" + this.elementtypes.replace(",", "','") + "')");
        }
        StringBuilder sb = new StringBuilder();
        first = true;
        sb.append("SELECT DISTINCT");
        if (!this.hasAggregate()) {
            sb.append("\n  e.idelement AS meta_id");
            sb.append("\n ,e.uuid AS meta_uuid");
            first = false;
        }
        for (String s : this.selects) {
            sb.append("\n  ");
            if (!first) {
                sb.append(",");
            }
            sb.append(s);
            first = false;
        }
        sb.append("\nFROM tdtaElement AS e");
        for (String s : this.froms) {
            sb.append("\n  ").append(s);
        }
        sb.append("\nWHERE ");
        Set<Integer> wherekeys = this.wheres.keySet();
        boolean secondOr = false;
        Iterator<Object> iterator = wherekeys.iterator();
        while (iterator.hasNext()) {
            int wherekey = iterator.next();
            sb.append(secondOr ? " OR " : "").append(" (");
            boolean firstWhere = true;
            for (String s : this.wheres.get(wherekey)) {
                if ("".equals(s)) continue;
                sb.append("\n  ").append(firstWhere ? "" : " AND ").append("(").append(s).append(")");
                firstWhere = false;
            }
            sb.append(firstWhere ? "true" : "").append("\n ) ");
            secondOr = true;
        }
        if (this.hasAggregate()) {
            first = true;
            sb.append("\nGROUP BY ");
            for (String s : this.fields) {
                if (this.aggregates.contains(s)) continue;
                if (!first) {
                    sb.append(",");
                }
                sb.append(s);
                first = false;
            }
        }
        if (order != null && !"".equals(order)) {
            sb.append("\n ORDER BY ").append(order);
        }
        sb.append("\n").append(this.limit);
        return sb.toString();
    }

    protected boolean hasAggregate() {
        return !this.aggregates.isEmpty();
    }

    public void setSql(String s) {
        this.sql = s;
    }

    public void setSort(CmsAttribute att) {
        this.addSelectAttribute(att);
        this.setSort(this.getAlias(att));
    }

    public void addSelect(String aggregate, String field, String alias) {
        if (this.addSelect(aggregate + "(" + field + ")", alias)) {
            this.aggregates.add(aggregate + "(" + field + ")");
        }
    }

    public boolean addSelect(String field, String alias) {
        String s = field + " AS " + alias;
        if (!this.selects.contains(s)) {
            this.selects.add(s);
            this.fields.add(field);
            return true;
        }
        return false;
    }

    public void addSelectElementtype(String alias) {
        this.addSelect("e.elementtype", alias);
    }

    public void addSelectTitle(String alias) {
        this.addSelect("el.title", alias);
    }

    public void addSelectSummary(String alias) {
        this.addSelect("el.summary", alias);
    }

    public void addSelectWorkflowstatus(String alias) {
        this.addSelect("e.idworkflowstatus", alias);
    }

    public void addSelectMeta() {
        this.addSelect("el.lang", "meta_lang");
        this.addSelectTitle("meta_title");
        this.addSelect("upper(el.title)", "meta_title_upper");
        this.addSelectSummary("meta_summary");
        this.addSelectElementtype("meta_elementtype");
        this.addSelect("e.metaowner", "meta_idgroup");
        this.addSelect("e.metacreator", "meta_iduser");
        this.addSelect("e.metamasterlang", "meta_masterlang");
        this.addSelect("el.metacreated", "meta_created");
        this.addSelect("el.metalastedit", "meta_lastedit");
        this.addSelect("el.metatranslator", "idmeta_lasteditby");
        this.addLeftJoin("tdtaElementLng AS meta_lasteditbyele ON (meta_lasteditbyele.idelement=el.metatranslator AND lower(meta_lasteditbyele.lang)=lower(el.lang))");
        this.addSelect("meta_lasteditbyele.title", "meta_lasteditby");
        this.addSelect("meta_lasteditbyele.lang", "meta_lasteditbylang");
        this.addSelect("e.idreadaccess", "idmeta_readaccess");
        this.addSelect("e.idwriteaccess", "idmeta_writeaccess");
        this.addSelectWorkflowstatus("idmeta_status");
        this.addSelect("e.deleted", "meta_trash");
    }

    public void addSelectAttribute(CmsAttribute att) {
        if (att == null) {
            throw new IllegalArgumentException("Attribute is NULL");
        }
        if (!att.isVirtual()) {
            if (att.isOfType(8)) {
                this.addSelectKeyTerm(att);
            } else if (att.isOfType(15)) {
                this.addSelectUploadItem(att);
            } else if (att.isOfType(14)) {
                if (((RelationAttribute)att).isSingle()) {
                    this.addSelectRelationSingleTerm(att);
                    this.addSelectRelationSingleId(att);
                } else {
                    this.addSelectRelationTerm(att);
                    this.addSelectRelationId(att);
                }
            } else if (att.isStandardAttribute()) {
                this.addCoreTableJoin(att.getParent(), att.isMultilingual());
                if (att.isMultilingual()) {
                    this.addSelect("elel." + att.getField(), this.getAlias(att));
                } else {
                    this.addSelect("ele." + att.getField(), this.getAlias(att));
                }
            }
        }
    }

    public void addSelectAllAttributes(String elementtype) {
        CmsElement ele = this.app.getDefaultElement(elementtype);
        this.addSelectMeta();
        for (CmsAttribute att : ele.getDataAttributes()) {
            if (!att.isStandardAttribute()) continue;
            this.addSelectAttribute(att);
        }
    }

    public void addSelectRelationId(CmsAttribute att) {
        if (att == null || !att.isOfType(14)) {
            throw new IllegalArgumentException("Attribute is NULL or not a RELATION attribute");
        }
        if (((RelationAttribute)att).isSingle()) {
            throw new IllegalArgumentException("Attribute is a SINGLE relation attribute");
        }
        String code = this.getAlias(att);
        this.addRelationJoin(att, false);
        this.addSelect(code + "e.idelement", "id" + code);
    }

    public void addSelectRelationTerm(CmsAttribute att) {
        if (att == null || !att.isOfType(14)) {
            throw new IllegalArgumentException("Attribute is NULL or not a RELATION attribute");
        }
        String code = this.getAlias(att);
        this.addRelationJoin(att, true);
        this.addSelect(code + "ele.title", code);
        this.addSelect(code + "ele.lang", code + "lang");
        this.addSelect(code + "e.deleted", code + "del");
        this.selectRelationAttributes.add(att);
    }

    public void addSelectRelationSingleTerm(CmsAttribute att) {
        if (att == null || !att.isOfType(14)) {
            throw new IllegalArgumentException("Attribute is NULL or not a RELATION attribute");
        }
        if (!((RelationAttribute)att).isSingle()) {
            throw new IllegalArgumentException("Attribute is not a SINGLE RELATION attribute");
        }
        String code = this.getAlias(att);
        String et = ((RelationAttribute)att).getElementtype();
        this.addRelationSingleJoin(att);
        this.addSelect(code + "ele.title", code);
        this.addSelect(code + "ele.lang", code + "lang");
    }

    public void addSelectRelationSingleId(CmsAttribute att) {
        if (att == null || !att.isOfType(14)) {
            throw new IllegalArgumentException("Attribute is NULL or not a RELATION attribute");
        }
        if (!((RelationAttribute)att).isSingle()) {
            throw new IllegalArgumentException("Attribute is not a SINGLE RELATION attribute");
        }
        String code = this.getAlias(att);
        String fld = att.getField();
        this.addCoreTableJoin(att.getParent(), false);
        this.addSelect("ele." + fld, "id" + code);
    }

    public void addSelectRelationCount(CmsAttribute att) {
        if (att == null || !att.isOfType(14)) {
            throw new IllegalArgumentException("Attribute is NULL or not a RELATION attribute");
        }
        RelationAttribute relatt = (RelationAttribute)att;
        if (relatt.isSingle()) {
            throw new IllegalArgumentException("Attribute is a SINGLE RELATION attribute");
        }
        if (relatt.getDirection() == 1) {
            this.addLeftJoin("(SELECT elementfrom AS id, count(elementto) AS count FROM tdtarelation WHERE relationcode='" + relatt.getRelationcode() + "' GROUP BY elementfrom) AS " + this.getAlias(att) + "counttbl ON " + this.getAlias(att) + "counttbl.id=e.idelement");
            this.addSelect(this.getAlias(att) + "counttbl.count", this.getAlias(att) + "count");
        } else {
            this.addLeftJoin("(SELECT elementto AS id, count(elementfrom) AS count FROM tdtarelation WHERE relationcode='" + relatt.getRelationcode() + "' GROUP BY elementto) AS " + this.getAlias(att) + "counttbl ON " + this.getAlias(att) + "counttbl.id=e.idelement");
            this.addSelect(this.getAlias(att) + "counttbl.count", this.getAlias(att) + "count");
        }
    }

    public void addSelectKeyTerm(CmsAttribute att) {
        if (att == null) {
            throw new IllegalArgumentException("Attribute is NULL");
        }
        String code = this.getAlias(att);
        String tbl = ((KeyAttribute)att).getTableCode();
        this.addKeytableJoin(att);
        this.addSelect(code + "tbl." + tbl + "term", code);
        this.addSelect(code + "tbl.id" + tbl, "id" + code);
    }

    public void addSelectKeyId(CmsAttribute att) {
        if (att == null || !att.isOfType(8)) {
            throw new IllegalArgumentException("Attribute is NULL or not a KEY attribute");
        }
        String code = this.getAlias(att);
        String fld = att.getField();
        this.addCoreTableJoin(att.getParent(), false);
        this.addSelect("ele." + fld, "id" + code);
    }

    public void addSelectUploadItem(CmsAttribute att) {
        if (att == null) {
            throw new IllegalArgumentException("Attribute is NULL");
        }
        String code = this.getAlias(att);
        String fld = att.getField();
        String tbl = "tdtafileupload";
        this.addLeftJoin("tdtafileupload AS " + code + "tbl ON (e.idelement=" + code + "tbl.idelement)");
        this.addSelect(code + "tbl.idfileupload", "id" + code);
        this.addSelect(code + "tbl.path", code + "path");
        this.addSelect(code + "tbl.name", code);
    }

    public void removeSelect(String sel) {
        String remove = null;
        for (String s : this.selects) {
            if (!s.toLowerCase().startsWith(sel.toLowerCase() + " ")) continue;
            remove = s;
        }
        if (remove != null && this.fields.contains(sel)) {
            this.selects.remove(remove);
            this.fields.remove(sel);
        }
    }

    public void addElementJoin(String elementtype) {
        this.addElementJoin(elementtype, "ele");
    }

    public void addElementJoin(String elementtype, String alias) {
        CmsElement defaultElement = this.getApplication().getDefaultElement(elementtype);
        this.addCoreTableJoin(defaultElement, alias, false);
        this.addCoreTableJoin(defaultElement, alias, true);
    }

    public void addInnerJoin(String join) {
        if (this.checkTableJoin(join)) {
            return;
        }
        this.froms.add("INNER JOIN " + join);
    }

    public void addLeftJoin(String join) {
        if (this.checkTableJoin(join)) {
            return;
        }
        this.froms.add("LEFT JOIN " + join);
    }

    private boolean checkTableJoin(String join) {
        String s = join.split("ON")[0];
        for (String f : this.froms) {
            if (!f.toLowerCase().contains(s.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    protected void addCoreTableJoin(CmsElement ele, boolean multilingual) {
        this.addCoreTableJoin(ele, "ele", multilingual);
    }

    protected void addCoreTableJoin(CmsElement ele, String tablealias, boolean multilingual) {
        if (multilingual) {
            this.addLeftJoin(ele.getTablename() + "lng AS " + tablealias + "l ON " + tablealias + "l.idelement=e.idelement AND lower(" + tablealias + "l.lang)=lower(el.lang)");
        } else {
            this.addLeftJoin(ele.getTablename() + " AS " + tablealias + " ON " + tablealias + ".idelement=e.idelement");
        }
    }

    public void addRelationJoin(CmsAttribute att, boolean addElementTable) {
        if (att == null) {
            throw new IllegalArgumentException("Attribute is NULL");
        }
        String code = this.getAlias(att);
        if (((RelationAttribute)att).getDirection() == 1) {
            this.addLeftJoin("tdtaRelation AS " + code + "rel ON e.idElement=" + code + "rel.elementFrom AND " + code + "rel.relationcode='" + ((RelationAttribute)att).getRelationcode() + "' ");
            if (addElementTable) {
                this.addLeftJoin("tdtaElementLng AS " + code + "ele ON " + code + "rel.elementTo=" + code + "ele.idElement AND lower(" + code + "ele.lang)=lower(el.lang)");
            }
            this.addLeftJoin("tdtaElement AS " + code + "e ON " + code + "rel.elementTo=" + code + "e.idElement ");
        } else {
            this.addLeftJoin("tdtaRelation AS " + code + "rel ON e.idElement=" + code + "rel.elementTo AND " + code + "rel.relationcode='" + ((RelationAttribute)att).getRelationcode() + "' ");
            if (addElementTable) {
                this.addLeftJoin("tdtaElementLng AS " + code + "ele ON " + code + "rel.elementFrom=" + code + "ele.idElement AND lower(" + code + "ele.lang)=lower(el.lang)");
            }
            this.addLeftJoin("tdtaElement AS " + code + "e ON " + code + "rel.elementFrom=" + code + "e.idElement ");
        }
    }

    protected void addRelationSingleJoin(CmsAttribute att) {
        if (att == null || !att.isOfType(14)) {
            throw new IllegalArgumentException("Attribute is NULL or not a RELATION attribute");
        }
        String fld = att.getField();
        String code = this.getAlias(att);
        this.addCoreTableJoin(att.getParent(), false);
        this.addLeftJoin("tdtaelementlng AS " + code + "ele ON " + code + "ele.idelement=ele." + fld + " AND lower(" + code + "ele.lang)=lower(el.lang)");
    }

    protected void addKeytableJoin(CmsAttribute att) {
        if (att == null || !att.isOfType(8)) {
            throw new IllegalArgumentException("Attribute is NULL or not a KEY attribute");
        }
        String tbl = ((KeyAttribute)att).getTableCode();
        String fld = att.getField();
        String code = this.getAlias(att);
        this.addCoreTableJoin(att.getParent(), false);
        this.addLeftJoin("tkey" + tbl + "lng AS " + code + "tbl ON " + code + "tbl.id" + tbl + "=ele." + fld + " AND lower(" + code + "tbl.lang)=lower(el.lang)");
    }

    protected void addMultikeytableRelationJoin(CmsAttribute att) {
        if (att == null || !att.isOfType(10)) {
            throw new IllegalArgumentException("Attribute is NULL or not a MULTIKEY attribute");
        }
        String tbl = ((MultikeyAttribute)att).getKeytable().getCode();
        String code = this.getAlias(att);
        this.addLeftJoin("tkey" + tbl + "rel AS " + code + "rel ON " + code + "rel.idelement=ele.idelement");
    }

    protected void addMultikeytableTermJoin(CmsAttribute att) {
        if (att == null || !att.isOfType(10)) {
            throw new IllegalArgumentException("Attribute is NULL or not a MULTIKEY attribute");
        }
        this.addMultikeytableRelationJoin(att);
        String tbl = ((MultikeyAttribute)att).getKeytable().getCode();
        String code = this.getAlias(att);
        this.addCoreTableJoin(att.getParent(), false);
        this.addLeftJoin("tkey" + tbl + "lng AS " + code + "tbl ON " + code + "rel.id" + tbl + "=" + code + "tbl.id" + tbl + " AND lower(" + code + "tbl.lang)=lower(el.lang)");
    }

    public void addWhere(int orcount, String elementtable, String where) {
        if (this.wheres.get(orcount) == null) {
            ArrayList<String> newWheres = new ArrayList<String>();
            newWheres.add(CmsPermission.getWhereClause(this.user, elementtable));
            this.wheres.put(orcount, newWheres);
        }
        if (!this.wheres.get(orcount).contains(where)) {
            this.wheres.get(orcount).add(where);
        }
    }

    public void addWhere(int orcount, String where) {
        this.addWhere(orcount, "e", where);
    }

    public void addWhere(String where) {
        this.addWhere(1, where);
    }

    public void addWhere(String field, String comparator, String value) {
        boolean toLower = false;
        if (comparator.toLowerCase().endsWith("like")) {
            comparator = "LIKE";
            toLower = true;
        }
        if (value.startsWith("'") && !value.endsWith("'")) {
            value = "'" + value.substring(1, value.length() - 1).replace("'", "''") + "'";
        }
        if (toLower) {
            field = "lower(" + field + ")";
            value = value.toLowerCase();
        }
        this.addWhere(field + " " + comparator + " " + value);
    }

    public void addWhereAttribute(CmsAttribute att, String comparator, String value) {
        this.addCoreTableJoin(att.getParent(), att.isMultilingual());
        String tablename = "ele";
        if (att.isMultilingual()) {
            tablename = "elel";
        }
        if (att.isSqlQuoted() && !value.startsWith("'") && !value.endsWith("'")) {
            value = "'" + value + "'";
        }
        value = value.replaceAll("\\*", "%");
        this.addWhere(tablename + "." + att.getField(), comparator, value);
    }

    public void addWhereRelationTerm(CmsAttribute att, String comparator, String value) {
        if (att == null || !att.isOfType(14)) {
            throw new IllegalArgumentException("Attribute is NULL or not a RELATION attribute");
        }
        String code = this.getAlias(att);
        if (((RelationAttribute)att).isSingle()) {
            this.addRelationSingleJoin(att);
        } else {
            this.addRelationJoin(att, true);
        }
        value = "'" + value + "'";
        this.addWhere(code + "ele.title", comparator, value);
    }

    public void addWhereRelationNone(CmsAttribute att) {
        if (att == null || !att.isOfType(14)) {
            throw new IllegalArgumentException("Attribute is NULL or not a RELATION attribute");
        }
        String code = this.getAlias(att);
        if (((RelationAttribute)att).isSingle()) {
            String fld = att.getField();
            this.addCoreTableJoin(att.getParent(), false);
            this.addWhere("ele." + fld + "<=0 OR ele." + fld + " IS NULL");
        } else {
            this.addRelationJoin(att, false);
            this.addWhere(code + "rel.relationcode IS NULL");
        }
    }

    public void addWhereRelationId(CmsAttribute att, String comparator, String value) {
        this.addWhereRelationId(att, comparator, value, false);
    }

    public void addWhereRelationId(CmsAttribute att, String comparator, String value, boolean withNull) {
        if (att == null || !att.isOfType(14)) {
            throw new IllegalArgumentException("Attribute is NULL or not a RELATION attribute");
        }
        String code = this.getAlias(att);
        if (((RelationAttribute)att).isSingle()) {
            String fld = att.getField();
            this.addCoreTableJoin(att.getParent(), false);
            String where = "ele." + fld + " " + comparator + " " + value;
            if (withNull) {
                where = "(" + where + " OR ele." + fld + " IS NULL)";
            }
            this.addWhere(where);
        } else {
            this.addRelationJoin(att, false);
            String field = "rel.element" + (((RelationAttribute)att).getDirection() == 1 ? "To" : "From");
            String where = code + field + " " + comparator + " " + value;
            if (withNull) {
                where = "(" + where + " OR " + code + field + " IS NULL)";
            }
            this.addWhere(where);
        }
    }

    public void addWhereKeytableTerm(CmsAttribute att, String comparator, String value) {
        if (att == null) {
            throw new IllegalArgumentException("Attribute is NULL");
        }
        String code = this.getAlias(att);
        this.addKeytableJoin(att);
        value = "'" + value + "'";
        this.addWhere(code + "tbl." + code + "term", comparator, value);
    }

    public void addWhereKeytableId(CmsAttribute att, String comparator, String value) {
        if (att == null) {
            throw new IllegalArgumentException("Attribute is NULL");
        }
        String fld = att.getField();
        this.addCoreTableJoin(att.getParent(), false);
        this.addWhere("ele." + fld + " " + comparator + " " + value);
    }

    public void addWhereMultikeytableId(CmsAttribute att, String comparator, String value) {
        if (att == null) {
            throw new IllegalArgumentException("Attribute is NULL");
        }
        if (!(att instanceof MultikeyAttribute)) {
            throw new IllegalArgumentException("Attribute is not of type Multikey");
        }
        this.addMultikeytableRelationJoin(att);
        String fld = att.getField();
        String code = this.getAlias(att);
        String tbl = ((MultikeyAttribute)att).getKeytable().getCode();
        this.addWhere(code + "rel.id" + tbl + " " + comparator + " " + value);
    }

    public void addWhereFreetext(String value) {
        if (value != null) {
            this.addWhereFreetext(value, null);
        }
    }

    public void addWhereFreetext(String value, String fields) {
        StringBuilder sb = new StringBuilder();
        sb.append("lower(el.title) LIKE '%").append(value.toLowerCase().replaceAll("'", "''")).append("%'");
        sb.append(" OR lower(el.summary) LIKE '%").append(value.toLowerCase().replaceAll("'", "''")).append("%'");
        if (fields != null) {
            for (String f : fields.split(",")) {
                sb.append(" OR lower(").append(f).append(") LIKE '%").append(value.toLowerCase().replaceAll("'", "''")).append("%'");
            }
        }
        this.addWhere(sb.toString());
    }

    public void addWhereBoolean(String checkfield, boolean onlyTrue) {
        if (checkfield != null) {
            if (onlyTrue) {
                this.addWhere(checkfield);
            } else {
                this.addWhere("NOT " + checkfield + " OR " + checkfield + " IS NULL");
            }
        }
    }

    public void setLimit(String limit) {
        this.limit = limit == null ? "" : "LIMIT " + limit;
    }

    @Override
    protected SearchResult runSearch() {
        List<DataRecord> recs;
        DataStorage ds = null;
        try {
            ds = this.getApplication().getDatastorage();
        }
        catch (Exception ex) {
            this.getApplication().getLogger().severe("This search works only for databases!");
            return null;
        }
        String sortspec = this.getSort();
        String fullsql = this.createSql(sortspec);
        SearchResult r = ds.executeQuery(fullsql, true);
        if (r == null) {
            r = new SearchResult();
        }
        r.setSql(fullsql);
        if (!this.selectRelationAttributes.isEmpty() && (recs = r.getResult()) != null) {
            for (DataRecord rec : recs) {
                for (CmsAttribute att : this.selectRelationAttributes) {
                    if (!rec.getBoolean(att.getCode() + "del", false).booleanValue()) continue;
                    rec.put(att.getCode(), "");
                    rec.put(att.getCode() + "id", null);
                }
            }
        }
        return r;
    }

    public void setSearchForm(SearchForm frm) {
        this.searchform = frm;
    }

    public SearchForm getSearchform() {
        return this.searchform;
    }

    public String getAlias(CmsAttribute att) {
        if (this.useElementcodeInAlias) {
            return att.getParent().getElementcode() + att.getCode();
        }
        return att.getCode();
    }
}

