/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cms.search;

import at.grid.cms.search.AbstractWebSearch;
import at.grid.cms.storage.DataRecord;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;

public class ListColumn {
    public static final int BUTTON_ADD = 1;
    public static final int BUTTON_EDIT = 2;
    public static final int BUTTON_ADD_OR_EDIT = 3;
    public static final int BUTTON_ACTION = 4;
    public String field = null;
    String template = null;
    String align = "LEFT";
    String checkbox = null;
    HashMap<String, String> link = null;
    boolean href = false;
    String sumField = null;
    String countField = null;
    String sumFieldTitle = null;
    String countFieldTitle = null;
    ArrayList<String> relationFields = new ArrayList();
    ArrayList<String> noSort = new ArrayList();
    int imagewidth = -1;
    int datatype = 0;
    String bgColor1 = null;
    String bgColor2 = null;
    boolean outputVisibility = false;
    AbstractWebSearch aws;
    String header = null;
    int buttontype = 0;
    String elementtype = null;
    String javascript = null;
    String attributes = null;
    String linkfield = null;
    NumberFormat format = null;
    String dateFormat = null;

    public ListColumn(String field, String template, AbstractWebSearch aws) {
        this.field = field;
        this.template = template;
        this.aws = aws;
    }

    public ListColumn(String field, String template, int size, AbstractWebSearch aws, boolean outputVisibility) {
        this.field = field;
        this.template = template;
        this.imagewidth = size;
        this.outputVisibility = outputVisibility;
        this.aws = aws;
    }

    public ListColumn(String field, String template, String name, AbstractWebSearch aws) {
        this.field = field;
        this.template = template;
        this.checkbox = name;
        this.aws = aws;
    }

    public ListColumn(int buttontype, String idfield, String otherfields, String elementtype, String template, String js, String attributes, AbstractWebSearch aws) {
        this.buttontype = buttontype;
        this.template = template;
        this.linkfield = idfield;
        this.field = idfield + "," + otherfields;
        this.elementtype = elementtype;
        this.javascript = js;
        this.attributes = attributes;
        this.datatype = 1111;
        this.aws = aws;
    }

    public static ListColumn createActionButton(String javacript, String jsmethod, String label, AbstractWebSearch aws) {
        ListColumn c = new ListColumn("meta_id", "", aws);
        c.linkfield = c.field;
        c.javascript = javacript;
        c.aws = aws;
        c.template = "<button style=\"float:right\" onclick=\"" + c.javascript + ".buttonAction({meta_id},'" + jsmethod + "')\">" + label + "</button>";
        c.outputVisibility = false;
        c.header = "";
        c.buttontype = 4;
        return c;
    }

    public void setDateFormat(String fmt) {
        this.dateFormat = fmt;
    }

    public ListColumn setHREF() {
        this.href = true;
        return this;
    }

    public String getAlign() {
        return this.align;
    }

    public ListColumn setAlign(String align) {
        this.align = align;
        return this;
    }

    public String getCheckboxName() {
        return this.checkbox;
    }

    public ListColumn setCheckbox(String checkbox) {
        this.checkbox = checkbox;
        return this;
    }

    public String getLink(String f) {
        if (this.link == null) {
            return null;
        }
        return this.link.get(f);
    }

    public ListColumn setLink(String f, String link) {
        if (this.link == null) {
            this.link = new HashMap();
        }
        this.link.put(f, link);
        return this;
    }

    public ListColumn setBackgroundColor(String color1, String color2) {
        this.bgColor1 = color1;
        this.bgColor2 = color2;
        return this;
    }

    public ListColumn setBackgroundColor(String color1) {
        this.setBackgroundColor(color1, color1);
        return this;
    }

    public String getBackgroundColors(int count) {
        if (count % 2 == 0) {
            return this.bgColor1;
        }
        return this.bgColor2;
    }

    public String getFirstBackgroundColor() {
        return this.bgColor1;
    }

    public String getSecondBackgroundColor() {
        return this.bgColor2;
    }

    public boolean hasBackgroundColor() {
        return this.bgColor1 != null;
    }

    public ListColumn setDatatype(int type) {
        this.datatype = type;
        return this;
    }

    public int getDatatype() {
        return this.getDatatype();
    }

    public int getImageWidth() {
        return this.imagewidth;
    }

    public ListColumn setHeader(String h) {
        this.header = h;
        return this;
    }

    public String getHeader() {
        return this.header;
    }

    public int getButtonType() {
        return this.buttontype;
    }

    public String getElementtype() {
        return this.elementtype;
    }

    public String getAttributes() {
        return this.attributes;
    }

    public String getLinkfield() {
        return this.linkfield;
    }

    public boolean hasButton() {
        return this.buttontype > 0;
    }

    public boolean hasImage() {
        return this.imagewidth >= 0;
    }

    public boolean visibleForExport() {
        return this.outputVisibility;
    }

    public boolean hasImageWidth() {
        return this.imagewidth > 0;
    }

    public boolean hasCheckbox() {
        return this.checkbox != null;
    }

    public boolean hasLink(String f) {
        return this.link != null && this.link.containsKey(f);
    }

    public String[] getFields() {
        if (this.field == null) {
            return new String[0];
        }
        return this.field.split(",");
    }

    public boolean hasContent(DataRecord rec) {
        if (this.hasButton()) {
            return true;
        }
        for (String f : this.getFields()) {
            if (rec.isEmpty(f) && !this.hasLink(f)) continue;
            return true;
        }
        return false;
    }

    public String getHead(boolean withHTMLlink, boolean html) {
        if (this.header != null) {
            return this.aws.getApplication().getResourceText("app.list." + this.aws.getClass().getSimpleName() + "." + this.header, this.aws.getUser().getCurrentLocale());
        }
        String t = this.template;
        if (this.hasImage()) {
            withHTMLlink = false;
            t = "{" + this.field + "}";
        }
        for (String f : this.getFields()) {
            String replacetext = this.aws.getApplication().getResourceText("app.list." + this.aws.getClass().getSimpleName() + "." + f, this.aws.getUser().getCurrentLocale());
            if (html) {
                boolean bl = withHTMLlink = !this.isNoSort(f);
            }
            if (withHTMLlink) {
                String sortlink = this.aws.getSortLink(f);
                replacetext = "<a href=\"" + sortlink + "\">" + replacetext + "</a>";
            }
            t = t.replace("{" + f + "}", replacetext);
        }
        return t;
    }

    public String getContent(DataRecord rec, boolean withHTMLlink) {
        return this.getContent(rec, withHTMLlink, null);
    }

    public String getContent(DataRecord rec, boolean withHTMLlink, NumberFormat fmt) {
        String t = this.template;
        if (this.format != null) {
            fmt = this.format;
        }
        if (this.hasButton()) {
            String iconadd = "<img style=\"float:right\" onclick=\"" + this.javascript + ".create('" + this.getElementtype() + "','" + this.getAttributes() + "','" + this.javascript + "')\" src=\"" + this.aws.getApplication().getResourceUrl() + "buttons/ele_edit.gif\">";
            String iconedit = "<img style=\"float:right\" onclick=\"" + this.javascript + ".load({" + this.getLinkfield() + "},'edit')\" src=\"" + this.aws.getApplication().getResourceUrl() + "buttons/ele_edit.gif\">";
            if (this.getButtonType() == 1) {
                t = iconadd;
            } else if (this.getButtonType() == 2) {
                t = iconedit;
            } else if (this.getButtonType() != 4 && this.getButtonType() == 3) {
                t = rec.isEmpty(this.getLinkfield()) ? iconadd : iconedit;
            }
        }
        for (String f : this.getFields()) {
            String replacetext = "<unknown_type>";
            int type = 1111;
            type = this.datatype == 0 ? rec.getDataType(f) : this.datatype;
            if (type == 91) {
                replacetext = rec.getDateAsString(f, TimeZone.getDefault(), this.dateFormat == null ? "dd.MM.yyyy" : this.dateFormat);
            } else if (type == 93) {
                replacetext = rec.getDateAsString(f, TimeZone.getDefault(), this.dateFormat == null ? "dd.MM.yyyy HH:mm" : this.dateFormat);
            } else if (type == 92) {
                replacetext = rec.getDateAsString(f, TimeZone.getDefault(), this.dateFormat == null ? "HH:mm" : this.dateFormat);
            } else if (type == 16 || type == -7) {
                replacetext = rec.getBoolean(f, false) != false ? "X" : "";
            } else if (type == 4 || type == 5 || type == -5) {
                replacetext = rec.getString(f, "");
                replacetext = !rec.isEmpty(f) ? (fmt == null || "meta_id".equals(f) ? Long.toString(rec.getInt(f).intValue()) : fmt.format(rec.getInt(f))) : "";
            } else if (type == 6 || type == 7 || type == 8 || type == 2 || type == 3) {
                replacetext = rec.getString(f, "");
                replacetext = !rec.isEmpty(f) ? (fmt == null ? Float.toString(rec.getFloat(f).floatValue()) : fmt.format(rec.getFloat(f))) : "";
            } else {
                replacetext = rec.getString(f, "");
            }
            if (withHTMLlink && this.hasLink(f)) {
                String linkid = rec.get(this.getLink(f));
                if (!"".equals(linkid)) {
                    if (replacetext == null || "".equals(replacetext)) {
                        replacetext = this.aws.getApplication().getResourceText("core.message.no_title", this.aws.getUser().getCurrentLocale());
                    }
                    replacetext = "<a onclick=\"gridelement.load(" + linkid + ",'view','gridelement')\">" + replacetext + "</a>";
                } else {
                    replacetext = "&nbsp;";
                }
            }
            if (this.href) {
                replacetext = "<a target=\"_new\" href=\"" + replacetext + "\">" + replacetext + "</a>";
            }
            if (this.relationFields.contains(t)) {
                t = "";
                String[] ids = replacetext.split(",");
                if (ids[0].equals("")) continue;
                for (String id : ids) {
                    t = t + "<a onclick=\"gridelement.load(" + id + ",'view','gridelement')\">" + this.aws.getApplication().getDatastorage().getElementTitle(Long.parseLong(id)) + "</a><br>";
                }
                continue;
            }
            t = t.replace("{" + f + "}", replacetext);
        }
        return t;
    }

    public long getImageId(DataRecord rec) {
        String id = null;
        for (String f : this.getFields()) {
            id = rec.getString(f, "");
        }
        return Long.parseLong(id);
    }

    public void setRelationField(String col) {
        this.relationFields.add(col);
    }

    public ListColumn setNoSort(String noSort) {
        this.noSort.add(noSort);
        return this;
    }

    private boolean isNoSort(String f) {
        return this.noSort.contains(f);
    }

    public ListColumn setSumField(String field, String title) {
        this.sumField = field;
        this.sumFieldTitle = title;
        return this;
    }

    public String calculateSummaryOfField(List<DataRecord> result) {
        if (this.sumField != null) {
            double sum = 0.0;
            int n = 0;
            String[] stringArray = this.getFields();
            int n2 = stringArray.length;
            if (n < n2) {
                String f = stringArray[n];
                for (DataRecord dataRecord : result) {
                    Float value = dataRecord.getFloat(f);
                    if (value == null) continue;
                    sum += (double)value.floatValue();
                }
                if ("".equals(this.sumFieldTitle)) {
                    return "" + NumberFormat.getNumberInstance(this.aws.getUser().getCurrentLocale()).format(sum);
                }
                return this.sumFieldTitle + " " + NumberFormat.getNumberInstance().format(sum);
            }
        }
        if (this.countField != null) {
            if ("".equals(this.countFieldTitle)) {
                return "" + NumberFormat.getNumberInstance().format(result.size());
            }
            return this.countFieldTitle + " " + NumberFormat.getNumberInstance().format(result.size());
        }
        return "-";
    }

    public ListColumn setCountField(String field, String title) {
        this.countField = field;
        this.countFieldTitle = title;
        return this;
    }

    public ListColumn setNumberFormat(NumberFormat fmt) {
        this.format = fmt;
        return this;
    }
}

