/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cms.search.depricated;

import at.grid.cms.CmsApplication;
import at.grid.cms.attribute.RelationAttribute;
import at.grid.cms.element.CmsElementSummary;
import at.grid.cms.element.CmsUser;
import at.grid.cms.search.CmsSearch;
import at.grid.cms.search.depricated.TableJoin;
import at.grid.cms.storage.DataRecord;
import at.grid.cms.storage.SearchResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class CmsSearchCore
extends CmsSearch {
    public static final int ASCENDING = 1;
    public static final int DESCENDING = 2;
    String freetext = null;
    boolean freetextExact = false;
    int sortdirection = 1;
    String whereClause = "";
    String sql = null;
    ArrayList<String> attributeSearch = new ArrayList();
    String ids = null;
    int rowPointer = 0;
    private ArrayList<String> searchcols = null;
    private ArrayList<String> tablecols = null;
    HashMap<String, String> tablecolref = new HashMap();
    List<TableJoin> tablejoins = new ArrayList<TableJoin>();
    String[] elementtypes = null;
    SearchResult searchresult;
    public static final int FORMAT_TABLE = 1;
    public static final int FORMAT_LIST = 2;
    private ArrayList<String> tablecolheaders = null;
    boolean showIcon = true;
    int outputformat = 1;

    public CmsSearchCore(CmsApplication app, CmsUser u) {
        super(app, u);
    }

    @Override
    public CmsApplication getApplication() {
        return this.app;
    }

    @Override
    public CmsUser getUser() {
        return this.user;
    }

    @Override
    public void setElementtypes(String elementtypes) {
        if (elementtypes != null) {
            this.elementtypes = elementtypes.split(",");
        }
    }

    @Override
    public void setElementtypes(Set<String> elementtypes) {
        this.elementtypes = new String[elementtypes.size()];
        for (int ii = 0; ii < elementtypes.size(); ++ii) {
            this.elementtypes[ii] = elementtypes.iterator().next();
        }
    }

    public String[] getElementtypes() {
        return this.elementtypes;
    }

    public void setFreetext(String t) {
        this.freetext = "".equals(t) ? null : t;
    }

    public void setFreetext(String t, boolean exact) {
        this.freetext = t;
        this.freetextExact = exact;
    }

    public String getFreetext() {
        return this.freetext;
    }

    public void setFreetextExact(boolean exact) {
        this.freetextExact = exact;
    }

    public boolean getFreetextExact() {
        return this.freetextExact;
    }

    public void setSortfield(String f) {
        this.sort = f;
        this.sortdirection = 1;
    }

    public void setSortfield(String f, int direction) {
        this.sort = f;
        this.sortdirection = direction;
    }

    public String getSortfield() {
        return this.sort;
    }

    public int getSortdirection() {
        return this.sortdirection;
    }

    public void setWhereClause(String s) {
        this.whereClause = s;
    }

    public String getWhereClause() {
        return this.whereClause;
    }

    public void setIds(String ids) {
        if (ids == null || "".equals(ids)) {
            return;
        }
        this.ids = ids;
    }

    public void setIds(List<Long> ids) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (long id : ids) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append(id);
        }
        this.setIds(sb.toString());
    }

    public String getIds() {
        return this.ids;
    }

    public void setOutputFormat(int format) {
        this.outputformat = format;
    }

    public void setOutputFormat(String format) {
        if ("list".equalsIgnoreCase(format)) {
            this.setOutputFormat(2);
        } else {
            this.setOutputFormat(1);
        }
    }

    public void addTableCol(String c) {
        this.addTableCol(c, c);
    }

    public void addTableCols(String cols) {
        for (String c : cols.split(",")) {
            this.addTableCol(c);
        }
    }

    public void addTableCol(String c, String h) {
        if (this.tablecols == null) {
            this.tablecols = new ArrayList();
            this.tablecolheaders = new ArrayList();
        }
        this.tablecols.add(c);
        this.tablecolheaders.add(h);
    }

    public void setTableCols(String tc) {
        String[] cols;
        for (String c : cols = tc.split(",")) {
            this.addTableCol(c);
        }
    }

    public void addTableColReference(String col, String field) {
        this.tablecolref.put(col, field);
    }

    public void setTableColReference(String refs) {
        String[] cols;
        for (String col : cols = refs.split(",")) {
            String[] def = col.split(":");
            if (def.length <= 1) continue;
            this.addTableColReference(def[0], def[1]);
        }
    }

    protected void addSearchCol(String c) {
        if (this.searchcols == null) {
            this.searchcols = new ArrayList();
        }
        this.searchcols.add(c);
    }

    public void addTableJoin(TableJoin j) {
        this.tablejoins.add(j);
    }

    public void addRelationJoin(RelationAttribute att, String relationtable, String fields) {
        String f2;
        String f1;
        if (att.getDirection() == 1) {
            f1 = "elementfrom";
            f2 = "elementto";
        } else {
            f1 = "elementto";
            f2 = "elementfrom";
        }
        TableJoin j = new TableJoin("LEFT", "tdtaelement", "tdtaelement", "idelement", att.getTableName(), "t_" + att.getRelationcode(), f1, null);
        j.setCondition(j.getJointableAlias() + ".relationcode = '" + att.getRelationcode() + "'");
        this.addTableJoin(j);
        j = new TableJoin("LEFT", j.getJointableAlias(), f2, relationtable, "idelement");
        for (String f : fields.split(",")) {
            j.addSelectField(f, att.getRelationcode() + "_" + f);
        }
        this.addTableJoin(j);
    }

    public List<TableJoin> getTableJoins() {
        return this.tablejoins;
    }

    public void setShowIcon(boolean flg) {
        this.showIcon = flg;
    }

    public void setShowIcon(String flg) {
        this.showIcon = "yes".equalsIgnoreCase(flg);
    }

    public String[] getTableCols() {
        if (this.tablecols == null) {
            String[] tc = new String[]{"meta_title", "meta_summary"};
            return tc;
        }
        return this.tablecols.toArray(new String[0]);
    }

    public List<String> getTableColList() {
        return this.tablecols;
    }

    public List<String> getSearchColList() {
        return this.searchcols;
    }

    public List<String> getAttributeCodes() {
        ArrayList<String> lst = new ArrayList<String>();
        if (this.getTableColList() != null) {
            lst.addAll(this.getTableColList());
        }
        if (this.getSearchColList() != null) {
            lst.addAll(this.getSearchColList());
        }
        return lst;
    }

    public String[] getTableColHeaders() {
        if (this.tablecolheaders == null) {
            String[] tc = new String[]{"Title", "Summary"};
            return tc;
        }
        return this.tablecolheaders.toArray(new String[0]);
    }

    public boolean hasTableCol(String c) {
        return this.tablecols.contains(c);
    }

    public ArrayList<String> getAttributeSearch() {
        return this.attributeSearch;
    }

    @Override
    protected abstract SearchResult runSearch();

    @Override
    public SearchResult search() {
        this.searchresult = this.runSearch();
        if (this.searchresult != null) {
            this.sql = this.searchresult.getSql();
        }
        return this.searchresult;
    }

    public String toHtml(String js) {
        if (this.searchresult == null) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Search not executed");
            return "";
        }
        if (this.outputformat == 1) {
            return this.toHtmlTable(js);
        }
        if (this.outputformat == 2) {
            return this.toHtmlList(js);
        }
        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Unknown output format: " + this.outputformat);
        return "";
    }

    private String toHtmlTable(String js) {
        String img = this.app.getResourceUrl();
        String[] cols = this.getTableCols();
        boolean even = false;
        String bkg = "";
        int countCols = cols.length;
        if (this.showIcon) {
            ++countCols;
        }
        StringBuffer htmlbody = new StringBuffer();
        htmlbody.append("<tbody>");
        for (DataRecord row : this.searchresult.getResult()) {
            bkg = even ? " background: #DDDDDD;" : "";
            htmlbody.append("\n<tr id=\"cms.search." + row.get("meta_id") + "\" style=\"border-top: 1px solid black;" + bkg + "\">");
            if (this.showIcon) {
                htmlbody.append("<td valign=\"top\"><img onclick=\"" + js + ".showElement(" + row.get("meta_id") + ",'view')\" src=\"" + img + "buttons/ele_view.gif\"></td>");
            }
            String[] stringArray = cols;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String col = stringArray[i];
                htmlbody.append("<td valign=\"top\">");
                if (this.tablecolref.containsKey(col)) {
                    htmlbody.append("<a style=\"cursor: pointer\" onclick=\"" + js + ".showElement(" + row.get(this.tablecolref.get(col)) + ",'view')\">");
                    htmlbody.append(row.get(col));
                    htmlbody.append("</a>");
                } else {
                    htmlbody.append(row.get(col));
                }
                htmlbody.append("</td>");
            }
            htmlbody.append("</tr>");
            even = !even;
        }
        htmlbody.append("</tbody>");
        htmlbody.append("</table>");
        StringBuffer html = new StringBuffer();
        html.append("<table width=\"100%\" cellpadding=\"3\" cellspacing=\"0\" rules=\"rows\">");
        html.append("<thead>");
        html.append("<tr style=\"background: #BBBBBB; border-top: 2px solid black;\">");
        html.append("<td colspan=\"" + countCols + "\">");
        html.append("Anzahl Suchergebnisse: " + this.searchresult.size());
        html.append("</td>");
        html.append("</tr>");
        html.append("<tr style=\"background: #BBBBBB; border-bottom: 2px solid black;\">");
        if (this.showIcon) {
            html.append("<td>&nbsp;</td>");
        }
        for (String col : cols) {
            html.append("<td valign=\"top\">");
            html.append("</td>");
        }
        html.append("</tr>");
        html.append("</thead>");
        html.append(htmlbody);
        return html.toString();
    }

    private String toHtmlList(String js) {
        String img = this.app.getResourceUrl();
        String[] cols = this.getTableCols();
        String titleCol = "meta_id";
        String textCol = null;
        if (cols.length > 0) {
            titleCol = cols[0];
        }
        if (cols.length > 1) {
            textCol = cols[1];
        }
        boolean even = false;
        String bkg = "";
        StringBuffer html = new StringBuffer();
        html.append("<table width=\"100%\" cellpadding=\"3\" cellspacing=\"0\" border=\"0\">");
        html.append("<thead>");
        html.append("<tr style=\"background: #BBBBBB; border-top: 2px solid black;\">");
        html.append("<td>");
        html.append("Anzahl Suchergebnisse: " + this.searchresult.size());
        html.append("</td>");
        html.append("</tr>");
        html.append("</thead>");
        html.append("<tbody>");
        for (DataRecord row : this.searchresult.getResult()) {
            bkg = even ? " background: #DDDDDD;" : "";
            html.append("\n<tr id=\"cms.search." + row.get("meta_id") + "\" style=\"border-top: 1px solid black;" + bkg + "\"><td>");
            html.append("<p style=\"font-weight: bold; cursor: pointer; margin: 5px 0px;" + bkg + "\"><a onclick=\"" + js + ".showElement(" + row.get("meta_id") + ",'view')\">");
            html.append(row.get(titleCol) + "</a></p>");
            if (textCol != null && row.get(textCol) != null && !"".equals(row.get(textCol))) {
                html.append("<p style=\"margin: 5px 15px;" + bkg + "\">" + row.get(textCol) + "</p>");
            }
            html.append("</td></tr>");
            even = !even;
        }
        html.append("</tbody>");
        html.append("</table>");
        return html.toString();
    }

    public String toHtmlSelect(String name, String id, String valueField, String contentField, boolean includeNone) {
        StringBuffer html = new StringBuffer();
        html.append("<select name=\"" + name + "\" id=\"" + id + "\">");
        if (includeNone) {
            html.append("<option value=\"\">-</option>");
        }
        for (DataRecord row : this.searchresult.getResult()) {
            html.append("<option value=\"" + row.get(valueField) + "\">" + row.get(contentField) + "</option>");
        }
        html.append("</select>");
        return html.toString();
    }

    @Override
    public String getSql() {
        return this.sql;
    }

    public int size() {
        return this.searchresult.size();
    }

    public DataRecord nextRow() {
        if (this.searchresult == null) {
            return null;
        }
        if (this.searchresult.hasNextRow()) {
            return this.searchresult.nextRow();
        }
        return null;
    }

    public DataRecord previousRow() {
        if (this.searchresult == null) {
            return null;
        }
        if (this.searchresult.hasPreviousRow()) {
            return this.searchresult.previousRow();
        }
        return null;
    }

    public boolean hasNextRow() {
        if (this.searchresult == null) {
            return false;
        }
        return this.searchresult.hasNextRow();
    }

    public boolean hasPreviousRow() {
        if (this.searchresult == null) {
            return false;
        }
        return this.searchresult.hasPreviousRow();
    }

    public List<DataRecord> getResult() {
        if (this.searchresult == null) {
            return new ArrayList<DataRecord>();
        }
        return this.searchresult.getResult();
    }

    public SearchResult getResultTable() {
        return this.searchresult;
    }

    public ArrayList<Long> getResultIds() {
        if (this.searchresult == null) {
            return null;
        }
        return this.searchresult.getResultIds();
    }

    public List<CmsElementSummary> getResultAsElementSummary() {
        ArrayList<CmsElementSummary> resultlist = new ArrayList<CmsElementSummary>();
        for (DataRecord rec : this.getResult()) {
            resultlist.add(new CmsElementSummary(this.getApplication(), rec));
        }
        return resultlist;
    }
}

