/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cms.search.depricated;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TableJoin {
    public static final String LEFT_JOIN = "LEFT";
    public static final String INNER_JOIN = "INNER";
    public static final String RIGHT_JOIN = "RIGHT";
    List<String> fields;
    Map<String, String> aliases;
    String joinsql;
    String reftable;
    String reftablealias;
    String jointable;
    String jointablealias;
    String reffield;
    String joinfield;
    String jointype;
    String condition;

    public TableJoin(String type, String reftable, String reffield, String jointable, String joinfield) {
        this(type, reftable, reftable, reffield, jointable, null, joinfield, null);
    }

    public TableJoin(String type, String refsql, String reftable, String reffield, String jointable, String joinfield) {
        this(type, reftable, reftable, reffield, jointable, null, joinfield, refsql);
    }

    public TableJoin(String type, String reftable, String refalias, String reffield, String jointable, String joinalias, String joinfield, String joinsql) {
        this.joinsql = joinsql;
        this.reffield = reffield;
        this.reftable = reftable;
        this.joinfield = joinfield;
        this.jointable = jointable;
        this.jointablealias = joinalias;
        this.reftablealias = refalias;
        this.jointype = type;
        this.fields = new ArrayList<String>();
        this.aliases = new HashMap<String, String>();
    }

    public void addSelectField(String field) {
        this.fields.add(field);
    }

    public void addSelectField(String field, String alias) {
        this.fields.add(field);
        this.aliases.put(field, alias);
    }

    public List<String> getFields() {
        return this.fields;
    }

    public boolean hasAlias(String field) {
        return this.aliases.containsKey(field);
    }

    public String getAlias(String field) {
        return this.aliases.get(field);
    }

    public String getJointableAlias() {
        if (this.jointablealias == null) {
            return this.jointable;
        }
        return this.jointablealias;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public String getJoin() {
        StringBuffer sb = new StringBuffer(" ");
        sb.append(this.jointype);
        sb.append(" JOIN ");
        if (this.joinsql != null) {
            sb.append("(" + this.joinsql + ") AS ");
        }
        sb.append(this.jointable);
        if (this.jointablealias != null) {
            sb.append(" AS " + this.jointablealias);
        }
        sb.append(" ON (");
        sb.append(this.getJointableAlias());
        sb.append(".");
        sb.append(this.joinfield);
        sb.append(" = ");
        sb.append(this.reftablealias);
        sb.append(".");
        sb.append(this.reffield);
        if (this.condition != null) {
            sb.append(" AND " + this.condition);
        }
        sb.append(") ");
        return sb.toString();
    }
}

