/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cms.search.output;

import at.grid.cms.content.UploadItem;
import at.grid.cms.search.AbstractWebSearch;
import at.grid.cms.search.ListColumn;
import at.grid.cms.storage.DataRecord;
import at.grid.util.Util;
import com.lowagie.text.BadElementException;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PdfSearchResult {
    ByteArrayOutputStream fos = new ByteArrayOutputStream();
    AbstractWebSearch aws = null;
    HashMap<String, Integer> columnWidths = new HashMap();
    int fontFamily = 1;
    Font fontColHead = new Font(this.fontFamily, 8.0f, 1);
    Font fontRow = new Font(this.fontFamily, 6.0f, 0);
    Font fontSum = new Font(this.fontFamily, 6.0f, 1);
    Font fontTitle = new Font(this.fontFamily, 8.0f, 1);
    Font fontInfo = new Font(this.fontFamily, 7.0f, 0);
    Paragraph emptyLine = new Paragraph("\n", this.fontInfo);

    public PdfSearchResult(AbstractWebSearch aws) throws DocumentException, FileNotFoundException {
        this.aws = aws;
    }

    public void createPdf(AbstractWebSearch aws, String company, String topic) throws DocumentException {
        Document document = new Document(PageSize.A4.rotate());
        this.fos = new ByteArrayOutputStream();
        PdfWriter.getInstance((Document)document, (OutputStream)this.fos);
        document.open();
        int colcount = 0;
        for (ListColumn col : aws.getColumns()) {
            if (!this.showColumn(col)) continue;
            ++colcount;
            this.columnWidths.put(col.field, 20);
        }
        document.addTitle("Suchergebnis");
        document.add((Element)new Paragraph(company + " (" + topic + ")", this.fontTitle));
        document.add((Element)this.emptyLine);
        PdfPTable tableinfo = new PdfPTable(1);
        tableinfo.setWidthPercentage(100.0f);
        PdfPCell cell = new PdfPCell();
        cell.setBorder(0);
        cell.setPhrase(new Phrase(aws.getUser().getUsername() + ", " + Util.formatDate((Date)new Date(), (String)Util.DATETIME_READ), this.fontRow));
        tableinfo.addCell(cell);
        tableinfo.completeRow();
        if (aws.doShowSearchcriteria()) {
            PdfPCell cellSearchCriteria = new PdfPCell();
            cellSearchCriteria.setBorder(0);
            cellSearchCriteria.setPhrase(new Phrase(aws.getCriteriaInfo(), this.fontRow));
            tableinfo.addCell(cellSearchCriteria);
            tableinfo.completeRow();
        }
        if (aws.doShowSort()) {
            PdfPCell cellSort = new PdfPCell();
            cellSort.setBorder(0);
            cellSort.setPhrase(new Phrase(aws.getSortInfo(), this.fontRow));
            tableinfo.addCell(cellSort);
            tableinfo.completeRow();
        }
        document.add((Element)tableinfo);
        document.add((Element)this.emptyLine);
        PdfPTable table = this.createTable(colcount);
        document.add((Element)table);
        document.close();
    }

    public byte[] getByteArrayOfPdf(String company, String topic) throws DocumentException {
        this.createPdf(this.aws, company, topic);
        return this.fos.toByteArray();
    }

    public void writeToFile(File outputfile, String company, String topic) throws FileNotFoundException, IOException, DocumentException {
        this.createPdf(this.aws, company, topic);
        FileOutputStream file = new FileOutputStream(outputfile);
        this.fos.writeTo(file);
        file.close();
    }

    private void checkWidthOfColumn(String field, String content) {
        int length = 0;
        if (content.contains("\n")) {
            String[] partsOfContent;
            for (String string : partsOfContent = content.split("\n")) {
                if (length >= string.length()) continue;
                length = string.length();
            }
        } else {
            length = content.length();
        }
        if (this.columnWidths.get(field) < length) {
            this.columnWidths.put(field, length);
        }
    }

    private void checkWidthOfColumn(String field, int length) {
        if (this.columnWidths.get(field) < length) {
            this.columnWidths.put(field, length);
        }
    }

    private void setAlignment(ListColumn col, PdfPCell cell) {
        if ("center".equalsIgnoreCase(col.getAlign())) {
            cell.setHorizontalAlignment(1);
        } else if ("right".equalsIgnoreCase(col.getAlign())) {
            cell.setHorizontalAlignment(2);
        } else {
            cell.setHorizontalAlignment(0);
        }
    }

    private PdfPTable createTable(int colcount) throws BadElementException, DocumentException {
        Object cell;
        PdfPTable table = new PdfPTable(colcount);
        table.setHeaderRows(1);
        table.setWidthPercentage(100.0f);
        for (ListColumn col : this.aws.getColumns()) {
            if (!this.showColumn(col)) continue;
            cell = new PdfPCell();
            cell.setGrayFill(0.9f);
            this.checkWidthOfColumn(col.field, col.getHead(false, false));
            cell.setPhrase(new Phrase(col.getHead(false, false), this.fontColHead));
            this.setAlignment(col, (PdfPCell)cell);
            table.addCell((PdfPCell)cell);
        }
        table.completeRow();
        for (DataRecord dataRecord : this.aws.getResult()) {
            for (ListColumn col : this.aws.getColumns()) {
                if (!this.showColumn(col)) continue;
                if (col.hasImage()) {
                    Image img = null;
                    UploadItem item = new UploadItem(this.aws.getApplication(), col.getImageId(dataRecord), this.aws.getUser());
                    try {
                        if (col.hasImageWidth()) {
                            img = Image.getInstance((String)item.getAbsolutePath());
                            img.scaleAbsoluteWidth((float)col.getImageWidth());
                        } else {
                            img = Image.getInstance((String)item.getAbsolutePath());
                        }
                    }
                    catch (IOException ex) {
                        Logger.getLogger(PdfSearchResult.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    PdfPCell cell2 = new PdfPCell();
                    this.checkWidthOfColumn(col.field, (int)img.getWidth());
                    cell2.setImage(img);
                    table.addCell(cell2);
                    continue;
                }
                PdfPCell cell3 = new PdfPCell();
                String cont = col.getContent(dataRecord, false);
                if (cont.contains("onclick=\"gridelement.")) {
                    String[] list;
                    String sum = "";
                    for (String ele : list = cont.split("<br>")) {
                        ele = ele.split(">")[1].split("<")[0];
                        ele = ele + "\n";
                        sum = sum + ele;
                    }
                    cont = sum;
                }
                this.checkWidthOfColumn(col.field, cont.length());
                cell3.setPhrase(new Phrase(cont, this.fontRow));
                this.setAlignment(col, cell3);
                table.addCell(cell3);
            }
            table.completeRow();
        }
        if (this.aws.hasSumFields()) {
            for (ListColumn col : this.aws.getColumns()) {
                if (!this.showColumn(col)) continue;
                cell = new PdfPCell();
                this.checkWidthOfColumn(col.field, col.calculateSummaryOfField(this.aws.getResult()));
                cell.setPhrase(new Phrase(col.calculateSummaryOfField(this.aws.getResult()), this.fontSum));
                this.setAlignment(col, (PdfPCell)cell);
                table.addCell((PdfPCell)cell);
            }
        }
        table.completeRow();
        float[] colwidthsFloat = new float[colcount];
        int i = 0;
        for (ListColumn col : this.aws.getColumns()) {
            if (!this.showColumn(col)) continue;
            colwidthsFloat[i] = this.columnWidths.get(col.field) > 11 ? (float)Math.log(this.columnWidths.get(col.field) * this.columnWidths.get(col.field)) : (float)(this.columnWidths.get(col.field) / 10);
            ++i;
        }
        table.setWidths(colwidthsFloat);
        return table;
    }

    protected boolean showColumn(ListColumn col) {
        if (col.hasCheckbox()) {
            return false;
        }
        return !col.hasImage() || col.visibleForExport();
    }
}

