/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cms.search.output;

import at.grid.cms.CmsApplication;
import at.grid.cms.content.UploadItem;
import at.grid.cms.search.AbstractWebSearch;
import at.grid.cms.search.ListColumn;
import at.grid.cms.storage.DataRecord;
import at.grid.util.Util;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;

public class XlsSearchResult {
    protected AbstractWebSearch aws = null;
    protected CmsApplication app = null;
    protected Workbook wb = new HSSFWorkbook();
    protected CellStyle csNormal = this.wb.createCellStyle();
    protected CellStyle csBold = this.wb.createCellStyle();
    protected CellStyle csBoldNoWrap = this.wb.createCellStyle();
    protected CellStyle csTitle = this.wb.createCellStyle();
    protected CellStyle csSubtitle = this.wb.createCellStyle();
    protected CellStyle csData = this.wb.createCellStyle();
    protected CellStyle csDataNoWrap = this.wb.createCellStyle();
    protected CellStyle csBorder = this.wb.createCellStyle();
    protected HashMap<String, BufferedImage> images = new HashMap();

    public XlsSearchResult(AbstractWebSearch aws) throws IOException {
        this.aws = aws;
        this.app = aws.getApplication();
        this.prepareFormat();
    }

    protected void createExcel(String company, String topic) {
        int row = 0;
        double imgscale = 2.0;
        Sheet hsheet = this.wb.createSheet();
        this.setCellValue(hsheet, row++, 0, this.csTitle, company);
        int n = ++row;
        ++row;
        this.setCellValue(hsheet, n, 0, this.csTitle, topic);
        int n2 = ++row;
        ++row;
        this.setCellValue(hsheet, n2, 0, this.csBoldNoWrap, this.aws.getUser().getUsername() + ", " + Util.formatDate((Date)new Date(), (String)Util.DATETIME_READ));
        ++row;
        if (this.aws.doShowSearchcriteria()) {
            this.setCellValue(hsheet, row++, 0, this.csDataNoWrap, this.aws.getCriteriaInfo());
        }
        if (this.aws.doShowSort()) {
            this.setCellValue(hsheet, row++, 0, this.csDataNoWrap, this.aws.getSortInfo());
        }
        ++row;
        int col = 0;
        for (ListColumn column : this.aws.getColumns()) {
            if (column.hasCheckbox() || (!column.hasImage() || !column.visibleForExport()) && column.hasImage()) continue;
            this.setCellValue(hsheet, row, col++, this.csBold, column.getHead(false, false));
        }
        ++row;
        for (DataRecord rec : this.aws.getResult()) {
            col = 0;
            for (ListColumn column : this.aws.getColumns()) {
                if (column.visibleForExport()) {
                    try {
                        String url = this.aws.getBaseURL() + column.getContent(rec, false);
                        BufferedImage img = null;
                        if (this.images.containsKey(url)) {
                            img = this.images.get(url);
                        } else {
                            UploadItem item = new UploadItem(this.app, column.getImageId(rec), this.aws.getUser());
                            img = column.hasImageWidth() ? Util.resizeImage((BufferedImage)ImageIO.read(item.getFile()), (int)column.getImageWidth()) : ImageIO.read(item.getFile());
                            this.images.put(url, img);
                        }
                        this.setCellImage(hsheet, row, col++, column.getImageWidth(), img);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(XlsSearchResult.class.getName()).log(Level.SEVERE, null, ex);
                        this.setCellValue(hsheet, row, col++, this.csData, "no Image found");
                    }
                    continue;
                }
                if (column.hasCheckbox() || column.hasImage()) continue;
                String cont = column.getContent(rec, false);
                if (cont.contains("onclick=\"gridelement.")) {
                    String[] list;
                    String sum = "";
                    for (String ele : list = cont.split("<br>")) {
                        if (ele.split(">").length <= 1) continue;
                        ele = ele.split(">")[1].split("<")[0];
                        ele = ele + "\n";
                        sum = sum + ele;
                    }
                    cont = sum;
                }
                this.setCellValue(hsheet, row, col++, this.csData, cont);
            }
            ++row;
        }
        if (this.aws.hasSumFields()) {
            ++row;
            col = 0;
            for (ListColumn column : this.aws.getColumns()) {
                this.setCellValue(hsheet, row, col++, this.csData, column.calculateSummaryOfField(this.aws.getResult()));
            }
        }
        int columnCount = 0;
        for (ListColumn column : this.aws.getColumns()) {
            if (!column.hasCheckbox() && !column.hasImage()) {
                hsheet.autoSizeColumn(columnCount);
            }
            ++columnCount;
        }
    }

    protected final void prepareFormat() {
        Font fontNormal = this.wb.createFont();
        fontNormal.setFontHeightInPoints((short)10);
        this.csNormal.setFont(fontNormal);
        this.csNormal.setWrapText(true);
        Font fontBold = this.wb.createFont();
        fontBold.setFontHeightInPoints((short)11);
        fontBold.setBold(true);
        this.csBold.setFont(fontBold);
        this.csBold.setWrapText(true);
        this.csBoldNoWrap.cloneStyleFrom(this.csBold);
        this.csBoldNoWrap.setWrapText(false);
        Font fontTitle = this.wb.createFont();
        fontTitle.setFontHeightInPoints((short)16);
        fontTitle.setBold(true);
        this.csTitle.setFont(fontTitle);
        this.csTitle.setWrapText(false);
        Font fontSubtitle = this.wb.createFont();
        fontSubtitle.setFontHeightInPoints((short)15);
        this.csSubtitle.setFont(fontSubtitle);
        this.csSubtitle.setWrapText(false);
        this.csBorder.setBorderBottom(BorderStyle.THIN);
        this.csBorder.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        this.csData.setFont(fontNormal);
        this.csData.setBorderTop(BorderStyle.DASHED);
        this.csData.setVerticalAlignment(VerticalAlignment.TOP);
        this.csData.setDataFormat(this.wb.getCreationHelper().createDataFormat().getFormat("dd.mm.yyyy"));
        this.csData.setWrapText(true);
        this.csDataNoWrap.cloneStyleFrom(this.csData);
        this.csDataNoWrap.setWrapText(false);
    }

    protected void setCellValue(Sheet sheet, int row, int col, CellStyle style, String value) {
        Row r = sheet.getRow(row);
        if (r == null) {
            r = sheet.createRow(row);
        }
        Cell c = r.createCell(col);
        if (style != null) {
            c.setCellStyle(style);
        } else {
            c.setCellStyle(this.csData);
        }
        c.setCellValue(value);
    }

    protected void setCellImage(Sheet sheet, int row, int col, int width, BufferedImage img) {
        try {
            sheet.setColumnWidth(0, 12800);
            int height = img.getHeight();
            Row r = sheet.getRow(row);
            if (r == null) {
                r = sheet.createRow(row);
            }
            r.setHeightInPoints(0.5f * (float)height * 0.75f + 1.0f);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)img, "JPG", baos);
            int pictureIdx = this.wb.addPicture(baos.toByteArray(), 5);
            CreationHelper helper = this.wb.getCreationHelper();
            Drawing drawing = sheet.createDrawingPatriarch();
            HSSFClientAnchor anchor = new HSSFClientAnchor(0, 0, (int)((double)width * 0.5), (int)((double)height * 0.5), (short)col, row, (short)(col + 1), row);
            anchor.setAnchorType(ClientAnchor.AnchorType.MOVE_AND_RESIZE);
            Picture pict = drawing.createPicture((ClientAnchor)anchor, pictureIdx);
            pict.resize(0.5);
        }
        catch (IOException ex) {
            Logger.getLogger(XlsSearchResult.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public byte[] getByteArrayOfExcel(String company, String topic) {
        this.createExcel(company, topic);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            this.wb.write((OutputStream)output);
            output.close();
        }
        catch (IOException ex) {
            Logger.getLogger(XlsSearchResult.class.getName()).log(Level.SEVERE, null, ex);
        }
        return output.toByteArray();
    }

    public void writeToFile(File outputfile, String company, String topic) throws FileNotFoundException, IOException {
        this.createExcel(company, topic);
        FileOutputStream fos = new FileOutputStream(outputfile);
        this.wb.write((OutputStream)fos);
        fos.close();
    }
}

