/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cms.servlet;

import at.grid.cms.CmsApplication;
import at.grid.cms.attribute.CmsAttribute;
import at.grid.cms.attribute.RelationAttribute;
import at.grid.cms.attribute.UploadAttribute;
import at.grid.cms.content.CmsPermission;
import at.grid.cms.content.UploadItem;
import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsElementPdfExport;
import at.grid.cms.element.CmsElementSummary;
import at.grid.cms.element.CmsUser;
import at.grid.cms.search.CmsSqlSearch;
import at.grid.cms.servlet.CmsRequest;
import at.grid.cms.servlet.CmsServlet;
import at.grid.cms.servlet.RelationElementWrapper;
import at.grid.cms.storage.DataRecord;
import at.grid.util.Util;
import com.lowagie.text.DocumentException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataSource;
import javax.mail.util.ByteArrayDataSource;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.MultiPartEmail;

public abstract class CmsElementServlet
extends CmsServlet {
    @Override
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String action = null;
        try {
            PrintWriter out;
            this.setNoCache(response);
            CmsUser user = this.getUser(request, response);
            CmsRequest req = new CmsRequest(request);
            HashMap<Long, UploadItem> uploads = new HashMap<Long, UploadItem>();
            if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
                try {
                    ServletFileUpload servletFileUpload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
                    List fileItemsList = servletFileUpload.parseRequest(request);
                    for (Object item : fileItemsList) {
                        DiskFileItem fileItem = (DiskFileItem)item;
                        if (fileItem.isFormField()) {
                            req.put(fileItem.getFieldName(), fileItem.getString("UTF-8"));
                            continue;
                        }
                        if ("".equals(fileItem.getName())) continue;
                        UploadItem upload = new UploadItem(this.getApplication(), this.getApplication().getDatastorage().createId("idfileupload"), this.getApplication().getTempfileLocation(), fileItem.getName(), fileItem.getContentType(), fileItem.getSize(), new Date(), 1);
                        OutputStream os = upload.getOutputStream();
                        InputStream is = fileItem.getInputStream();
                        IOUtils.copy((InputStream)is, (OutputStream)os);
                        is.close();
                        os.close();
                        uploads.put(upload.getId(), upload);
                        req.put(fileItem.getFieldName(), Long.toString(upload.getId()));
                    }
                }
                catch (FileUploadException ex) {
                    this.getApplication().getLogger().warning("Error while loading file: " + ex.getMessage());
                }
            }
            if ((action = request.getParameter("action")) == null) {
                action = req.getParameter("gridaction");
            }
            if ("version".equals(action) || "status".equals(action)) {
                response.setContentType("text/html;charset=UTF-8");
                out = response.getWriter();
                StringBuilder stringBuilder = new StringBuilder().append("GRIDontoloty version: <b>");
                this.getApplication();
                out.print(stringBuilder.append(CmsApplication.getCmsVersion()).append("</b><br/>").toString());
                out.print("Application version: <b>" + this.getApplication().getVersion() + "</b><br/>");
                out.print("User: <b>" + user.getUsername() + " (" + (user.isAuthenticated() ? "logged in" : "NOT logged in") + ")</b><br/>");
                CmsElement ele = this.getCurrentElement(request.getSession(true), user, null);
                out.print("Current element: <b>");
                if (ele == null) {
                    out.print("NONE");
                } else {
                    out.print("#" + ele.getId() + " : " + ele.getTitle());
                }
                out.print("</b><br/>");
                out.print(Util.formatDate((Date)new Date(), (String)Util.DATETIME_READ));
                out.close();
            } else if ("create".equals(action)) {
                response.setContentType("text/html;charset=UTF-8");
                out = response.getWriter();
                String js = req.getParameter("js", "gridelement");
                out.print(this.createElement(req, user).getId());
                out.close();
            } else if ("check_empty_trash".equals(action)) {
                response.setContentType("text/html;charset=UTF-8");
                out = response.getWriter();
                out.print("Wirklich alles l\u00f6schen?");
                out.close();
            } else if ("empty_trash".equals(action)) {
                response.setContentType("text/html;charset=UTF-8");
                out = response.getWriter();
                this.getApplication().getDatastorage().emptyTrash();
                out.close();
            } else if ("load".equals(action)) {
                if ("xml".equalsIgnoreCase(req.getParameter("mode", "view"))) {
                    response.setContentType("text/xml;charset=UTF-8");
                } else {
                    response.setContentType("text/html;charset=UTF-8");
                }
                out = response.getWriter();
                out.print(this.showElement(req, user, true));
                out.close();
            } else if ("removefromsession".equals(action)) {
                String id = req.getParameter("id", "");
                req.getSession().removeAttribute("cms_element" + id);
            } else if ("show".equals(action)) {
                if ("xml".equalsIgnoreCase(req.getParameter("mode", "view"))) {
                    response.setContentType("text/xml;charset=UTF-8");
                } else {
                    response.setContentType("text/html;charset=UTF-8");
                }
                out = response.getWriter();
                out.print(this.showElement(req, user, false));
                out.close();
            } else if ("copy".equals(action)) {
                response.setContentType("text/html;charset=UTF-8");
                out = response.getWriter();
                out.print(this.copyElement(req, user, false));
                out.close();
            } else if ("button".equals(action)) {
                response.setContentType("text/html;charset=UTF-8");
                out = response.getWriter();
                out.print(this.runButtonAction(request, req, response, user, uploads));
                out.close();
            } else if ("addcomment".equals(action)) {
                response.setContentType("text/html;charset=UTF-8");
                out = response.getWriter();
                out.print(this.addComment(request, req, response, user, uploads));
                out.close();
            } else if ("deletecomment".equals(action)) {
                response.setContentType("text/html;charset=UTF-8");
                out = response.getWriter();
                out.print(this.deleteComment(request, req, response, user, uploads));
                out.close();
            } else if ("createrelation".equals(action)) {
                response.setContentType("text/html;charset=UTF-8");
                out = response.getWriter();
                out.print(this.createRelation(req, user, uploads));
                out.close();
            } else if ("addrelation".equals(action)) {
                response.setContentType("text/html;charset=UTF-8");
                out = response.getWriter();
                out.print(this.addRelation(req, user, uploads));
                out.close();
            } else if ("checkaddrelation".equals(action)) {
                response.setContentType("text/html;charset=UTF-8");
                out = response.getWriter();
                out.print(this.checkSingleAddRelation(req, user, uploads));
                out.close();
            } else if ("deleterelation".equals(action)) {
                response.setContentType("text/html;charset=UTF-8");
                out = response.getWriter();
                out.print(this.deleteRelation(req, user, uploads));
                out.close();
            } else if ("moverelation".equals(action)) {
                response.setContentType("text/html;charset=UTF-8");
                out = response.getWriter();
                out.print(this.moveRelation(req, user, uploads));
                out.close();
            } else if ("searchrelation".equals(action)) {
                response.setContentType("text/html;charset=UTF-8");
                out = response.getWriter();
                out.print(this.searchRelation(req, user, uploads));
                out.close();
            } else if ("save".equals(action)) {
                response.setContentType("text/html;charset=UTF-8");
                out = response.getWriter();
                out.print(this.saveElement(req, user, uploads));
                out.close();
            } else if ("savemeta".equals(action)) {
                response.setContentType("text/html;charset=UTF-8");
                out = response.getWriter();
                out.print(this.saveMetaElement(req, user));
                out.close();
            } else if ("update".equals(action)) {
                response.setContentType("text/html;charset=UTF-8");
                out = response.getWriter();
                out.print(this.updateElement(req, user, uploads));
                out.close();
            } else if ("setworkflowstatus".equals(action)) {
                response.setContentType("text/html;charset=UTF-8");
                out = response.getWriter();
                out.print(this.setWorkflowStatus(req, user));
                out.close();
            } else if ("trash".equals(action)) {
                response.setContentType("text/html;charset=UTF-8");
                out = response.getWriter();
                out.print(this.trashElement(req, user, true));
                out.close();
            } else if ("untrash".equals(action)) {
                response.setContentType("text/html;charset=UTF-8");
                out = response.getWriter();
                out.print(this.trashElement(req, user, false));
                out.close();
            } else if ("unlock".equals(action)) {
                response.setContentType("text/html;charset=UTF-8");
                out = response.getWriter();
                this.unlockElement(req, user, uploads);
                out.close();
            } else if ("completedelete".equals(action)) {
                response.setContentType("text/html;charset=UTF-8");
                out = response.getWriter();
                out.print(this.completeDelete(request, req, response, user, uploads));
                out.close();
            } else if ("file".equals(action)) {
                this.getFile(request, req, response);
            } else if ("searchuser".equals(action)) {
                response.setContentType("text/html;charset=UTF-8");
                out = response.getWriter();
                out.print(this.searchUsers(req, user));
                out.close();
            } else if ("sendmail".equals(action)) {
                response.setContentType("text/html;charset=UTF-8");
                out = response.getWriter();
                out.print(this.sendMail(req, user));
                out.close();
            } else if ("deletefile".equals(action)) {
                response.setContentType("text/html;charset=UTF-8");
                out = response.getWriter();
                out.print(this.deleteFile(request, req, response, user, uploads));
                out.close();
            } else if ("".equals(action) || action == null) {
                response.setContentType("text/html;charset=UTF-8");
                out = response.getWriter();
                out.print("action not defined");
                out.close();
            } else if ("addupload".equals(action)) {
                response.setContentType("text/html;charset=UTF-8");
                out = response.getWriter();
                out.print(this.addUpload(request, req, response, user, uploads));
                out.close();
            } else if ("dialogtitle".equals(action)) {
                response.setContentType("text/html;charset=UTF-8");
                out = response.getWriter();
                long id = Long.parseLong(req.getParameter("id"));
                DataRecord rec = this.getApplication().getDatastorage().getElementMeta(id);
                if (rec != null) {
                    out.print(rec.getString("title") + " [" + rec.getString("elementtype") + "]");
                } else {
                    out.print("Element");
                }
                out.close();
            } else {
                response.setContentType("text/html;charset=UTF-8");
                out = response.getWriter();
                out.print("unknown action '" + action + "'");
                out.close();
            }
        }
        catch (Exception ex) {
            this.getApplication().getLogger().log(Level.SEVERE, "An error occured with action '" + action + "':" + ex.getMessage(), ex);
            PrintWriter out = response.getWriter();
            ex.printStackTrace(out);
            out.close();
        }
    }

    @Override
    protected boolean verifyRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        return true;
    }

    public CmsElement createElement(CmsRequest req, CmsUser user) {
        String elementtype = req.getParameter("elementtype");
        if (!this.getApplication().hasElementtype(elementtype)) {
            throw new IllegalArgumentException("Unknown elementtype '" + elementtype + "'");
        }
        String id = req.getParameter("meta_id");
        CmsElement e = id == null ? this.getApplication().createElement(elementtype, user) : this.getApplication().createElement(Long.parseLong(id), elementtype, user);
        e.update(req, user, null);
        this.setElement(req.getSession(), e);
        return e;
    }

    public CmsElement loadElement(CmsRequest req, CmsUser user) {
        String id = req.getParameter("meta_id");
        if (id == null) {
            throw new IllegalArgumentException("ID must not be null");
        }
        String lang = req.getParameter("lang");
        CmsElement e = this.getApplication().loadElement(Long.parseLong(id), user);
        if (e == null) {
            e = this.getCurrentElement(req.getSession(), user, Long.parseLong(id));
        }
        if (e == null) {
            throw new IllegalArgumentException("Cannot load element with ID=" + id + ", please check the log file");
        }
        this.getApplication().getLogger().info("Element loaded, ID = " + e.getId());
        this.setElement(req.getSession(), e);
        return e;
    }

    public String saveElement(CmsRequest req, CmsUser user, HashMap<Long, UploadItem> uploads) {
        try {
            long id = Long.parseLong(req.getParameter("meta_id"));
            CmsElement e = this.getCurrentElement(req.getSession(), user, id);
            e.update(req, user, uploads);
            boolean isnew = e.isNew();
            if (e.save()) {
                this.getApplication().getLogger().info("Element saved, ID = " + e.getId());
                if (isnew) {
                    this.getApplication().getDatastorage().lockElement(id, user.getId());
                }
                if (e.getId() == user.getId()) {
                    user.reload();
                }
                if (e.hasWarningmessage()) {
                    String msg = e.getWarningmessage();
                    e.clearWarningmessage();
                    return "#WARNING#" + msg;
                }
                return "";
            }
            this.getApplication().getLogger().info("Element could not be saved saved, ID = " + e.getId() + ", " + e.getStatusmessage());
            return e.getStatusmessage();
        }
        catch (Exception ex) {
            this.getApplication().getLogger().log(Level.SEVERE, ex.getMessage(), ex);
            return ex.getMessage();
        }
    }

    public String saveMetaElement(CmsRequest req, CmsUser user) {
        try {
            long id = Long.parseLong(req.getParameter("meta_id"));
            CmsElement e = this.getCurrentElement(req.getSession(), user, id);
            e.updateMeta(req, user);
            if (e.save()) {
                this.getApplication().getLogger().info("Element saved, ID = " + e.getId());
                return "";
            }
            this.getApplication().getLogger().info("Element could not be saved saved, ID = " + e.getId() + ", " + e.getStatusmessage());
            return e.getStatusmessage();
        }
        catch (Exception ex) {
            this.getApplication().getLogger().log(Level.SEVERE, ex.getMessage(), ex);
            return ex.getMessage();
        }
    }

    public String updateElement(CmsRequest req, CmsUser user, HashMap<Long, UploadItem> uploads) {
        try {
            RelationAttribute att;
            long id = Long.parseLong(req.getParameter("meta_id"));
            CmsElement e = this.getCurrentElement(req.getSession(), user, id);
            String attgroup = req.getParameter("attgroup", "_first");
            String js = req.getParameter("js", "gridelement");
            e.update(req, user, uploads);
            String relation = req.getParameter("updaterelation");
            if (relation != null && (att = e.getRelationAttribute(relation)) != null) {
                this.getApplication().getDatastorage().loadElementRelation(e, att);
            }
            this.setElement(req.getSession(), e);
            return e.toHTMLEdit(attgroup, js);
        }
        catch (Exception ex) {
            this.getApplication().getLogger().log(Level.SEVERE, ex.getMessage(), ex);
            return ex.getMessage();
        }
    }

    public String copyElement(CmsRequest req, CmsUser user, boolean forceload) {
        String js = req.getParameter("js", "gridelement");
        long id = Long.parseLong(req.getParameter("meta_id"));
        String lang = req.getParameter("lang");
        String attgroup = req.getParameter("attgroup", "_first");
        CmsElement e = this.getCurrentElement(req.getSession(), user, id);
        long newId = e.saveCopy();
        e = this.getCurrentElement(req.getSession(), user, newId);
        this.setElement(req.getSession(), e);
        return Long.toString(newId);
    }

    public String showElement(CmsRequest req, CmsUser user, boolean forceload) {
        String mode = req.getParameter("mode");
        String js = req.getParameter("js", "gridelement");
        long id = Long.parseLong(req.getParameter("meta_id"));
        String lang = req.getParameter("lang");
        CmsElement e = this.getCurrentElement(req.getSession(), user, id);
        if (forceload || e == null || e.getId() != id || lang != null && !e.getLang().equals(lang)) {
            e = this.loadElement(req, user);
        }
        String attgroup = req.getParameter("attgroup", "_first");
        if ("view".equals(mode)) {
            if (CmsPermission.check(e, user, 1)) {
                return e.toHTMLView(attgroup, js);
            }
        } else if ("edit".equals(mode)) {
            if (CmsPermission.check(e, user, 2)) {
                if (e.isNew()) {
                    return e.toHTMLEdit(attgroup, js);
                }
                if (!this.getApplication().getDatastorage().isElementLocked(id, user.getId())) {
                    this.getApplication().getDatastorage().lockElement(id, user.getId());
                    return e.toHTMLEdit(attgroup, js);
                }
                return "element is locked";
            }
        } else if ("meta".equals(mode)) {
            if (CmsPermission.check(e, user, 1)) {
                return e.toHTMLView("_meta", js);
            }
        } else if ("trash".equals(mode)) {
            if (CmsPermission.check(e, user, 2)) {
                return e.toHTMLTrash(js);
            }
        } else if ("untrash".equals(mode)) {
            if (CmsPermission.check(e, user, 2)) {
                return e.toHTMLUntrash(js);
            }
        } else if ("manage".equals(mode)) {
            if (CmsPermission.check(e, user, 3)) {
                return e.toHTMLManage(js);
            }
        } else if ("xml".equals(mode)) {
            if (CmsPermission.check(e, user, 1)) {
                return e.toXML();
            }
        } else {
            return "unknown mode '" + mode + "'";
        }
        return "no permission";
    }

    public String trashElement(CmsRequest req, CmsUser user, boolean dotrash) {
        try {
            long id = Long.parseLong(req.getParameter("meta_id"));
            CmsElement e = this.getCurrentElement(req.getSession(), user, id);
            String trashinfo = "Dataset moved to trash";
            if (dotrash) {
                e.moveToTrash();
            } else {
                trashinfo = e.restoreFromTrash();
            }
            this.getApplication().getLogger().info("Element trashed, ID = " + e.getId());
            return trashinfo;
        }
        catch (Exception ex) {
            this.getApplication().getLogger().log(Level.SEVERE, ex.getMessage(), ex);
            return ex.getMessage();
        }
    }

    public String createRelation(CmsRequest req, CmsUser user, HashMap<Long, UploadItem> uploads) {
        try {
            String elementtype = req.getParameter("elementtype");
            String title = req.getParameter("title", "No title (" + elementtype + ")");
            RelationElementWrapper w = this.getRelationWrapper(req, user, uploads);
            if (w.hasError()) {
                return w.error;
            }
            if (!CmsPermission.check(w.e, user, 2)) {
                return "-1";
            }
            w.emain.update(req, user, uploads);
            CmsElementSummary ele = w.att.addNew(elementtype, title);
            if (ele == null) {
                return "-1";
            }
            CmsElement newele = this.getApplication().createElement(ele);
            this.setElement(req.getSession(), newele);
            newele.addAttributesFromParent(w.e);
            return Long.toString(ele.getId());
        }
        catch (Exception ex) {
            this.getApplication().getLogger().log(Level.SEVERE, ex.getMessage(), ex);
            return "Some error has occured: " + ex.getMessage();
        }
    }

    public String addRelation(CmsRequest req, CmsUser user, HashMap<Long, UploadItem> uploads) {
        try {
            RelationElementWrapper w = this.getRelationWrapper(req, user, uploads);
            if (w.hasError()) {
                return w.error;
            }
            String code = "grid_" + w.att.getCode();
            for (String p : req.getParameterNames()) {
                if (!p.startsWith(code)) continue;
                try {
                    String idrel = p.substring(code.length() + 1);
                    w.att.add(Long.parseLong(idrel));
                }
                catch (Exception ex) {
                    this.getApplication().getLogger().log(Level.SEVERE, "Cannot add relation: " + ex.getMessage(), ex);
                }
            }
            w.emain.update(req, user, uploads);
            return w.emain.toHTMLEdit(w.attgroup, w.js);
        }
        catch (Exception ex) {
            this.getApplication().getLogger().log(Level.SEVERE, ex.getMessage(), ex);
            return "Some error has occured: " + ex.getMessage();
        }
    }

    public String deleteRelation(CmsRequest req, CmsUser user, HashMap<Long, UploadItem> uploads) {
        try {
            long relid = Long.parseLong(req.getParameter("relationid"));
            RelationElementWrapper w = this.getRelationWrapper(req, user, uploads);
            if (w.hasError()) {
                return w.error;
            }
            if (!CmsPermission.check(w.e, user, 2)) {
                return "no permission";
            }
            if (this.getApplication().getDatastorage().isElementLocked(w.emain.getId(), user.getId())) {
                return "element is locked";
            }
            w.att.delete(relid);
            w.emain.update(req, user, uploads);
            return w.emain.toHTMLEdit(w.attgroup, w.js);
        }
        catch (Exception ex) {
            this.getApplication().getLogger().log(Level.SEVERE, ex.getMessage(), ex);
            return "Some error has occured: " + ex.getMessage();
        }
    }

    public String moveRelation(CmsRequest req, CmsUser user, HashMap<Long, UploadItem> uploads) {
        try {
            long relationid = Long.parseLong(req.getParameter("relationid"));
            String direction = req.getParameter("direction");
            RelationElementWrapper w = this.getRelationWrapper(req, user, uploads);
            if (w.hasError()) {
                return w.error;
            }
            if (!CmsPermission.check(w.emain, user, 2)) {
                return "no permission";
            }
            w.emain.update(req, user, uploads);
            w.att.move(relationid, direction);
            return w.emain.toHTMLEdit(w.attgroup, w.js);
        }
        catch (Exception ex) {
            this.getApplication().getLogger().log(Level.SEVERE, ex.getMessage(), ex);
            return "Some error has occured: " + ex.getMessage();
        }
    }

    public String searchRelation(CmsRequest req, CmsUser user, HashMap<Long, UploadItem> uploads) {
        try {
            String term = req.getParameter("searchterm", "%");
            String js = req.getParameter("js", "gridelement");
            String idmain = req.getParameter("idmain", null);
            String attgroup = req.getParameter("attgroup", "_first");
            RelationElementWrapper w = this.getRelationWrapper(req, user, uploads);
            if (w.hasError()) {
                return w.error;
            }
            w.emain.update(req, user, uploads);
            return w.att.getHtmlRelationSearch(term, user, idmain, js, attgroup);
        }
        catch (Exception ex) {
            this.getApplication().getLogger().log(Level.SEVERE, ex.getMessage(), ex);
            return "Some error has occured: " + ex.getMessage();
        }
    }

    public String checkSingleAddRelation(CmsRequest req, CmsUser user, HashMap<Long, UploadItem> uploads) {
        try {
            String term = req.getParameter("searchterm", "%");
            RelationElementWrapper w = this.getRelationWrapper(req, user, uploads);
            if (w.hasError()) {
                return w.error;
            }
            return w.att.getCountRelationSearch(term, user);
        }
        catch (Exception ex) {
            this.getApplication().getLogger().log(Level.SEVERE, ex.getMessage(), ex);
            return "Some error has occured: " + ex.getMessage();
        }
    }

    protected RelationElementWrapper getRelationWrapper(CmsRequest req, CmsUser user, HashMap<Long, UploadItem> uploads) {
        RelationElementWrapper w = new RelationElementWrapper();
        String attribute = req.getParameter("attribute", null);
        Long idmain = new Long(req.getParameter("iddialogelement"));
        Long id = new Long(req.getParameter("idelement"));
        w.js = req.getParameter("js", "gridelement");
        if (id == null) {
            w.error = "No ID provided";
            return w;
        }
        if (id.equals(idmain)) {
            w.e = w.emain = this.getCurrentElement(req.getSession(), user, id);
        } else {
            w.emain = this.getCurrentElement(req.getSession(), user, idmain);
            for (RelationAttribute a : w.emain.getRelationAttributes()) {
                if (!a.isSubelement() || !a.contains(id)) continue;
                w.e = a.getFullElement(id);
                w.attgroup = a.getAttributegroup();
            }
        }
        if (w.e == null) {
            w.error = "No element in session found";
            return w;
        }
        w.att = w.e.getRelationAttribute(attribute);
        if (w.att == null) {
            w.error = "No relation attribute '" + attribute + "'";
            return w;
        }
        if (w.attgroup == null) {
            w.attgroup = w.att.getAttributegroup();
        }
        w.emain.update(req, user, uploads);
        return w;
    }

    public String searchUsers(CmsRequest req, CmsUser user) {
        String term = req.getParameter("user", "%");
        CmsSqlSearch s = new CmsSqlSearch(this.getApplication(), user);
        s.addWhereFreetext(term);
        s.addSelectMeta();
        s.setElementtypes("user");
        List<DataRecord> recs = s.search().getResult();
        StringBuilder html = new StringBuilder();
        if (recs.isEmpty()) {
            html.append("Keine Benutzer gefunden");
        } else {
            for (DataRecord rec : recs) {
                String checked = "";
                if (recs.size() == 1) {
                    checked = "checked=\"checked\"";
                }
                String id = rec.getString("meta_id");
                html.append("<input style=\"margin-right: 5px; float: left\" type=\"checkbox\" " + checked + "name=\"item\" value=\"" + id + "\">");
                html.append("<div style=\"cursor:pointer\" onclick=\"jQuery('#" + id + "').attr('checked', !jQuery('#" + id + "').attr('checked'))\">");
                html.append(rec.getString("meta_title")).append("</div>");
            }
        }
        return html.toString();
    }

    public String sendMail(CmsRequest req, CmsUser user) {
        String errormessage = "error while mail sending to following adresses: ";
        boolean error = false;
        ArrayList<String> users = req.getParameters("item");
        Long id = Long.parseLong(req.getParameter("meta_id", ""));
        String subject = req.getParameter("subject", "");
        String mailtext = req.getParameter("emailtext", "");
        String[] mailadress = req.getParameter("mailadress", "").split(",");
        CmsElement e = this.getCurrentElement(req.getSession(), user, id);
        String[] ids = new String[]{"" + e.getId()};
        CmsElementPdfExport pdf = null;
        try {
            pdf = new CmsElementPdfExport(ids, this.getApplication(), user);
        }
        catch (DocumentException ex) {
            Logger.getLogger(CmsElementServlet.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(CmsElementServlet.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (users != null && users.size() > 0) {
            for (String u : users) {
                try {
                    MultiPartEmail email = new MultiPartEmail();
                    email.setHostName(this.getApplication().getProperty("mail.smtp", ""));
                    email.setFrom(user.getAttributeValue("email"));
                    email.addBcc(((CmsUser)this.getApplication().loadElement(Long.parseLong(u), user)).getAttributeValue("email"));
                    email.setSubject(subject);
                    ByteArrayDataSource source = null;
                    source = new ByteArrayDataSource(pdf.getByteArrayOfPdf(), "application/pdf");
                    email.attach((DataSource)source, e.getTitle() + ".pdf", "attachment", "attachment");
                    email.setMsg(mailtext);
                    email.send();
                }
                catch (EmailException ex) {
                    Logger.getLogger(CmsElementServlet.class.getName()).log(Level.SEVERE, null, ex);
                    error = true;
                    errormessage = errormessage + " " + ((CmsUser)this.getApplication().loadElement(Long.parseLong(u), user)).getAttributeValue("email") + ",";
                }
                catch (DocumentException ex) {
                    Logger.getLogger(CmsElementServlet.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        if (mailadress != null && !"".equals(mailadress[0])) {
            for (String address : mailadress) {
                try {
                    MultiPartEmail email = new MultiPartEmail();
                    email.setHostName(this.getApplication().getProperty("mail.smtp", ""));
                    email.setFrom(user.getAttributeValue("email"));
                    email.addBcc(address);
                    email.setSubject(subject);
                    ByteArrayDataSource source = null;
                    source = new ByteArrayDataSource(pdf.getByteArrayOfPdf(), "application/pdf");
                    email.attach((DataSource)source, e.getTitle() + ".pdf", "attachment", "attachment");
                    email.setMsg(mailtext);
                    email.send();
                }
                catch (EmailException ex) {
                    Logger.getLogger(CmsElementServlet.class.getName()).log(Level.SEVERE, null, ex);
                    error = true;
                    errormessage = errormessage + " " + address + ",";
                }
                catch (DocumentException ex) {
                    Logger.getLogger(CmsElementServlet.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        if (error) {
            return errormessage;
        }
        return "all mails were successfully sent";
    }

    public String setWorkflowStatus(CmsRequest req, CmsUser user) {
        try {
            long id = Long.parseLong(req.getParameter("meta_id"));
            int status = Integer.parseInt(req.getParameter("status"));
            String js = req.getParameter("js", "gridelement");
            CmsElement e = this.getCurrentElement(req.getSession(), user, id);
            if (!CmsPermission.check(e, user, 2)) {
                return "no permission";
            }
            e.setWorkflowStatus(status);
            if (!e.save()) {
                this.getApplication().getLogger().info("Element could not be saved saved, ID = " + e.getId() + ", " + e.getStatusmessage());
            }
            return e.toHTMLView("_first", js);
        }
        catch (Exception ex) {
            this.getApplication().getLogger().log(Level.SEVERE, ex.getMessage(), ex);
            return "Some error has occured: " + ex.getMessage();
        }
    }

    public void getFile(HttpServletRequest request, CmsRequest req, HttpServletResponse response) {
        try {
            long fileid = Long.parseLong(req.getParameter("meta_id"));
            CmsUser u = this.getUser(request, response);
            UploadItem item = new UploadItem(this.getApplication(), fileid, u);
            if (!item.isValid()) {
                response.setContentType("text/html;charset=UTF-8");
                PrintWriter out = response.getWriter();
                out.print("no permission");
                out.close();
                return;
            }
            ServletOutputStream os = response.getOutputStream();
            FileInputStream fis = new FileInputStream(item.getFile());
            response.setContentType(item.getContenttype());
            response.setHeader("CONTENT-DISPOSITION", "attachment;filename=" + item.getName());
            response.setHeader("AGE-VALUE", "0");
            IOUtils.copy((InputStream)fis, (OutputStream)os);
            fis.close();
            os.close();
        }
        catch (Exception ex) {
            this.getApplication().getLogger().log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public String addUpload(HttpServletRequest request, CmsRequest req, HttpServletResponse response, CmsUser user, HashMap<Long, UploadItem> uploads) {
        try {
            long id = Long.parseLong(req.getParameter("meta_id"));
            String js = req.getParameter("js", "gridelement");
            CmsUser u = this.getUser(request, response);
            CmsElement e = this.getCurrentElement(request.getSession(), u, id);
            if (!CmsPermission.check(e, u, 2)) {
                return "no permission";
            }
            if (this.getApplication().getDatastorage().isElementLocked(e.getId(), user.getId())) {
                return "element is locked";
            }
            e.update(req, user, uploads);
            return e.toHTMLEdit(request.getParameter("attgroup"), js);
        }
        catch (Exception ex) {
            this.getApplication().getLogger().log(Level.SEVERE, ex.getMessage(), ex);
            return "Some error has occured: " + ex.getMessage();
        }
    }

    public String runButtonAction(HttpServletRequest request, CmsRequest req, HttpServletResponse response, CmsUser user, HashMap<Long, UploadItem> uploads) {
        long id = Long.parseLong(req.getParameter("id"));
        CmsElement e = this.getCurrentElement(request.getSession(), user, id);
        e.update(req, user, uploads);
        String buttoncode = req.getParameter("buttoncode");
        e.actionButton(buttoncode);
        CmsAttribute att = e.getAttribute(buttoncode);
        String attgroup = "_first";
        if (att != null) {
            attgroup = att.getAttributegroup();
        }
        String js = req.getParameter("js", "gridelement");
        String mode = req.getParameter("mode", "view");
        if (mode.equals("edit")) {
            return e.toHTMLEdit(attgroup, js);
        }
        return e.toHTMLView(attgroup, js);
    }

    public String addComment(HttpServletRequest request, CmsRequest req, HttpServletResponse response, CmsUser user, HashMap<Long, UploadItem> uploads) {
        long id = Long.parseLong(req.getParameter("id"));
        CmsElement e = this.getCurrentElement(request.getSession(), user, id);
        e.update(req, user, uploads);
        String comment = req.getParameter("comment", "");
        if (user.isAuthenticated()) {
            this.getApplication().getDatastorage().insertComment(comment, user, e.getId());
        }
        String js = req.getParameter("js", "gridelement");
        e = this.getApplication().loadElement(id, user);
        return e.toHTMLEdit("_comments", js);
    }

    public String completeDelete(HttpServletRequest request, CmsRequest req, HttpServletResponse response, CmsUser user, HashMap<Long, UploadItem> uploads) {
        CmsElement e = this.getCurrentElement(req.getSession(), user, null);
        if (CmsPermission.check(e, user, 3)) {
            e.remove();
            return "Element removed";
        }
        return this.getApplication().getResourceText("core.message.no_permission", user.getCurrentLocale());
    }

    public String deleteComment(HttpServletRequest request, CmsRequest req, HttpServletResponse response, CmsUser user, HashMap<Long, UploadItem> uploads) {
        long id = Long.parseLong(req.getParameter("id"));
        long eleid = Long.parseLong(req.getParameter("eleid"));
        CmsElement e = this.getApplication().loadElement(eleid, user);
        long userid = this.getApplication().getDatastorage().getUserIdOfComment(id);
        if (user.getId() == userid || user.isSuperadmin()) {
            this.getApplication().getDatastorage().removeComment(id);
        }
        String js = req.getParameter("js", "gridelement");
        return e.toHTMLView("_comments", js);
    }

    public String deleteFile(HttpServletRequest request, CmsRequest req, HttpServletResponse response, CmsUser user, HashMap<Long, UploadItem> uploads) {
        try {
            long id = Long.parseLong(req.getParameter("meta_id"));
            String attribute = req.getParameter("attribute");
            String attgroup = req.getParameter("attgroup");
            long fileid = Long.parseLong(req.getParameter("fileid"));
            String js = req.getParameter("js", "gridelement");
            CmsUser u = this.getUser(request, response);
            CmsElement e = this.getCurrentElement(request.getSession(), u, id);
            if (!CmsPermission.check(e, u, 2)) {
                return "no permission";
            }
            e.update(req, user, uploads);
            ((UploadAttribute)e.getAttribute(attribute)).deleteUpload(fileid);
            return e.toHTMLEdit(attgroup, js);
        }
        catch (Exception ex) {
            this.getApplication().getLogger().log(Level.SEVERE, ex.getMessage(), ex);
            return "Some error has occured: " + ex.getMessage();
        }
    }

    public void unlockElement(CmsRequest req, CmsUser user, HashMap<Long, UploadItem> uploads) {
        long id = Long.parseLong(req.getParameter("meta_id"));
        CmsElement e = this.getCurrentElement(req.getSession(), user, id);
        if (CmsPermission.check(e, user, 2)) {
            this.getApplication().getDatastorage().unlockElement(id, user.getId());
        }
    }

    public void setElement(HttpSession session, CmsElement e) {
        session.setAttribute("cms_element" + e.getId(), (Object)e);
    }

    protected CmsElement getCurrentElement(HttpSession session, CmsUser user, Long id) {
        return this.getCurrentElement(session, user, id, -1L, true);
    }

    protected CmsElement getCurrentElement(HttpSession session, CmsUser user, Long id, Long idsubelement, boolean putInSession) {
        if (id == null) {
            return null;
        }
        CmsElement e = (CmsElement)session.getAttribute("cms_element" + id);
        if (e == null) {
            e = this.getApplication().loadElement(id, user);
            return e;
        }
        if (e.getId() != idsubelement.longValue()) {
            // empty if block
        }
        return e;
    }
}

