/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cms.servlet;

import at.grid.cms.content.Keytable;
import at.grid.cms.element.CmsUser;
import at.grid.cms.servlet.CmsRequest;
import at.grid.cms.servlet.CmsServlet;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class CmsKeyTableServlet
extends CmsServlet {
    @Override
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        CmsUser user = this.getUser(request, response);
        CmsRequest req = new CmsRequest(request);
        Keytable keytable = (Keytable)req.getSession().getAttribute("currentKeytable");
        String idstr = req.getParameter("id", "-1");
        if ("undefined".equals(idstr)) {
            idstr = "-1";
        }
        Long id = Long.parseLong(idstr);
        String action = request.getParameter("action");
        if (!user.isSuperadmin()) {
            response.setContentType("text/html;charset=UTF-8");
            PrintWriter out = response.getWriter();
            out.print("no permission");
            out.close();
        } else if ("load".equals(action)) {
            String name = request.getParameter("name");
            keytable = this.getApplication().getKeytable(name);
            req.getSession().setAttribute("currentKeytable", (Object)keytable);
            this.printKeytabelHtml(keytable, response);
        } else if (keytable == null) {
            this.printErrorMessage("No keytable loaded", response);
        } else if ("save".equals(action)) {
            this.applyKeytableChanges(keytable, req);
            keytable.save();
            this.printKeytabelHtml(keytable, response);
        } else if ("up".equals(action)) {
            this.applyKeytableChanges(keytable, req);
            keytable.moveUp(id);
            this.printKeytabelHtml(keytable, response);
        } else if ("down".equals(action)) {
            this.applyKeytableChanges(keytable, req);
            keytable.moveDown(id);
            this.printKeytabelHtml(keytable, response);
        } else if ("delete".equals(action)) {
            this.applyKeytableChanges(keytable, req);
            keytable.remove(id);
            this.printKeytabelHtml(keytable, response);
        } else if ("addrow".equals(action)) {
            this.applyKeytableChanges(keytable, req);
            long newId = keytable.getNextId();
            for (String lang : this.getApplication().getLanguages()) {
                keytable.addTerm(newId, lang, "");
            }
            this.printKeytabelHtml(keytable, response);
        }
    }

    protected void printKeytabelHtml(Keytable keytable, HttpServletResponse response) {
        try {
            response.setContentType("text/html;charset=UTF-8");
            PrintWriter out = response.getWriter();
            out.print(keytable.toHTMLedit());
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void printErrorMessage(String msg, HttpServletResponse response) {
        try {
            response.setContentType("text/html;charset=UTF-8");
            PrintWriter out = response.getWriter();
            out.print(msg);
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void applyKeytableChanges(Keytable keytable, CmsRequest req) {
        for (String p : req.getParameterNames()) {
            if (!p.startsWith("keytable." + keytable.getCode() + ".")) continue;
            String[] split = p.split("\\.");
            keytable.addOrReplaceTerm(Long.parseLong(split[2]), split[3], req.getParameter(p));
        }
    }

    @Override
    protected boolean verifyRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        return true;
    }
}

