/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cms.servlet;

import at.grid.cms.CmsApplication;
import at.grid.cms.element.CmsUser;
import at.grid.util.Util;
import java.io.IOException;
import java.util.Date;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class CmsServlet
extends HttpServlet {
    public CmsUser getUser(HttpServletRequest request, HttpServletResponse response) {
        CmsUser u = (CmsUser)this.getApplication().getSessionObject(request.getSession(), "user.currentUser");
        if (u == null) {
            Util.getLogger((String)((Object)((Object)this)).getClass().getName()).log(Level.INFO, "No user in session, creating new anonymous user");
            u = (CmsUser)this.getApplication().createElement("user", this.getApplication().getAdminUser());
            this.getApplication().setSessionObject(request.getSession(), "user.currentUser", u);
        }
        return u;
    }

    protected String getRequestParameter(HttpServletRequest request, String param, String defaultvalue) {
        String result = request.getParameter(param);
        if (result == null) {
            return defaultvalue;
        }
        return result;
    }

    public String getUrlBase(HttpServletRequest request) {
        String context = request.getContextPath();
        String server = request.getHeader("x-forwarded-host");
        if (server != null) {
            context = "";
        }
        return context;
    }

    public String getClientIP(HttpServletRequest request) {
        String result = request.getHeader("x-forwarded-for");
        if (result == null) {
            result = request.getRemoteAddr();
        }
        return result;
    }

    public String getServerAddr(HttpServletRequest request) {
        String result = request.getHeader("x-forwarded-host");
        if (result == null) {
            result = request.getHeader("host");
        }
        if (result == null) {
            result = request.getServerName();
        }
        return result;
    }

    public void setNoCache(HttpServletResponse response) {
        response.setHeader("cache-control", "no-cache, must-revalidate, max-age=0");
        response.setHeader("pragma", "no-cache");
        response.setHeader("expires", "-1");
        response.setHeader("Last-Modified", new Date().toString());
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.verifyAndProcessRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.verifyAndProcessRequest(request, response);
    }

    protected void verifyAndProcessRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.verifyRequest(request, response)) {
            throw new ServletException("No permission to process request");
        }
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "CMS base servlet (abstract)";
    }

    protected abstract void processRequest(HttpServletRequest var1, HttpServletResponse var2) throws ServletException, IOException;

    protected abstract boolean verifyRequest(HttpServletRequest var1, HttpServletResponse var2) throws ServletException, IOException;

    protected abstract CmsApplication getApplication();
}

