/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cms.servlet;

import at.grid.cms.element.CmsUser;
import at.grid.cms.servlet.CmsServlet;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class CmsUserServlet
extends CmsServlet {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter out = response.getWriter();
        String action = request.getParameter("action");
        if (action == null) {
            action = request.getParameter("gridaction");
        }
        this.setNoCache(response);
        try {
            if ("status".equals(action)) {
                out.print(this.getUser(request, response).toHTMLView("_first", "gridelement"));
            } else if ("login".equals(action)) {
                if (this.login(request, response)) {
                    out.print("login successful");
                } else {
                    out.print("login failed");
                }
            } else if ("logout".equals(action)) {
                this.getUser(request, response).logout();
                out.print("user logged out");
            } else if ("checkauthentication".equals(action)) {
                if (this.getUser(request, response).isAuthenticated()) {
                    out.print("1");
                } else {
                    out.print("0");
                }
            } else if ("checkauthenticationforjs".equals(action)) {
                response.setContentType("text/html;charset=UTF-8");
                if (this.getUser(request, response).isAuthenticated()) {
                    out.print("1");
                } else {
                    out.print("0");
                }
            } else if ("".equals(action) || action == null) {
                out.print("CmsUserServlet: action not defined");
            } else {
                out.print("unknown action '" + action + "'");
            }
        }
        finally {
            out.close();
        }
    }

    @Override
    protected boolean verifyRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        return true;
    }

    private boolean login(HttpServletRequest request, HttpServletResponse response) {
        CmsUser u = this.getUser(request, response);
        String ip = request.getHeader("x-forwarded-for");
        boolean success = u.login(this.getRequestParameter(request, "username", ""), this.getRequestParameter(request, "password", ""), ip);
        if (success) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.INFO, "User logged in as '" + u.getUsername() + "' with ID " + u.getId());
        } else {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.INFO, "User NOT logged in");
        }
        this.getApplication().setSessionObject(request.getSession(), "user.currentUser", u);
        return success;
    }
}

