/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cms.storage;

import at.grid.cms.CmsApplication;
import at.grid.cms.storage.SearchResult;
import at.grid.util.Util;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import java.util.logging.Level;

public class DataRecord {
    HashMap<String, String> rec;
    SearchResult result = null;
    private CmsApplication app;
    ArrayList<String> nullvalues = new ArrayList();

    public DataRecord(HashMap<String, String> rec) {
        this.rec = new HashMap<String, String>(rec);
    }

    public DataRecord(CmsApplication app) {
        this.app = app;
        this.rec = new HashMap();
    }

    public DataRecord(SearchResult dq, ResultSet rs) throws SQLException {
        this.app = dq.getApplication();
        this.result = dq;
        this.rec = new HashMap();
        for (String col : dq.getColumns()) {
            String val = rs.getString(col);
            if (val == null) {
                val = "";
                this.nullvalues.add(col);
            }
            this.add(col, val);
        }
    }

    public boolean isNull(String col) {
        return this.nullvalues.contains(col);
    }

    public Object[] getValues(List<String> cols) {
        Object[] result = new Object[cols.size()];
        int counter = 0;
        for (String c : cols) {
            result[counter] = this.get(c);
            ++counter;
        }
        return result;
    }

    public void add(String key, String val) {
        this.rec.put(key, val);
    }

    public void put(String key, String val) {
        this.rec.put(key, val);
    }

    public String get(String key) {
        return this.rec.get(key);
    }

    public boolean isEmpty(String key) {
        String v = this.get(key);
        return v == null || "".equals(v);
    }

    public void setMetaElementtype(String et) {
        ArrayList<String> oldkeys = new ArrayList<String>();
        for (String k : this.rec.keySet()) {
            oldkeys.add(k);
        }
        for (String k : oldkeys) {
            if (k.startsWith("meta_")) {
                this.add(et + k, this.rec.get(k));
                this.rec.remove(k);
                continue;
            }
            if (!k.startsWith("idmeta")) continue;
            this.add("id" + et + k.substring(2), this.rec.get(k));
            this.rec.remove(k);
        }
    }

    public int getDataType(String key) {
        if (this.result == null) {
            return 1111;
        }
        return this.result.getColumnType(key);
    }

    public void deleteColum(String key) {
        this.rec.remove(key);
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getString(String key1, String def) {
        if (this.get(key1) != null) {
            return this.get(key1);
        }
        return def;
    }

    public Long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public Long getLong(String key, Long def) {
        if (this.isEmpty(key)) {
            return def;
        }
        return Long.parseLong(this.get(key));
    }

    public Integer getInt(String key) {
        return this.getInt(key, null);
    }

    public Integer getInt(String key, Integer def) {
        if (this.isEmpty(key)) {
            return def;
        }
        return Integer.parseInt(this.get(key));
    }

    public Float getFloat(String key) {
        return this.getFloat(key, null);
    }

    public Float getFloat(String key, Float def) {
        if (this.isEmpty(key)) {
            return def;
        }
        return Float.valueOf(Float.parseFloat(this.get(key)));
    }

    public Boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public Boolean getBoolean(String key, Boolean def) {
        if (this.isEmpty(key)) {
            return def;
        }
        return "t".equalsIgnoreCase(this.get(key)) || "true".equalsIgnoreCase(this.get(key));
    }

    public Date getDate(String key, TimeZone tz) {
        return this.getDate(key, null, tz);
    }

    public Date getDate(String key, Date def, TimeZone tz) {
        if (this.isEmpty(key)) {
            return def;
        }
        try {
            return Util.parseDate((String)this.get(key), (String)Util.DATETIME_SQL, (TimeZone)tz);
        }
        catch (ParseException parseException) {
            try {
                return Util.parseDate((String)this.get(key), (String)Util.DATE_SQL, (TimeZone)tz);
            }
            catch (ParseException ex) {
                this.app.getLogger().log(Level.SEVERE, "Cannot parse date '" + this.get(key) + "'");
                return def;
            }
        }
    }

    public String getDateAsString(String key, TimeZone tz, String format) {
        Date dt = this.getDate(key, tz);
        if (dt == null) {
            return "";
        }
        return Util.formatDate((Date)dt, (String)format, (TimeZone)tz);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String k : this.rec.keySet()) {
            sb.append((Object)k).append(" = ").append(this.get(k)).append(", ");
        }
        return sb.toString();
    }
}

