/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cms.storage;

import at.grid.cms.CmsApplication;
import at.grid.cms.OntologyFileAccess;
import at.grid.cms.attribute.CmsAttribute;
import at.grid.cms.attribute.KeyAttribute;
import at.grid.cms.attribute.MultikeyAttribute;
import at.grid.cms.attribute.RelationAttribute;
import at.grid.cms.attribute.TextAttribute;
import at.grid.cms.attribute.UploadAttribute;
import at.grid.cms.content.CmsPermission;
import at.grid.cms.content.Keytable;
import at.grid.cms.content.KeytableRecord;
import at.grid.cms.content.UploadItem;
import at.grid.cms.element.CmsComment;
import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsElementSummary;
import at.grid.cms.element.CmsUser;
import at.grid.cms.search.CmsSqlSearch;
import at.grid.cms.storage.DataRecord;
import at.grid.cms.storage.SearchResult;
import at.grid.util.Util;
import at.grid.util.db.ConnectionPool;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public abstract class DataStorage {
    private CmsApplication app;
    protected Properties props;
    protected ConnectionPool pool;
    ArrayList<String> newtables = new ArrayList();
    int dbversionBeforeUpdate = -1;
    File traceFile = null;
    OutputStream traceOutputStream = null;
    PrintWriter traceFileWriter = null;
    public static final int DBVERSION = 21;

    public DataStorage() {
    }

    public DataStorage(CmsApplication app, Properties props) {
        this.initialise(app, props);
    }

    public CmsApplication getApplication() {
        return this.app;
    }

    public boolean isConnected() {
        boolean result = false;
        try {
            Connection c = this.getConnection();
            result = true;
            this.freeConnection(c);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public String getConnectionInfo() {
        String dburi = this.getProperties().getProperty("db.uri");
        int idx = dburi.lastIndexOf("/");
        if (idx < 0) {
            idx = 0;
        }
        if (idx == dburi.length() - 1) {
            idx = 0;
        }
        StringBuilder sbuf = new StringBuilder();
        sbuf.append(dburi.substring(idx + 1));
        sbuf.append(" (").append(this.getProperties().getProperty("db.user")).append(")");
        return sbuf.toString();
    }

    public final void initialise(CmsApplication app, Properties props) {
        this.app = app;
        this.props = props;
        String v = this.verifyProperties();
        if (v != null) {
            this.getApplication().getLogger().log(Level.SEVERE, "Properties verification failed: " + v);
            throw new Error("Application error, unable to continue");
        }
        this.postInitialise(app, props);
    }

    public void postInitialise(CmsApplication app, Properties props) {
    }

    public Properties getProperties() {
        return this.props;
    }

    public abstract String verifyProperties();

    public void setTraceFile(File f, OntologyFileAccess fileAccess) throws IOException {
        this.traceFile = f;
        fileAccess.mkdirs(f.getParentFile());
        this.traceOutputStream = fileAccess.outputStream(f);
        this.traceFileWriter = new PrintWriter(this.traceOutputStream);
    }

    public void closeTraceFile() {
        if (this.traceFileWriter != null) {
            this.traceFileWriter.close();
        }
        if (this.traceOutputStream != null) {
            try {
                this.traceOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.traceFile != null && this.traceFile.length() == 0L) {
            this.app.getFileAccess().delete(this.traceFile);
        }
        this.traceFile = null;
        this.traceFileWriter = null;
        this.traceOutputStream = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File createSqlDump(File f, OntologyFileAccess fileAccess) {
        OutputStream fos = null;
        ZipOutputStream zipOut = null;
        FileInputStream fis = null;
        fileAccess.mkdirs(f.getParentFile());
        File zipfile = new File(f.getParentFile(), Util.getFileNameWithoutExtension((File)f) + ".zip");
        this.executeQuery("script to '" + f.getAbsolutePath() + "'", true);
        try {
            int length;
            fos = fileAccess.outputStream(zipfile);
            zipOut = new ZipOutputStream(fos);
            fis = new FileInputStream(f);
            ZipEntry zipEntry = new ZipEntry(f.getName());
            zipOut.putNextEntry(zipEntry);
            byte[] bytes = new byte[1024];
            while ((length = fis.read(bytes)) >= 0) {
                zipOut.write(bytes, 0, length);
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(DataStorage.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(DataStorage.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                zipOut.close();
            }
            catch (Exception ex) {}
            try {
                fis.close();
                fileAccess.delete(f);
            }
            catch (Exception ex) {}
            try {
                fos.close();
            }
            catch (Exception ex) {}
        }
        return zipfile;
    }

    public synchronized Connection getConnection() throws SQLException {
        if (this.pool == null) {
            throw new NullPointerException("Connection pool not initialised");
        }
        return this.pool.getConnection();
    }

    public void close() {
        this.pool.closeAllConnections();
    }

    public void closeConnection(Connection conn) throws Exception {
        conn.close();
    }

    public synchronized void freeConnection(Connection conn) throws SQLException {
        this.pool.free(conn);
    }

    public synchronized int executeUpdate(String sql, boolean showWarning) {
        ArrayList<String> sqls = new ArrayList<String>();
        sqls.add(sql);
        return this.executeUpdate(sqls, showWarning);
    }

    public synchronized int executeUpdate(ArrayList<String> sqls, boolean showWarning) {
        return this.executeUpdate(sqls, showWarning, false);
    }

    public synchronized int executeUpdate(ArrayList<String> sqls, boolean showWarning, boolean debug) {
        long performanceMillis = new Date().getTime();
        int count = 0;
        String sql = "";
        if (this.traceFileWriter != null) {
            for (String s : sqls) {
                try {
                    this.traceFileWriter.println(s + ";");
                    this.traceFileWriter.flush();
                }
                catch (Exception ex) {
                    this.app.getLogger().severe("Cannot write to trace file: " + ex.getMessage());
                }
            }
        }
        try {
            Connection conn = this.getConnection();
            try {
                Statement stmt = conn.createStatement(1004, 1007);
                if (sqls.size() > 1) {
                    if (debug) {
                        for (String s : sqls) {
                            this.executeUpdate(s, showWarning);
                        }
                    } else {
                        Iterator<String> iterator = sqls.iterator();
                        while (iterator.hasNext()) {
                            String s;
                            sql = s = iterator.next();
                            stmt.addBatch(s);
                        }
                        int[] counts = stmt.executeBatch();
                        for (Object c : (Iterator<String>)counts) {
                            count += c;
                        }
                    }
                } else if (sqls.size() == 1) {
                    sql = sqls.get(0);
                    count = stmt.executeUpdate(sql);
                    this.app.getLogger().finer("PERFORMANCE: " + (new Date().getTime() - performanceMillis) + " ms, UPDATE count = " + count + ", SQL = " + sql.replace("\n", " "));
                }
                stmt.close();
            }
            catch (SQLException ex) {
                if (showWarning) {
                    this.getApplication().getLogger().log(Level.WARNING, "SQL error using: " + sqls.toString() + "\n                    " + ex.getMessage() + " NextException: " + ex.getNextException() + (!debug ? "\n... trying again" : ""));
                    if (!debug) {
                        this.executeUpdate(sqls, showWarning, true);
                    }
                }
                count = -1;
            }
            this.freeConnection(conn);
        }
        catch (SQLException ex) {
            this.getApplication().getLogger().log(Level.SEVERE, "SQL connection error", ex);
            count = -1;
        }
        return count;
    }

    public SearchResult runQuery(String sql) {
        return this.executeQuery(sql, false);
    }

    public ResultSet executeQueryForResultSet(String sql, boolean showWarning) {
        ResultSet rs = null;
        try {
            Connection conn;
            block4: {
                conn = this.getConnection();
                try {
                    Statement stmt = conn.createStatement(1004, 1007);
                    rs = stmt.executeQuery(sql);
                }
                catch (Exception ex) {
                    if (!showWarning) break block4;
                    this.getApplication().getLogger().log(Level.SEVERE, "SQL error using: " + sql + "\n                    Exception.Message : " + ex.getMessage(), ex);
                }
            }
            this.freeConnection(conn);
        }
        catch (Exception ex) {
            this.getApplication().getLogger().log(Level.SEVERE, "Database connection error: " + ex.getMessage(), ex);
        }
        return rs;
    }

    public SearchResult executeQuery(String sql, boolean showWarning) {
        SearchResult dq = new SearchResult();
        try {
            Connection conn;
            block5: {
                conn = this.getConnection();
                try {
                    long performanceMillis = new Date().getTime();
                    Statement stmt = conn.createStatement(1004, 1007);
                    ResultSet rs = stmt.executeQuery(sql);
                    dq = new SearchResult(rs, this.getApplication());
                    dq.setSql(sql);
                    if (!sql.startsWith("SELECT stringval AS val FROM config")) {
                        this.app.getLogger().finer("PERFORMANCE: " + (new Date().getTime() - performanceMillis) + " ms, SQL = " + sql.replace("\n", " "));
                    }
                }
                catch (Exception ex) {
                    if (!showWarning) break block5;
                    this.getApplication().getLogger().log(Level.SEVERE, "SQL error using: " + sql + "\n                    Exception.Message : " + ex.getMessage(), ex);
                }
            }
            this.freeConnection(conn);
        }
        catch (Exception ex) {
            this.getApplication().getLogger().log(Level.SEVERE, "Database connection error: " + ex.getMessage(), ex);
        }
        return dq;
    }

    public static boolean checkResultSetForField(ResultSet rs, String f) throws SQLException {
        for (int ii = 1; ii <= rs.getMetaData().getColumnCount(); ++ii) {
            if (!f.equalsIgnoreCase(rs.getMetaData().getColumnLabel(ii))) continue;
            return true;
        }
        return false;
    }

    public String getFieldType(CmsAttribute att) {
        int length = 0;
        if (att.isOfType(12)) {
            length = ((TextAttribute)att).getSize();
        }
        return this.getFieldType(att.getType(), length);
    }

    public abstract String getFieldType(int var1, int var2);

    public String getByteArrayFieldType() {
        return "bytea";
    }

    public int getDatabaseVersion() {
        return this.getDatabaseVersion("ontologyversion");
    }

    public int getDatabaseApplicationVersion(String applicationcode) {
        return this.getDatabaseVersion(applicationcode);
    }

    public void setDatabaseApplicationVersion(String applicationcode, int version) {
        this.executeUpdate(this.sqlSetVersion(applicationcode, version), true);
    }

    private int getDatabaseVersion(String key) {
        DataRecord row = this.executeQuery(this.sqlGetVersion(key), false).firstRow();
        if (row != null && !row.isEmpty("version")) {
            return row.getInt("version", 0);
        }
        DataRecord row0 = this.executeQuery(this.sqlGetOldVersion(), false).firstRow();
        if (row0 != null && !row0.isEmpty("version") && "ontologyversion".equals(key)) {
            return row0.getInt("version", 0);
        }
        return 0;
    }

    public String sqlGetVersion(String key) {
        return "SELECT max(intval) AS version FROM config WHERE key='" + key + "'";
    }

    public String sqlGetOldVersion() {
        return "SELECT max(version) AS version FROM cms_config";
    }

    protected String sqlSetVersion(String key, int version) {
        return "INSERT INTO config (datetime,key,intval) VALUES (now(),'" + key + "'," + version + ")";
    }

    public boolean hasConfig(String key) {
        String config = this.getConfig(key);
        return config != null && !"".equals(config);
    }

    public String getConfig(String key) {
        DataRecord row = this.executeQuery(this.sqlGetConfig(key), false).firstRow();
        if (row != null) {
            return row.getString("val");
        }
        return null;
    }

    public Properties getConfig() {
        Properties props = new Properties();
        List<DataRecord> recs = this.executeQuery(this.sqlGetConfig(), false).getResult();
        for (DataRecord rec : recs) {
            String val = rec.getString("stringval");
            if (val == null || "".equals(val)) {
                val = rec.getString("intval");
            }
            props.setProperty(rec.getString("key"), val);
        }
        return props;
    }

    public ArrayList<String> getConfigKeys() {
        ArrayList<String> result = new ArrayList<String>();
        List<DataRecord> recs = this.executeQuery(this.sqlGetConfigKeys(), false).getResult();
        for (DataRecord rec : recs) {
            result.add(rec.get("key"));
        }
        return result;
    }

    public void setConfig(String key, String val) {
        this.executeUpdate(this.sqlDelConfig(key), true);
        this.executeUpdate(this.sqlSetConfig(key, val), true);
    }

    public void removeConfig(String key) {
        this.executeUpdate(this.sqlDelConfig(key), true);
    }

    public String sqlGetConfig(String key) {
        return "SELECT stringval AS val FROM config WHERE key='" + key + "' ORDER BY datetime DESC";
    }

    public String sqlGetConfigKeys() {
        return "SELECT DISTINCT key FROM config";
    }

    public String sqlGetConfig() {
        return "SELECT key,intval,stringval FROM config ORDER BY datetime ASC";
    }

    protected String sqlSetConfig(String key, String val) {
        return "INSERT INTO config (datetime,key,stringval) VALUES (now()," + Util.toSqlString((String)key) + "," + Util.toSqlString((String)val) + ")";
    }

    protected String sqlDelConfig(String key) {
        return "DELETE FROM config WHERE key = " + Util.toSqlString((String)key);
    }

    public int getElementtypeCount(String elementtype) {
        DataRecord rec = this.executeQuery(this.sqlGetElementtypeCount(elementtype, null, null), true).firstRow();
        if (rec != null) {
            return rec.getInt("count");
        }
        return 0;
    }

    public int getElementtypeCount(String elementtype, String tbl, String cond) {
        DataRecord rec = this.executeQuery(this.sqlGetElementtypeCount(elementtype, tbl, cond), true).firstRow();
        if (rec != null) {
            return rec.getInt("count");
        }
        return 0;
    }

    protected String sqlGetElementtypeCount(String elementtype, String tbl, String cond) {
        if (tbl != null && cond != null) {
            return "SELECT count(*) AS count FROM tdtaElement WHERE elementtype = " + Util.toSqlString((String)elementtype) + " AND NOT deleted  AND idelement IN (SELECT idelement FROM " + tbl + " WHERE " + cond + ")";
        }
        if (cond != null) {
            return "SELECT count(*) AS count FROM tdtaElement WHERE elementtype = " + Util.toSqlString((String)elementtype) + " AND NOT deleted";
        }
        return "SELECT count(*) AS count FROM tdtaElement WHERE elementtype = " + Util.toSqlString((String)elementtype) + " AND NOT deleted";
    }

    public long createId(String sequence) {
        SearchResult result = this.executeQuery(this.sqlSequenceNextval(sequence), false);
        if (result == null || result.isEmpty()) {
            this.executeUpdate(this.sqlSequenceCreate(sequence), false);
            result = this.executeQuery(this.sqlSequenceNextval(sequence), false);
        }
        if (result == null || result.isEmpty()) {
            this.getApplication().getLogger().log(Level.SEVERE, "Cannot access or create sequence " + sequence.toUpperCase());
        } else {
            DataRecord row = result.firstRow();
            if (row != null) {
                this.getApplication().getLogger().log(Level.FINE, "New ID created for '" + sequence + "': " + row.getLong("nextval"));
                return row.getLong("nextval");
            }
            this.getApplication().getLogger().log(Level.SEVERE, "Cannot retrieve sequence value for " + sequence.toUpperCase());
        }
        return -1L;
    }

    @Deprecated
    public long updateSequence(String sequence, long val) {
        SearchResult result = this.executeQuery(this.sqlSequenceSetval(sequence, val), false);
        if (result == null || result.isEmpty()) {
            return -1L;
        }
        return result.firstRow().getLong("setval");
    }

    public long setSequenceValue(String sequence, long val) {
        long id = this.updateSequence(sequence, val);
        if (id > 0L) {
            return id;
        }
        this.executeUpdate(this.sqlSequenceCreate(sequence), false);
        SearchResult result = this.executeQuery(this.sqlSequenceSetval(sequence, val), false);
        if (result == null || result.isEmpty()) {
            this.getApplication().getLogger().log(Level.SEVERE, "Cannot access or create sequence " + sequence.toUpperCase());
        } else {
            DataRecord row = result.firstRow();
            if (row != null) {
                this.getApplication().getLogger().log(Level.FINE, "New ID created for '" + sequence + "': " + row.getLong("setval"));
                return row.getLong("setval");
            }
            this.getApplication().getLogger().log(Level.SEVERE, "Cannot retrieve sequence value for " + sequence.toUpperCase());
        }
        return -1L;
    }

    public String sqlSequenceNextval(String sequence) {
        return "SELECT nextval('" + sequence + "') AS nextval";
    }

    public String sqlSequenceSetval(String sequence, long val) {
        return "SELECT setval('" + sequence + "'," + val + ") AS setval";
    }

    public String sqlSequenceCreate(String sequence) {
        return "CREATE SEQUENCE " + sequence;
    }

    public ArrayList<String> getTableNames() {
        ArrayList<String> tables = new ArrayList<String>();
        List<DataRecord> recs = this.executeQuery("select table_name from INFORMATION_SCHEMA.TABLES WHERE table_schema='PUBLIC'", true).getResult();
        for (DataRecord rec : recs) {
            tables.add(rec.getString("table_name").toLowerCase());
        }
        return tables;
    }

    public boolean hasTable(String tbl) {
        return this.getTableFieldnames(tbl.toUpperCase()) != null;
    }

    public ArrayList<String> getTableFieldnames(String tbl) {
        String sql = this.sqlSelectAllLimitOne(tbl);
        ArrayList<String> result = null;
        try {
            Connection conn = this.getConnection();
            try {
                Statement stmt = conn.createStatement(1004, 1007);
                stmt.setMaxRows(1);
                ResultSet rs = stmt.executeQuery(sql);
                int count = rs.getMetaData().getColumnCount();
                result = new ArrayList<String>();
                for (int ii = 0; ii < count; ++ii) {
                    result.add(rs.getMetaData().getColumnName(ii + 1).toUpperCase());
                }
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.freeConnection(conn);
        }
        catch (SQLException ex) {
            this.getApplication().getLogger().log(Level.SEVERE, "SQL connection error", ex);
        }
        return result;
    }

    public boolean hasTableField(String tbl, String fld) {
        ArrayList<String> fields = this.getTableFieldnames(tbl);
        return fields != null && fields.contains(fld.toUpperCase());
    }

    public String sqlSelectAllLimitOne(String tablename) {
        return "SELECT * FROM " + tablename + " LIMIT 1";
    }

    public int checkLanguage(String lang) {
        boolean ok = false;
        int result = -1;
        String sql1 = this.sqlLanguageSelectId(lang);
        String sql2 = this.sqlLanguageMaxSort();
        try {
            Connection conn = this.getConnection();
            try {
                Statement stmt = conn.createStatement(1004, 1007);
                ResultSet rs = stmt.executeQuery(sql1);
                if (rs.next()) {
                    ok = true;
                } else {
                    rs = stmt.executeQuery(sql2);
                    if (rs.next()) {
                        result = rs.getInt(1) + 1;
                    }
                }
                stmt.close();
            }
            catch (SQLException ex) {
                this.getApplication().getLogger().log(Level.SEVERE, "SQL error using: " + sql1, ex);
            }
            this.freeConnection(conn);
        }
        catch (SQLException ex) {
            this.getApplication().getLogger().log(Level.SEVERE, "SQL connection error", ex);
        }
        return result;
    }

    public String sqlLanguageSelectId(String lang) {
        return "SELECT idLanguage FROM tkeyLanguage WHERE lang = '" + lang + "'";
    }

    public String sqlLanguageMaxSort() {
        return "SELECT max(languagesort) FROM tkeyLanguage";
    }

    public abstract boolean checkAndCreateDatabase(Properties var1) throws SQLException;

    protected boolean createDatabase(String uri, String dbname, String template, Properties p) {
        String sql = this.sqlCreateDatabase(dbname, p.getProperty("user"), template);
        try {
            Connection c = DriverManager.getConnection(uri, p);
            try {
                if (template != null) {
                    sql = sql + " TEMPLATE=" + template;
                }
                c.createStatement(1004, 1007).execute(sql);
                this.getApplication().getLogger().log(Level.INFO, "Database '" + dbname + "' created");
                return true;
            }
            catch (SQLException ex) {
                this.getApplication().getLogger().log(Level.SEVERE, "Cannot create database using SQL: '" + sql + "', terminating", ex);
                throw new Error("Application error, unable to continue");
            }
        }
        catch (SQLException ex) {
            this.getApplication().getLogger().log(Level.WARNING, "No template '" + template + "' on server using URI '" + uri + "'");
            return false;
        }
    }

    protected String sqlCreateDatabase(String dbName, String dbOwner, String template) {
        return "CREATE DATABASE " + dbName + " ENCODING='utf8' OWNER=" + dbOwner;
    }

    public boolean createLanguage(String lang, int nextsort) {
        ArrayList<String> sql = new ArrayList<String>();
        sql.add(this.sqlLangaugeAdd(lang, nextsort));
        sql.add(this.sqlLangaugeAddLng(lang));
        return this.executeUpdate(sql, true) > 0;
    }

    public String sqlLangaugeAdd(String lang, int nextsort) {
        return "INSERT INTO tkeyLanguage (idlanguage,lang,languagesort) VALUES ('" + lang + "','" + lang + "'," + nextsort + ")";
    }

    public String sqlLangaugeAddLng(String lang) {
        return "INSERT INTO tkeyLanguagelng (idlanguage,lang,languageterm) VALUES ('" + lang + "','" + lang + "','" + lang + "')";
    }

    public void createDatabaseBaseTables() {
        ArrayList<String> sqls = this.sqlDatabaseBaseTablesCreate();
        for (String sql : sqls) {
            this.executeUpdate(sql, true);
        }
        this.getApplication().getLogger().log(Level.INFO, "Core database tables created");
    }

    public ArrayList<String> sqlDatabaseBaseTablesCreate() {
        ArrayList<String> result = new ArrayList<String>();
        if (!this.hasTable("tkeylanguage")) {
            result.add("CREATE TABLE tkeyLanguage (  idLanguage       CHAR(2) NOT NULL,  lang             CHAR(2),  languageSort     INTEGER,PRIMARY KEY (idLanguage))");
        }
        if (!this.hasTable("tkeyLanguageLng")) {
            result.add("CREATE TABLE tkeyLanguageLng (  idLanguage       CHAR(2) NOT NULL REFERENCES tkeyLanguage(idLanguage) ON UPDATE CASCADE ON DELETE CASCADE,  lang             CHAR(2) NOT NULL REFERENCES tkeyLanguage(idLanguage) ON UPDATE CASCADE ON DELETE CASCADE,  languageTerm     VARCHAR(100) NOT NULL,PRIMARY KEY (idLanguage, lang))");
        }
        if (!this.hasTable("config")) {
            result.add("CREATE TABLE config (datetime TIMESTAMP, key VARCHAR(100), intval INTEGER, stringval TEXT, PRIMARY KEY(datetime,key));");
            if (this.hasTable("cms_config")) {
                result.add("INSERT INTO config (datetime,key,intval) SELECT now(),'ontologyversion',max(version) FROM cms_config");
            } else if (!this.hasTable("tdtaelement")) {
                result.add("INSERT INTO config (datetime,key,intval) VALUES (now(),'ontologyversion'," + this.getRequiredDatabaseVersion() + ")");
                result.add("INSERT INTO config (datetime,key,intval) VALUES (now(),'themisupdate'," + this.app.getApplicationVersion() + ")");
                result.add("INSERT INTO config (datetime,key,intval) VALUES (now(),'themis'," + this.app.getAppliationDatabaseVersion() + ")");
            }
        }
        if (!this.hasTable("tdtasystemlog")) {
            result.add("CREATE TABLE tdtasystemlog (idsystemlog BIGINT, logdate TIMESTAMP, type VARCHAR(100), sourceclass VARCHAR(250), sourcemethod VARCHAR(250), message TEXT, stack TEXT,PRIMARY KEY (idsystemlog))");
            result.add("CREATE SEQUENCE idsystemlog");
        }
        if (!this.hasTable("tdtaElementHistory")) {
            result.add("CREATE TABLE tdtaElementHistory (idelement BIGINT, savedate TIMESTAMP, data BINARY)");
        }
        return result;
    }

    public boolean migrateDatabaseV38() {
        ArrayList<String> elementFields = this.getTableFieldnames("tdtaelement");
        if (elementFields == null) {
            return false;
        }
        if (elementFields.contains("IDELEMENTTYPE") && !elementFields.contains("ELEMENTTYPE")) {
            this.getApplication().getLogger().info("Updating v38 database version ...");
            this.executeUpdate("ALTER TABLE tdtaElementLng RENAME abstract TO summary", true);
            this.executeUpdate("ALTER TABLE tdtaElement ADD elementtype VARCHAR(100)", true);
            this.executeUpdate("UPDATE tdtaElement SET elementtype = tkeyElementtype.elementtypecode FROM tkeyElementtype WHERE tkeyElementtype.idElementtype = tdtaElement.idElementtype", true);
            this.executeUpdate("ALTER TABLE tdtaElement DROP idElementtype", true);
            this.executeUpdate("ALTER TABLE tdtaElement ADD idworkflowstatus BIGINT", true);
            this.executeUpdate("UPDATE tdtaElement SET idworkflowstatus = tdtaElementLng.idstatus FROM tdtaElementLng WHERE tdtaElementLng.idElement=tdtaElement.idElement", true);
            this.executeUpdate("ALTER TABLE tdtaElementLng DROP idstatus", true);
            this.executeUpdate("ALTER TABLE tdtaRelation ADD relationcode VARCHAR(100)", true);
            this.executeUpdate("ALTER TABLE tdtaRelation ADD orderfrom INT", true);
            this.executeUpdate("ALTER TABLE tdtaRelation ADD orderto INT", true);
            this.executeUpdate("UPDATE tdtaRelation  SET relationcode = tkeyRelationtype.relationtypeterm FROM tkeyRelationtype WHERE tkeyRelationtype.idRelationtype = tdtaRelation.idRelationtype", true);
            this.executeUpdate("ALTER TABLE tdtaUser ADD loginip VARCHAR(50)", true);
            this.executeUpdate("ALTER TABLE tdtaelement ALTER COLUMN metaowner DROP NOT NULL", true);
            this.executeUpdate("ALTER TABLE tdtaelement ALTER COLUMN metacreator DROP NOT NULL", true);
            this.executeUpdate("ALTER TABLE tdtaelementlng ALTER COLUMN metatranslator DROP NOT NULL", true);
            this.executeUpdate("ALTER TABLE tdtaRelation DROP idrelationtype CASCADE ", true);
            this.executeUpdate("ALTER TABLE tdtaRelation DROP idrelation CASCADE ", true);
            this.executeUpdate("ALTER TABLE tdtaelement DROP CONSTRAINT \"$1\";", true);
            this.executeUpdate("ALTER TABLE tdtaelement ALTER metaowner DROP not null;", true);
            this.executeUpdate("ALTER TABLE tdtaelement ALTER metacreator DROP not null;", true);
            this.executeUpdate("CREATE TABLE cms_config (version INTEGER, datetime TIMESTAMP, PRIMARY KEY(version));", true);
            this.executeUpdate("INSERT INTO cms_config (version,datetime) VALUES (6,now())", true);
            this.executeUpdate("DROP TABLE tkeyRelationtypeSpec CASCADE ", true);
            this.executeUpdate("DROP TABLE tdtarelationatt CASCADE ", true);
            this.executeUpdate("DROP TABLE tdtaAttributeRelLng CASCADE ", true);
            this.executeUpdate("DROP TABLE tdtaAttributeRel CASCADE ", true);
            this.executeUpdate("ALTER TABLE tdtaRelation DROP confirm ", true);
            this.executeUpdate("ALTER TABLE tdtaRelation DROP confirminverse ", true);
            this.executeUpdate("DROP TABLE tdtaattributeLng CASCADE", true);
            this.executeUpdate("DROP TABLE tdtaattribute CASCADE", true);
            this.executeUpdate("DROP TABLE tdtaattributesubLng CASCADE", true);
            this.executeUpdate("DROP TABLE tdtaattributesub CASCADE ", true);
            this.executeUpdate("DROP TABLE tkeyoccurence CASCADE ", true);
            this.executeUpdate("DROP TABLE tkeyrelationtype CASCADE ", true);
            this.executeUpdate("DROP TABLE tkeyattributetype CASCADE ", true);
            this.executeUpdate("DROP TABLE tkeyelementtype CASCADE ", true);
            this.executeUpdate("DROP TABLE tkeyelementtypeLng CASCADE ", true);
            if (this.hasTable("tdtasuberdaslicense")) {
                this.migrateSubelement("suberdaslicense", "erdaslicense", "erdaslicense");
            }
            if (this.hasTable("tdtasubaddress")) {
                this.migrateSubelement("subaddress", "address", "address");
            }
            if (this.hasTable("tdtasubcontact")) {
                this.migrateSubelement("subcontact", "contactdetails", "contactdetails");
            }
            if (this.hasTable("tdtasubprojecttask")) {
                this.migrateSubelement("subprojecttask", "projecttask", "projecttask");
            }
            if (this.hasTable("tdtasubofferte")) {
                this.migrateSubelement("subofferte", "teilofferte", "teilofferte");
            }
            return true;
        }
        return false;
    }

    public void migrateSubelement(String origTableCode, String newTableCode, String relationcode) {
        this.getApplication().getLogger().info("Migrating former subelement '" + origTableCode + "' ...");
        this.executeUpdate("CREATE TABLE tdtaEle" + newTableCode + " AS SELECT nextval('idelement') AS idelementneu,* FROM tdta" + origTableCode, true);
        this.executeUpdate("ALTER TABLE tdtaEle" + newTableCode + " RENAME idelement TO idelementalt", true);
        this.executeUpdate("ALTER TABLE tdtaEle" + newTableCode + " RENAME idelementneu TO idelement", true);
        this.executeUpdate("ALTER TABLE tdtaEle" + newTableCode + " ADD PRIMARY KEY(idElement)", true);
        this.executeUpdate("CREATE TABLE tdtaEle" + newTableCode + "Lng AS SELECT * FROM tdta" + origTableCode + "Lng", true);
        this.executeUpdate("UPDATE tdtaEle" + newTableCode + "Lng SET idelement = tdtaEle" + newTableCode + ".idElement FROM tdtaEle" + newTableCode + " WHERE tdtaEle" + newTableCode + ".id" + origTableCode + "=tdtaEle" + newTableCode + "Lng.id" + origTableCode + "", true);
        this.executeUpdate("ALTER TABLE tdtaEle" + newTableCode + "Lng ADD PRIMARY KEY(idElement,lang)", true);
        this.executeUpdate("DROP TABLE tdta" + origTableCode + "Lng", true);
        this.executeUpdate("DROP TABLE tdta" + origTableCode, true);
        this.executeUpdate("INSERT INTO tdtaElement(idelement,metamasterlang,metaowner,metacreator,metanews,idreadaccess,idwriteaccess,sort,deleted,mainid,currentview,currentedit,elementtype,idworkflowstatus) SELECT o.idelement,'de',e.metaowner,e.metacreator,'f',e.idreadaccess,e.idwriteaccess,1,e.deleted,o.idelement,'t','t','" + newTableCode + "',e.idworkflowstatus FROM tdtaEle" + newTableCode + " AS o INNER JOIN tdtaElement AS e ON (o.idelementalt=e.idelement) ", true);
        this.executeUpdate("INSERT INTO tdtaElementLng(idelement,lang,title,summary,metatranslator,metacreated,metalastedit) SELECT o.idelement,'de','(neu)','',2,now(),now() FROM tdtaEle" + newTableCode + " AS o ", true);
        this.executeUpdate("INSERT INTO tdtaRelation (elementfrom,elementto,relationcode) SELECT idElementAlt,idElement,'" + relationcode + "' FROM tdtaEle" + newTableCode, true);
    }

    public void updateDatabaseTables() {
        int version;
        boolean updated = false;
        this.dbversionBeforeUpdate = version = this.getDatabaseVersion();
        int checkversion = version + 1;
        ArrayList<String> sqls = this.sqlDatabaseUpdate(checkversion, true);
        while (sqls != null) {
            this.getApplication().getLogger().log(Level.INFO, "Updating databsae to version " + checkversion + " using the following SQL's");
            for (String sql : sqls) {
                this.getApplication().getLogger().log(Level.INFO, "- " + sql);
            }
            if (sqls.isEmpty() || this.executeUpdate(sqls, true) >= 0) {
                if (sqls.isEmpty()) {
                    this.getApplication().getLogger().log(Level.INFO, "No specific SQL's to be executed");
                }
                this.executeUpdate(this.sqlSetVersion("ontologyversion", checkversion), true);
                this.getApplication().getLogger().log(Level.INFO, "Database updated to version " + checkversion);
                updated = true;
            } else {
                this.getApplication().getLogger().log(Level.WARNING, "Error while updating database to version " + checkversion);
            }
            sqls = this.sqlDatabaseUpdate(++checkversion, true);
        }
        if (!updated) {
            this.getApplication().getLogger().log(Level.INFO, "System database is up to date");
        }
    }

    public void updateDatabaseTablesAfterInit() {
        boolean updated = false;
        ArrayList<String> sqls = this.sqlDatabaseUpdateAfterInit();
        if (sqls != null) {
            this.getApplication().getLogger().log(Level.INFO, "Updating databsae after initialisation from initial version " + this.dbversionBeforeUpdate + " using the following SQL's");
            for (String sql : sqls) {
                this.getApplication().getLogger().log(Level.INFO, "- " + sql);
            }
            if (sqls.isEmpty() || this.executeUpdate(sqls, true) >= 0) {
                if (sqls.isEmpty()) {
                    this.getApplication().getLogger().log(Level.INFO, "No specific SQL's to be executed");
                }
                this.getApplication().getLogger().log(Level.INFO, "Database updated");
                updated = true;
            } else {
                this.getApplication().getLogger().log(Level.WARNING, "Error while updating database ");
            }
        }
        if (!updated) {
            this.getApplication().getLogger().log(Level.INFO, "No updates after initialisation required");
        }
    }

    public ArrayList<String> sqlDatabaseUpdate(int version, boolean execute) {
        ArrayList<String> sqls = new ArrayList<String>();
        switch (version) {
            case 1: {
                sqls.add("ALTER TABLE tdtaelement ADD trash BOOLEAN");
                sqls.add("UPDATE tdtaelement SET trash = 'f'");
                break;
            }
            case 2: {
                sqls.add("ALTER TABLE tdtaelementlng ADD lasteditby BIGINT");
                break;
            }
            case 3: {
                sqls.add("UPDATE tdtaelement SET idworkflowstatus = 4");
                break;
            }
            case 4: {
                sqls.add("ALTER TABLE tdtauser ADD loginip VARCHAR(250)");
                break;
            }
            case 5: {
                sqls.add("ALTER TABLE tdtafileupload ADD code VARCHAR(100)");
                break;
            }
            case 6: {
                sqls.add("ALTER TABLE tdtaelement RENAME trash TO deleted");
                sqls.add("ALTER TABLE tdtauser RENAME pwd TO password");
                sqls.add("ALTER TABLE tdtauser RENAME active TO inactive");
                sqls.add("UPDATE tdtauser SET inactive = NOT inactive");
                sqls.add("ALTER TABLE tdtaelement RENAME iduser TO metacreator");
                sqls.add("ALTER TABLE tdtaelement RENAME idgroup TO metaowner");
                sqls.add("ALTER TABLE tdtaelement RENAME masterlang TO metamasterlang");
                sqls.add("ALTER TABLE tdtaelementlng RENAME lastedit TO metalastedit");
                sqls.add("ALTER TABLE tdtaelementlng RENAME lasteditby TO metatranslator");
                sqls.add("ALTER TABLE tdtaelementlng RENAME created TO metacreated");
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                sqls.add("UPDATE tdtaGroup SET idelement = nextval('idelement')");
                sqls.add("UPDATE tdtaUser SET idelement = nextval('idelement')");
                break;
            }
            case 9: {
                SearchResult userSearch = this.executeQuery("SELECT idelement FROM tdtaGroup", false);
                long idgroup = -1L;
                if (userSearch != null && userSearch.size() > 0) {
                    idgroup = userSearch.getResult().get(0).getLong("idelement");
                }
                userSearch = this.executeQuery("SELECT iduser,idelement FROM tdtaUser WHERE superadmin", false);
                long idadmin = -1L;
                if (userSearch != null && userSearch.size() > 0) {
                    idadmin = userSearch.getResult().get(0).getLong("iduser");
                }
                sqls.add("UPDATE tdtaGroup SET idgroup = idelement");
                sqls.add("ALTER TABLE tdtaGroup DROP idelement");
                sqls.add(this.sqlRenameColumn("tdtaGroup", "idgroup", "idelement"));
                sqls.add("INSERT INTO tdtaElement (idelement,elementtype,idworkflowstatus,metaowner,metacreator,idreadaccess,idwriteaccess,deleted,metamasterlang) SELECT idelement,'group',4," + idgroup + "," + idadmin + ",3,4,'f','" + this.app.getPrimaryLang() + "' FROM tdtaGroup");
                sqls.add("INSERT INTO tdtaElementLng (idelement,lang,title,summary,metacreated,metalastedit,metatranslator)  SELECT idelement,'" + this.app.getPrimaryLang() + "',groupname,description,now(),now()," + idadmin + " FROM tdtaGroup");
                sqls.add("INSERT INTO tdtaGroupLng SELECT idelement,'" + this.app.getPrimaryLang() + "' FROM tdtaGroup");
                userSearch = this.executeQuery("SELECT idelement FROM tdtaUser WHERE iduser=" + idadmin, false);
                idadmin = -1L;
                if (userSearch != null && userSearch.size() > 0) {
                    idadmin = userSearch.getResult().get(0).getLong("idelement");
                }
                sqls.add("UPDATE tdtaUser SET iduser = idelement");
                sqls.add("ALTER TABLE tdtaUser DROP idelement");
                sqls.add(this.sqlRenameColumn("tdtaUser", "iduser", "idelement"));
                sqls.add("INSERT INTO tdtaElement (idelement,elementtype,idworkflowstatus,metaowner,metacreator,idreadaccess,idwriteaccess,deleted,metamasterlang) SELECT idelement,'user',4," + idgroup + "," + idadmin + ",3,4,'f','" + this.app.getPrimaryLang() + "' FROM tdtaUser");
                sqls.add("INSERT INTO tdtaElementLng (idelement,lang,title,summary,metacreated,metalastedit,metatranslator)  SELECT idelement,'" + this.app.getPrimaryLang() + "',username,fullname,now(),now()," + idadmin + " FROM tdtaUser");
                sqls.add("INSERT INTO tdtaUserLng SELECT idelement,'" + this.app.getPrimaryLang() + "' FROM tdtaUser");
                sqls.add("INSERT INTO tdtaRelation (elementfrom,elementto,relationcode) SELECT iduser,idgroup,'groupguest' FROM trelusergroup WHERE idrole=1");
                sqls.add("INSERT INTO tdtaRelation (elementfrom,elementto,relationcode) SELECT iduser,idgroup,'groupauthor' FROM trelusergroup WHERE idrole=2");
                sqls.add("INSERT INTO tdtaRelation (elementfrom,elementto,relationcode) SELECT iduser,idgroup,'groupeditor' FROM trelusergroup WHERE idrole=3");
                sqls.add("INSERT INTO tdtaRelation (elementfrom,elementto,relationcode) SELECT iduser,idgroup,'groupadmin' FROM trelusergroup WHERE idrole=4");
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                sqls.add("ALTER TABLE tdtafileupload ADD comment TEXT ");
                break;
            }
            case 12: {
                sqls.add("ALTER TABLE tdtafileupload ADD fileinfo TEXT ");
                break;
            }
            case 13: {
                if (!execute) break;
                this.executeUpdate("ALTER TABLE tdtaelement ADD uuid VARCHAR(36) ", true);
                PreparedStatement stmt = null;
                String sql = "UPDATE tdtaelement SET uuid = ? WHERE idelement = ?";
                try {
                    stmt = this.getConnection().prepareStatement(sql);
                    List<DataRecord> recs = this.executeQuery("SELECT idelement FROM tdtaelement", true).getResult();
                    for (DataRecord rec : recs) {
                        UUID uuid = UUID.randomUUID();
                        stmt.setString(1, uuid.toString());
                        stmt.setLong(2, rec.getLong("idelement"));
                        stmt.executeUpdate();
                    }
                    break;
                }
                catch (SQLException ex) {
                    Logger.getLogger(DataStorage.class.getName()).log(Level.SEVERE, null, ex);
                    break;
                }
            }
            case 14: {
                sqls.add("ALTER TABLE tdtauser ADD idsprache INT ");
                break;
            }
            case 15: {
                sqls.add("ALTER TABLE tdtaElementHistory ADD data " + this.getByteArrayFieldType());
                break;
            }
            case 16: {
                if (!this.hasTable("tkeyuploaddetail") && execute) {
                    new Keytable(this.app, "uploaddetail");
                }
                sqls.add("ALTER TABLE tdtaFileUpload ADD iduploaddetail BIGINT ");
                break;
            }
            case 17: {
                break;
            }
            case 18: {
                if (!this.hasTable("tkeyuploaddetail") && execute) {
                    new Keytable(this.app, "uploaddetail");
                }
                if (this.hasTableField("tdtafileupload", "iduploaddetail")) break;
                sqls.add("ALTER TABLE tdtaFileUpload ADD iduploaddetail BIGINT ");
                break;
            }
            case 19: {
                sqls.add("ALTER TABLE tdtaFileUpload ADD deleted BOOLEAN");
                sqls.add("UPDATE tdtaFileUpload SET deleted = 'f'");
                break;
            }
            case 20: {
                ArrayList<String> tableNames = this.getTableNames();
                for (String tableName : tableNames) {
                    if (!tableName.toLowerCase().startsWith("tkey") || tableName.toLowerCase().endsWith("lng")) continue;
                    String code = tableName.toLowerCase().substring(4);
                    sqls.add("ALTER TABLE " + tableName + " ADD " + code + "color INT");
                }
                break;
            }
            case 21: {
                sqls.add("ALTER TABLE tdtafileupload ADD elementtype VARCHAR(100)");
                if (this.hasTableField("tdtaFileUpload", "deleted")) break;
                sqls.add("ALTER TABLE tdtaFileUpload ADD deleted BOOLEAN");
                sqls.add("UPDATE tdtaFileUpload SET deleted = 'f'");
                break;
            }
            default: {
                return null;
            }
        }
        return sqls;
    }

    public ArrayList<String> sqlDatabaseUpdateAfterInit() {
        ArrayList<String> sqls = new ArrayList<String>();
        if (this.dbversionBeforeUpdate < 17) {
            for (CmsElement e : this.getApplication().getDefaultElements()) {
                for (KeyAttribute att : e.getDataKeyAttributes()) {
                    String keycode = att.getTableCode();
                    sqls.add("ALTER TABLE " + e.getTablename() + " ADD FOREIGN KEY (" + att.getField() + ") REFERENCES tkey" + keycode + " (id" + keycode + ") ON UPDATE CASCADE");
                }
            }
        }
        if (sqls.isEmpty()) {
            return null;
        }
        return sqls;
    }

    public int getRequiredDatabaseVersion() {
        int version = 1;
        while (this.sqlDatabaseUpdate(version, false) != null) {
            ++version;
        }
        return version - 1;
    }

    protected String sqlRenameColumn(String table, String oldcol, String newcol) {
        return "ALTER TABLE " + table + " RENAME " + oldcol + " TO " + newcol;
    }

    public void renameColumn(String table, String oldcol, String newcol) {
        this.executeUpdate(this.sqlRenameColumn(table, oldcol, newcol), true);
    }

    public void createDatabaseElementTables(String[] elementtypes) {
        ArrayList<String> sqls = this.sqlDatabaseElementTablesCreate(elementtypes);
        sqls.addAll(this.getApplication().postCreateTablesSql());
        for (String sql : sqls) {
            this.executeUpdate(sql, true);
        }
    }

    public void createDatabaseElementTables(ArrayList<String> elementtypes) {
        this.createDatabaseElementTables(elementtypes.toArray(new String[0]));
    }

    protected ArrayList<String> sqlDatabaseElementTablesCreate(String[] elementtypes) {
        this.newtables.clear();
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<CmsElement> elements = new ArrayList<CmsElement>();
        for (String et : elementtypes) {
            CmsElement ele = this.getApplication().getDefaultElement(et);
            elements.add(ele);
            for (KeyAttribute att : ele.getKeyAttributes()) {
                att.getKeytable();
            }
        }
        for (Keytable tbl : this.getApplication().getKeytables().values()) {
            if (this.hasTable("tkey" + tbl.getCode())) continue;
            result.addAll(this.sqlKeytableCreate(tbl));
        }
        ArrayList<String> fields1 = this.getTableFieldnames("tdtaelement");
        ArrayList<String> fields2 = this.getTableFieldnames("tdtaelementlng");
        if (fields1 == null) {
            result.add("CREATE SEQUENCE idelement;");
        }
        StringBuilder sql1 = new StringBuilder();
        StringBuilder sql2 = new StringBuilder();
        if (fields1 == null) {
            sql1.append("CREATE TABLE tdtaelement (idelement BIGINT, uuid VARCHAR(36), ");
        }
        if (fields2 == null) {
            sql2.append("CREATE TABLE tdtaelementlng (idelement BIGINT REFERENCES tdtaelement (idelement) ON UPDATE CASCADE ON DELETE CASCADE, lang CHAR(2), ");
            sql2.append("title VARCHAR(250), summary ").append(this.getFieldType(13, 0)).append(", ");
        }
        if (elementtypes.length > 0) {
            for (CmsAttribute att : this.getApplication().getDefaultElement(elementtypes[0]).getMetaAttributes()) {
                if (att.isVirtual() || att.isOfType(14) && !((RelationAttribute)att).isSingle()) continue;
                if (att.isMultilingual()) {
                    if (fields2 == null) {
                        sql2.append(att.getField()).append(" ").append(this.getFieldType(att)).append(", ");
                        continue;
                    }
                    if (fields2.contains(att.getField().toUpperCase())) continue;
                    result.add("ALTER TABLE tdtaelementlng ADD " + att.getField() + " " + this.getFieldType(att));
                    continue;
                }
                if (fields1 == null) {
                    sql1.append(att.getField()).append(" ").append(this.getFieldType(att)).append(", ");
                    continue;
                }
                if (fields1.contains(att.getField().toUpperCase())) continue;
                result.add("ALTER TABLE tdtaelement ADD " + att.getField() + " " + this.getFieldType(att));
            }
        }
        if (fields1 == null) {
            sql1.append("PRIMARY KEY (idelement));");
            result.add(sql1.toString());
        }
        if (fields2 == null) {
            sql2.append("PRIMARY KEY (idelement,lang));");
            result.add(sql2.toString());
        }
        for (CmsElement element : elements) {
            result.addAll(this.sqlElementCreateTables(element));
        }
        if (!this.hasTable("tdtaelementlock")) {
            result.add("CREATE TABLE tdtaelementlock (idelement  bigint   REFERENCES tdtaelement(idelement) ON UPDATE CASCADE ON DELETE CASCADE, iduser     bigint   REFERENCES tdtauser(idelement) ON UPDATE CASCADE ON DELETE CASCADE,locktime   TIMESTAMP,PRIMARY KEY (idelement,iduser))");
        }
        return result;
    }

    protected ArrayList<String> sqlElementCreateTables(CmsElement ele) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder sql3 = new StringBuilder();
        StringBuilder sql4 = new StringBuilder();
        ArrayList<String> fields3 = this.getTableFieldnames(ele.getTablename());
        ArrayList<String> fields4 = this.getTableFieldnames(ele.getTablename() + "lng");
        if (fields3 == null) {
            sql3.append("CREATE TABLE ").append(ele.getTablename()).append(" (idelement BIGINT REFERENCES tdtaelement (idelement) ON UPDATE CASCADE ON DELETE CASCADE, ");
        } else if (!fields3.contains("IDELEMENT")) {
            result.add("ALTER TABLE " + ele.getTablename() + " ADD idelement BIGINT");
        }
        if (fields4 == null) {
            sql4.append("CREATE TABLE ").append(ele.getTablename()).append("lng (idelement BIGINT, lang CHAR(2), ");
        } else {
            if (!fields4.contains("IDELEMENT")) {
                result.add("ALTER TABLE " + ele.getTablename() + "lng ADD idelement BIGINT");
            }
            if (!fields4.contains("LANG")) {
                result.add("ALTER TABLE " + ele.getTablename() + "lng ADD lang CHAR(2)");
            }
        }
        for (CmsAttribute att : ele.getDataAttributes()) {
            String tbl;
            String dbref = att.getDbreference();
            dbref = dbref != null ? " REFERENCES " + dbref + " ON UPDATE CASCADE ON DELETE SET NULL " : "";
            if (att.isVirtual() || att.isGeoAttribute()) continue;
            if (att.isOfType(10)) {
                tbl = ((MultikeyAttribute)att).getTableName();
                if (this.hasTable("tkey" + tbl + "rel") || this.newtables.contains("tkey" + tbl + "rel")) continue;
                result.add("CREATE TABLE tkey" + tbl + "rel (idelement BIGINT REFERENCES tdtaelement (idelement) ON UPDATE CASCADE ON DELETE CASCADE, id" + tbl + " BIGINT REFERENCES tkey" + tbl + " ON UPDATE CASCADE ON DELETE CASCADE, PRIMARY KEY (idelement,id" + tbl + "));");
                this.newtables.add("tkey" + tbl + "rel");
                continue;
            }
            if (att.isOfType(14) && !((RelationAttribute)att).isSingle()) {
                tbl = ((RelationAttribute)att).getTableName();
                if (this.hasTable(tbl) || this.newtables.contains(tbl)) continue;
                result.add("CREATE TABLE " + tbl + " (elementfrom BIGINT REFERENCES tdtaelement (idelement) ON UPDATE CASCADE ON DELETE CASCADE, elementto BIGINT REFERENCES tdtaelement (idelement) ON UPDATE CASCADE ON DELETE CASCADE, relationcode VARCHAR(100), orderfrom INT,orderto INT,PRIMARY KEY (elementfrom,elementto,relationcode));");
                this.newtables.add(tbl);
                continue;
            }
            if (att.isOfType(15) || att.isOfType(16)) {
                if (this.hasTable("tdtafileupload") || this.newtables.contains("tdtafileupload")) continue;
                String s = "CREATE TABLE tdtafileupload (idfileupload BIGINT, idelement BIGINT REFERENCES tdtaelement (idelement) ON UPDATE CASCADE ON DELETE CASCADE, iduploaddetail BIGINT REFERENCES tkeyUploadDetail (iduploaddetail) ON UPDATE CASCADE ON DELETE CASCADE, name VARCHAR(250), filesize INT, uploaddate TIMESTAMP, contenttype VARCHAR(100), path " + this.getFieldType(13, 0) + ", urlbase VARCHAR(100), code VARCHAR(100), elementtype VARCHAR(100), title TEXT, deleted BOOLEAN, comment TEXT, fileinfo TEXT, PRIMARY KEY (idfileupload));";
                if (!result.contains(s)) {
                    result.add(s);
                }
                if (!result.contains(s = "CREATE SEQUENCE idfileupload")) {
                    result.add(s);
                }
                this.newtables.add("tdtafileupload");
                continue;
            }
            if (att.isOfType(8)) {
                String keycode = ((KeyAttribute)att).getTableCode();
                if (fields3 == null) {
                    sql3.append(att.getField()).append(" ").append(this.getFieldType(att)).append(" REFERENCES tkey").append(keycode).append(" ON UPDATE CASCADE, ");
                    continue;
                }
                if (fields3.contains(att.getField().toUpperCase())) continue;
                result.add("ALTER TABLE " + ele.getTablename() + " ADD " + att.getField() + " " + this.getFieldType(att));
                result.add("ALTER TABLE " + ele.getTablename() + " ADD FOREIGN KEY (" + att.getField() + ") REFERENCES tkey" + keycode + " (id" + keycode + ") ON UPDATE CASCADE");
                continue;
            }
            if (att.isMultilingual()) {
                if (fields4 == null) {
                    sql4.append(att.getField()).append(" ").append(this.getFieldType(att)).append(dbref).append(", ");
                    continue;
                }
                if (fields4.contains(att.getField().toUpperCase())) continue;
                result.add("ALTER TABLE " + ele.getTablename() + "lng ADD " + att.getField() + " " + this.getFieldType(att));
                if (!att.hasDbreference()) continue;
                result.add("ALTER TABLE " + ele.getTablename() + "lng ADD FOREIGN KEY (" + att.getField() + ")  " + dbref);
                continue;
            }
            if (fields3 == null) {
                sql3.append(att.getField()).append(" ").append(this.getFieldType(att)).append(dbref).append(", ");
                continue;
            }
            if (fields3.contains(att.getField().toUpperCase())) continue;
            result.add("ALTER TABLE " + ele.getTablename() + " ADD " + att.getField() + " " + this.getFieldType(att));
            if (!att.hasDbreference()) continue;
            result.add("ALTER TABLE " + ele.getTablename() + " ADD FOREIGN KEY (" + att.getField() + ")  " + dbref);
        }
        if (fields3 == null) {
            sql3.append("PRIMARY KEY (idelement))");
        }
        if (fields4 == null) {
            sql4.append("FOREIGN KEY (idelement,lang) REFERENCES tdtaelementlng (idelement,lang) ON DELETE CASCADE ON UPDATE CASCADE,");
            sql4.append("PRIMARY KEY (idelement,lang));");
        }
        if (fields3 == null) {
            result.add(sql3.toString());
        }
        if (fields4 == null) {
            result.add(sql4.toString());
        }
        for (CmsAttribute att : ele.getDataAttributes()) {
            if (!att.isGeometry()) continue;
            result.add("SELECT AddGeometryColumn('" + ele.getTablename() + "', '" + att.getCode() + "', " + this.getApplication().getSRS() + ", '" + this.getFieldType(att) + "', 2);");
        }
        return result;
    }

    public SearchResult getKeytable(String keycode) {
        return this.executeQuery(this.sqlKeytable(keycode), true);
    }

    public String sqlKeytable(String keycode) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT * FROM tkey").append(keycode).append(" AS k INNER JOIN tkey").append(keycode).append("lng AS kl ");
        sql.append("ON (k.id").append(keycode).append(" = kl.id").append(keycode).append(") ORDER BY ").append(keycode).append("sort");
        return sql.toString();
    }

    public void createKeytable(Keytable tbl) {
        this.executeUpdate(this.sqlKeytableCreate(tbl), true);
    }

    public ArrayList<String> sqlKeytableCreate(Keytable tbl) {
        ArrayList<String> result = new ArrayList<String>();
        if (!this.hasTable("tdtaKeytableNames")) {
            result.add("CREATE TABLE tdtaKeytableNames (  code VARCHAR(250),   lang CHAR(2) REFERENCES tkeylanguage(idlanguage) ON DELETE CASCADE ON UPDATE CASCADE,   term VARCHAR(250), PRIMARY KEY (code,lang));");
        }
        if (!this.hasTable("tkey" + tbl.getCode())) {
            result.add("CREATE TABLE tkey" + tbl.getCode() + " (  id" + tbl.getCode() + " BIGINT, " + tbl.getCode() + "sort INTEGER, " + tbl.getCode() + "color INTEGER, PRIMARY KEY (id" + tbl.getCode() + "));");
            result.add("CREATE TABLE tkey" + tbl.getCode() + "lng (  id" + tbl.getCode() + " BIGINT REFERENCES tkey" + tbl.getCode() + "(id" + tbl.getCode() + ") ON DELETE CASCADE ON UPDATE CASCADE,  lang CHAR(2) REFERENCES tkeylanguage(idlanguage) ON DELETE CASCADE ON UPDATE CASCADE, " + tbl.getCode() + "term VARCHAR(250), PRIMARY KEY (id" + tbl.getCode() + ",lang));");
        }
        return result;
    }

    public void populateKeytable(Keytable tbl) {
        if (tbl.size() > 0) {
            this.executeUpdate(this.sqlKeytablePopulatePrepare(tbl.getCode(), tbl.getIdsAsSql()), true);
            for (String lang : tbl.getTable().keySet()) {
                ArrayList<KeytableRecord> t = tbl.getTable().get(lang);
                int sort = 1;
                for (KeytableRecord rec : t) {
                    int count = this.executeUpdate(this.sqlKeytablePopulateUpdate(tbl.getCode(), sort, rec.color, rec.id), true);
                    ++sort;
                    if (count == 0) {
                        this.executeUpdate(this.sqlKeytablePopulateInsert(tbl.getCode(), sort, rec.color, rec.id), true);
                    }
                    this.executeUpdate(this.sqlKeytablePopulateInsertLng(tbl.getCode(), rec.id, lang, rec.term), true);
                }
            }
        }
    }

    public ArrayList<String> sqlKeytablePopulatePrepare(String keycode, String ids) {
        ArrayList<String> sqls = new ArrayList<String>();
        sqls.add("DELETE FROM tkey" + keycode + " WHERE id" + keycode + " NOT IN " + ids);
        sqls.add("DELETE FROM tkey" + keycode + "lng");
        return sqls;
    }

    public String sqlKeytablePopulateUpdate(String keycode, int sort, Integer color, long id) {
        return "UPDATE tkey" + keycode + " SET " + keycode + "sort=" + sort + "," + keycode + "color=" + (color == null ? "null" : color) + "  WHERE id" + keycode + " = " + id;
    }

    public String sqlKeytablePopulateInsert(String keycode, int sort, Integer color, long id) {
        return "INSERT INTO tkey" + keycode + " (id" + keycode + "," + keycode + "sort," + keycode + "color) VALUES (" + id + "," + sort + "," + (color == null ? "null" : color) + ")";
    }

    public String sqlKeytablePopulateInsertLng(String keycode, long id, String lang, String term) {
        return "INSERT INTO tkey" + keycode + "lng (id" + keycode + ",lang," + keycode + "term) VALUES (" + id + ",'" + lang + "'," + Util.toSqlString((String)term) + ")";
    }

    public SearchResult getKeytableNames(String keycode) {
        return this.executeQuery(this.sqlKeytableNames(keycode), true);
    }

    public String sqlKeytableNames(String keycode) {
        return "SELECT * FROM tdtaKeytableNames WHERE code='" + keycode + "'";
    }

    public void setKeytableNames(Keytable tbl) {
        this.executeUpdate(this.sqlKeytableNamesDelete(tbl.getCode()), true);
        ArrayList<String> langs = tbl.getLanguages();
        ArrayList<String> sqls = new ArrayList<String>();
        for (String lang : langs) {
            sqls.add(this.sqlKeytableNamesInsert(lang, tbl.getName(lang), tbl.getCode()));
        }
        this.executeUpdate(sqls, true);
    }

    public String sqlKeytableNamesDelete(String keycode) {
        return "DELETE FROM tdtaKeytableNames WHERE code='" + keycode + "'";
    }

    public String sqlKeytableNamesInsert(String lang, String name, String keycode) {
        return "INSERT INTO tdtaKeytableNames (lang,term,code) VALUES (" + Util.toSqlString((String)lang) + "," + Util.toSqlString((String)name) + "," + Util.toSqlString((String)keycode) + ")";
    }

    public void updateKeytableId(String keycode, long oldId, long newId) {
        this.executeUpdate(this.sqlUpdateKeytableId(keycode, oldId, newId), true);
    }

    protected String sqlUpdateKeytableId(String keycode, long oldId, long newId) {
        return "UPDATE tkey" + keycode + " SET id" + keycode + " = " + newId + " WHERE id" + keycode + " = " + oldId;
    }

    public void addLog(LogRecord record) {
        StringBuilder stack = new StringBuilder();
        if (record.getThrown() != null) {
            for (StackTraceElement trace : record.getThrown().getStackTrace()) {
                stack.append(trace.toString()).append("\n");
            }
        }
        this.executeUpdate(this.sqlAddLog(Util.formatDate((Date)new Date(record.getMillis()), (String)Util.DATETIME_SQL, (TimeZone)this.getApplication().getTimeZone()), record.getLevel().getName(), record.getMessage(), record.getSourceClassName(), record.getSourceMethodName(), stack.toString()), true);
    }

    protected String sqlAddLog(String dt, String level, String msg, String sourceclass, String sourcemethod, String stack) {
        return "INSERT INTO tdtasystemlog (idsystemlog,logdate,type,message,sourceclass,sourcemethod,stack) VALUES (nextval('idsystemlog'), '" + dt + "','" + level + "'," + Util.toSqlString((String)msg) + ",'" + sourceclass + "','" + sourcemethod + "'," + Util.toSqlString((String)stack) + ")";
    }

    public List<Long> getElementsInDatabase(String ids) {
        ArrayList<Long> result = new ArrayList<Long>();
        String sql = this.sqlElementsInDatabase(ids);
        try {
            Connection conn = this.getConnection();
            try {
                Statement stmt = conn.createStatement(1004, 1007);
                ResultSet rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    result.add(rs.getLong(1));
                }
                stmt.close();
            }
            catch (SQLException ex) {
                this.getApplication().getLogger().log(Level.SEVERE, "SQL error using: " + sql, ex);
            }
            this.freeConnection(conn);
        }
        catch (SQLException ex) {
            this.getApplication().getLogger().log(Level.SEVERE, "SQL connection error", ex);
        }
        return result;
    }

    public String sqlElementsInDatabase(String ids) {
        return "SELECT idelement FROM tdtaelement WHERE idelement in " + ids;
    }

    public String getElementtypeById(long id) {
        DataRecord row = this.executeQuery(this.sqlElementtypeById(id), true).firstRow();
        if (row != null) {
            return row.getString("elementtype");
        }
        return null;
    }

    public String sqlElementtypeById(long id) {
        return "SELECT elementtype FROM tdtaelement WHERE idelement = " + id;
    }

    public UUID getElementUUIDById(long id) {
        DataRecord row = this.executeQuery(this.sqlElementUUIDById(id), true).firstRow();
        if (row != null) {
            if (row.isEmpty("uuid")) {
                return null;
            }
            return UUID.fromString(row.getString("uuid"));
        }
        return null;
    }

    public String sqlElementUUIDById(long id) {
        return "SELECT uuid FROM tdtaelement WHERE idelement = " + id;
    }

    public boolean isDeleted(long id) {
        DataRecord row = this.executeQuery(this.sqlIsDeleted(id), true).firstRow();
        return row != null ? row.getBoolean("deleted") : false;
    }

    public String sqlIsDeleted(long id) {
        return "SELECT deleted FROM tdtaElement WHERE idElement=" + id;
    }

    public String getElementTitle(long id) {
        DataRecord row = this.executeQuery(this.sqlElementTitle(id), true).firstRow();
        if (row != null) {
            return row.getString("title");
        }
        return null;
    }

    public void updateElementTitle(CmsElementSummary ele) {
        this.updateElementTitle(ele.getId(), ele.getCurrentUser());
    }

    public void updateElementTitle(long id, CmsUser user) {
        CmsElement e = this.getApplication().loadElement(id, user);
        if (e != null) {
            String title = e.getTitle();
            String lang = e.getLang();
            this.executeUpdate("UPDATE tdtaElementLng SET title = " + Util.toSqlString((String)title) + " WHERE idelement = " + id + " AND lang = " + Util.toSqlString((String)lang), true);
        }
    }

    public String sqlElementTitle(long id) {
        return "SELECT el.title FROM tdtaelementlng AS el INNER JOIN tdtaelement AS e ON (e.idelement=el.idelement AND lower(el.lang)=lower(e.metamasterlang)) WHERE e.idelement = " + id;
    }

    public long getElementId(UUID uuid) {
        DataRecord row = this.executeQuery(this.sqlElementId(uuid), true).firstRow();
        if (row != null) {
            return row.getLong("idelement");
        }
        return -1L;
    }

    protected String sqlElementId(UUID uuid) {
        return "SELECT idelement FROM tdtaelement WHERE uuid='" + uuid.toString() + "'";
    }

    public long getElementId(String title, String elementtype) {
        DataRecord row = this.executeQuery(this.sqlElementId(title, elementtype), true).firstRow();
        if (row != null) {
            return row.getLong("idelement");
        }
        return -1L;
    }

    protected String sqlElementId(String title, String elementtype) {
        return "SELECT el.idelement FROM tdtaelementlng AS el INNER JOIN tdtaElement AS e ON (el.idelement=e.idelement) WHERE el.title=" + Util.toSqlString((String)title) + " AND e.elementtype=" + Util.toSqlString((String)elementtype);
    }

    public CmsElementSummary getElementSummary(CmsElement parent, UUID uuid) {
        CmsElementSummary result = null;
        if (uuid == null) {
            return null;
        }
        DataRecord row = this.executeQuery(this.sqlElementSummary(uuid), true).firstRow();
        if (row != null) {
            result = new CmsElementSummary(parent, row.getLong("meta_id"), row.getString("meta_title"), row.getString("meta_lang"), uuid, row.getBoolean("meta_trash"));
        }
        return result;
    }

    protected String sqlElementSummary(UUID uuid) {
        return "SELECT e.idelement AS meta_id,el.title AS meta_title,el.lang AS meta_lang,e.deleted AS meta_trash FROM tdtaelement AS e INNER JOIN tdtaElementLng AS el ON (e.idelement=el.idelement AND e.metamasterlang = el.lang) WHERE uuid='" + uuid.toString() + "'";
    }

    public String getElementAttribute(long id, String att) {
        String et = this.getElementtypeById(id);
        if (et == null) {
            return null;
        }
        CmsElement e = this.app.getDefaultElement(et);
        CmsAttribute a = e.getAttribute(att);
        if (a != null) {
            DataRecord rec;
            String t = e.getTablename();
            String f = a.getField();
            if (t != null && f != null && (rec = this.executeQuery("SELECT " + f + " as v FROM " + t + " WHERE idelement = " + id, true).firstRow()) != null) {
                return rec.getString("v");
            }
        }
        return null;
    }

    public String getObservationFullNumber(long id, boolean withPrefix, boolean withSuffix) {
        String sql = "SELECT l.prenumber AS locprenumber, l.postnumber AS locpostnumber, l.number AS locnumber, o.number AS obsnumber FROM tdtaEleLocation AS l INNER JOIN tdtaRelation AS r ON (l.idelement=r.elementfrom AND r.relationcode='locationobservation') INNER JOIN tdtaEleObservation AS o ON (o.idelement=r.elementto) WHERE o.idelement=" + id;
        DataRecord rec = this.executeQuery(sql, true).firstRow();
        if (rec != null) {
            return (withPrefix ? rec.getString("locprenumber") : "") + rec.getString("locnumber") + "." + rec.getString("obsnumber") + (withSuffix ? rec.getString("locpostnumber") : "");
        }
        return "";
    }

    public boolean hasElement(long id) {
        DataRecord row = this.executeQuery(this.sqlHasElement(id), true).firstRow();
        return row != null;
    }

    public String sqlHasElement(long id) {
        return "SELECT idelement FROM tdtaelement WHERE idelement = " + id;
    }

    public boolean hasElement(UUID uuid) {
        DataRecord row = this.executeQuery(this.sqlHasElement(uuid), true).firstRow();
        return row != null;
    }

    public String sqlHasElement(UUID uuid) {
        return "SELECT idelement FROM tdtaelement WHERE uuid = '" + uuid.toString() + "'";
    }

    public boolean hasUpload(long id) {
        DataRecord row = this.executeQuery(this.sqlHasUpload(id), true).firstRow();
        return row != null;
    }

    public String sqlHasUpload(long id) {
        return "SELECT idfileupload FROM tdtafileupload WHERE idfileupload = " + id;
    }

    public DataRecord getElementMeta(long id) {
        DataRecord row = this.executeQuery(this.sqlElementMeta(id), true).firstRow();
        return row;
    }

    public String sqlElementMeta(long id) {
        return "SELECT * FROM tdtaelementlng AS el INNER JOIN tdtaelement AS e ON (e.idelement=el.idelement AND el.lang=e.metamasterlang) WHERE e.idelement = " + id;
    }

    public void setElementTrash(CmsElement ele, boolean flg) {
        this.app.getCache().removeElement(ele.getId());
        this.executeUpdate(this.sqlElementTrash(Arrays.asList(ele.getId()), flg), true);
    }

    public void setElementTrash(long id, boolean flg) {
        this.app.getCache().removeElement(id);
        this.executeUpdate(this.sqlElementTrash(Arrays.asList(id), flg), true);
    }

    public void setElementTrash(ArrayList<Long> ids, boolean flg) {
        this.app.getCache().removeElement(ids);
        this.executeUpdate(this.sqlElementTrash(ids, flg), true);
    }

    public String sqlElementTrash(List<Long> ids, boolean flag) {
        return " UPDATE tdtaElement SET deleted = '" + (flag ? "t" : "f") + "' WHERE idelement IN " + Util.toSqlString(ids, (boolean)false);
    }

    public void emptyTrash() {
        this.executeUpdate(this.sqlEmptyTrash(), true);
    }

    protected String sqlEmptyTrash() {
        return "DELETE FROM tdtaElement WHERE deleted";
    }

    public void setElementLastEdit(long id, CmsUser u) {
        this.executeUpdate(this.sqlElementLastEditUser(id, u), true);
        this.executeUpdate(this.sqlElementLastEditDate(id), true);
    }

    public String sqlElementLastEditUser(long id, CmsUser u) {
        return " UPDATE tdtaElementLng SET metatranslator = " + u.getId() + " WHERE idelement = " + id;
    }

    public String sqlElementLastEditDate(long id) {
        return " UPDATE tdtaElementLng SET metalastedit = now() WHERE idelement = " + id;
    }

    public void loadAttribute(CmsAttribute att, long idelement) {
        CmsSqlSearch s = new CmsSqlSearch(this.app, this.app.getAdminUser());
        s.addSelectAttribute(att);
        s.addWhere("e.idelement", "=", Long.toString(idelement));
        SearchResult result = s.search();
        att.clear();
        if (!result.isEmpty()) {
            att.setValue(result.getResult().get(0), true);
        }
    }

    public CmsElementSummary loadElementSummary(long id, CmsUser u) {
        CmsSqlSearch s = new CmsSqlSearch(this.app, u);
        s.addSelect("el.lang", "meta_lang");
        s.addSelectTitle("meta_title");
        s.addSelectSummary("meta_summary");
        s.addSelectElementtype("meta_elementtype");
        s.addSelect("e.metaowner", "meta_idgroup");
        s.addSelect("e.metacreator", "meta_iduser");
        s.addSelect("el.metalastedit", "meta_lastedit");
        s.addSelect("el.metatranslator", "idmeta_lasteditby");
        s.addSelect("e.idreadaccess", "idmeta_readaccess");
        s.addSelect("e.idwriteaccess", "idmeta_writeaccess");
        s.addSelectWorkflowstatus("idmeta_status");
        s.addSelect("e.deleted", "meta_trash");
        s.addWhere("e.idelement = " + id);
        CmsElementSummary ele = null;
        SearchResult result = s.search();
        DataRecord rec = result.firstRow();
        if (rec != null) {
            ele = new CmsElementSummary(this.app, rec, u);
        }
        return ele;
    }

    public void loadElement(CmsElement ele, long id, String lang, boolean loadfull, CmsUser user) {
        this.loadElement(ele, this.sqlElementWhereId(id), lang, loadfull, user);
    }

    public void loadElement(CmsElement ele, UUID uuid, String lang, boolean loadfull, CmsUser user) {
        this.loadElement(ele, this.sqlElementWhereUUID(uuid), lang, loadfull, user);
    }

    public void loadElement(CmsElement ele, String condition, String lang, boolean loadfull, CmsUser user) {
        CmsSqlSearch s = new CmsSqlSearch(this.getApplication(), user);
        s.addSelectAllAttributes(ele.getElementcode());
        s.setIgnoreTrash();
        s.addWhere(condition);
        SearchResult search = s.search();
        if (search.isEmpty()) {
            this.getApplication().getLogger().log(Level.SEVERE, "Cannot load Element with condition '" + condition + "' - no database record found using SQL '" + s.getSql() + "'");
        } else {
            ele.create(search.getResult().get(0), user, loadfull);
        }
    }

    public String sqlElementWhereId(long id) {
        return "e.idelement = " + id;
    }

    public String sqlElementWhereUUID(UUID uuid) {
        return "e.uuid = '" + uuid.toString() + "'";
    }

    public void loadElementCommnets(CmsElement ele) {
        List<DataRecord> list = this.executeQuery("select * from tdtacomment where idelement = " + ele.getId() + " ORDER BY issuedate ASC", true).getResult();
        for (DataRecord dataRecord : list) {
            CmsComment cmsComment = new CmsComment();
            cmsComment.setName(dataRecord.getString("name"));
            cmsComment.setIdcomment(dataRecord.getInt("idcomment"));
            cmsComment.setIdelement(dataRecord.getInt("idelement"));
            cmsComment.setLang(dataRecord.getString("lang"));
            cmsComment.setIssuedate(dataRecord.getDate("issuedate", this.getApplication().getTimeZone()));
            cmsComment.setComment(dataRecord.getString("comment"));
            cmsComment.setIduser(dataRecord.getInt("iduser"));
            cmsComment.setEmail(dataRecord.getString("email"));
            ele.addComment(cmsComment);
        }
    }

    public void saveElement(CmsElement ele) {
        this.saveElement(ele, false);
    }

    public void saveElement(CmsElement ele, boolean ignoreRelations) {
        for (CmsAttribute att : ele.getDataAttributes()) {
            if (!att.isOfType(22) || att.hasValue()) continue;
            att.setValue(Long.toString(this.createId(att.getParent().getElementcode() + "_" + att.getCode())));
        }
        ArrayList<String> sqls = this.sqlElementUpdate(ele);
        ArrayList<UploadItem> uploadsToMove = new ArrayList<UploadItem>();
        ArrayList<UploadItem> uploadsToDelete = new ArrayList<UploadItem>();
        ArrayList<Long> uploadDetailIds = this.app.getKeytable("uploaddetail").getIds();
        for (CmsAttribute att : ele.getDataAttributes()) {
            String tbl;
            if (att.isVirtual() || att.isOfType(2)) continue;
            if (att.isOfType(10)) {
                tbl = ((MultikeyAttribute)att).getTableName();
                sqls.add(this.sqlElementDeleteMultikey(tbl, ele.getId()));
                sqls.add(this.sqlElementInsertMultikey(tbl, ele.getId(), att.getDatabaseValue()));
                continue;
            }
            if (att.isOfType(14) && !((RelationAttribute)att).isSingle()) {
                if (ignoreRelations && !((RelationAttribute)att).isSubelement()) continue;
                tbl = ((RelationAttribute)att).getTableName();
                sqls.add(this.sqlElementDeleteRelation(tbl, ele.getId(), ((RelationAttribute)att).getRelationcode(), ((RelationAttribute)att).getDirection()));
                int counter = 1;
                String relationcode = ((RelationAttribute)att).getRelationcode();
                List<Long> idsInDatabase = this.getElementsInDatabase(((RelationAttribute)att).getDatabaseValue());
                int i = 1;
                List<CmsElementSummary> es = ((RelationAttribute)att).getElements(false);
                for (CmsElementSummary e : es) {
                    if (!e.isNew() && !idsInDatabase.contains(e.getId())) continue;
                    if (((RelationAttribute)att).isSubelement()) {
                        ((RelationAttribute)att).getFullElement(e.getId()).save(true);
                    }
                    if (e.isNew()) {
                        this.getApplication().getLogger().log(Level.INFO, "Saving new relation element: " + e.toString());
                        e.save();
                    }
                    sqls.add(this.sqlElementInsertRelation(tbl, ele.getId(), e.getId(), relationcode, counter, i, ((RelationAttribute)att).getDirection()));
                    ++i;
                    ++counter;
                }
                if (!((RelationAttribute)att).deleteRemoved()) continue;
                Iterator<Object> iterator = ((RelationAttribute)att).getElementIds().iterator();
                while (iterator.hasNext()) {
                    long relId = (Long)iterator.next();
                    if (!((RelationAttribute)att).contains(relId)) {
                        relationcode = ((RelationAttribute)att).getRelationcode();
                        sqls.add(this.sqlElementTrash(Arrays.asList(relId), true));
                        sqls.add(this.sqlElementInsertRelation(tbl, ele.getId(), relId, relationcode, counter, -1, ((RelationAttribute)att).getDirection()));
                        ++counter;
                        continue;
                    }
                    if (!ele.isTrash()) continue;
                    sqls.add(this.sqlElementTrash(Arrays.asList(relId), true));
                }
                continue;
            }
            if (!att.isOfType(15) && !att.isOfType(16)) continue;
            tbl = "fileupload";
            sqls.add(this.sqlElementDeleteUpload(tbl, ele.getId(), att.getCode()));
            for (UploadItem item : ((UploadAttribute)att).getAllUploadItems()) {
                item.setReference(ele.getId(), ele.getElementcode());
                if (!item.isInRepository()) {
                    uploadsToMove.add(item);
                }
                sqls.add(this.sqlElementDeleteUpload(tbl, item.getId()));
                long idUploadDetail = item.getUploadDetail();
                if (!uploadDetailIds.contains(idUploadDetail)) {
                    idUploadDetail = -1L;
                }
                sqls.add(this.sqlElementInsertUpload(tbl, item.getId(), ele.getId(), item.getName(), item.getContenttype(), item.getFilesize(), item.getUploaddate(), item.createFilename(), att.getCode(), item.getFileComment(), item.getFileInfo(), idUploadDetail, item.getElementtype(), item.isDeleted()));
            }
            for (UploadItem item : ((UploadAttribute)att).getRemovedUploadItems()) {
                uploadsToDelete.add(item);
            }
            ((UploadAttribute)att).clearItemsToBeRemoved();
        }
        int result = this.executeUpdate(sqls, true);
        if (result >= 0) {
            for (int ii = 0; ii < uploadsToMove.size(); ++ii) {
                UploadItem item = (UploadItem)uploadsToMove.get(ii);
                try {
                    for (int jj = ii + 1; jj < uploadsToMove.size(); ++jj) {
                        if (!((UploadItem)uploadsToMove.get(jj)).getName().equals(item.getName())) continue;
                        item.setStatus(2);
                        break;
                    }
                    this.getApplication().getLogger().log(Level.INFO, "adding file " + item.getId());
                    item.moveFile(new File(this.getApplication().getFileLocation(), ele.getElementcode()));
                    continue;
                }
                catch (IOException ex) {
                    this.getApplication().getLogger().log(Level.SEVERE, "Cannot move file to target location, location does not exist", ex);
                }
            }
            for (UploadItem item : uploadsToDelete) {
                this.getApplication().getLogger().log(Level.INFO, "deleting file " + item.getId());
                item.deleteFile();
            }
            ele.setSaved(true);
            if (!ignoreRelations && this.app.isKeepElementHistory() && ele.hasChanged()) {
                String xml = ele.toXML();
                byte[] xmlZip = Util.deflate((String)xml);
                try {
                    this.insertElementHistory(ele.getId(), xmlZip);
                    try {
                        Thread.sleep(2L);
                    }
                    catch (InterruptedException ex) {}
                }
                catch (SQLException ex) {
                    Logger.getLogger(DataStorage.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        this.getApplication().getLogger().log(Level.INFO, "Element '" + ele.getElementcode() + "' saved, ID = " + ele.getId());
    }

    public void insertElementHistory(long id, byte[] zip) throws SQLException {
        PreparedStatement prep = this.getConnection().prepareStatement("INSERT INTO tdtaElementHistory (idelement, savedate, data) VALUES (?, ?, ?)");
        Date dt = new Date();
        prep.setLong(1, id);
        prep.setTimestamp(2, new Timestamp(dt.getTime()));
        prep.setBytes(3, zip);
        prep.execute();
        prep.close();
    }

    public ArrayList<String> sqlElementUpdate(CmsElement ele) {
        if (ele.isNew()) {
            return this.sqlElementInsert(ele);
        }
        ArrayList<String> result = new ArrayList<String>();
        boolean first3 = true;
        boolean first4 = true;
        StringBuilder sql1 = new StringBuilder();
        StringBuilder sql2 = new StringBuilder();
        StringBuilder sql3 = new StringBuilder();
        StringBuilder sql4 = new StringBuilder();
        sql1.append("UPDATE tdtaelement SET ");
        sql2.append("UPDATE tdtaelementlng SET ");
        sql3.append("UPDATE ").append(ele.getTablename()).append(" SET ");
        sql4.append("UPDATE ").append(ele.getTablename()).append("lng SET ");
        sql1.append("uuid = ").append("'").append(ele.getUUID().toString()).append("'");
        sql2.append("title = ").append(Util.toSqlString((String)ele.getTitle()));
        sql2.append(",summary = ").append(Util.toSqlString((String)ele.getSummary()));
        for (CmsAttribute att : ele.getMetaAttributes()) {
            if (att.isVirtual()) continue;
            if (att.isMultilingual()) {
                sql2.append(",").append(att.getField()).append(" = ").append(att.getDatabaseValue());
                continue;
            }
            sql1.append(",").append(att.getField()).append(" = ").append(att.getDatabaseValue());
        }
        sql1.append(" WHERE idelement = ").append(ele.getId()).append(" ");
        sql2.append(" WHERE idelement = ").append(ele.getId()).append(" AND lower(lang) = '").append(ele.getLang().toLowerCase()).append("' ");
        for (CmsAttribute att : ele.getDataAttributes()) {
            if (att.isVirtual() || att.getField() == null) continue;
            if (att.isMultilingual()) {
                if (!first4) {
                    sql4.append(",");
                }
                sql4.append(att.getField()).append(" = ").append(att.getDatabaseValue());
                first4 = false;
                continue;
            }
            if (!first3) {
                sql3.append(",");
            }
            if (att.isOfType(14) && ((RelationAttribute)att).size() > 0 && ((RelationAttribute)att).getFirstElement().isNew()) {
                ((RelationAttribute)att).getFirstElement().save();
            }
            sql3.append(att.getField()).append(" = ").append(att.getDatabaseValue());
            first3 = false;
        }
        sql3.append(" WHERE idelement = ").append(ele.getId()).append(" ");
        sql4.append(" WHERE idelement = ").append(ele.getId()).append(" AND lower(lang) = '").append(ele.getLang().toLowerCase()).append("' ");
        result.add(sql1.toString());
        if (!first3) {
            result.add(sql3.toString());
        }
        result.add(sql2.toString());
        if (!first4) {
            result.add(sql4.toString());
        }
        return result;
    }

    public ArrayList<String> sqlElementInsert(CmsElement ele) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder sql1 = new StringBuilder();
        StringBuilder sql2 = new StringBuilder();
        StringBuilder sql3 = new StringBuilder();
        StringBuilder sql4 = new StringBuilder();
        sql1.append("INSERT INTO tdtaelement (idelement,uuid");
        sql2.append("INSERT INTO tdtaelementlng (idelement,lang,title,summary");
        sql3.append("INSERT INTO ").append(ele.getTablename()).append(" (idelement");
        sql4.append("INSERT INTO ").append(ele.getTablename()).append("lng (idelement,lang");
        for (CmsAttribute att : ele.getMetaAttributes()) {
            if (att.isVirtual()) continue;
            if (att.isMultilingual()) {
                sql2.append(",").append(att.getField());
                continue;
            }
            sql1.append(",").append(att.getField());
        }
        sql1.append(") VALUES (").append(ele.getId()).append(",'").append(ele.getUUID().toString()).append("'");
        sql2.append(") VALUES (").append(ele.getId()).append(",'").append(ele.getLang()).append("'");
        sql2.append(",").append(Util.toSqlString((String)ele.getTitle())).append(",").append(Util.toSqlString((String)ele.getSummary())).append("");
        for (CmsAttribute att : ele.getMetaAttributes()) {
            if (att.isVirtual()) continue;
            if (att.isMultilingual()) {
                sql2.append(",").append(att.getDatabaseValue());
                continue;
            }
            sql1.append(",").append(att.getDatabaseValue());
        }
        sql1.append(")");
        sql2.append(")");
        for (CmsAttribute att : ele.getDataAttributes()) {
            if (att.isVirtual() || att.getField() == null) continue;
            if (att.isMultilingual()) {
                sql4.append(",").append(att.getField());
                continue;
            }
            sql3.append(",").append(att.getField());
        }
        sql3.append(") VALUES (").append(ele.getId());
        sql4.append(") VALUES (").append(ele.getId()).append(",'").append(ele.getLang()).append("'");
        for (CmsAttribute att : ele.getDataAttributes()) {
            if (att.isVirtual() || att.getField() == null) continue;
            if (att.isMultilingual()) {
                sql4.append(",").append(att.getDatabaseValue());
                continue;
            }
            if (att.isOfType(14) && ((RelationAttribute)att).size() > 0 && ((RelationAttribute)att).getFirstElement().isNew()) {
                ((RelationAttribute)att).getFirstElement().save();
            }
            sql3.append(",").append(att.getDatabaseValue());
        }
        sql3.append(")");
        sql4.append(")");
        result.add(sql1.toString());
        result.add(sql3.toString());
        result.add(sql2.toString());
        result.add(sql4.toString());
        return result;
    }

    public String sqlElementDeleteMultikey(String tablename, long idelement) {
        return "DELETE FROM tkey" + tablename + "rel WHERE idelement = " + idelement;
    }

    public String sqlElementInsertMultikey(String tablename, long idelement, String values) {
        return "INSERT INTO tkey" + tablename + "rel (idelement,id" + tablename + ") SELECT " + idelement + ",id" + tablename + " FROM tkey" + tablename + " WHERE id" + tablename + " IN " + values;
    }

    public String sqlElementDeleteRelation(String tablename, long idelement, String relationcode, int direction) {
        String sql = "DELETE FROM " + tablename + " WHERE relationcode = '" + relationcode + "' AND ";
        sql = direction == 1 ? sql + "elementfrom = " + idelement : sql + "elementto = " + idelement;
        return sql;
    }

    public String sqlElementInsertRelation(String tablename, long idelement, long relid, String relationcode, int order, int relorder, int direction) {
        String sql = "INSERT INTO " + tablename + " (elementfrom,elementto,relationcode,orderfrom,orderto) VALUES (";
        sql = direction == 1 ? sql + idelement + "," + relid + ",'" + relationcode + "'," + order + "," + relorder + ")" : sql + relid + "," + idelement + ",'" + relationcode + "'," + relorder + "," + order + ")";
        return sql;
    }

    public String sqlElementDeleteUpload(String tablename, long idelement, String code) {
        return "DELETE FROM tdta" + tablename + " WHERE idelement = " + idelement + " AND code = '" + code + "'";
    }

    public String sqlElementDeleteUpload(String tablename, long idupload) {
        return "DELETE FROM tdta" + tablename + " WHERE id" + tablename + " = " + idupload;
    }

    public boolean hasRelation(long elementFrom, long elementTo, String code, boolean includeTrash) {
        SearchResult result = this.executeQuery(this.sqlHasRelation(elementFrom, elementTo, code, includeTrash), true);
        return !result.isEmpty();
    }

    public String sqlHasRelation(long elementFrom, long elementTo, String code, boolean includeTrash) {
        return "SELECT r.elementfrom FROM tdtaRelation AS r INNER JOIN tdtaElement AS e ON (r.elementTo=e.idelement)WHERE r.elementfrom=" + elementFrom + " AND r.elementTo=" + elementTo + " AND r.relationcode=" + Util.toSqlString((String)code) + " " + (includeTrash ? "" : "AND NOT e.deleted");
    }

    public void saveUploadItem(UploadItem item) {
        long idUploadDetail;
        ArrayList<Long> uploadDetailIds = this.app.getKeytable("uploaddetail").getIds();
        if (!uploadDetailIds.contains(idUploadDetail = item.getUploadDetail())) {
            idUploadDetail = -1L;
        }
        this.executeUpdate(this.sqlElementInsertUpload("fileupload", item.getId(), item.getIdelement(), item.getName(), item.getContenttype(), item.getFilesize(), item.getUploaddate(), item.createFilename(), item.getAttributeCode(), item.getFileComment(), item.getFileInfo(), idUploadDetail, item.getElementtype(), item.isDeleted()), true);
    }

    public String sqlElementInsertUpload(String tablename, long idupload, long idelement, String filename, String contenttype, long filesize, Date uploaddate, String path, String code, String comment, String fileinfo, long idUploadDetail, String elementtype, boolean deleted) {
        return "INSERT INTO tdta" + tablename + " (id" + tablename + ",idelement,name,contenttype,filesize,uploaddate,urlbase,path,code,comment,fileinfo,iduploaddetail,elementtype,deleted) VALUES (" + idupload + "," + idelement + ",'" + filename + "','" + contenttype + "'," + filesize + ",'" + Util.formatDate((Date)uploaddate, (String)Util.DATETIME_SQL, (TimeZone)this.getApplication().getTimeZone()) + "',''," + Util.toSqlString((String)path) + "," + Util.toSqlString((String)code) + "," + (comment == null ? "''" : Util.toSqlString((String)comment)) + "," + (fileinfo == null ? "''" : Util.toSqlString((String)fileinfo)) + "," + (idUploadDetail < 0L ? "null" : Long.valueOf(idUploadDetail)) + "," + Util.toSqlString((String)elementtype) + "," + (deleted ? "'t'" : "'f'") + ")";
    }

    public void updateUploadItem(UploadItem item) {
        long idUploadDetail;
        ArrayList<Long> uploadDetailIds = this.app.getKeytable("uploaddetail").getIds();
        if (!uploadDetailIds.contains(idUploadDetail = item.getUploadDetail())) {
            idUploadDetail = -1L;
        }
        this.executeUpdate(this.sqlUpdateUploadItem(item.getId(), item.getIdelement(), item.getFilename(), item.getContenttype(), item.getFilesize(), item.getUploaddate(), item.getFilename(), item.getAttributeCode(), item.getFileComment(), item.getFileInfo(), idUploadDetail, item.getElementtype(), item.isDeleted()), true);
    }

    public String sqlUpdateUploadItem(long idupload, long idelement, String filename, String contenttype, long filesize, Date uploaddate, String path, String code, String comment, String fileinfo, long idUploadDetail, String elementtype, boolean deleted) {
        return "UPDATE tdtafileupload SET  idelement = " + idelement + ",name = '" + filename + "',contenttype = '" + contenttype + "',filesize = " + filesize + ",uploaddate = '" + Util.formatDate((Date)uploaddate, (String)Util.DATETIME_SQL, (TimeZone)this.getApplication().getTimeZone()) + "',urlbase = '',path = " + Util.toSqlString((String)comment) + ",code = " + Util.toSqlString((String)code) + ",comment = " + (comment == null ? "''" : Util.toSqlString((String)comment)) + ",fileinfo = " + (fileinfo == null ? "''" : Util.toSqlString((String)fileinfo)) + ",iduploaddetail = " + (idUploadDetail < 0L ? "null" : Long.valueOf(idUploadDetail)) + ",elementtype = " + Util.toSqlString((String)elementtype) + ",deleted = " + (deleted ? "'t'" : "'f'") + " WHERE id" + "fileupload" + " = " + idupload;
    }

    public ArrayList<UploadItem> getUploadItems(long idelement, String attcode) {
        return this.getUploadItems(idelement, attcode, false);
    }

    public ArrayList<UploadItem> getUploadItems(long idelement, String attcode, boolean includeDeleted) {
        ArrayList<UploadItem> items = new ArrayList<UploadItem>();
        SearchResult result = this.app.getDatastorage().executeQuery(this.sqlGetUploadItems(idelement, attcode), true);
        for (DataRecord rec : result.getResult()) {
            if (!includeDeleted && rec.getBoolean("deleted").booleanValue()) continue;
            items.add(new UploadItem(this.app, rec));
        }
        return items;
    }

    protected String sqlGetUploadItems(long idelement, String attcode) {
        return "SELECT * FROM tdtaFileUpload WHERE idelement = " + idelement + " AND code = '" + attcode + "' ORDER BY idfileupload";
    }

    public ArrayList<UploadItem> getUploadItems(String elementIds, String code) {
        return this.getUploadItems(elementIds, code, false);
    }

    public ArrayList<UploadItem> getUploadItems(String elementIds, String code, boolean includeDeleted) {
        ArrayList<UploadItem> items = new ArrayList<UploadItem>();
        SearchResult result = this.app.getDatastorage().executeQuery(this.sqlGetUploadItems("idelement IN (" + elementIds + ")", code), true);
        for (DataRecord rec : result.getResult()) {
            if (!includeDeleted && rec.getBoolean("deleted").booleanValue()) continue;
            items.add(new UploadItem(this.app, rec));
        }
        return items;
    }

    public ArrayList<UploadItem> getUploadItems() {
        return this.getUploadItems(false, "files");
    }

    public ArrayList<UploadItem> getUploadItems(boolean includeDeleted, String itemtype) {
        ArrayList<UploadItem> items = new ArrayList<UploadItem>();
        SearchResult result = this.app.getDatastorage().executeQuery(this.sqlGetUploadItems("true", itemtype), true);
        for (DataRecord rec : result.getResult()) {
            if (!includeDeleted && rec.getBoolean("deleted").booleanValue()) continue;
            items.add(new UploadItem(this.app, rec));
        }
        return items;
    }

    public ArrayList<UploadItem> getAllUploadItems() {
        ArrayList<UploadItem> items = new ArrayList<UploadItem>();
        SearchResult result = this.app.getDatastorage().executeQuery(this.sqlGetUploadItems("true", null), true);
        for (DataRecord rec : result.getResult()) {
            items.add(new UploadItem(this.app, rec));
        }
        return items;
    }

    protected String sqlGetUploadItems(String sql, String code) {
        return "SELECT * FROM tdtaFileUpload WHERE " + sql + (code == null ? "" : " AND code = '" + code + "'");
    }

    public int updateUploadItemComment(long idUpload, String comment) {
        return this.executeUpdate(this.sqlUpdateUploadItemComment(idUpload, comment), true);
    }

    protected String sqlUpdateUploadItemComment(long idUpload, String comment) {
        return "UPDATE tdtaFileUpload SET comment = " + Util.toSqlString((String)comment) + " WHERE idFileUpload = " + idUpload;
    }

    public int updateUploadItemInfos(long idUpload, String comment, long uploadDetail) {
        if (uploadDetail == 0L) {
            uploadDetail = 1L;
        }
        return this.executeUpdate(this.sqlUpdateUploadItemInfos(idUpload, comment, uploadDetail), true);
    }

    protected String sqlUpdateUploadItemInfos(long idUpload, String comment, long uploadDetail) {
        return "UPDATE tdtaFileUpload SET comment = " + Util.toSqlString((String)comment) + ", idUploaddetail = " + uploadDetail + " WHERE idFileUpload = " + idUpload;
    }

    public int updateUploadItemFileInfo(long idUpload, String fileinfo) {
        return this.executeUpdate(this.sqlUpdateUploadItemFileInfo(idUpload, fileinfo), true);
    }

    protected String sqlUpdateUploadItemFileInfo(long idUpload, String fileinfo) {
        return "UPDATE tdtaFileUpload SET fileinfo = " + Util.toSqlString((String)fileinfo) + " WHERE idFileUpload = " + idUpload;
    }

    public ArrayList<Date> getElementHistoryDates(long id) {
        ArrayList<Date> result = new ArrayList<Date>();
        result.addAll(this.getElementHistory(id).keySet());
        Collections.sort(result);
        return result;
    }

    public TreeMap<Date, String> getElementHistory(long id) {
        TreeMap<Date, String> map = new TreeMap<Date, String>();
        try {
            Connection conn = this.getConnection();
            try {
                Statement stmt = conn.createStatement(1004, 1007);
                ResultSet rs = stmt.executeQuery(this.sqlGetElementHistory(id));
                while (rs.next()) {
                    Date dt = new Date(rs.getTimestamp("savedate").getTime());
                    byte[] bytes = rs.getBytes("data");
                    String xml = Util.inflate((byte[])bytes);
                    if (dt == null) continue;
                    map.put(dt, xml);
                }
            }
            catch (Exception ex) {
                this.getApplication().getLogger().log(Level.SEVERE, "SQL error: " + ex.getMessage(), ex);
            }
            this.freeConnection(conn);
        }
        catch (Exception ex) {
            this.getApplication().getLogger().log(Level.SEVERE, "Database connection error: " + ex.getMessage(), ex);
        }
        return map;
    }

    public String sqlGetElementHistory(long id) {
        return "SELECT * FROM tdtaElementHistory WHERE idelement = " + id + " ORDER BY savedate ASC";
    }

    public String getElementHistory(long id, Date dt) {
        String xml = null;
        try {
            Connection conn = this.getConnection();
            try {
                Statement stmt = conn.createStatement(1004, 1007);
                String sql = this.sqlGetElementHistory(id, dt);
                ResultSet rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    byte[] bytes = rs.getBytes("data");
                    xml = Util.inflate((byte[])bytes);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.freeConnection(conn);
        }
        catch (Exception ex) {
            this.getApplication().getLogger().log(Level.SEVERE, "Database connection error: " + ex.getMessage(), ex);
        }
        return xml;
    }

    public String sqlGetElementHistory(long id, Date dt) {
        Timestamp ts = new Timestamp(dt.getTime());
        return "SELECT * FROM tdtaElementHistory WHERE idelement = " + id + " AND savedate = '" + ts.toString() + "'";
    }

    public void changeId(CmsElement ele, long newId) {
        String sql = this.sqlElementChangeId(ele.getId(), newId);
        this.getApplication().getLogger().log(Level.INFO, sql);
        int result = this.executeUpdate(sql, true);
        if (result > 0) {
            ele.setId(newId);
        }
    }

    public String sqlElementChangeId(long oldId, long newId) {
        return "UPDATE tdtaElement SET idelement = " + newId + " WHERE idelement = " + oldId;
    }

    public void lockElement(long idelement, long iduser) {
        this.executeUpdate(this.sqlUnlockElement(idelement, iduser), true);
        this.executeUpdate(this.sqlLockElement(idelement, iduser), true);
    }

    public void unlockElement(long idelement, long iduser) {
        this.executeUpdate(this.sqlUnlockElement(idelement, iduser), true);
    }

    protected String sqlLockElement(long idelement, long iduser) {
        return "INSERT INTO tdtaelementlock (idelement,iduser,locktime) VALUES (" + idelement + "," + iduser + "," + Util.toSqlString((Date)new Date(), (TimeZone)this.app.getTimeZone()) + ")";
    }

    protected String sqlUnlockElement(long idelement, long iduser) {
        return "DELETE FROM tdtaelementlock WHERE idelement=" + idelement;
    }

    public boolean isElementLocked(long idelement, long iduser) {
        return !this.executeQuery(this.sqlIsElementLocked(idelement, iduser), true).isEmpty();
    }

    protected String sqlIsElementLocked(long idelement, long iduser) {
        Date dt = new Date();
        dt.setTime(dt.getTime() - 60000L * Long.parseLong(this.app.getProperty("conf.locktime", "20")));
        return "SELECT idelement FROM tdtaelementlock WHERE idelement=" + idelement + " AND iduser!=" + iduser + " AND locktime>" + Util.toSqlString((Date)dt, (TimeZone)this.app.getTimeZone());
    }

    public boolean removeElement(CmsElement ele) {
        return this.executeUpdate(this.sqlElementRemove(ele.getId()), true) > 0;
    }

    protected String sqlElementRemove(long idelement) {
        return " DELETE FROM tdtaElement WHERE idelement = " + idelement;
    }

    public void loadUploadItem(UploadItem item, long idUpload) {
        String sql = this.sqlUploadItemLoad(idUpload);
        SearchResult result = this.executeQuery(sql, true);
        if (!result.isEmpty()) {
            item.create(this.getApplication(), result.firstRow());
        }
    }

    public void loadUploadItem(UploadItem item, long id, CmsUser u) {
        String sql = this.sqlUploadItemLoad(id, u);
        SearchResult result = this.executeQuery(sql, true);
        if (!result.isEmpty()) {
            item.create(this.getApplication(), result.firstRow());
        }
    }

    protected String sqlUploadItemLoad(long idupload) {
        return "SELECT * FROM tdtafileupload WHERE idfileupload = " + idupload;
    }

    protected String sqlUploadItemLoad(long id, CmsUser u) {
        return "SELECT * FROM tdtafileupload as f INNER JOIN tdtaelement as e ON f.idelement = e.idelement  WHERE f.idfileupload = " + id + " AND " + CmsPermission.getWhereClause(u, "e");
    }

    public void loadElementRelationByIds(CmsElement parent, RelationAttribute att, String ids) {
        CmsSqlSearch s = new CmsSqlSearch(this.app, parent.getCurrentUser());
        s.setIgnoreTrash();
        s.addSelect("el.lang", "meta_lang");
        s.addSelectTitle("meta_title");
        s.addSelectSummary("meta_summary");
        s.addSelectElementtype("meta_elementtype");
        s.addSelect("e.metaowner", "meta_idgroup");
        s.addSelect("e.metacreator", "meta_iduser");
        s.addSelect("el.metalastedit", "meta_lastedit");
        s.addSelect("el.metatranslator", "idmeta_lasteditby");
        s.addSelect("e.idreadaccess", "idmeta_readaccess");
        s.addSelect("e.idwriteaccess", "idmeta_writeaccess");
        s.addSelectWorkflowstatus("idmeta_status");
        s.addSelect("e.deleted", "meta_trash");
        s.addWhere("e.idelement IN (" + Util.toSqlString((String)ids) + ")");
        SearchResult result = s.search();
        for (DataRecord rec : result.getResult()) {
            CmsElementSummary ele = new CmsElementSummary(parent, rec);
            if (att.isSubelement()) {
                att.addFullElement(parent.getApplication().loadElement(ele.getId(), parent.getCurrentUser()));
                continue;
            }
            att.add(ele);
        }
    }

    public void loadElementRelation(CmsElement parent, RelationAttribute att) {
        CmsSqlSearch s = new CmsSqlSearch(this.app, parent.getCurrentUser());
        s.setIgnoreTrash();
        s.addSelect("el.lang", "meta_lang");
        s.addSelectTitle("meta_title");
        s.addSelectSummary("meta_summary");
        s.addSelectElementtype("meta_elementtype");
        s.addSelect("e.metaowner", "meta_idgroup");
        s.addSelect("e.metacreator", "meta_iduser");
        s.addSelect("el.metalastedit", "meta_lastedit");
        s.addSelect("el.metatranslator", "idmeta_lasteditby");
        s.addSelect("e.idreadaccess", "idmeta_readaccess");
        s.addSelect("e.idwriteaccess", "idmeta_writeaccess");
        s.addSelectWorkflowstatus("idmeta_status");
        s.addSelect("e.deleted", "meta_trash");
        String code = att.getCode();
        if (att.getInverseField() != null) {
            String et = att.getElementtype();
            String tbl = this.app.getDefaultElement(et).getTablename();
            s.addInnerJoin(tbl + " AS rel ON (rel.idelement=e.idelement AND rel." + att.getInverseField() + " = " + parent.getId() + ")");
        } else if (att.getDirection() == 1) {
            s.addInnerJoin("tdtaRelation AS " + code + "rel ON e.idElement=" + code + "rel.elementTo AND " + code + "rel.relationcode='" + att.getRelationcode() + "' ");
            s.setSort(code + "rel.orderTo");
            s.addSelect(code + "rel.orderTo", "sortorder");
            s.addWhere(code + "rel.elementFrom=" + parent.getId());
        } else {
            s.addInnerJoin("tdtaRelation AS " + code + "rel ON e.idElement=" + code + "rel.elementFrom AND " + code + "rel.relationcode='" + att.getRelationcode() + "' ");
            s.setSort(code + "rel.orderFrom");
            s.addSelect(code + "rel.orderFrom", "sortorder");
            s.addWhere(code + "rel.elementTo=" + parent.getId());
        }
        if (att.hasAutosort()) {
            if (att.getAutosort().toLowerCase().startsWith("ele.")) {
                s.addElementJoin(att.getElementtype(), "ele");
                s.addSelect(att.getAutosort(), att.getAutosort().replaceAll(".", "_"));
            }
            s.setSort(att.getAutosort());
        }
        SearchResult result = s.search();
        for (DataRecord rec : result.getResult()) {
            CmsElementSummary ele = new CmsElementSummary(parent, rec);
            if (att.contains(ele.getId())) continue;
            if (att.isSubelement()) {
                att.addFullElement(parent.getApplication().loadElement(ele.getId(), parent.getCurrentUser()));
                continue;
            }
            att.add(ele);
        }
    }

    public ArrayList<Long> getRelationIds(List<Long> elementids, String relationcode, boolean FROM_TO) {
        return this.getRelationIds(elementids, relationcode, FROM_TO, false);
    }

    public ArrayList<Long> getRelationIds(List<Long> elementids, String relationcode, boolean FROM_TO, boolean withDeleted) {
        ArrayList<Long> result = new ArrayList<Long>();
        List<DataRecord> recs = this.executeQuery(this.sqlRelationIds(elementids, relationcode, FROM_TO, withDeleted), true).getResult();
        for (DataRecord rec : recs) {
            result.add(rec.getLong("id"));
        }
        return result;
    }

    public ArrayList<Long> getRelationIdsTo(long elementid, String relationcode, boolean withDeleted) {
        return this.getRelationIds(elementid, relationcode, true, withDeleted);
    }

    public ArrayList<Long> getRelationIdsFrom(long elementid, String relationcode, boolean withDeleted) {
        return this.getRelationIds(elementid, relationcode, false, withDeleted);
    }

    public long getRelationIdsToFirst(long elementid, String relationcode, boolean withDeleted) {
        ArrayList<Long> ids = this.getRelationIds(elementid, relationcode, true, withDeleted);
        return ids.isEmpty() ? -1L : ids.get(0);
    }

    public long getRelationIdsFromFirst(long elementid, String relationcode, boolean withDeleted) {
        ArrayList<Long> ids = this.getRelationIds(elementid, relationcode, false, withDeleted);
        return ids.isEmpty() ? -1L : ids.get(ids.size() - 1);
    }

    public ArrayList<Long> getRelationIds(long elementid, String relationcode, boolean FROM_TO) {
        return this.getRelationIds(elementid, relationcode, FROM_TO, true);
    }

    public ArrayList<Long> getRelationIds(long elementid, String relationcode, boolean FROM_TO, boolean withDeleted) {
        ArrayList<Long> result = new ArrayList<Long>();
        List<DataRecord> recs = this.executeQuery(this.sqlRelationIds(elementid, relationcode, FROM_TO, withDeleted), true).getResult();
        for (DataRecord rec : recs) {
            result.add(rec.getLong("id"));
        }
        return result;
    }

    protected String sqlRelationIds(long elementid, String relationcode, boolean FROM_TO, boolean withDeleted) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT r.element").append(FROM_TO ? "to" : "from").append(" AS id FROM tdtarelation AS r ");
        if (!withDeleted) {
            sb.append("INNER JOIN tdtaElement AS e ON (").append("element").append(FROM_TO ? "to" : "from").append("=e.idelement AND NOT e.deleted) ");
        }
        sb.append("WHERE relationcode = ").append(Util.toSqlString((String)relationcode));
        if (elementid > 0L) {
            sb.append(" AND element" + (FROM_TO ? "from" : "to") + "=" + elementid);
        }
        return sb.toString();
    }

    protected String sqlRelationIds(List<Long> elementids, String relationcode, boolean FROM_TO) {
        return "SELECT DISTINCT element" + (FROM_TO ? "to" : "from") + " AS id, orderfrom, orderto FROM tdtarelation  WHERE element" + (FROM_TO ? "from" : "to") + " IN " + Util.toSqlString(elementids, (boolean)false) + " AND relationcode = " + Util.toSqlString((String)relationcode) + " ORDER BY " + (FROM_TO ? "orderfrom" : "orderto");
    }

    protected String sqlRelationIds(List<Long> elementids, String relationcode, boolean FROM_TO, boolean withDeleted) {
        return "SELECT DISTINCT element" + (FROM_TO ? "to" : "from") + " AS id, orderfrom, orderto FROM tdtarelation AS r  INNER JOIN tdtaElement AS e ON (r.element" + (FROM_TO ? "to" : "from") + " = e.idelement)  WHERE element" + (FROM_TO ? "from" : "to") + " IN " + Util.toSqlString(elementids, (boolean)false) + " AND relationcode = " + Util.toSqlString((String)relationcode) + (withDeleted ? "" : " AND NOT e.deleted ") + " ORDER BY " + (FROM_TO ? "orderfrom" : "orderto");
    }

    public long checkUser(String username) {
        long result = -1L;
        String sql = this.sqlUserGetId(username);
        try {
            Connection conn = this.getConnection();
            try {
                Statement stmt = conn.createStatement(1004, 1007);
                ResultSet rs = stmt.executeQuery(sql);
                if (rs.next()) {
                    result = rs.getLong("idelement");
                }
                stmt.close();
            }
            catch (SQLException ex) {
                this.getApplication().getLogger().log(Level.SEVERE, "SQL error using: " + sql, ex);
            }
            this.freeConnection(conn);
        }
        catch (SQLException ex) {
            this.getApplication().getLogger().log(Level.SEVERE, "SQL connection error", ex);
        }
        return result;
    }

    public String checkUser(long iduser) {
        String result = "-";
        String sql = this.sqlUserGetName(iduser);
        try {
            Connection conn = this.getConnection();
            try {
                Statement stmt = conn.createStatement(1004, 1007);
                ResultSet rs = stmt.executeQuery(sql);
                if (rs.next()) {
                    result = rs.getString("username");
                }
                stmt.close();
            }
            catch (SQLException ex) {
                this.getApplication().getLogger().log(Level.SEVERE, "SQL error using: " + sql, ex);
            }
            this.freeConnection(conn);
        }
        catch (SQLException ex) {
            this.getApplication().getLogger().log(Level.SEVERE, "SQL connection error", ex);
        }
        return result;
    }

    public String getUserFullName(String username) {
        String result = "";
        String sql = this.sqlUserFullname(username);
        try {
            Connection conn = this.getConnection();
            try {
                Statement stmt = conn.createStatement(1004, 1007);
                ResultSet rs = stmt.executeQuery(sql);
                if (rs.next()) {
                    result = CmsUser.getFullname(rs.getString("sirname"), rs.getString("firstname"), username);
                }
                stmt.close();
            }
            catch (SQLException ex) {
                this.getApplication().getLogger().log(Level.SEVERE, "SQL error using: " + sql, ex);
            }
            this.freeConnection(conn);
        }
        catch (SQLException ex) {
            this.getApplication().getLogger().log(Level.SEVERE, "SQL connection error", ex);
        }
        return result;
    }

    public ArrayList<String> getUsernames() {
        return this.getUsernames(false);
    }

    public ArrayList<String> getUsernames(boolean all) {
        ArrayList<String> result = new ArrayList<String>();
        List<DataRecord> recs = this.executeQuery(this.sqlUserGetNames(), true).getResult();
        for (DataRecord rec : recs) {
            String name = rec.getString("username");
            if (!all && name.startsWith("_")) continue;
            result.add(name);
        }
        return result;
    }

    protected String sqlUserGetId(String username) {
        return "SELECT u.idelement FROM tdtaUser AS u INNER JOIN tdtaelement AS e ON (u.idelement=e.idelement) WHERE username = '" + username + "' AND NOT e.deleted";
    }

    protected String sqlUserGetName(long id) {
        return "SELECT u.username FROM tdtaUser AS u INNER JOIN tdtaelement AS e ON (u.idelement=e.idelement) WHERE u.idelement = " + id + " AND NOT e.deleted";
    }

    protected String sqlUserGetNames() {
        return "SELECT u.username FROM tdtaUser AS u INNER JOIN tdtaelement AS e ON (u.idelement=e.idelement) WHERE NOT e.deleted";
    }

    String sqlUserFullname(String username) {
        return "SELECT sirname,firstname FROM tdtaUser WHERE username = '" + username + "'";
    }

    public long checkGroup(String groupname) {
        long result = -1L;
        String sql = this.sqlGroupGetId(groupname);
        try {
            Connection conn = this.getConnection();
            try {
                Statement stmt = conn.createStatement(1004, 1007);
                ResultSet rs = stmt.executeQuery(sql);
                if (rs.next()) {
                    result = rs.getLong("idelement");
                }
                stmt.close();
            }
            catch (SQLException ex) {
                this.getApplication().getLogger().log(Level.SEVERE, "SQL error using: " + sql, ex);
            }
            this.freeConnection(conn);
        }
        catch (SQLException ex) {
            this.getApplication().getLogger().log(Level.SEVERE, "SQL connection error", ex);
        }
        return result;
    }

    protected String sqlGroupGetId(String groupname) {
        return "SELECT g.idelement FROM tdtaGroup AS g INNER JOIN tdtaelement AS e ON (g.idelement=e.idelement) WHERE g.groupname = '" + groupname + "' AND NOT e.deleted";
    }

    public String checkGroup(long idgroup) {
        String result = "-";
        String sql = this.sqlGroupGetName(idgroup);
        try {
            Connection conn = this.getConnection();
            try {
                Statement stmt = conn.createStatement(1004, 1007);
                ResultSet rs = stmt.executeQuery(sql);
                if (rs.next()) {
                    result = rs.getString("groupname");
                }
                stmt.close();
            }
            catch (SQLException ex) {
                this.getApplication().getLogger().log(Level.SEVERE, "SQL error using: " + sql, ex);
            }
            this.freeConnection(conn);
        }
        catch (SQLException ex) {
            this.getApplication().getLogger().log(Level.SEVERE, "SQL connection error", ex);
        }
        return result;
    }

    protected String sqlGroupGetName(long id) {
        return "SELECT g.groupname FROM tdtaGroup AS g INNER JOIN tdtaelement AS e ON (g.idelement=e.idelement) WHERE g.idelement = " + id + " AND NOT e.deleted";
    }

    public void updateLastLogin(CmsUser u, String loginip) {
        this.executeUpdate(this.sqlUserUpdateLogin(u.getId(), loginip), true);
    }

    protected String sqlUserUpdateLogin(long userid, String ip) {
        return "UPDATE tdtaUser SET lastlogin = '" + Util.formatDate((Date)new Date(), (String)Util.DATETIME_SQL, (TimeZone)this.getApplication().getTimeZone()) + "', loginip = " + Util.toSqlString((String)ip) + ", loggedin='t' WHERE idelement = " + userid;
    }

    public void updateLogout(CmsUser u) {
        this.executeUpdate(this.sqlUserUpdateLogout(u.getId()), true);
    }

    protected String sqlUserUpdateLogout(long userid) {
        return "UPDATE tdtaUser SET loggedin='f' WHERE idelement = " + userid;
    }

    public void createSystemUsers(String username) {
        this.executeUpdate(this.sqlCreateSystemUsers(username), true);
    }

    protected ArrayList<String> sqlCreateSystemUsers(String username) {
        ArrayList<String> sqls = new ArrayList<String>();
        long groupid = this.createId("idelement");
        sqls.add("INSERT INTO tdtaElement (idelement,elementtype,uuid,idworkflowstatus,metaowner,metacreator,idreadaccess,idwriteaccess,deleted,metamasterlang) VALUES (" + groupid + ",'group','" + UUID.randomUUID().toString() + "',4,null,null,4,4,'f','de') ");
        sqls.add("INSERT INTO tdtaElementLng (idelement,lang,title,summary,metatranslator,metacreated,metalastedit) VALUES (" + groupid + ",'de','" + username + "','System admin',null,now(),now())");
        sqls.add("INSERT INTO tdtaGroup (idElement,groupname,description) VALUES (" + groupid + ",'" + username + "','')");
        sqls.add("INSERT INTO tdtaGroupLng (idElement,lang) VALUES (" + groupid + ",'" + this.app.getPrimaryLang() + "')");
        long userid = this.createId("idelement");
        sqls.add("INSERT INTO tdtaElement (idelement,elementtype,uuid,idworkflowstatus,metaowner,metacreator,idreadaccess,idwriteaccess,deleted,metamasterlang) VALUES (" + userid + ",'user','" + UUID.randomUUID().toString() + "',4," + groupid + ",null,4,4,'f','de') ");
        sqls.add("INSERT INTO tdtaElementLng (idelement,lang,title,summary,metatranslator,metacreated,metalastedit) VALUES (" + userid + ",'de','" + username + "','System admin',null,now(),now())");
        sqls.add("INSERT INTO tdtaUser (idElement,username,password,sirname,email,inactive,superadmin,maingroup,settings) VALUES (" + userid + ",'" + username + "','','System admin','','f','t'," + groupid + ",'')");
        sqls.add("INSERT INTO tdtaUserLng (idElement,lang) VALUES (" + userid + ",'" + this.app.getPrimaryLang() + "')");
        sqls.add("UPDATE tdtaElement SET metaowner = " + groupid + " WHERE idelement = " + groupid);
        sqls.add("UPDATE tdtaElement SET metacreator = " + userid + " WHERE idelement = " + groupid);
        sqls.add("UPDATE tdtaElementLng SET metatranslator = " + userid + " WHERE idelement = " + groupid);
        sqls.add("UPDATE tdtaElement SET metacreator = " + userid + " WHERE idelement = " + userid);
        sqls.add("UPDATE tdtaElementLng SET metatranslator = " + userid + " WHERE idelement = " + userid);
        return sqls;
    }

    public long getNextCounter(String table, String field) {
        return this.getNextCounter(table, field, null, false);
    }

    public long getNextCounter(String table, String field, String condition, boolean closegap) {
        String sql = closegap ? this.sqlNextCounterCloseGap(table, field, condition) : this.sqlNextCounter(table, field, condition);
        long result = -1L;
        try {
            Connection conn = this.getConnection();
            try {
                Statement stmt = conn.createStatement(1004, 1007);
                ResultSet rs = stmt.executeQuery(sql);
                result = rs.next() ? rs.getLong("counter") : 1L;
                stmt.close();
            }
            catch (SQLException ex) {
                this.getApplication().getLogger().log(Level.SEVERE, "SQL error using " + sql, ex);
            }
            this.freeConnection(conn);
        }
        catch (SQLException ex) {
            this.getApplication().getLogger().log(Level.SEVERE, "SQL connection error", ex);
        }
        if (result == 0L) {
            ++result;
        }
        return result;
    }

    public String sqlNextCounter(String table, String field, String condition) {
        return "SELECT (max(" + field + ")+1) AS counter FROM " + table + (condition == null ? "" : " WHERE " + condition);
    }

    public String sqlNextCounterCloseGap(String table, String field, String condition) {
        return "SELECT  MIN(" + field + ") + 1 AS counter FROM " + table + " AS mo  WHERE NOT EXISTS (SELECT NULL FROM " + table + " AS " + table + " WHERE mi." + field + " = mo." + field + " + 1 " + (condition == null ? "" : " AND " + condition) + " )";
    }

    public long getNextLocationNumber(long idlocation) {
        return this.getNextLocationNumber("NOT l.building AND l.idelement!=" + idlocation);
    }

    public long getNextLocationNumberForPlan(long idlocation, long idplan) {
        String cond = "NOT l.building AND l.idelement!=" + idlocation + " AND r1.elementto = " + idplan;
        if (idplan < 0L) {
            cond = "l.idelement NOT IN (SELECT l.idelement FROM tdtaelelocation AS l LEFT JOIN tdtarelation AS r1 ON (l.idelement=r1.elementfrom AND r1.relationcode='locationplan') LEFT JOIN tdtaRelation AS r2 ON (r2.elementfrom=r1.elementto AND r2.relationcode='planbuilding') WHERE NOT l.building AND l.idelement!=" + idlocation + " AND r1.elementto is not null) AND NOT l.building AND l.idelement!=" + idlocation;
        }
        return this.getNextLocationNumber(cond);
    }

    public long getNextBuildingNumber(long idlocation) {
        String cond = "l.building AND l.idelement!=" + idlocation;
        return this.getNextLocationNumber(cond);
    }

    public long getNextLocationNumberForBuilding(long idlocation, long idbuilding) {
        String cond = "NOT l.building AND l.idelement!=" + idlocation + " AND r2.elementto = " + idbuilding;
        if (idbuilding < 0L) {
            cond = "l.idelement NOT IN (SELECT l.idelement FROM tdtaelelocation AS l LEFT JOIN tdtarelation AS r1 ON (l.idelement=r1.elementfrom AND r1.relationcode='locationplan') LEFT JOIN tdtaRelation AS r2 ON (r2.elementfrom=r1.elementto AND r2.relationcode='planbuilding') WHERE NOT l.building AND l.idelement!=" + idlocation + " AND r2.elementto is not null) AND NOT l.building AND l.idelement!=" + idlocation;
        }
        return this.getNextLocationNumber(cond);
    }

    protected long getNextLocationNumber(String sqlcondition) {
        DataRecord rec = this.executeQuery(this.sqlNextLocationNumber(sqlcondition), true).firstRow();
        if (rec != null) {
            return rec.getLong("counter");
        }
        return 1L;
    }

    protected String sqlNextLocationNumber(String condition) {
        return "SELECT max(l.number)+1 AS counter FROM tdtaelelocation AS l INNER JOIN tdtaElement AS e ON (l.idelement=e.idelement) LEFT JOIN tdtarelation AS r1 ON (l.idelement=r1.elementfrom AND r1.relationcode='locationplan') LEFT JOIN tdtaRelation AS r2 ON (r2.elementfrom=r1.elementto AND r2.relationcode='planbuilding') WHERE NOT e.deleted " + (condition == null ? "" : " AND " + condition);
    }

    public boolean hasLocationNumber(long number) {
        return this.hasLocationNumber("NOT l.building AND l.number=" + number);
    }

    public boolean hasLocationNumberForPlan(long number, long idplan) {
        String cond = "NOT l.building AND l.number=" + number + " AND r1.elementto = " + idplan;
        if (idplan < 0L) {
            cond = "l.idelement NOT IN (SELECT l.idelement FROM tdtaelelocation AS l LEFT JOIN tdtarelation AS r1 ON (l.idelement=r1.elementfrom AND r1.relationcode='locationplan') LEFT JOIN tdtaRelation AS r2 ON (r2.elementfrom=r1.elementto AND r2.relationcode='planbuilding') WHERE NOT l.building AND r1.elementto is not null) AND NOT l.building AND l.number=" + number;
        }
        return this.hasLocationNumber(cond);
    }

    public boolean hasLocationNumberForBuilding(long number, long idbuilding) {
        String cond = "NOT l.building AND l.number=" + number + " AND r2.elementto = " + idbuilding;
        if (idbuilding < 0L) {
            cond = "l.idelement NOT IN (SELECT l.idelement FROM tdtaelelocation AS l LEFT JOIN tdtarelation AS r1 ON (l.idelement=r1.elementfrom AND r1.relationcode='locationplan') LEFT JOIN tdtaRelation AS r2 ON (r2.elementfrom=r1.elementto AND r2.relationcode='planbuilding') WHERE NOT l.building AND r2.elementto is not null) AND NOT l.building AND l.number=" + number;
        }
        return this.hasLocationNumber(cond);
    }

    public boolean hasBuildingNumber(long number) {
        String cond = "l.building AND l.number=" + number;
        return this.hasLocationNumber(cond);
    }

    protected boolean hasLocationNumber(String sqlcondition) {
        DataRecord rec = this.executeQuery(this.sqlGetLocationNumber(sqlcondition), true).firstRow();
        return rec != null;
    }

    protected String sqlGetLocationNumber(String condition) {
        return "SELECT l.number AS number FROM tdtaelelocation AS l INNER JOIN tdtaElement AS e ON (l.idelement=e.idelement) LEFT JOIN tdtarelation AS r1 ON (l.idelement=r1.elementfrom AND r1.relationcode='locationplan') LEFT JOIN tdtaRelation AS r2 ON (r2.elementfrom=r1.elementto AND r2.relationcode='planbuilding') WHERE NOT e.deleted " + (condition == null ? "" : " AND " + condition);
    }

    public ArrayList<Long> getLocationGroupsInUse() {
        return this.executeQuery(this.sqlLocationGroupsInUse(), true).getResultIds();
    }

    protected String sqlLocationGroupsInUse() {
        return "SELECT g.idelement AS meta_id FROM tdtaElement AS g INNER JOIN tdtaRelation AS r ON (g.idelement=r.elementto AND r.relationcode='locationgroup') INNER JOIN tdtaElement AS l ON (r.elementfrom=l.idelement) WHERE NOT g.deleted AND NOT l.deleted";
    }

    public String getLocationNumberTitle(long id) {
        DataRecord rec = this.executeQuery(this.sqlLocationNumberTitle(id), true).firstRow();
        if (rec != null) {
            return "[" + rec.getString("number") + "] " + rec.getString("titel");
        }
        return "";
    }

    protected String sqlLocationNumberTitle(long id) {
        return "SELECT number,titel FROM tdtaelelocation WHERE idelement = " + id;
    }

    public int getTemplateItemSortMax() {
        Integer max = 0;
        DataRecord rec = this.executeQuery("SELECT max(itemsort) AS max FROM tdtaelelocationgroup", true).firstRow();
        max = rec == null ? max : Math.max(max, rec.getInt("max", 0));
        rec = this.executeQuery("SELECT max(itemsort) AS max FROM tdtaelelocationtemplate", true).firstRow();
        max = rec == null ? max : Math.max(max, rec.getInt("max", 0));
        rec = this.executeQuery("SELECT max(itemsort) AS max FROM tdtaeleobservationtemplate", true).firstRow();
        max = rec == null ? max : Math.max(max, rec.getInt("max", 0));
        rec = this.executeQuery("SELECT max(itemsort) AS max FROM tdtaelemeasuretemplate", true).firstRow();
        max = rec == null ? max : Math.max(max, rec.getInt("max", 0));
        return max;
    }

    public void insertComment(String comment, CmsUser user, long id) {
        System.out.println("INSERT INTO tdtacomment (idcomment, idelement, lang ,issuedate,comment, iduser,name,email) VALUES (" + this.getNextCounter("tdtacomment", "idcomment") + "," + id + ",'',now(),'" + comment + "'," + user.getId() + ",'" + user.getTitle() + "','" + user.getAttributeValue("email") + "')");
        this.executeUpdate("INSERT INTO tdtacomment (idcomment, idelement, lang ,issuedate,comment, iduser,name,email) VALUES (" + this.getNextCounter("tdtacomment", "idcomment") + "," + id + ",'',now(),'" + comment + "'," + user.getId() + ",'" + user.getTitle() + "','" + user.getAttributeValue("email") + "')", true);
    }

    public long getUserIdOfComment(long id) {
        List<DataRecord> result = this.executeQuery("SELECT iduser FROm tdtacomment where idcomment = " + id, true).getResult();
        Iterator<DataRecord> iterator = result.iterator();
        if (iterator.hasNext()) {
            DataRecord dataRecord = iterator.next();
            return dataRecord.getLong("iduser");
        }
        return 0L;
    }

    public void removeComment(long id) {
        this.executeUpdate("DELETE FROM tdtacomment WHERE idcomment=" + id, true);
    }

    public void addEventReference(long idevent, long idelement) {
        this.executeUpdate(this.sqlRemoveEventReference(idevent, idelement), true);
        this.executeUpdate(this.sqlAddEventReference(idevent, idelement), true);
    }

    protected String sqlAddEventReference(long idevent, long idelement) {
        return "INSERT INTO trelEventElement (idevent,idelement) values (" + idevent + "," + idelement + ")";
    }

    protected String sqlRemoveEventReference(long idevent, long idelement) {
        return "DELETE FROM trelEventElement where idevent=" + idevent + " AND idelement=" + idelement;
    }

    public boolean checkConnection(Properties projectProperties) {
        return false;
    }
}

