/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cms.storage;

import at.grid.cms.CmsApplication;
import at.grid.cms.storage.DataStorage;
import at.grid.util.db.ConnectionPool;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;

public class DerbyDatastorage
extends DataStorage {
    protected long sequenceid = -1L;

    public DerbyDatastorage(CmsApplication app, Properties props) {
        super(app, props);
        String poolsize = props.getProperty("db.poolsize", "5");
        String dbdriver = this.getDriver();
        try {
            this.pool = new ConnectionPool(dbdriver, props.getProperty("db.uri"), props.getProperty("db.user"), null, 1, Integer.parseInt(poolsize), true);
        }
        catch (SQLException ex) {
            this.getApplication().getLogger().log(Level.SEVERE, "SQL Exception", ex);
        }
        catch (NumberFormatException ex) {
            this.getApplication().getLogger().log(Level.SEVERE, "Poolsize is could not be parsed", ex);
        }
    }

    public final String getDriver() {
        return "org.apache.derby.jdbc.EmbeddedDriver";
    }

    @Override
    public String verifyProperties() {
        Properties p = this.getProperties();
        if (p.getProperty("db.user") == null) {
            return "Missing database user [db.user]";
        }
        if (p.getProperty("db.uri") == null) {
            return "Missing database URI [db.uri]";
        }
        return null;
    }

    @Override
    public String getFieldType(int atttype, int length) {
        switch (atttype) {
            case 1: {
                return "CHAR(1)";
            }
            case 18: {
                return null;
            }
            case 2: {
                return "TIMESTAMP";
            }
            case 3: {
                return "FLOAT";
            }
            case 16: {
                return null;
            }
            case 7: {
                return "INT";
            }
            case 8: {
                return "BIGINT";
            }
            case 9: {
                return "BIGINT";
            }
            case 10: {
                return null;
            }
            case 14: {
                return "BIGINT";
            }
            case 17: {
                return null;
            }
            case 12: {
                return "VARCHAR(" + length + ")";
            }
            case 13: {
                return "VARCHAR(10000)";
            }
            case 15: {
                return null;
            }
        }
        throw new IllegalArgumentException("Unknown attribute type: " + atttype);
    }

    public void setDerbyHome() {
        String derbyHome = this.getApplication().getProperty("db.home", null);
        if (derbyHome != null && !derbyHome.equalsIgnoreCase("")) {
            System.setProperty("derby.system.home", derbyHome);
            this.getApplication().getLogger().log(Level.INFO, "Derby database location : " + derbyHome);
        } else {
            String userHomeDir = System.getProperty("user.home", ".");
            String systemDir = userHomeDir + "/." + this.getApplication().getProjectCode();
            System.setProperty("derby.system.home", systemDir);
            this.getApplication().getLogger().log(Level.INFO, "Derby database location : " + systemDir);
        }
    }

    @Override
    public boolean checkAndCreateDatabase(Properties props) {
        String user = props.getProperty("db.user");
        String uri = props.getProperty("db.uri");
        String password = props.getProperty("db.password");
        try {
            Class.forName(this.getDriver());
        }
        catch (ClassNotFoundException cnfe) {
            System.out.println("Can't find class for database driver: " + this.getDriver());
            throw new Error("Application error, unable to continue");
        }
        Properties p = new Properties();
        if (user != null) {
            p.setProperty("user", user);
        }
        if (password != null) {
            p.setProperty("password", password);
        }
        p.setProperty("create", "true");
        try {
            Connection c = DriverManager.getConnection(uri, p);
            this.getApplication().getLogger().log(Level.INFO, "Ok, database is available");
            return true;
        }
        catch (SQLException ex) {
            this.getApplication().getLogger().log(Level.INFO, "Cannot initialise database, terminating");
            throw new Error("Application error, unable to continue");
        }
    }

    @Override
    protected boolean createDatabase(String uri_base, String template, String dbname, Properties p) {
        return false;
    }
}

