/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cms.storage;

import at.grid.cms.CmsApplication;
import at.grid.cms.storage.DataStorage;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class H2Datastorage
extends DataStorage {
    private Connection conn;

    public H2Datastorage() {
    }

    public H2Datastorage(CmsApplication app, Properties props) {
        super(app, props);
    }

    public String getDriver() {
        return "org.h2.Driver";
    }

    @Override
    public boolean isConnected() {
        return this.conn != null;
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        if (this.conn == null) {
            Properties connectionProperties = new Properties();
            connectionProperties.setProperty("user", this.getProperties().getProperty("db.user"));
            String pwd = this.getProperties().getProperty("db.password");
            if (pwd != null) {
                connectionProperties.setProperty("password", pwd);
            }
            this.conn = DriverManager.getConnection(this.getProperties().getProperty("db.uri"), connectionProperties);
        }
        return this.conn;
    }

    @Override
    public void close() {
        if (this.conn != null) {
            try {
                this.executeUpdate("SHUTDOWN", true);
                this.conn.close();
                this.conn = null;
            }
            catch (SQLException ex) {
                Logger.getLogger(H2Datastorage.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public synchronized void freeConnection(Connection conn) throws SQLException {
    }

    @Override
    public String verifyProperties() {
        Properties p = this.getProperties();
        if (p.getProperty("db.user") == null) {
            return "Missing database user [db.user]";
        }
        if (p.getProperty("db.uri") == null) {
            return "Missing database URI [db.uri]";
        }
        return null;
    }

    @Override
    public String getFieldType(int atttype, int length) {
        switch (atttype) {
            case 1: {
                return "BOOLEAN";
            }
            case 18: {
                return null;
            }
            case 2: {
                return "TIMESTAMP";
            }
            case 3: {
                return "FLOAT";
            }
            case 16: {
                return null;
            }
            case 7: {
                return "INT";
            }
            case 8: {
                return "BIGINT";
            }
            case 9: {
                return "BIGINT";
            }
            case 22: {
                return "BIGINT";
            }
            case 10: {
                return null;
            }
            case 14: {
                return "BIGINT";
            }
            case 17: {
                return null;
            }
            case 12: {
                return "VARCHAR(" + length + ")";
            }
            case 13: {
                return "VARCHAR";
            }
            case 15: {
                return null;
            }
        }
        throw new IllegalArgumentException("Unknown attribute type: " + atttype);
    }

    @Override
    public String getByteArrayFieldType() {
        return "binary";
    }

    @Override
    public boolean checkAndCreateDatabase(Properties props) throws SQLException {
        String user = props.getProperty("db.user");
        String uri = props.getProperty("db.uri");
        String password = props.getProperty("db.password");
        this.getApplication().getLogger().info("Checking database '" + uri + "' ... ");
        try {
            Class.forName(this.getDriver());
        }
        catch (ClassNotFoundException cnfe) {
            System.out.println("Can't find class for database driver: " + this.getDriver());
            throw new Error("Application error, unable to continue");
        }
        Properties p = new Properties();
        if (user != null) {
            p.setProperty("user", user);
        }
        if (password != null) {
            p.setProperty("password", password);
        }
        try {
            Connection c = DriverManager.getConnection(uri, p);
            if (c != null) {
                this.getApplication().getLogger().info("Ok, database is available");
            }
            return true;
        }
        catch (SQLException ex) {
            this.getApplication().getLogger().severe("Database connection problem: " + ex.getMessage());
            return false;
        }
    }

    @Override
    protected boolean createDatabase(String uri_base, String template, String dbname, Properties p) {
        return false;
    }

    @Override
    protected String sqlRenameColumn(String table, String oldcol, String newcol) {
        return "ALTER TABLE " + table + " ALTER " + oldcol + " RENAME TO " + newcol;
    }

    @Override
    public long updateSequence(String sequence, long val) {
        int count = this.executeUpdate(this.sqlSequenceSetval(sequence, val), true);
        if (count >= 0) {
            return val;
        }
        return -1L;
    }

    @Override
    public String sqlSequenceSetval(String sequence, long val) {
        return "alter sequence " + sequence + " restart with " + val;
    }
}

