/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cms.storage;

import at.grid.cms.CmsApplication;
import at.grid.cms.storage.DataStorage;
import at.grid.util.db.ConnectionPool;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;

public class MySQLDatastorage
extends DataStorage {
    protected long sequenceid = -1L;

    public MySQLDatastorage(CmsApplication app, Properties props) {
        super(app, props);
        String poolsize = props.getProperty("db.poolsize", "5");
        String dbdriver = this.getDriver();
        try {
            this.pool = new ConnectionPool(dbdriver, props.getProperty("db.uri"), props.getProperty("db.user"), props.getProperty("db.password"), 1, Integer.parseInt(poolsize), true);
        }
        catch (SQLException ex) {
            this.getApplication().getLogger().log(Level.SEVERE, "SQL Exception", ex);
        }
        catch (NumberFormatException ex) {
            this.getApplication().getLogger().log(Level.SEVERE, "Poolsize is could not be parsed", ex);
        }
    }

    public String getDriver() {
        return "org.apache.derby.jdbc.EmbeddedDriver";
    }

    @Override
    public String verifyProperties() {
        Properties p = this.getProperties();
        if (p.getProperty("db.user") == null) {
            return "Missing database user [db.user]";
        }
        if (p.getProperty("db.uri") == null) {
            return "Missing database URI [db.uri]";
        }
        return null;
    }

    @Override
    public String sqlSequenceNextval(String sequence) {
        return "SELECT MAX(DISTINCT id) FROM cms_sequence";
    }

    @Override
    public String getFieldType(int atttype, int length) {
        switch (atttype) {
            case 1: {
                return "BOOLEAN";
            }
            case 18: {
                return null;
            }
            case 2: {
                return "TIMESTAMP";
            }
            case 3: {
                return "FLOAT";
            }
            case 16: {
                return null;
            }
            case 7: {
                return "INT";
            }
            case 8: {
                return "BIGINT";
            }
            case 9: {
                return "BIGINT";
            }
            case 22: {
                return "BIGINT";
            }
            case 10: {
                return null;
            }
            case 14: {
                return "BIGINT";
            }
            case 17: {
                return null;
            }
            case 12: {
                return "VARCHAR(" + length + ")";
            }
            case 13: {
                return "TEXT";
            }
            case 15: {
                return null;
            }
        }
        throw new IllegalArgumentException("Unknown attribute type: " + atttype);
    }

    @Override
    public boolean checkAndCreateDatabase(Properties props) {
        String user = props.getProperty("db.user");
        String uri = props.getProperty("db.uri");
        String password = props.getProperty("db.password");
        this.getApplication().getLogger().log(Level.INFO, "Checking database '" + uri + "' ... ");
        try {
            Class.forName(this.getDriver());
        }
        catch (ClassNotFoundException cnfe) {
            System.out.println("Can't find class for database driver: " + this.getDriver());
            throw new Error("Application error, unable to continue");
        }
        Properties p = new Properties();
        if (user != null) {
            p.setProperty("user", user);
        }
        if (password != null) {
            p.setProperty("password", password);
        }
        try {
            Connection c = DriverManager.getConnection(uri, p);
            this.getApplication().getLogger().log(Level.INFO, "Ok, database is available");
            return true;
        }
        catch (SQLException sQLException) {
            this.getApplication().getLogger().log(Level.WARNING, "Cannot establish connection to database '" + uri + "', trying to initialise database");
            if (!this.createDatabase(uri, "", uri.substring(uri.lastIndexOf("/") + 1), p)) {
                this.getApplication().getLogger().log(Level.SEVERE, "Cannot initialise database, terminating");
                throw new Error("Application error, unable to continue");
            }
            this.getApplication().getLogger().log(Level.INFO, "Ok, database successfully initialised");
            return false;
        }
    }

    @Override
    protected boolean createDatabase(String uri_base, String template, String dbname, Properties p) {
        String sqlCreate = "CREATE DATABASE " + dbname + " CHARACTER SET utf8";
        try {
            Connection c = DriverManager.getConnection(uri_base, p);
            try {
                c.createStatement(1004, 1007).execute(sqlCreate);
                this.getApplication().getLogger().log(Level.INFO, "Database '" + dbname + "' created");
                return true;
            }
            catch (SQLException ex) {
                this.getApplication().getLogger().log(Level.SEVERE, "Cannot create database using SQL: " + sqlCreate + " TEMPLATE=" + template + ", terminating", ex);
                throw new Error("Application error, unable to continue");
            }
        }
        catch (SQLException ex) {
            this.getApplication().getLogger().log(Level.WARNING, "SQL Error : " + ex.getMessage());
            return false;
        }
    }
}

