/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cms.storage;

import at.grid.cms.CmsApplication;
import at.grid.cms.storage.DataStorage;
import at.grid.util.db.ConnectionPool;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;

public class PostgresDatastorage
extends DataStorage {
    public PostgresDatastorage() {
    }

    public PostgresDatastorage(CmsApplication app, Properties props) {
        super(app, props);
    }

    @Override
    public void postInitialise(CmsApplication app, Properties props) {
        super.postInitialise(app, props);
        String poolsize = props.getProperty("db.poolsize", "5");
        String dbdriver = this.getDriver();
        String dburi = props.getProperty("db.uri");
        String dbuser = props.getProperty("db.user");
        this.getApplication().getLogger().info("Creating postgresql datastorage class for database " + dburi + " with user " + dbuser + " ...");
        try {
            this.pool = new ConnectionPool(dbdriver, dburi, dbuser, props.getProperty("db.password"), 1, Integer.parseInt(poolsize), true);
            this.getApplication().getLogger().info("Connection pool created");
        }
        catch (SQLException ex) {
            this.getApplication().getLogger().log(Level.SEVERE, "Could not create connection pool to DB : " + ex.getMessage(), ex);
        }
        catch (NumberFormatException ex) {
            this.getApplication().getLogger().log(Level.SEVERE, null, ex);
        }
    }

    public String getDriver() {
        return "org.postgresql.Driver";
    }

    @Override
    public String verifyProperties() {
        Properties p = this.getProperties();
        if (p.getProperty("db.user") == null) {
            return "Missing database user [db.user]";
        }
        if (p.getProperty("db.uri") == null) {
            return "Missing database URI [db.uri]";
        }
        return null;
    }

    @Override
    public String getFieldType(int atttype, int length) {
        switch (atttype) {
            case 1: {
                return "BOOLEAN";
            }
            case 18: {
                return null;
            }
            case 2: {
                return "TIMESTAMP";
            }
            case 3: {
                return "FLOAT";
            }
            case 16: {
                return null;
            }
            case 7: {
                return "INT";
            }
            case 22: {
                return "BIGINT";
            }
            case 8: {
                return "BIGINT";
            }
            case 9: {
                return "BIGINT";
            }
            case 10: {
                return null;
            }
            case 14: {
                return "BIGINT";
            }
            case 17: {
                return null;
            }
            case 12: {
                return "VARCHAR(" + length + ")";
            }
            case 13: {
                return "TEXT";
            }
            case 15: {
                return null;
            }
        }
        throw new IllegalArgumentException("Unknown attribute type: " + atttype);
    }

    @Override
    public boolean checkAndCreateDatabase(Properties props) {
        String user = props.getProperty("db.user");
        String uri = props.getProperty("db.uri");
        String pwd = props.getProperty("db.password");
        this.getApplication().getLogger().log(Level.INFO, "Checking database '" + uri + "' ... ");
        try {
            Class.forName(this.getDriver());
        }
        catch (ClassNotFoundException cnfe) {
            System.out.println("Can't find class for database driver: " + this.getDriver());
            throw new Error("Application error, unable to continue");
        }
        Properties p = new Properties();
        if (user != null) {
            p.setProperty("user", user);
        }
        if (pwd != null) {
            p.setProperty("password", pwd);
        }
        try {
            Connection c = DriverManager.getConnection(uri, p);
            this.getApplication().getLogger().log(Level.INFO, "Ok, database is available");
            return true;
        }
        catch (SQLException sQLException) {
            String uri_base = uri.substring(0, uri.lastIndexOf("/")) + "/";
            this.getApplication().getLogger().log(Level.WARNING, "Cannot establish connection to database '" + uri + "', trying to initialise database");
            if (this.createDatabase(uri_base + "/template0", uri.substring(uri.lastIndexOf("/") + 1), "template0", p)) {
                this.getApplication().getLogger().log(Level.INFO, "Using template 'template0'");
            } else if (this.createDatabase(uri_base + "/template1", uri.substring(uri.lastIndexOf("/") + 1), "template1", p)) {
                this.getApplication().getLogger().log(Level.INFO, "Using template 'template1'");
            } else if (this.createDatabase(uri_base + "/template_postgis", uri.substring(uri.lastIndexOf("/") + 1), "template_postgis", p)) {
                this.getApplication().getLogger().log(Level.INFO, "Using template 'template_postgis'");
            } else if (this.createDatabase(uri_base + "/postgres", uri.substring(uri.lastIndexOf("/") + 1), "postgres", p)) {
                this.getApplication().getLogger().log(Level.INFO, "Using template 'postgres'");
            } else if (this.createDatabase(uri_base + "/template2", uri.substring(uri.lastIndexOf("/") + 1), "template2", p)) {
                this.getApplication().getLogger().log(Level.INFO, "Using template 'template2'");
            } else {
                this.getApplication().getLogger().log(Level.SEVERE, "Cannot initialise database, terminating");
                throw new Error("Application error, unable to continue");
            }
            this.getApplication().getLogger().log(Level.INFO, "Ok, database successfully initialised");
            return false;
        }
    }

    @Override
    protected String sqlCreateDatabase(String dbName, String dbOwner, String template) {
        return "CREATE DATABASE " + dbName + " ENCODING='utf8' OWNER=" + dbOwner + " -T " + template;
    }
}

