/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cms.storage;

import at.grid.cms.CmsApplication;
import at.grid.cms.element.CmsElementSummary;
import at.grid.cms.element.CmsUser;
import at.grid.cms.storage.DataRecord;
import at.grid.cms.swing.CmsBasicElement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;

public class SearchResult {
    List<DataRecord> result = new ArrayList<DataRecord>();
    int rowPointer = 0;
    List<String> columns = new ArrayList<String>();
    List<Integer> columntypes = null;
    String idcolumn = "meta_id";
    String sql;
    boolean error = false;
    CmsApplication app;
    CmsUser user = null;

    public SearchResult() {
        this.error = true;
    }

    protected CmsApplication getApplication() {
        return this.app;
    }

    public SearchResult(ResultSet rs, CmsApplication app) throws SQLException {
        this(rs, null, app);
    }

    public SearchResult(ResultSet rs, CmsUser u, CmsApplication app) throws SQLException {
        this.app = app;
        this.user = u;
        if (rs == null) {
            this.error = true;
            return;
        }
        int count = rs.getMetaData().getColumnCount();
        this.columns = new ArrayList<String>();
        this.columntypes = new ArrayList<Integer>();
        for (int ii = 0; ii < count; ++ii) {
            this.columns.add(rs.getMetaData().getColumnLabel(ii + 1).toLowerCase(Locale.ENGLISH));
            this.columntypes.add(rs.getMetaData().getColumnType(ii + 1));
        }
        while (rs.next()) {
            DataRecord rec = new DataRecord(this, rs);
            this.result.add(rec);
        }
    }

    public SearchResult(SearchResult res) {
        this.columns = new ArrayList<String>();
        this.columntypes = new ArrayList<Integer>();
        int count = res.getColumnCount();
        for (int ii = 0; ii < count; ++ii) {
            this.columns.add(res.getColumn(ii));
            this.columntypes.add(res.getColumnType(ii));
        }
    }

    public void setUser(CmsUser u) {
        this.user = u;
    }

    public void addColumn(String col) {
        this.columns.add(col);
        for (DataRecord rec : this.result) {
            rec.add(col, "");
        }
    }

    public void addRecord(DataRecord rec) {
        this.result.add(rec);
    }

    public void setIdColumn(String columnname) {
        this.idcolumn = columnname;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String getSql() {
        return this.sql;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public boolean hasColumn(String col) {
        return this.columns.contains(col);
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public String getColumn(int index) {
        return this.columns.get(index);
    }

    public void addColumn(String label, int type) {
        this.columns.add(label);
        this.columntypes.add(type);
    }

    public int getColumnType(int index) {
        return this.columntypes.get(index);
    }

    public int getColumnType(String label) {
        int idx = this.columns.indexOf(label);
        if (idx < 0) {
            return 1111;
        }
        return this.columntypes.get(idx);
    }

    public int size() {
        return this.result.size();
    }

    public boolean isEmpty() {
        return this.result.isEmpty();
    }

    public boolean hasError() {
        return this.error;
    }

    public DataRecord firstRow() {
        if (!this.isEmpty()) {
            this.rowPointer = 1;
            return this.result.get(this.rowPointer - 1);
        }
        return null;
    }

    public DataRecord nextRow() {
        if (this.hasNextRow()) {
            ++this.rowPointer;
            return this.result.get(this.rowPointer - 1);
        }
        return null;
    }

    public DataRecord previousRow() {
        if (this.hasPreviousRow()) {
            --this.rowPointer;
            return this.result.get(this.rowPointer - 1);
        }
        return null;
    }

    public boolean hasNextRow() {
        return this.rowPointer < this.size();
    }

    public boolean hasPreviousRow() {
        return this.rowPointer > 1;
    }

    public List<DataRecord> getResult() {
        if (this.result == null) {
            this.getApplication().getLogger().log(Level.WARNING, "No result");
            return null;
        }
        return this.result;
    }

    public ArrayList<Long> getResultIds() {
        ArrayList<Long> l = new ArrayList<Long>();
        if (this.result == null) {
            return l;
        }
        if (!this.hasColumn(this.idcolumn)) {
            return l;
        }
        for (DataRecord item : this.result) {
            l.add(Long.parseLong(item.get(this.idcolumn)));
        }
        return l;
    }

    public ArrayList<Long> getDistinctResultIds() {
        ArrayList<Long> l = new ArrayList<Long>();
        if (this.result == null) {
            return l;
        }
        if (!this.hasColumn(this.idcolumn)) {
            return l;
        }
        for (DataRecord item : this.result) {
            Long id = Long.parseLong(item.get(this.idcolumn));
            if (l.contains(id)) continue;
            l.add(id);
        }
        return l;
    }

    public ArrayList<CmsElementSummary> getResultAsElementSummary() {
        ArrayList<CmsElementSummary> resultlist = new ArrayList<CmsElementSummary>();
        for (DataRecord rec : this.getResult()) {
            resultlist.add(new CmsElementSummary(this.app, rec, this.user));
        }
        return resultlist;
    }

    public ArrayList<CmsBasicElement> getResultAsBasicElements() {
        return this.getResultAsBasicElements(null);
    }

    public ArrayList<CmsBasicElement> getResultAsBasicElements(String ... attributes) {
        ArrayList<CmsBasicElement> resultlist = new ArrayList<CmsBasicElement>();
        for (DataRecord rec : this.getResult()) {
            CmsBasicElement ele = new CmsBasicElement(rec);
            if (attributes != null) {
                for (String att : attributes) {
                    ele.setAttribute(att, rec.getString(att));
                }
            }
            resultlist.add(ele);
        }
        return resultlist;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Number of records : " + this.size()).append("\n");
        for (DataRecord rec : this.getResult()) {
            sb.append(rec.toString()).append("\n");
        }
        return sb.toString();
    }
}

