/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cms.swing;

import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsElementSummary;
import at.grid.cms.storage.DataRecord;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CmsBasicElement {
    private long id;
    private String title;
    private HashMap<String, String> attributes = new HashMap();

    public CmsBasicElement(ResultSet rs) throws SQLException {
        if (rs.isBeforeFirst()) {
            rs.next();
        }
        if (rs.isAfterLast()) {
            throw new SQLException("no data in result set");
        }
        try {
            this.id = rs.getLong("meta_id");
            this.title = rs.getString("meta_title");
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public CmsBasicElement(DataRecord rec) {
        this.id = rec.getLong("meta_id");
        this.title = rec.getString("meta_title");
    }

    public CmsBasicElement(long id, String title) {
        this.id = id;
        this.title = title;
    }

    public CmsBasicElement(CmsElementSummary e) {
        this.id = e.getId();
        this.title = e.getTitle();
    }

    public CmsBasicElement(CmsElement e) {
        this.id = e.getId();
        this.title = e.getTitle();
    }

    public long getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String t) {
        this.title = t;
    }

    public String toString() {
        return this.title;
    }

    public CmsBasicElement setAttribute(String att, String val) {
        this.attributes.put(att, val);
        return this;
    }

    public String getAttribute(String att) {
        return this.attributes.get(att);
    }
}

