/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cms.user;

import at.grid.cms.CmsApplication;
import at.grid.cms.element.CmsUser;
import at.grid.cms.user.AuthenticationModule;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import javax.naming.AuthenticationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;

public class LDAPAuthentication
implements AuthenticationModule {
    private String base;
    private String url;
    private String port = "389";

    public void setBase(String base) {
        this.base = base;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setPort(String port) {
        this.port = port;
    }

    @Override
    public boolean authenticate(CmsApplication app, String username, String password) {
        try {
            this.getContext(username, password);
            return true;
        }
        catch (AuthenticationException ex) {
            return false;
        }
        catch (NamingException ex) {
            app.getLogger().log(Level.WARNING, "A problem occured during LDAP authentication", ex);
            return false;
        }
    }

    public DirContext getContext(String username, String password) throws NamingException {
        Hashtable<String, String> authEnv = new Hashtable<String, String>(11);
        String dn = "uid=" + username + "," + this.base;
        authEnv.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        authEnv.put("java.naming.provider.url", this.url + ":" + this.port);
        authEnv.put("java.naming.security.authentication", "simple");
        authEnv.put("java.naming.security.principal", dn);
        authEnv.put("java.naming.security.credentials", password);
        return new InitialDirContext(authEnv);
    }

    @Override
    public CmsUser getUser(CmsApplication app, String username) {
        CmsUser u = (CmsUser)app.createElement("user", app.getAdminUser());
        return u;
    }

    private List<String> findUsersByAccountName(CmsUser u, String pwd, String accountName) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        String snPrefix = accountName.substring(0, 2) + "*";
        String givenNamePrefix = accountName.substring(2) + "*";
        String searchFilter = "(&(objectClass=user)(sn=" + snPrefix + ")(givenName=" + givenNamePrefix + "))";
        SearchControls searchControls = new SearchControls();
        String[] resultAttributes = new String[]{"sn", "givenName", "sAMAccountName"};
        searchControls.setReturningAttributes(resultAttributes);
        searchControls.setSearchScope(2);
        Hashtable<String, String> authEnv = new Hashtable<String, String>(11);
        String dn = "uid=" + u.getUsername() + "," + this.base;
        authEnv.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        authEnv.put("java.naming.provider.url", this.url);
        authEnv.put("java.naming.security.authentication", "simple");
        authEnv.put("java.naming.security.principal", dn);
        authEnv.put("java.naming.security.credentials", pwd);
        InitialLdapContext ctx = new InitialLdapContext(authEnv, null);
        NamingEnumeration<SearchResult> results = ctx.search(this.base, searchFilter, searchControls);
        while (results.hasMoreElements()) {
            SearchResult searchResult = (SearchResult)results.nextElement();
            list.add(searchResult.toString());
        }
        return list;
    }
}

