/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cms.util;

import at.grid.util.Util;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DatabaseConverter {
    static String name = "kai_grid_v39.12";
    static String server = "192.168.123.106";
    static String user = "hk";
    static String pwd = "";
    private Connection conn;
    ArrayList<String> elementtypes = new ArrayList();
    Properties props = new Properties();

    public DatabaseConverter(String server, String port, String dbname, String user, String pwd) throws SQLException, ClassNotFoundException {
        Class.forName("org.postgresql.Driver");
        this.conn = DriverManager.getConnection("jdbc:postgresql://" + server + ":" + port + "/" + dbname + "", user, pwd);
    }

    private int executeUpdate(Statement stmt, String sql) {
        try {
            int result = stmt.executeUpdate(sql);
            Logger.getLogger(DatabaseConverter.class.getName()).info("OK - " + sql);
            return result;
        }
        catch (SQLException ex) {
            Logger.getLogger(DatabaseConverter.class.getName()).log(Level.SEVERE, ex.getMessage());
            return 0;
        }
    }

    public void updateDatabase() throws SQLException {
        Statement stmt = this.conn.createStatement();
        this.executeUpdate(stmt, "ALTER TABLE tdtaElementLng RENAME abstract TO summary");
        this.executeUpdate(stmt, "ALTER TABLE tdtaElement ADD elementtype VARCHAR(100)");
        this.executeUpdate(stmt, "UPDATE tdtaElement SET elementtype = tkeyElementtype.elementtypecode FROM tkeyElementtype WHERE tkeyElementtype.idElementtype = tdtaElement.idElementtype");
        this.executeUpdate(stmt, "ALTER TABLE tdtaElement DROP idElementtype");
        this.executeUpdate(stmt, "ALTER TABLE tdtaElement ADD idworkflowstatus BIGINT");
        this.executeUpdate(stmt, "UPDATE tdtaElement SET idworkflowstatus = tdtaElementLng.idstatus FROM tdtaElementLng WHERE tdtaElementLng.idElement=tdtaElement.idElement");
        this.executeUpdate(stmt, "ALTER TABLE tdtaElementLng DROP idstatus");
        this.executeUpdate(stmt, "ALTER TABLE tdtaRelation ADD relationcode VARCHAR(100)");
        this.executeUpdate(stmt, "ALTER TABLE tdtaRelation ADD orderfrom INT");
        this.executeUpdate(stmt, "ALTER TABLE tdtaRelation ADD orderto INT");
        this.executeUpdate(stmt, "UPDATE tdtaRelation  SET relationcode = tkeyRelationtype.relationtypeterm FROM tkeyRelationtype WHERE tkeyRelationtype.idRelationtype = tdtaRelation.idRelationtype");
        this.executeUpdate(stmt, "ALTER TABLE tdtaUser ADD loginip VARCHAR(50)");
        this.executeUpdate(stmt, "ALTER TABLE tdtaelement ALTER COLUMN metaowner DROP NOT NULL");
        this.executeUpdate(stmt, "ALTER TABLE tdtaelement ALTER COLUMN metacreator DROP NOT NULL");
        this.executeUpdate(stmt, "ALTER TABLE tdtaelementlng ALTER COLUMN metatranslator DROP NOT NULL");
        this.executeUpdate(stmt, "ALTER TABLE tdtaRelation DROP idrelationtype CASCADE ");
        this.executeUpdate(stmt, "ALTER TABLE tdtaRelation DROP idrelation CASCADE ");
        this.executeUpdate(stmt, "ALTER TABLE tdtaelement DROP CONSTRAINT \"$1\";");
        this.executeUpdate(stmt, "ALTER TABLE tdtaelement ALTER metaowner DROP not null;");
        this.executeUpdate(stmt, "ALTER TABLE tdtaelement ALTER metacreator DROP not null;");
        this.executeUpdate(stmt, "CREATE TABLE cms_config (version INTEGER, datetime TIMESTAMP, PRIMARY KEY(version));");
        this.executeUpdate(stmt, "INSERT INTO cms_config (version,datetime) VALUES (6,now())");
        this.executeUpdate(stmt, "DROP TABLE tkeyRelationtypeSpec CASCADE ");
        this.executeUpdate(stmt, "DROP TABLE tdtarelationatt CASCADE ");
        this.executeUpdate(stmt, "DROP TABLE tdtaAttributeRelLng CASCADE ");
        this.executeUpdate(stmt, "DROP TABLE tdtaAttributeRel CASCADE ");
        this.executeUpdate(stmt, "ALTER TABLE tdtaRelation DROP confirm ");
        this.executeUpdate(stmt, "ALTER TABLE tdtaRelation DROP confirminverse ");
        this.executeUpdate(stmt, "DROP TABLE tdtaattributeLng CASCADE");
        this.executeUpdate(stmt, "DROP TABLE tdtaattribute CASCADE");
        this.executeUpdate(stmt, "DROP TABLE tdtaattributesubLng CASCADE");
        this.executeUpdate(stmt, "DROP TABLE tdtaattributesub CASCADE ");
        this.executeUpdate(stmt, "DROP TABLE tkeyoccurence CASCADE ");
        this.executeUpdate(stmt, "DROP TABLE tkeyrelationtype CASCADE ");
        this.executeUpdate(stmt, "DROP TABLE tkeyattributetype CASCADE ");
        this.executeUpdate(stmt, "DROP TABLE tkeyelementtype CASCADE ");
        this.executeUpdate(stmt, "DROP TABLE tkeyelementtypeLng CASCADE ");
        stmt.close();
    }

    public void convertSubelement(String origTableCode, String newTableCode, String relationcode) throws SQLException {
        Statement stmt = this.conn.createStatement();
        this.executeUpdate(stmt, "CREATE TABLE tdtaEle" + newTableCode + " AS SELECT nextval('idelement') AS idelementneu,* FROM tdta" + origTableCode);
        this.executeUpdate(stmt, "ALTER TABLE tdtaEle" + newTableCode + " RENAME idelement TO idelementalt");
        this.executeUpdate(stmt, "ALTER TABLE tdtaEle" + newTableCode + " RENAME idelementneu TO idelement");
        this.executeUpdate(stmt, "ALTER TABLE tdtaEle" + newTableCode + " ADD PRIMARY KEY(idElement)");
        this.executeUpdate(stmt, "CREATE TABLE tdtaEle" + newTableCode + "Lng AS SELECT * FROM tdta" + origTableCode + "Lng");
        this.executeUpdate(stmt, "UPDATE tdtaEle" + newTableCode + "Lng SET idelement = tdtaEle" + newTableCode + ".idElement FROM tdtaEle" + newTableCode + " WHERE tdtaEle" + newTableCode + ".id" + origTableCode + "=tdtaEle" + newTableCode + "Lng.id" + origTableCode + "");
        this.executeUpdate(stmt, "ALTER TABLE tdtaEle" + newTableCode + "Lng ADD PRIMARY KEY(idElement,lang)");
        this.executeUpdate(stmt, "DROP TABLE tdta" + origTableCode + "Lng");
        this.executeUpdate(stmt, "DROP TABLE tdta" + origTableCode);
        this.executeUpdate(stmt, "INSERT INTO tdtaElement(idelement,metamasterlang,metaowner,metacreator,metanews,idreadaccess,idwriteaccess,sort,deleted,mainid,currentview,currentedit,elementtype,idworkflowstatus) SELECT o.idelement,'de',e.metaowner,e.metacreator,'f',e.idreadaccess,e.idwriteaccess,1,e.deleted,o.idelement,'t','t','" + newTableCode + "',e.idworkflowstatus FROM tdtaEle" + newTableCode + " AS o INNER JOIN tdtaElement AS e ON (o.idelementalt=e.idelement) ");
        this.executeUpdate(stmt, "INSERT INTO tdtaElementLng(idelement,lang,title,summary,metatranslator,metacreated,metalastedit) SELECT o.idelement,'de','(neu)','',2,now(),now() FROM tdtaEle" + newTableCode + " AS o ");
        this.executeUpdate(stmt, "INSERT INTO tdtaRelation (elementfrom,elementto,relationcode) SELECT idElementAlt,idElement,'" + relationcode + "' FROM tdtaEle" + newTableCode);
        stmt.close();
    }

    public void generateElementXml(File xmlfile, File propFile, String packagename) throws IOException {
        BufferedWriter fw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(xmlfile), Charset.forName("UTF-8")));
        fw.write(this.attributesToXml(packagename, packagename != null));
        fw.close();
        this.props.store(new FileWriter(propFile), "Created from IRMI database");
        System.out.println("XML and ResourceBundle generated");
    }

    public String attributesToXml(String packagename, boolean setClassFile) {
        String sql = "";
        String et = null;
        this.elementtypes.clear();
        ArrayList<String> keytables = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("\n<gridcms>");
        sb.append("\n    <!-- ============================================= ");
        sb.append("\n          ELEMENTTYPES ");
        sb.append("\n         ============================================= --> \n");
        sb.append("\n  <elementtypes>");
        try {
            String item;
            Statement stmt = this.conn.createStatement();
            sql = "select *, attributeterm as attterm from tdtaattribute inner join tkeyelementtype using (idelementtype) inner join tkeyattributetype using (idattributetype) inner join tdtaattributelng using (idattribute) where lang='de' order by elementtypecode,attributesort";
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                if (!rs.getString("elementtypecode").equals(et)) {
                    if (et != null) {
                        sb.append("\n    </elementtype>\n");
                    }
                    et = rs.getString("elementtypecode");
                    this.elementtypes.add(et);
                    sb.append("\n    <!-- ============================================= ");
                    sb.append("\n          Element " + et.toUpperCase());
                    sb.append("\n         ============================================= --> ");
                    sb.append("\n    <elementtype ");
                    if (setClassFile) {
                        sb.append("class=\"" + packagename + "." + et.substring(0, 1).toUpperCase() + et.substring(1).toLowerCase() + "Element\" ");
                    }
                    sb.append("code=\"" + et + "\" table=\"tdtaele" + et + "\">");
                }
                if (!"info".equals(rs.getString("attributetypeterm")) && !"georelation".equals(rs.getString("attributetypeterm")) && (item = this.getAttributeXml(this.conn.createStatement(), rs, et)) != null) {
                    sb.append(item);
                }
                if (!"key".equals(rs.getString("attributetypeterm")) && !"multikey".equals(rs.getString("attributetypeterm")) || keytables.contains(rs.getString("typespec"))) continue;
                keytables.add(rs.getString("typespec"));
            }
            sb.append("\n    </elementtype>\n");
            et = null;
            sql = "select *, 1 as idoccurence, attributesubterm as attterm, false as special from tdtaattributesub inner join tkeyattributetype using (idattributetype) inner join tdtaattributesublng using (idattributesub) where lang='de' order by subelement,idattributesub";
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                if (!rs.getString("subelement").equals(et)) {
                    if (et != null) {
                        sb.append("\n    </elementtype>\n");
                    }
                    et = rs.getString("subelement");
                    this.elementtypes.add(et);
                    sb.append("\n    <!-- ============================================= ");
                    sb.append("\n          (Sub)Element " + et.toUpperCase());
                    sb.append("\n         ============================================= --> ");
                    sb.append("\n    <elementtype ");
                    if (setClassFile) {
                        sb.append("class=\"" + packagename + "." + et.substring(0, 1).toUpperCase() + et.substring(1).toLowerCase() + "Element\" ");
                    }
                    sb.append("code=\"" + et + "\" table=\"tdtaele" + et + "\">");
                }
                if ((item = this.getAttributeXml(this.conn.createStatement(), rs, et)) != null) {
                    sb.append(item);
                }
                if (!"key".equals(rs.getString("attributetypeterm")) || keytables.contains(rs.getString("typespec"))) continue;
                keytables.add(rs.getString("typespec"));
            }
            sb.append("\n    </elementtype>\n");
            sb.append("\n  </elementtypes>\n");
            sb.append("\n    <!-- ============================================= ");
            sb.append("\n          KEYTABLES ");
            sb.append("\n         ============================================= --> \n");
            sb.append("\n  <keytables>");
            for (String keycode : keytables) {
                sb.append("\n    <keytable table=\"" + keycode + "\">");
                ResultSet rs2 = stmt.executeQuery("SELECT * FROM tkey" + keycode + " AS k INNER JOIN tkey" + keycode + "lng AS kl ON (k.id" + keycode + " = kl.id" + keycode + ") ORDER BY " + keycode + "sort");
                while (rs2.next()) {
                    if (!"de".equals(rs2.getString("lang"))) continue;
                    sb.append("\n      <item id=\"" + rs2.getString("id" + keycode) + "\" lang=\"" + rs2.getString("lang") + "\" term=\"" + rs2.getString(keycode + "term") + "\" />");
                }
                sb.append("\n    </keytable>");
            }
            sb.append("\n  </keytables>");
            sb.append("\n</gridcms>");
            stmt.close();
        }
        catch (SQLException ex) {
            Util.getLogger((String)this.getClass().getName()).log(Level.WARNING, "SQL error using: " + sql.toString() + "\n                    " + ex.getMessage());
        }
        return sb.toString();
    }

    private String getAttributeXml(Statement stmt, ResultSet rs, String elementtype) throws SQLException {
        String type = rs.getString("attributetypeterm");
        int idoccurence = rs.getInt("idoccurence");
        String attributeterm = rs.getString("attterm");
        String typespec = rs.getString("typespec");
        String code = rs.getString("code");
        boolean multilingual = rs.getBoolean("multilingual");
        String length = rs.getString("length");
        boolean virtual = rs.getBoolean("special");
        boolean invrelation = false;
        String relationtype = typespec;
        boolean subrelation = false;
        StringBuffer sb = new StringBuffer();
        if (length == null) {
            length = "20";
        }
        if ("longtext".equals(type)) {
            type = "textarea";
        } else if ("int".equals(type)) {
            type = "integer";
        } else if ("invrelation".equals(type)) {
            type = "relation";
            invrelation = true;
        } else if ("key".equals(type)) {
            if (idoccurence == 2 || idoccurence == 4) {
                type = "multikey";
            }
        } else if ("hierarchy".equals(type)) {
            type = "relation";
        } else if ("sub".equals(type)) {
            type = "relation";
            subrelation = true;
        }
        StringBuffer elementtypes = new StringBuffer();
        if ("relation".equals(type)) {
            ResultSet rs2 = stmt.executeQuery("SELECT idrelationtype FROM tkeyrelationtype WHERE relationtypeterm = '" + typespec + "'");
            if (rs2.next()) {
                relationtype = rs2.getString(1);
            }
            StringBuffer sql = new StringBuffer();
            if (invrelation) {
                sql.append("SELECT etfrom.elementtypecode AS fromcode ");
            } else {
                sql.append("SELECT etto.elementtypecode AS tocode ");
            }
            sql.append("FROM   tkeyRelationtypeSpec AS rts ");
            sql.append("       INNER JOIN tkeyRelationtype AS rt USING (idRelationtype) ");
            sql.append("       INNER JOIN tkeyElementtype AS etfrom ON (rts.elementtypefrom=etfrom.idElementtype) ");
            sql.append("       INNER JOIN tkeyElementtype AS etto ON (rts.elementtypeto=etto.idElementtype) ");
            sql.append("WHERE  rt.relationtypeterm='" + typespec + "' ");
            if (invrelation) {
                sql.append("       AND etto.elementtypecode='" + elementtype + "'");
            } else {
                sql.append("       AND etfrom.elementtypecode='" + elementtype + "'");
            }
            rs2 = stmt.executeQuery(sql.toString());
            while (rs2.next()) {
                if (elementtypes.length() > 0) {
                    elementtypes.append(",");
                }
                elementtypes.append(rs2.getString(1));
            }
        }
        sb.append("\n      <attribute ");
        if (code != null) {
            sb.append(" code=\"" + code + "\" ");
        }
        if (code.length() < 20) {
            sb.append("                    ".substring(code.length()));
        }
        sb.append(" type=\"" + type + "\" ");
        if (type.length() < 15) {
            sb.append("               ".substring(type.length()));
        }
        if (virtual) {
            sb.append(" virtual=\"true\"");
        }
        if ("button".equals(type)) {
            sb.append(" jsfunction=\"\" ");
            sb.append(" buttontext=\"" + attributeterm + "\" ");
            sb.append(" label=\"\" ");
        } else if ("section".equals(type)) {
            sb.append(" label=\"" + attributeterm + "\" ");
            this.props.setProperty("attribute." + elementtype + "." + code, attributeterm);
        } else {
            sb.append(" label=\"" + attributeterm + "\" ");
            this.props.setProperty("attribute." + elementtype + "." + code, attributeterm);
            if (!"image".equals(type)) {
                if ("upload".equals(type)) {
                    sb.append(" maxcount=\"-1\" ");
                } else if ("relation".equals(type)) {
                    sb.append(" relationcode=\"" + typespec + "\" ");
                    sb.append(" elementcodes=\"" + elementtypes.toString() + "\" ");
                    if (subrelation) {
                        sb.append(" category=\"" + typespec + "\"");
                        sb.append(" allowadd=\"true\"");
                        sb.append(" allowsearch=\"false\"");
                        sb.append(" deleteremoved=\"true\"");
                    } else {
                        if (idoccurence == 1 || idoccurence == 3) {
                            sb.append(" single=\"true\"");
                            sb.append(" field=\"id" + code + "\"");
                        }
                        if (invrelation) {
                            sb.append(" inverse=\"true\"");
                        }
                        if (rs.getBoolean("allowdetailadd")) {
                            sb.append(" allowadd=\"true\"");
                        }
                        sb.append(" allowsearch=\"true\"");
                        sb.append(" deleteremoved=\"false\"");
                    }
                } else if ("multikey".equals(type)) {
                    sb.append(" table=\"" + typespec + "\" ");
                } else if ("text".equals(type)) {
                    sb.append(" multilingual=\"" + (multilingual ? "true" : "false") + "\" ");
                    sb.append(" size=\"" + length + "\" ");
                    sb.append(" field=\"" + code + "\" ");
                } else if ("textarea".equals(type)) {
                    sb.append(" multilingual=\"" + (multilingual ? "true" : "false") + "\" ");
                    sb.append(" field=\"" + code + "\" ");
                } else if ("key".equals(type)) {
                    sb.append(" table=\"" + typespec + "\" ");
                    sb.append(" field=\"id" + typespec + "\" ");
                } else {
                    sb.append(" field=\"" + code + "\" ");
                }
            }
        }
        sb.append("/>");
        return sb.toString();
    }

    public void createClassFile(String packagename, File path) {
        for (String elementtype : this.elementtypes) {
            StringBuilder sb = new StringBuilder();
            String et = elementtype.substring(0, 1).toUpperCase() + elementtype.substring(1).toLowerCase();
            String classname = et + "Element";
            sb.append("package ").append(packagename).append(";\n");
            sb.append("\n");
            sb.append("import at.grid.cms.element.CmsElement;\n");
            sb.append("\n");
            sb.append("/**\n");
            sb.append(" * " + et + " element\n");
            sb.append(" * @author hk\n");
            sb.append(" */\n");
            sb.append("public class " + classname + " extends CmsElement {\n");
            sb.append("\n");
            sb.append("  // =====================================================================\n");
            sb.append("  // SUMMARY AND TITLE\n");
            sb.append("  // =====================================================================\n");
            sb.append("  /**\n");
            sb.append("   * Get the summary for the element\n");
            sb.append("   * @return\n");
            sb.append("   */\n");
            sb.append("  @Override\n");
            sb.append("  public String getSummary() {\n");
            sb.append("    return \"\";\n");
            sb.append("  }\n");
            sb.append("\n");
            sb.append("  /**\n");
            sb.append("   * Get the title for the element\n");
            sb.append("   * @return\n");
            sb.append("   */\n");
            sb.append("  @Override\n");
            sb.append("  public String getTitle() {\n");
            sb.append("    return \"\";\n");
            sb.append("  }\n");
            sb.append("  // =====================================================================\n");
            sb.append("  // TRIGGER\n");
            sb.append("  // =====================================================================\n");
            sb.append("  // =====================================================================\n");
            sb.append("  // PRIVATE METHODS\n");
            sb.append("  // =====================================================================\n");
            sb.append("}\n");
            try {
                FileWriter fw = new FileWriter(new File(path, classname + ".java"));
                fw.write(sb.toString());
                fw.close();
            }
            catch (IOException ex) {
                Logger.getLogger(DatabaseConverter.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static void main(String[] args) throws IOException, SQLException, ClassNotFoundException {
        DatabaseConverter kai = new DatabaseConverter(server, "5432", name, user, pwd);
        File outputpath = new File("c:/temp/kai/" + name);
        String fn1 = "kai_" + name + "_elementtypes.xml";
        String fn2 = "kai_" + name + "_bundle.properties";
        String packagename = "at.grid.kai.element";
        outputpath.mkdirs();
        kai.updateDatabase();
        kai.convertSubelement("suberdaslicense", "erdaslicense", "erdaslicense");
        kai.convertSubelement("subaddress", "address", "address");
        kai.convertSubelement("subcontact", "contactdetails", "contactdetails");
        kai.convertSubelement("subprojecttask", "projecttask", "projecttask");
    }
}

