/*
 * Decompiled with CFR 0.152.
 */
package at.grid.cms.util;

import at.grid.cms.CmsApplication;
import at.grid.cms.attribute.CmsAttribute;
import at.grid.cms.attribute.RelationAttribute;
import at.grid.cms.element.CmsElement;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class OntologyExporter {
    static String TAB = "\t";
    static String EOL = "\n";

    public static void exportOntologyStructure(CmsApplication app, File f) throws IOException {
        FileWriter fw = new FileWriter(f);
        fw.write("Zeile");
        fw.write(TAB + "Elementtyp");
        fw.write(TAB + "Attributgruppe");
        fw.write(TAB + "Attribut Label");
        fw.write(TAB + "Attribut Code");
        fw.write(TAB + "Attribut Typ");
        fw.write(TAB + "Pflichtfeld");
        fw.write(EOL);
        int line = 1;
        for (String et : app.getElementtypes()) {
            CmsElement e = app.getDefaultElement(et);
            for (CmsAttribute att : e.getDataAttributes()) {
                fw.write(Integer.toString(line));
                fw.write(TAB + et);
                fw.write(TAB + att.getAttributegroup());
                fw.write(TAB + att.getLabel());
                fw.write(TAB + att.getCode());
                fw.write(TAB + att.getTypeAsString());
                fw.write(TAB + (att.isRequired() ? "X" : ""));
                fw.write(EOL);
                ++line;
            }
        }
        fw.close();
    }

    public static void getRelations(CmsApplication app, File f) throws IOException {
        FileWriter fw = new FileWriter(f);
        fw.write("Zeile");
        fw.write(TAB + "Elementtyp FROM");
        fw.write(TAB + "Elementtyp TO");
        fw.write(TAB + "Attribut Code");
        fw.write(TAB + "Attribut Label");
        fw.write(TAB + "Anzahl");
        int line = 1;
        for (String et : app.getElementtypes()) {
            CmsElement ele = app.getDefaultElement(et);
            for (RelationAttribute att : ele.getRelationAttributes()) {
                fw.write(Integer.toString(line));
                fw.write(TAB + et);
                boolean first = true;
                StringBuilder sb = new StringBuilder();
                for (String type : att.getElementtypes()) {
                    if (!first) {
                        sb.append(",");
                    }
                    first = false;
                    sb.append(type);
                }
                fw.write(TAB + sb.toString());
                fw.write(TAB + att.getCode());
                fw.write(TAB + att.getLabel());
                if (att.isSizeOne()) {
                    fw.write(TAB + "[1]");
                } else {
                    fw.write(TAB + "[n]");
                }
                fw.write(EOL);
                ++line;
            }
        }
        fw.close();
    }
}

