/*
 * Decompiled with CFR 0.152.
 */
package net.sf.image4j.codec.bmp;

import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.sf.image4j.codec.bmp.BMPImage;
import net.sf.image4j.codec.bmp.ColorEntry;
import net.sf.image4j.codec.bmp.InfoHeader;
import net.sf.image4j.io.CountingInputStream;
import net.sf.image4j.io.LittleEndianInputStream;

public class BMPDecoder {
    private BufferedImage img;
    private InfoHeader infoHeader;

    public BMPDecoder(InputStream inputStream) throws IOException {
        LittleEndianInputStream littleEndianInputStream = new LittleEndianInputStream(new CountingInputStream(inputStream));
        byte[] byArray = new byte[2];
        littleEndianInputStream.read(byArray);
        String string = new String(byArray, "UTF-8");
        if (!string.equals("BM")) {
            throw new IOException("Invalid signature '" + string + "' for BMP format");
        }
        int n = littleEndianInputStream.readIntLE();
        int n2 = littleEndianInputStream.readIntLE();
        int n3 = littleEndianInputStream.readIntLE();
        this.infoHeader = BMPDecoder.readInfoHeader(littleEndianInputStream);
        this.img = BMPDecoder.read(this.infoHeader, littleEndianInputStream);
    }

    private static int getBit(int n, int n2) {
        return n >> 7 - n2 & 1;
    }

    private static int getNibble(int n, int n2) {
        return n >> 4 * (1 - n2) & 0xF;
    }

    public InfoHeader getInfoHeader() {
        return this.infoHeader;
    }

    public BufferedImage getBufferedImage() {
        return this.img;
    }

    private static void getColorTable(ColorEntry[] colorEntryArray, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        for (int i = 0; i < colorEntryArray.length; ++i) {
            byArray[i] = (byte)colorEntryArray[i].bRed;
            byArray2[i] = (byte)colorEntryArray[i].bGreen;
            byArray3[i] = (byte)colorEntryArray[i].bBlue;
        }
    }

    public static InfoHeader readInfoHeader(LittleEndianInputStream littleEndianInputStream) throws IOException {
        InfoHeader infoHeader = new InfoHeader(littleEndianInputStream);
        return infoHeader;
    }

    public static InfoHeader readInfoHeader(LittleEndianInputStream littleEndianInputStream, int n) throws IOException {
        InfoHeader infoHeader = new InfoHeader(littleEndianInputStream, n);
        return infoHeader;
    }

    public static BufferedImage read(InfoHeader infoHeader, LittleEndianInputStream littleEndianInputStream) throws IOException {
        BufferedImage bufferedImage = null;
        ColorEntry[] colorEntryArray = null;
        if (infoHeader.sBitCount <= 8) {
            colorEntryArray = BMPDecoder.readColorTable(infoHeader, littleEndianInputStream);
        }
        bufferedImage = BMPDecoder.read(infoHeader, littleEndianInputStream, colorEntryArray);
        return bufferedImage;
    }

    public static BufferedImage read(InfoHeader infoHeader, LittleEndianInputStream littleEndianInputStream, ColorEntry[] colorEntryArray) throws IOException {
        BufferedImage bufferedImage = null;
        if (infoHeader.sBitCount == 1 && infoHeader.iCompression == 0) {
            bufferedImage = BMPDecoder.read1(infoHeader, littleEndianInputStream, colorEntryArray);
        } else if (infoHeader.sBitCount == 4 && infoHeader.iCompression == 0) {
            bufferedImage = BMPDecoder.read4(infoHeader, littleEndianInputStream, colorEntryArray);
        } else if (infoHeader.sBitCount == 8 && infoHeader.iCompression == 0) {
            bufferedImage = BMPDecoder.read8(infoHeader, littleEndianInputStream, colorEntryArray);
        } else if (infoHeader.sBitCount == 24 && infoHeader.iCompression == 0) {
            bufferedImage = BMPDecoder.read24(infoHeader, littleEndianInputStream);
        } else if (infoHeader.sBitCount == 32 && infoHeader.iCompression == 0) {
            bufferedImage = BMPDecoder.read32(infoHeader, littleEndianInputStream);
        } else {
            throw new IOException("Unrecognized bitmap format: bit count=" + infoHeader.sBitCount + ", compression=" + infoHeader.iCompression);
        }
        return bufferedImage;
    }

    public static ColorEntry[] readColorTable(InfoHeader infoHeader, LittleEndianInputStream littleEndianInputStream) throws IOException {
        ColorEntry[] colorEntryArray = new ColorEntry[infoHeader.iNumColors];
        for (int i = 0; i < infoHeader.iNumColors; ++i) {
            ColorEntry colorEntry;
            colorEntryArray[i] = colorEntry = new ColorEntry(littleEndianInputStream);
        }
        return colorEntryArray;
    }

    public static BufferedImage read1(InfoHeader infoHeader, LittleEndianInputStream littleEndianInputStream, ColorEntry[] colorEntryArray) throws IOException {
        int n;
        byte[] byArray = new byte[colorEntryArray.length];
        byte[] byArray2 = new byte[colorEntryArray.length];
        byte[] byArray3 = new byte[colorEntryArray.length];
        BMPDecoder.getColorTable(colorEntryArray, byArray, byArray2, byArray3);
        IndexColorModel indexColorModel = new IndexColorModel(1, 2, byArray, byArray2, byArray3);
        BufferedImage bufferedImage = new BufferedImage(infoHeader.iWidth, infoHeader.iHeight, 12, indexColorModel);
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n2 = n = infoHeader.iWidth;
        if (n2 % 32 != 0) {
            n2 = (n2 / 32 + 1) * 32;
        }
        int n3 = n2 - n;
        int n4 = n3 / 8;
        int n5 = n2 / 8;
        int[] nArray = new int[n5];
        for (int i = infoHeader.iHeight - 1; i >= 0; --i) {
            int n6;
            for (n6 = 0; n6 < n5; ++n6) {
                nArray[n6] = littleEndianInputStream.readUnsignedByte();
            }
            for (n6 = 0; n6 < infoHeader.iWidth; ++n6) {
                int n7 = n6 / 8;
                int n8 = nArray[n7];
                int n9 = n6 % 8;
                int n10 = BMPDecoder.getBit(n8, n9);
                writableRaster.setSample(n6, i, 0, n10);
            }
        }
        return bufferedImage;
    }

    public static BufferedImage read4(InfoHeader infoHeader, LittleEndianInputStream littleEndianInputStream, ColorEntry[] colorEntryArray) throws IOException {
        byte[] byArray = new byte[colorEntryArray.length];
        byte[] byArray2 = new byte[colorEntryArray.length];
        byte[] byArray3 = new byte[colorEntryArray.length];
        BMPDecoder.getColorTable(colorEntryArray, byArray, byArray2, byArray3);
        IndexColorModel indexColorModel = new IndexColorModel(4, infoHeader.iNumColors, byArray, byArray2, byArray3);
        BufferedImage bufferedImage = new BufferedImage(infoHeader.iWidth, infoHeader.iHeight, 12, indexColorModel);
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n = infoHeader.iWidth * 4;
        if (n % 32 != 0) {
            n = (n / 32 + 1) * 32;
        }
        int n2 = n / 8;
        int[] nArray = new int[n2];
        for (int i = infoHeader.iHeight - 1; i >= 0; --i) {
            int n3;
            int n4;
            for (n4 = 0; n4 < n2; ++n4) {
                nArray[n4] = n3 = littleEndianInputStream.readUnsignedByte();
            }
            for (n4 = 0; n4 < infoHeader.iWidth; ++n4) {
                n3 = n4 / 2;
                int n5 = n4 % 2;
                int n6 = nArray[n3];
                int n7 = BMPDecoder.getNibble(n6, n5);
                writableRaster.setSample(n4, i, 0, n7);
            }
        }
        return bufferedImage;
    }

    public static BufferedImage read8(InfoHeader infoHeader, LittleEndianInputStream littleEndianInputStream, ColorEntry[] colorEntryArray) throws IOException {
        int n;
        byte[] byArray = new byte[colorEntryArray.length];
        byte[] byArray2 = new byte[colorEntryArray.length];
        byte[] byArray3 = new byte[colorEntryArray.length];
        BMPDecoder.getColorTable(colorEntryArray, byArray, byArray2, byArray3);
        IndexColorModel indexColorModel = new IndexColorModel(8, infoHeader.iNumColors, byArray, byArray2, byArray3);
        BufferedImage bufferedImage = new BufferedImage(infoHeader.iWidth, infoHeader.iHeight, 13, indexColorModel);
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n2 = n = infoHeader.iWidth;
        if (n2 % 4 != 0) {
            n2 = (n2 / 4 + 1) * 4;
        }
        int n3 = n2 - n;
        for (int i = infoHeader.iHeight - 1; i >= 0; --i) {
            for (int j = 0; j < infoHeader.iWidth; ++j) {
                int n4 = littleEndianInputStream.readUnsignedByte();
                writableRaster.setSample(j, i, 0, n4);
            }
            littleEndianInputStream.skip(n3);
        }
        return bufferedImage;
    }

    public static BufferedImage read24(InfoHeader infoHeader, LittleEndianInputStream littleEndianInputStream) throws IOException {
        BufferedImage bufferedImage = new BufferedImage(infoHeader.iWidth, infoHeader.iHeight, 1);
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n = infoHeader.iWidth * 3;
        int n2 = n;
        if (n2 % 4 != 0) {
            n2 = (n2 / 4 + 1) * 4;
        }
        int n3 = n2 - n;
        for (int i = infoHeader.iHeight - 1; i >= 0; --i) {
            for (int j = 0; j < infoHeader.iWidth; ++j) {
                int n4 = littleEndianInputStream.readUnsignedByte();
                int n5 = littleEndianInputStream.readUnsignedByte();
                int n6 = littleEndianInputStream.readUnsignedByte();
                writableRaster.setSample(j, i, 0, n6);
                writableRaster.setSample(j, i, 1, n5);
                writableRaster.setSample(j, i, 2, n4);
            }
            littleEndianInputStream.skip(n3);
        }
        return bufferedImage;
    }

    public static BufferedImage read32(InfoHeader infoHeader, LittleEndianInputStream littleEndianInputStream) throws IOException {
        BufferedImage bufferedImage = new BufferedImage(infoHeader.iWidth, infoHeader.iHeight, 2);
        WritableRaster writableRaster = bufferedImage.getRaster();
        WritableRaster writableRaster2 = bufferedImage.getAlphaRaster();
        for (int i = infoHeader.iHeight - 1; i >= 0; --i) {
            for (int j = 0; j < infoHeader.iWidth; ++j) {
                int n = littleEndianInputStream.readUnsignedByte();
                int n2 = littleEndianInputStream.readUnsignedByte();
                int n3 = littleEndianInputStream.readUnsignedByte();
                int n4 = littleEndianInputStream.readUnsignedByte();
                writableRaster.setSample(j, i, 0, n3);
                writableRaster.setSample(j, i, 1, n2);
                writableRaster.setSample(j, i, 2, n);
                writableRaster2.setSample(j, i, 0, n4);
            }
        }
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage read(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            BufferedImage bufferedImage = BMPDecoder.read(new BufferedInputStream(fileInputStream));
            return bufferedImage;
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static BufferedImage read(InputStream inputStream) throws IOException {
        BMPDecoder bMPDecoder = new BMPDecoder(inputStream);
        return bMPDecoder.getBufferedImage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BMPImage readExt(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            BMPImage bMPImage = BMPDecoder.readExt(new BufferedInputStream(fileInputStream));
            return bMPImage;
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static BMPImage readExt(InputStream inputStream) throws IOException {
        BMPDecoder bMPDecoder = new BMPDecoder(inputStream);
        BMPImage bMPImage = new BMPImage(bMPDecoder.getBufferedImage(), bMPDecoder.getInfoHeader());
        return bMPImage;
    }
}

