/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.special;

import at.grid.themis.application.THEMIS;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.license.LicenseUtils;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.themis.special.Bundle;
import at.grid.themis.special.bellinger.BellingerPanel;
import at.grid.themis.special.endress.EndressPanel;
import at.grid.themis.special.fix.FixPanel;
import at.grid.themis.special.grid.GridItPanel;
import at.grid.themis.special.ibs.IbsPanel;
import at.grid.themis.special.kaefer.KaeferPanel;
import at.grid.themis.special.kempenkrause.KempenKrausePanel;
import at.grid.themis.special.kubus360.Kubus360Panel;
import at.grid.themis.special.kyberna.KybernaPanel;
import at.grid.themis.special.lippmann.LippmannPanel;
import at.grid.themis.special.oehmke.OehmkePanel;
import at.grid.themis.special.oking.OkIngPanel;
import at.grid.themis.special.securitas.SecuritasPanel;
import at.grid.themis.special.terra.TerraPanel;
import at.grid.themis.special.thyssen.ThyssenPanel;
import at.grid.themis.special.wrw.WienerWohnenPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="SpecialFeatureTopComponent", persistenceType=0)
public final class SpecialFeatureTopComponent
extends TopComponent {
    public static final int FEATURE_DEACTIVATE_LICENSE = 1266;
    public static final int FEATURE_SQL_DIALOG = 1173;
    public static final int FEATURE_RESET_PASSWORD = 1032;
    public static final int FEATURE_BUGFIX_QUANTITY = 1311;
    public static final int FEATURE_ACTIVATE_EMAIL_SYNC = 1097;
    public static final int FEATURE_DATABASE_DUMP = 1066;
    public static final int FEATURE_DBVERSION_504 = 1417;
    public static final int FEATURE_REPAIR_DATABASE = 1722;
    public static final int FEATURE_UPDATE_INTERN = 1891;
    public static final int FEATURE_PROJECT_VOLLVERSION = 1219;
    public static final int FEATURE_PROJECT_BRANDSCHUTZBUCH = 1777;
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    File pathToKevoxImport = null;
    private int specialFeatureAttemptCounter = 0;
    private JButton btnSetCustomer;
    private JPanel codePanel;
    private JTextField fldClientId;
    private JComboBox<String> fldCustomer;
    private JLabel jLabel1;
    private JLabel jLabel13;
    private JPanel jPanel1;
    private JLabel lblFeatureInfo;
    private JPanel mainPanel;

    public SpecialFeatureTopComponent() {
        ThemisApplication.getInstance().getProject().getLogger().info("initialising " + ((Object)((Object)this)).getClass().getName() + " ...");
        this.initComponents();
        this.setName(Bundle.CTL_SpecialFeatureTopComponent());
        this.setToolTipText(Bundle.HINT_SpecialFeatureTopComponent());
        this.codePanel.setVisible(this.app.getLicense().isInternalLicense());
        this.updateVisibility(null);
        ThemisApplication.getInstance().getProject().getLogger().info("... done initialising " + ((Object)((Object)this)).getClass().getName() + " - Version " + ThemisProject.VERSION);
    }

    private void updateVisibility(String clientID) {
        ThemisLicense license;
        this.codePanel.setVisible(this.app.getLicense().isInternalLicense());
        if (!ThemisLicense.isLicenseLevelExact((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.FULL)) {
            this.project.getLogger().info("No license for special features");
            return;
        }
        if (clientID == null && (license = ThemisApplication.getInstance().getLicense()) != null) {
            clientID = Integer.toString(license.getClientID());
        }
        this.fldClientId.setText(clientID);
        this.lblFeatureInfo.setText("");
        if (LicenseUtils.isClientEquals((String)clientID, (LicenseUtils.Client)LicenseUtils.Client.GRID_IT)) {
            this.showPanel(new GridItPanel());
        } else if (LicenseUtils.isClientEquals((String)clientID, (LicenseUtils.Client)LicenseUtils.Client.KUBUS360)) {
            this.showPanel(new Kubus360Panel());
        } else if (LicenseUtils.isClientEquals((String)clientID, (LicenseUtils.Client)LicenseUtils.Client.FIX)) {
            this.showPanel(new FixPanel());
        } else if (LicenseUtils.isClientEquals((String)clientID, (LicenseUtils.Client)LicenseUtils.Client.KAEFER)) {
            this.showPanel(new KaeferPanel());
        } else if (LicenseUtils.isClientEquals((String)clientID, (LicenseUtils.Client)LicenseUtils.Client.BELLINGER)) {
            this.showPanel(new BellingerPanel());
        } else if (LicenseUtils.isClientEquals((String)clientID, (LicenseUtils.Client)LicenseUtils.Client.THYSSEN)) {
            this.showPanel(new ThyssenPanel());
        } else if (LicenseUtils.isClientEquals((String)clientID, (LicenseUtils.Client)LicenseUtils.Client.TERRA)) {
            this.showPanel(new TerraPanel());
        } else if (LicenseUtils.isClientEquals((String)clientID, (LicenseUtils.Client)LicenseUtils.Client.OEHMKE)) {
            this.showPanel(new OehmkePanel());
        } else if (LicenseUtils.isClientEquals((String)clientID, (LicenseUtils.Client)LicenseUtils.Client.ENDRESS)) {
            this.showPanel(new EndressPanel());
        } else if (LicenseUtils.isClientEquals((String)clientID, (LicenseUtils.Client)LicenseUtils.Client.KYBERNA)) {
            this.showPanel(new KybernaPanel());
        } else if (LicenseUtils.isClientEquals((String)clientID, (LicenseUtils.Client)LicenseUtils.Client.OK_ING)) {
            this.showPanel(new OkIngPanel());
        } else if (LicenseUtils.isClientEquals((String)clientID, (LicenseUtils.Client)LicenseUtils.Client.KEMPENKRAUSE)) {
            this.showPanel(new KempenKrausePanel());
        } else if (LicenseUtils.isClientEquals((String)clientID, (LicenseUtils.Client)LicenseUtils.Client.WIENERWOHNEN)) {
            this.showPanel(new WienerWohnenPanel());
        } else if (LicenseUtils.isClientEquals((String)clientID, (LicenseUtils.Client)LicenseUtils.Client.SECURITAS)) {
            this.showPanel(new SecuritasPanel());
        } else if (LicenseUtils.isClientEquals((String)clientID, (LicenseUtils.Client)LicenseUtils.Client.IBS)) {
            this.showPanel(new IbsPanel());
        } else if (LicenseUtils.isClientEquals((String)clientID, (LicenseUtils.Client)LicenseUtils.Client.LIPPMANN)) {
            this.showPanel(new LippmannPanel());
        } else {
            this.lblFeatureInfo.setText("Keine Spezialfunktion verf\u00fcgbar!");
        }
    }

    private void showPanel(JPanel p) {
        this.mainPanel.removeAll();
        this.mainPanel.add((Component)p, "Center");
        this.mainPanel.repaint();
        this.mainPanel.revalidate();
    }

    private void initComponents() {
        this.codePanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.fldCustomer = new JComboBox();
        this.btnSetCustomer = new JButton();
        this.mainPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.jLabel13 = new JLabel();
        this.fldClientId = new JTextField();
        this.lblFeatureInfo = new JLabel();
        this.codePanel.setLayout(new GridBagLayout());
        this.jLabel1.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(SpecialFeatureTopComponent.class, (String)"SpecialFeatureTopComponent.jLabel1.text"));
        this.jLabel1.setMinimumSize(new Dimension(5, 16));
        this.jLabel1.setPreferredSize(null);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.codePanel.add((Component)this.jLabel1, gridBagConstraints);
        this.fldCustomer.setModel(new DefaultComboBoxModel<String>(new String[]{"GRID-IT #1097", "KUBUS360 #32030", "FIX #34366", "K\u00c4FER #33140", "Thyssen #36791", "TERRA Vermessung #55041", "Oehmke-Herbert #28934", "Kyberne #66168", "Endress #36268", "OK-Ingenieure #78842", "KempenKrause #42579", "Wiener Wohnen #42694", "Securitas #73113", "Ibs #28716", "Lippmann #45925"}));
        this.fldCustomer.setMinimumSize(new Dimension(5, 26));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.codePanel.add(this.fldCustomer, gridBagConstraints);
        this.btnSetCustomer.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnSetCustomer, (String)NbBundle.getMessage(SpecialFeatureTopComponent.class, (String)"SpecialFeatureTopComponent.btnSetCustomer.text"));
        this.btnSetCustomer.setMinimumSize(new Dimension(50, 30));
        this.btnSetCustomer.setPreferredSize(new Dimension(50, 30));
        this.btnSetCustomer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpecialFeatureTopComponent.this.btnSetCustomerActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.codePanel.add((Component)this.btnSetCustomer, gridBagConstraints);
        this.mainPanel.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel13, (String)NbBundle.getMessage(SpecialFeatureTopComponent.class, (String)"SpecialFeatureTopComponent.jLabel13.text"));
        this.jLabel13.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SpecialFeatureTopComponent.this.jLabel13MouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.jLabel13, gridBagConstraints);
        this.fldClientId.setEditable(false);
        this.fldClientId.setHorizontalAlignment(0);
        this.fldClientId.setText(NbBundle.getMessage(SpecialFeatureTopComponent.class, (String)"SpecialFeatureTopComponent.fldClientId.text"));
        this.fldClientId.setMinimumSize(new Dimension(5, 24));
        this.fldClientId.setPreferredSize(new Dimension(100, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.fldClientId, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblFeatureInfo, (String)NbBundle.getMessage(SpecialFeatureTopComponent.class, (String)"SpecialFeatureTopComponent.lblFeatureInfo.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.lblFeatureInfo, gridBagConstraints);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.codePanel, -1, -1, Short.MAX_VALUE).addComponent(this.mainPanel, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.codePanel, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mainPanel, -1, 245, Short.MAX_VALUE)));
    }

    private void btnSetCustomerActionPerformed(ActionEvent evt) {
        String customer = (String)this.fldCustomer.getSelectedItem();
        String[] customerSplit = customer.split("#");
        if (customerSplit.length > 1) {
            this.updateVisibility(customerSplit[1]);
        }
    }

    private void jLabel13MouseClicked(MouseEvent evt) {
        this.updateVisibility(null);
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }
}

