/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.special.bellinger;

import at.grid.cms.element.CmsElement;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.action.ThemisActionProvider;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.action.ThemisActionListener;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.SoftBevelBorder;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class BellingerPanel
extends JPanel
implements ThemisActionListener {
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    long locationid = 0L;
    private JButton btnCreateEmails;
    private JButton btnMakeBuilding;
    private JTextField fldCurrentLocation;
    private JButton jButton1;
    private JLabel jLabel1;

    public BellingerPanel() {
        this.initComponents();
        ThemisActionProvider.getInstance().register((ThemisActionListener)this);
    }

    public void onAction(ThemisAction action) {
        if (action.is(ThemisAction.SELECTION_CHANGED)) {
            this.populate();
        }
    }

    public void populate() {
        ArrayList ids = this.project.getSelectionManager().getSelectedLocationIds();
        if (ids.isEmpty()) {
            this.fldCurrentLocation.setText("");
            this.btnMakeBuilding.setEnabled(false);
        } else {
            this.locationid = (Long)ids.get(0);
            this.fldCurrentLocation.setText(this.project.getDatastorage().getElementTitle(this.locationid));
            this.btnMakeBuilding.setEnabled(true);
        }
    }

    private void makeBuilding() {
        if (this.locationid > 0L) {
            CmsElement ele = this.project.loadElement(this.locationid, this.project.getUser());
            ele.getBooleanAttribute("building").setValue(true);
            ele.save();
            ThemisActionProvider.getInstance().invokeAction(ThemisAction.LOCATION_OBSERVATION_SAVED.setId(this.locationid));
            this.app.getDialog().showInfoDialog("OK, '" + this.fldCurrentLocation.getText() + "' ist jetzt ein Geb\u00e4ude!");
        }
        this.populate();
    }

    private void initComponents() {
        this.btnCreateEmails = new JButton();
        this.jLabel1 = new JLabel();
        this.fldCurrentLocation = new JTextField();
        this.btnMakeBuilding = new JButton();
        this.jButton1 = new JButton();
        this.btnCreateEmails.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnCreateEmails, (String)NbBundle.getMessage(BellingerPanel.class, (String)"BellingerPanel.btnCreateEmails.text"));
        this.btnCreateEmails.setBorder(new SoftBevelBorder(0));
        this.btnCreateEmails.setMinimumSize(new Dimension(5, 22));
        this.btnCreateEmails.setPreferredSize(new Dimension(197, 35));
        this.btnCreateEmails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BellingerPanel.this.btnCreateEmailsActionPerformed(evt);
            }
        });
        this.jLabel1.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(BellingerPanel.class, (String)"BellingerPanel.jLabel1.text"));
        this.fldCurrentLocation.setFont(THEMIS.fontTextfield);
        this.fldCurrentLocation.setText(NbBundle.getMessage(BellingerPanel.class, (String)"BellingerPanel.fldCurrentLocation.text"));
        this.fldCurrentLocation.setEnabled(false);
        this.fldCurrentLocation.setMinimumSize(new Dimension(5, 24));
        this.btnMakeBuilding.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnMakeBuilding, (String)NbBundle.getMessage(BellingerPanel.class, (String)"BellingerPanel.btnMakeBuilding.text"));
        this.btnMakeBuilding.setBorder(new SoftBevelBorder(0));
        this.btnMakeBuilding.setMinimumSize(new Dimension(5, 22));
        this.btnMakeBuilding.setPreferredSize(new Dimension(197, 35));
        this.btnMakeBuilding.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BellingerPanel.this.btnMakeBuildingActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(BellingerPanel.class, (String)"BellingerPanel.jButton1.text"));
        this.jButton1.setMinimumSize(new Dimension(5, 32));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BellingerPanel.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnCreateEmails, -1, 402, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButton1, -2, -1, -2)))).addGroup(layout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.fldCurrentLocation, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.btnMakeBuilding, -1, 402, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.btnCreateEmails, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jButton1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fldCurrentLocation, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnMakeBuilding, -2, -1, -2).addContainerGap(106, Short.MAX_VALUE)));
    }

    private void btnCreateEmailsActionPerformed(ActionEvent evt) {
        this.app.getProject().getDatastorage().executeUpdate("UPDATE tdtaelelocationgroup SET itemsort = 0", true);
        this.app.getProject().getDatastorage().executeUpdate("UPDATE tdtaelelocationtemplate SET itemsort = 0", true);
        this.app.getProject().getDatastorage().executeUpdate("UPDATE tdtaeleobservationtemplate SET itemsort = 0", true);
        this.app.getProject().getDatastorage().executeUpdate("UPDATE tdtaelemeasuretemplate SET itemsort = 0", true);
    }

    private void btnMakeBuildingActionPerformed(ActionEvent evt) {
        this.makeBuilding();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.populate();
    }
}

