/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.special.fix;

import at.grid.themis.application.THEMIS;
import at.grid.themis.application.action.ThemisActionProvider;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.api.ThemisFileDialog;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.themis.ontology.settings.ThemisSettings;
import com.opencsv.CSVReader;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.SoftBevelBorder;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class FixPanel
extends JPanel {
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    ThemisLicense license = THEMIS.getLicense();
    File file;
    private ArrayList<CmsLocation> locations = new ArrayList();
    private HashMap<Long, CmsObservation> observations = new HashMap();
    private ArrayList<String> comments = new ArrayList();
    private JButton btnReadFile;
    private JButton btnStartImport;
    private JTextArea fldComments;
    private JTextField fldFilename;
    private JButton jButton1;
    private JButton jButton2;
    private JScrollPane jScrollPane2;

    public FixPanel() {
        this.initComponents();
        THEMIS.getLicense();
    }

    private void clear() {
        this.locations.clear();
        this.observations.clear();
        this.comments.clear();
        this.fldComments.setText("");
    }

    private void initComponents() {
        this.btnStartImport = new JButton();
        this.fldFilename = new JTextField();
        this.jButton1 = new JButton();
        this.btnReadFile = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.fldComments = new JTextArea();
        this.jButton2 = new JButton();
        this.btnStartImport.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnStartImport, (String)NbBundle.getMessage(FixPanel.class, (String)"FixPanel.btnStartImport.text"));
        this.btnStartImport.setBorder(new SoftBevelBorder(0));
        this.btnStartImport.setEnabled(false);
        this.btnStartImport.setMinimumSize(new Dimension(5, 22));
        this.btnStartImport.setPreferredSize(new Dimension(185, 35));
        this.btnStartImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FixPanel.this.btnStartImportActionPerformed(evt);
            }
        });
        this.fldFilename.setEditable(false);
        this.fldFilename.setFont(THEMIS.fontTextfield);
        this.fldFilename.setText(NbBundle.getMessage(FixPanel.class, (String)"FixPanel.fldFilename.text"));
        this.jButton1.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(FixPanel.class, (String)"FixPanel.jButton1.text"));
        this.jButton1.setBorder(new SoftBevelBorder(0));
        this.jButton1.setMinimumSize(new Dimension(5, 22));
        this.jButton1.setPreferredSize(new Dimension(197, 35));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FixPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.btnReadFile.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnReadFile, (String)NbBundle.getMessage(FixPanel.class, (String)"FixPanel.btnReadFile.text"));
        this.btnReadFile.setBorder(new SoftBevelBorder(0));
        this.btnReadFile.setEnabled(false);
        this.btnReadFile.setMinimumSize(new Dimension(5, 22));
        this.btnReadFile.setPreferredSize(new Dimension(185, 35));
        this.btnReadFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FixPanel.this.btnReadFileActionPerformed(evt);
            }
        });
        this.jScrollPane2.setMinimumSize(new Dimension(10, 20));
        this.fldComments.setEditable(false);
        this.fldComments.setColumns(20);
        this.fldComments.setFont(THEMIS.fontTextfield);
        this.fldComments.setLineWrap(true);
        this.fldComments.setRows(5);
        this.fldComments.setWrapStyleWord(true);
        this.jScrollPane2.setViewportView(this.fldComments);
        this.jButton2.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton2, (String)NbBundle.getMessage(FixPanel.class, (String)"FixPanel.jButton2.text"));
        this.jButton2.setBorder(new SoftBevelBorder(0));
        this.jButton2.setMinimumSize(new Dimension(5, 22));
        this.jButton2.setPreferredSize(new Dimension(197, 35));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FixPanel.this.jButton2ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnStartImport, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButton1, -1, 380, Short.MAX_VALUE).addComponent(this.fldFilename, GroupLayout.Alignment.TRAILING).addComponent(this.btnReadFile, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane2, -1, -1, Short.MAX_VALUE).addComponent(this.jButton2, GroupLayout.Alignment.TRAILING, -1, 380, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.fldFilename, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnReadFile, -2, 35, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnStartImport, -2, 35, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 295, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2, -2, -1, -2).addContainerGap()));
    }

    private void btnStartImportActionPerformed(ActionEvent evt) {
        if (!this.project.isOpen() || this.project == null) {
            Dialogs.getInstance().showWarningDialog(this.app.getProject().getResourceText("app.core.text.noproject", this.app.getLocale()));
            return;
        }
        if (this.file == null || this.file.isDirectory()) {
            Dialogs.getInstance().showWarningDialog(this.app.getProject().getResourceText("app.file.errorReading.text", this.app.getLocale()));
            this.btnReadFile.setEnabled(false);
            this.btnStartImport.setEnabled(false);
            return;
        }
        try {
            for (int ii = 0; ii < this.locations.size(); ++ii) {
                this.locations.get(ii).save();
                this.observations.get(this.locations.get(ii).getId()).setLocation(this.locations.get(ii));
                this.observations.get(this.locations.get(ii).getId()).save();
            }
            this.app.getFilter().resetSearchResult();
            ThemisActionProvider.getInstance().invokeAction(ThemisAction.LOCATION_OBSERVATION_SAVED);
            this.fldComments.append("\n\nDie Daten wurden erfolgreich gespeichert");
        }
        catch (Exception ex) {
            this.fldComments.append("\n\nFehler beim Speichern der Daten.");
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app) || ThemisLicense.isActionDeniedForBSbuch((ThemisApplication)this.app)) {
            return;
        }
        if (!this.project.isOpen() || this.project == null) {
            Dialogs.getInstance().showWarningDialog(this.app.getProject().getResourceText("app.core.text.noproject", this.app.getLocale()));
            return;
        }
        if (!this.project.checkForCurrentEvent()) {
            return;
        }
        try {
            File f = new ThemisFileDialog("CSV Datei \u00f6ffnen", ThemisFileDialog.DIALOGTYPE.OPEN, this.app.getDocumentImportFolder(), null, THEMIS.getCsvFilter(), null, false).getSelectedFile();
            if (f != null) {
                this.clear();
                this.app.setDocumentImportFolder(f.getParentFile());
                this.fldFilename.setText(f.getName());
                this.file = f;
                this.fldComments.append("\nDatei ausgew\u00e4hlt: " + this.file.getAbsolutePath() + "\n\n");
                this.btnReadFile.setEnabled(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void btnReadFileActionPerformed(ActionEvent evt) {
        if (!this.project.isOpen() || this.project == null) {
            Dialogs.getInstance().showWarningDialog(this.app.getProject().getResourceText("app.core.text.noproject", this.app.getLocale()));
            return;
        }
        if (this.file == null || this.file.isDirectory()) {
            Dialogs.getInstance().showWarningDialog(this.app.getProject().getResourceText("app.file.errorReading.text", this.app.getLocale()));
            this.btnReadFile.setEnabled(false);
            this.btnStartImport.setEnabled(false);
            return;
        }
        this.readCsvFile();
        this.btnStartImport.setEnabled(true);
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app) || ThemisLicense.isActionDeniedForBSbuch((ThemisApplication)this.app)) {
            return;
        }
        if (!this.project.isOpen() || this.project == null) {
            Dialogs.getInstance().showWarningDialog(this.app.getProject().getResourceText("app.core.text.noproject", this.app.getLocale()));
            return;
        }
        try {
            ThemisSettings settings = ThemisApplication.getInstance().getSettings();
            settings.getLocationAttribute("group").setUsed(false);
            settings.getLocationAttribute("prefixsuffix").setUsed(true);
            settings.getLocationAttribute("suffix").setUsed(true);
            settings.getLocationAttribute("text1").setLabel("Position").setUsed(true);
            settings.getLocationAttribute("text2").setLabel("Kunde").setUsed(true);
            settings.getLocationAttribute("barcode").setLabel("Strichcode").setUsed(false);
            settings.getLocationAttribute("list1").setLabel("Brandschutzkl.").setUsed(true);
            settings.getLocationAttribute("list2").setLabel("Hersteller").setUsed(true);
            settings.getLocationAttribute("icon").setUsed(false);
            settings.getObservationAttribute("responsible").setUsed(true);
            settings.getObservationAttribute("duedate").setUsed(true);
            settings.getObservationAttribute("done").setUsed(true);
            settings.getObservationAttribute("text1").setUsed(false);
            settings.getObservationAttribute("text2").setUsed(false);
            settings.getObservationAttribute("text3").setUsed(false);
            settings.getObservationAttribute("text4").setUsed(false);
            settings.getObservationAttribute("longtext1").setUsed(false);
            settings.getObservationAttribute("list1").setUsed(false);
            settings.getObservationAttribute("list2").setUsed(false);
            settings.getObservationAttribute("list3").setUsed(false);
            settings.getObservationAttribute("quantity").setUsed(false);
            settings.getObservationAttribute("assessment").setUsed(false);
            settings.getObservationAttribute("measure").setUsed(false);
            Dialogs.getInstance().showInfoDialog("Einstellungen erfolgreich gesetzt.");
        }
        catch (Exception ex) {
            Dialogs.getInstance().showErrorDialog("Fehler beim Setzen der Einstellungen.", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readCsvFile() {
        CSVReader reader = null;
        try {
            String[] nextLine;
            reader = new CSVReader((Reader)new FileReader(this.file), ';');
            String[] cols = reader.readNext();
            for (int ii = 0; ii < cols.length; ++ii) {
                if (!"".equals(cols[ii])) continue;
            }
            this.locations.clear();
            this.observations.clear();
            int countLocations = 0;
            while ((nextLine = reader.readNext()) != null) {
                try {
                    CmsLocation loc = (CmsLocation)this.project.createElement("location");
                    loc.setAttributeValue("barcode", !"".equals(nextLine[5]) ? nextLine[5] : "");
                    loc.setAttributeValue("code2", !"".equals(nextLine[2]) ? nextLine[2] : "");
                    loc.setAttributeValue("code", !"".equals(nextLine[3]) ? nextLine[3] : "");
                    String locDescription = "";
                    locDescription = locDescription + (!"".equals(nextLine[4]) ? "Herstelldatum: " + nextLine[4] + "\n" : "");
                    loc.setAttributeValue("number", nextLine[5]);
                    String[] remarks = nextLine[6].trim().split("Datum");
                    String description = "";
                    for (String remark : remarks) {
                        if ("".equals(remark)) continue;
                        description = description + "Datum" + remark + "\n";
                    }
                    description = description + "\nAufgenommen durch: " + nextLine[22] + " " + nextLine[23] + " (Fix Geb\u00e4udesicherheit + Service GmbH)";
                    CmsObservation obs = (CmsObservation)this.project.createElement("observation");
                    obs.setNumber(loc.getNextObservationNumber());
                    obs.setAttributeValue("title", "Wartungsinformation");
                    obs.setAttributeValue("description", description);
                    obs.getKeyAttribute("type").setValue(3L);
                    this.observations.put(loc.getId(), obs);
                    loc.setAttributeValue("list2", !"".equals(nextLine[8]) ? nextLine[8] : "-");
                    loc.setAttributeValue("title", !"".equals(nextLine[9]) ? nextLine[9] : "");
                    loc.setAttributeValue("list1", !"".equals(nextLine[10]) ? nextLine[10] : "-");
                    locDescription = locDescription + (!"".equals(nextLine[11]) ? "Antrieb: " + nextLine[11] + "\n" : "");
                    locDescription = locDescription + (!"".equals(nextLine[12]) ? "Geht\u00fcr im Tor: " + nextLine[12] + "\n" : "");
                    locDescription = locDescription + (!"".equals(nextLine[13]) ? "Haltemagnet: " + nextLine[13] + "\n" : "");
                    locDescription = locDescription + "von Raum \"" + ("Andere".equals(nextLine[15]) ? nextLine[14] : nextLine[15]);
                    locDescription = locDescription + "\" zu Raum \"" + ("Andere".equals(nextLine[17]) ? nextLine[16] : nextLine[17]) + "\"\n";
                    loc.setAttributeValue("description", locDescription);
                    this.locations.add(loc);
                    ++countLocations;
                }
                catch (Exception ex) {
                    this.fldComments.append("Eintrag " + (countLocations + 1) + " konnte nicht gelesen werden.\n");
                }
            }
            this.fldComments.append("\n\n" + countLocations + " Gegenst\u00e4nde wurden erfolgreich eingelesen.");
        }
        catch (FileNotFoundException ex) {
            Dialogs.getInstance().showErrorDialog(this.app.getProject().getResourceText("app.file.notFound.text", this.app.getLocale()), (Exception)ex);
        }
        catch (IOException ex) {
            Dialogs.getInstance().showErrorDialog(this.app.getProject().getResourceText("app.file.errorReading.text", this.app.getLocale()), (Exception)ex);
        }
        catch (Exception ex) {
            Dialogs.getInstance().showErrorDialog(this.app.getProject().getResourceText("app.file.otherErrorOccured.text", this.app.getLocale()), ex);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

