/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.special.grid;

import at.grid.cms.CmsApplication;
import at.grid.cms.content.UploadItem;
import at.grid.cms.element.CmsElement;
import at.grid.cms.search.CmsSqlSearch;
import at.grid.cms.storage.DataRecord;
import at.grid.cms.storage.DataStorage;
import at.grid.cms.storage.SearchResult;
import at.grid.data.grid.GridGeometry;
import at.grid.gui.SimpleGeometry;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.UpdateManager;
import at.grid.themis.application.action.ThemisActionProvider;
import at.grid.themis.application.action.ViewHelper;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.api.ThemisFileDialog;
import at.grid.themis.application.communication.email.EmailSyncPanel;
import at.grid.themis.application.io.importer.ImportTarget;
import at.grid.themis.application.io.importer.ImportWizard2;
import at.grid.themis.application.io.importer.TemplateImportTarget;
import at.grid.themis.application.util.ThemisTaskWithDialog;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisFile;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.ThemisProjectUpdater;
import at.grid.themis.ontology.ThemisUtil;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.cli.ThemisCommand;
import at.grid.themis.ontology.element.CmsEvent;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.themis.ontology.element.CmsLocationTemplate;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.element.CmsPlan;
import at.grid.themis.ontology.javafx.JavaFxSwingDialog;
import at.grid.themis.ontology.javafx.ThemisTextEditor2;
import at.grid.themis.ontology.license.LicenseUtils;
import at.grid.themis.special.grid.HtmlMailPanel;
import at.grid.themis.special.sql.HistoryPanel;
import at.grid.themis.special.sql.SQLQueryPanel;
import at.grid.util.ImageHelper;
import at.grid.util.ProgressHandler;
import at.grid.util.Timer;
import at.grid.util.Util;
import at.grid.util.cli.Terminal;
import com.aspose.cells.Workbook;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Separator;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.SoftBevelBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressRunnable;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;
import org.xml.sax.InputSource;

public class GridItPanel
extends JPanel {
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    File pathToKevoxImport = null;
    private int specialFeatureAttemptCounter = 0;
    CmsPlan plan = null;
    ArrayList<String> tablesDone = new ArrayList();
    File h2dbfile = null;
    private JButton btnChangeToBsBuch;
    private JButton btnCheckLicenseKey;
    private JButton btnCheckUploads;
    private JButton btnCommandExe;
    private JButton btnCreateEmails;
    private JButton btnCreateUploads;
    private JButton btnDisableSpecialFeatures;
    private JButton btnElementHistory;
    private JButton btnImportProject;
    private JButton btnImportTemplates;
    private JButton btnMoveObservation;
    private JButton btnOpenDemo;
    private JButton btnOpenJavaFx;
    private JButton btnProjectExport;
    private JButton btnRecoverIds;
    private JButton btnSetUsernameNeu;
    private JButton btnSetWindowSize;
    private JButton btnShowSQL;
    private JCheckBox chkCreateWithFoto;
    private JTextField fldAppVersion;
    private JTextField fldCommand;
    private JTextArea fldCommandOutput;
    private JTextField fldCountBuilding;
    private JTextField fldCountEvent;
    private JTextField fldCountLocation;
    private JTextField fldCountObservation;
    private JTextField fldCountPlan;
    private JTextField fldElementId;
    private JTextField fldEmailAddress;
    private JTextField fldLicenseKey;
    private JComboBox<String> fldLicenseType;
    private JTextField fldProjectExportDate;
    private JTextArea fldRecoverIds;
    private JComboBox<String> fldUpdatePhase;
    private JTextField fldUsernameNeu;
    private JButton jButton10;
    private JButton jButton11;
    private JButton jButton12;
    private JButton jButton13;
    private JButton jButton16;
    private JButton jButton17;
    private JButton jButton18;
    private JButton jButton19;
    private JButton jButton5;
    private JButton jButton6;
    private JButton jButton7;
    private JButton jButton8;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel26;
    private JLabel jLabel27;
    private JLabel jLabel3;
    private JLabel jLabel31;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel9;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JTabbedPane jTabbedPane1;
    private JPanel panelCheckLicenseKey;
    private JPanel panelCommand;
    private JPanel panelData;
    private JPanel panelFunctions;
    private JPanel panelStandard;

    public GridItPanel() {
        this.initComponents();
    }

    public void createDummyData(final int countBuilding, final int countPlan, int countCompany, int countDocument, final int countEvent, final int countLocation, final int countObservation, boolean withFoto) {
        if (!this.project.isOpen()) {
            Dialogs.getInstance().showErrorDialog("Kein Projekt");
            return;
        }
        int countElementsX = countCompany + countDocument + countBuilding * countPlan * countLocation * countObservation * countEvent;
        if (countBuilding * countPlan == 0) {
            countElementsX = countCompany + countDocument + countLocation * countObservation * countEvent;
        }
        int totalCount = countPlan * countLocation;
        if (countBuilding > 0) {
            totalCount *= countBuilding;
        }
        final int totalCountProgress = totalCount;
        if (withFoto) {
            URL url = this.getClass().getResource("/at/grid/themis/special/grid/media/dummy_foto.jpg");
            try {
                FileOutputStream fos = new FileOutputStream(new File(this.project.getTempfileLocation(), "dummy_foto.jpg"));
                Util.copy((InputStream)url.openStream(), (OutputStream)fos);
                fos.close();
                withFoto = true;
            }
            catch (FileNotFoundException ex) {
                this.project.getLogger().severe("Cannot create image in temp folder");
            }
            catch (IOException ex) {
                this.project.getLogger().severe("Cannot create image in temp folder");
            }
        }
        final boolean withImage = withFoto;
        String progressTitle = "Daten werden angelegt";
        BaseProgressUtils.showProgressDialogAndRun((ProgressRunnable)new ProgressRunnable<String>(){

            public String run(ProgressHandle ph) {
                CmsElement e;
                ThemisActionProvider.getInstance().setActive(false);
                ph.switchToDeterminate(totalCountProgress + 1);
                ph.progress("Ereignisse werden erstellt", 0);
                int counter = 0;
                ArrayList<CmsElement> events = new ArrayList<CmsElement>();
                for (int ii = 0; ii < countEvent; ++ii) {
                    e = GridItPanel.this.createDummyEvemt(ii);
                    e.save();
                    events.add(e);
                }
                ArrayList<CmsLocationTemplate> templateids = new ArrayList<CmsLocationTemplate>();
                CmsSqlSearch s2 = new CmsSqlSearch((CmsApplication)GridItPanel.this.project, GridItPanel.this.project.getUser(), false);
                s2.setElementtypes("locationtemplate");
                SearchResult result2 = s2.search();
                Iterator iterator = result2.getResultIds().iterator();
                while (iterator.hasNext()) {
                    long l = (Long)iterator.next();
                    templateids.add((CmsLocationTemplate)GridItPanel.this.project.loadElement(l, GridItPanel.this.project.getUser()));
                }
                boolean hasTemplates = !templateids.isEmpty();
                for (int ii = 0; ii < Math.max(countBuilding, 1); ++ii) {
                    long idbuilding = -1L;
                    if (countBuilding > 0) {
                        e = GridItPanel.this.createDummyBuilding(ii);
                        e.save();
                        idbuilding = e.getId();
                    }
                    for (int jj = 0; jj < Math.max(countPlan, 1); ++jj) {
                        long idplan = GridItPanel.this.project.getCurrentPlanId();
                        ph.setDisplayName("Plan " + (jj + 1) + " von " + countPlan + " wird bef\u00fcllt");
                        if (countPlan > 0) {
                            e = GridItPanel.this.createDummyPlan(idbuilding, jj);
                            e.save();
                            idplan = e.getId();
                        }
                        for (int kk = 0; kk < countLocation; ++kk) {
                            ph.progress("Gegenstand " + (kk + 1) + " von " + countLocation, counter++);
                            e = GridItPanel.this.createDummyLocation(idplan, kk);
                            if (hasTemplates) {
                                int idx = (int)(Math.random() * (double)templateids.size());
                                ((CmsLocationTemplate)templateids.get(idx)).applyTo((CmsLocation)e);
                            }
                            e.save();
                            CmsLocation loc = (CmsLocation)e;
                            for (int ll = 0; ll < countObservation; ++ll) {
                                e = GridItPanel.this.createDummyObservation(loc.getId(), ll, withImage);
                                ((CmsObservation)e).setLocation(loc);
                                ((CmsObservation)e).setNumber((long)(ll + 1));
                                for (CmsElement event : events) {
                                    GridItPanel.this.project.setCurrentEvent((CmsEvent)event);
                                    e.save();
                                }
                            }
                        }
                    }
                }
                ph.finish();
                ThemisActionProvider.getInstance().setActive(true);
                ThemisActionProvider.getInstance().invokeAction(ThemisAction.PROJECT_OPENED);
                ThemisActionProvider.getInstance().invokeAction(ThemisAction.LOCATION_OBSERVATION_SAVED);
                return null;
            }
        }, (String)progressTitle, (boolean)true);
    }

    private CmsElement createDummyEvemt(int ii) {
        CmsElement e = this.project.createElement("event");
        e.setAttributeValue("title", "Ereignis " + (ii + 1));
        return e;
    }

    private CmsElement createDummyBuilding(int ii) {
        CmsElement e = this.project.createElement("location");
        e.setAttributeValue("title", "Geb\u00e4ude " + (ii + 1));
        return e;
    }

    private CmsElement createDummyDocument(long documenttype, int ii) {
        CmsElement e = this.project.createElement("location");
        if (documenttype > 0L) {
            e.getKeyAttribute("documenttype").setValue((long)ii % documenttype);
        }
        e.setAttributeValue("title", "Dokument " + (ii + 1));
        e.getDateAttribute("date").setDate(new Date());
        e.setAttributeValue("comment", "Kommentar zum Dokument " + (ii + 1));
        return e;
    }

    private CmsElement createDummyContact(int ii) {
        CmsElement e = this.project.createElement("company");
        e.setAttributeValue("name", "Unternehmen " + (ii + 1));
        e.setAttributeValue("email", "mail " + (ii + 1) + "@test.de");
        e.setAttributeValue("tel", "01-12345" + (ii + 1));
        return e;
    }

    public CmsElement createDummyPlan(long idbuilding, int ii) {
        File temp = this.project.getTempfileLocation();
        File planfile = new File(temp, "plan.jpg");
        try {
            URL url = this.getClass().getResource("/at/grid/themis/special/grid/media/dummy_plan.jpg");
            Util.copy((InputStream)url.openStream(), (OutputStream)new FileOutputStream(planfile));
        }
        catch (IOException ex) {
            Logger.getLogger(ThemisProject.class.getName()).log(Level.SEVERE, null, ex);
        }
        CmsElement e = this.project.createElement("plan");
        e.setAttributeValue("title", "Plan " + (ii + 1));
        if (planfile.isFile()) {
            ((CmsPlan)e).addPlanFile(planfile, null, null, new Date());
        }
        return e;
    }

    public CmsElement createDummyLocation(long idplan, int ii) {
        if (this.plan == null || this.plan.getId() != idplan) {
            this.plan = (CmsPlan)this.project.loadElement(idplan, this.project.getUser());
        }
        GridGeometry geom = this.plan.getPlanExtent();
        int width = geom.getWidth();
        int height = geom.getHeight();
        CmsElement e = this.project.createElement("location");
        e.setAttributeValue("title", "Gegenstand " + (ii + 1));
        if (idplan > 0L) {
            e.getRelationAttribute("plan").add(idplan);
            double x = Math.random() * (double)width;
            double y = Math.random() * (double)height;
            SimpleGeometry g = new SimpleGeometry(1);
            g.add(x + geom.getCorner().x, y + geom.getCorner().y);
            e.setAttributeValue("position", g.toWKT());
        }
        return e;
    }

    public CmsElement createDummyObservation(long idlocation, int ii, boolean withImage) {
        File f;
        CmsElement e = this.project.createElement("observation");
        e.setAttributeValue("title", "Beobachtung " + (ii + 1));
        e.getRelationAttribute("location").add(idlocation);
        if (withImage && (f = new File(this.project.getTempfileLocation(), "dummy_foto.jpg")).isFile()) {
            e.getUploadAttribute("files").addUpload(f);
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backupDatabase() {
        String[] tables = new String[]{"config", "tdtauser", "tdtauserlng", "tkeydocumenttype", "tkeydocumenttypelng", "tkeylanguage", "tkeylanguagelng", "tkeylist1", "tkeylist1lng", "tkeylist2", "tkeylist2lng", "tkeyobservationtype", "tkeyobservationtypelng", "tkeyobstype", "tkeyobstypelng", "tkeypermissionlevel", "tkeypermissionlevellng", "tkeypriority", "tkeyprioritylng", "tkeyrepeat", "tkeyrepeatlng", "tkeytopic", "tkeytopiclng", "tkeyuploaddetail", "tkeyuploaddetaillng", "tkeyworkflowstatus", "tkeyworkflowstatuslng", "tdtadrawing", "tdtaeleaction", "tdtaeleactionlng", "tdtaelecompany", "tdtaelecompanylng", "tdtaeleevent", "tdtaeleeventlng", "tdtaelefilter", "tdtaelefilterlng", "tdtaelehistory", "tdtaelehistorylng", "tdtaeleicon", "tdtaeleiconlng", "tdtaeleinfo", "tdtaeleinfolng", "tdtaelelocation", "tdtaelelocationgroup", "tdtaelelocationgrouplng", "tdtaelelocationlng", "tdtaelelocationtemplate", "tdtaelelocationtemplatelng", "tdtaelelog", "tdtaeleloglng", "tdtaelemeasuretemplate", "tdtaelemeasuretemplatelng", "tdtaelement", "tdtaelementhistory2", "tdtaelementlng", "tdtaelementlock", "tdtaeleobservation", "tdtaeleobservationlng", "tdtaeleobservationtemplate", "tdtaeleobservationtemplatelng", "tdtaeleplan", "tdtaeleplanfile", "tdtaeleplanfilelng", "tdtaeleplanlng", "tdtaeleproject", "tdtaeleprojectlng", "tdtafileupload", "tdtagroup", "tdtagrouplng", "tdtakeytablenames", "tdtarelation2", "tdtasystemlog", "treleventelement"};
        Connection conn = null;
        ArrayList<String> foreignKeys = new ArrayList<String>();
        try {
            File dbfile = new ThemisFileDialog("Datenbankdatei ausw\u00e4hlen", ThemisFileDialog.DIALOGTYPE.OPEN, this.h2dbfile, this.h2dbfile, THEMIS.getDatabaseFilter(), null, false).getSelectedFile();
            if (dbfile == null) {
                return;
            }
            this.h2dbfile = dbfile;
            String dbfileuri = dbfile.getAbsolutePath();
            dbfileuri = dbfileuri.replaceAll(".h2.db", "");
            String dburi = "jdbc:h2:" + dbfileuri + ";MV_STORE=FALSE;MVCC=FALSE";
            Properties connectionProperties = new Properties();
            connectionProperties.setProperty("user", "themis");
            connectionProperties.setProperty("password", "wNd92c-56dx");
            conn = DriverManager.getConnection(dburi, connectionProperties);
            Statement stmt = conn.createStatement();
            for (String t : tables) {
                boolean talbeExportOk = false;
                File f = new File(dbfile.getParentFile(), "tables/" + t + ".sql");
                File f2 = new File(dbfile.getParentFile(), "tables2/" + t + ".sql");
                f.getParentFile().mkdirs();
                f2.getParentFile().mkdirs();
                try {
                    stmt.executeQuery("script to '" + f.getAbsolutePath() + "' table " + t);
                    talbeExportOk = true;
                }
                catch (Exception ex) {
                    this.project.getLogger().severe("Error exporting table '" + t + "':" + ex.getMessage());
                }
                try {
                    if (talbeExportOk) {
                        BufferedReader br = new BufferedReader(new FileReader(f));
                        FileWriter fw = new FileWriter(f2);
                        String ln = br.readLine();
                        while (ln != null) {
                            ln = ln.replaceAll("CREATE SEQUENCE PUBLIC", "CREATE SEQUENCE IF NOT EXISTS PUBLIC");
                            if ((ln = ln.replaceAll("CREATE CACHED TABLE PUBLIC", "CREATE CACHED TABLE IF NOT EXISTS PUBLIC")).indexOf("FOREIGN KEY") >= 0) {
                                foreignKeys.add(ln);
                            } else {
                                fw.write(ln + "\n");
                            }
                            ln = br.readLine();
                        }
                        br.close();
                        fw.close();
                    }
                }
                catch (Exception ex) {
                    this.project.getLogger().severe("Error writing original table '" + t + "':" + ex.getMessage());
                }
                if (f2.exists()) continue;
                this.project.getLogger().severe("Could not create table '" + f2.getName() + "'");
            }
            try {
                File f2 = new File(dbfile.getParentFile(), "tables2/fk.sql");
                FileWriter fw = new FileWriter(f2);
                for (String ln : foreignKeys) {
                    fw.write(ln + "\n");
                }
                fw.close();
            }
            catch (Exception ex) {
                this.project.getLogger().severe("Error writing foreign keys:" + ex.getMessage());
            }
        }
        catch (SQLException ex) {
            this.project.getLogger().severe("SQL Error:" + ex.getMessage());
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private void createUploads() {
        if (!this.project.isOpen()) {
            return;
        }
        File temp = this.project.getTempfileLocation();
        final File planfile = new File(temp, "dummy_plan.jpg");
        final File fotofile = new File(temp, "dummy_foto.jpg");
        final File iconfilegif = new File(temp, "dummy_icon.gif");
        final File iconfilepng = new File(temp, "dummy_icon.png");
        final File iconfilejpg = new File(temp, "dummy_icon.jpg");
        try {
            Util.copy((InputStream)GridItPanel.class.getResourceAsStream("/at/grid/themis/special/grid/media/dummy_plan.jpg"), (OutputStream)new FileOutputStream(planfile));
        }
        catch (IOException ex) {
            Logger.getLogger(ThemisProject.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            Util.copy((InputStream)GridItPanel.class.getResourceAsStream("/at/grid/themis/special/grid/media/dummy_foto.jpg"), (OutputStream)new FileOutputStream(fotofile));
        }
        catch (IOException ex) {
            Logger.getLogger(ThemisProject.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            Util.copy((InputStream)GridItPanel.class.getResourceAsStream("/at/grid/themis/special/grid/media/dummy_icon.gif"), (OutputStream)new FileOutputStream(iconfilegif));
        }
        catch (IOException ex) {
            Logger.getLogger(ThemisProject.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            Util.copy((InputStream)GridItPanel.class.getResourceAsStream("/at/grid/themis/special/grid/media/dummy_icon.jpg"), (OutputStream)new FileOutputStream(iconfilejpg));
        }
        catch (IOException ex) {
            Logger.getLogger(ThemisProject.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            Util.copy((InputStream)GridItPanel.class.getResourceAsStream("/at/grid/themis/special/grid/media/dummy_icon.png"), (OutputStream)new FileOutputStream(iconfilepng));
        }
        catch (IOException ex) {
            Logger.getLogger(ThemisProject.class.getName()).log(Level.SEVERE, null, ex);
        }
        String progressTitle = "Uploads erzeugen";
        BaseProgressUtils.showProgressDialogAndRun((ProgressRunnable)new ProgressRunnable<String>(){

            public String run(ProgressHandle ph) {
                ArrayList allUploadItems = GridItPanel.this.project.getDatastorage().getAllUploadItems();
                ph.switchToDeterminate(allUploadItems.size());
                int counter = 0;
                ph.setDisplayName("Uploads erstellen");
                ph.progress("Dummy-Dateien werden erstellt", counter);
                for (UploadItem item : allUploadItems) {
                    if (!item.getFile().isFile()) {
                        String type;
                        if (item.getId() == 22L) {
                            boolean bl = false;
                        }
                        if ((type = GridItPanel.this.project.getDatastorage().getElementtypeById(item.getIdelement())) == null) continue;
                        switch (type) {
                            case "plan": 
                            case "planfile": {
                                try {
                                    Util.copy((File)planfile, (File)item.getFile());
                                }
                                catch (IOException ex) {
                                    Exceptions.printStackTrace((Throwable)ex);
                                }
                                break;
                            }
                            case "info": 
                            case "observation": 
                            case "location": 
                            case "history": {
                                try {
                                    Util.copy((File)fotofile, (File)item.getFile());
                                }
                                catch (IOException ex) {
                                    Exceptions.printStackTrace((Throwable)ex);
                                }
                                break;
                            }
                            case "icon": {
                                try {
                                    switch (Util.getFileExtension((File)item.getFile()).toLowerCase()) {
                                        case "jpg": {
                                            Util.copy((File)iconfilejpg, (File)item.getFile());
                                            break;
                                        }
                                        case "gif": {
                                            Util.copy((File)iconfilegif, (File)item.getFile());
                                            break;
                                        }
                                        case "png": {
                                            Util.copy((File)iconfilepng, (File)item.getFile());
                                        }
                                    }
                                    break;
                                }
                                catch (IOException ex) {
                                    Exceptions.printStackTrace((Throwable)ex);
                                }
                            }
                        }
                    }
                    ph.progress(counter++);
                }
                ph.finish();
                return null;
            }
        }, (String)progressTitle, (boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreDatabase() {
        Connection conn = null;
        try {
            String[] tables;
            File dbfile = new ThemisFileDialog("Datenbankdatei ausw\u00e4hlen", ThemisFileDialog.DIALOGTYPE.OPEN, this.h2dbfile, this.h2dbfile, THEMIS.getDatabaseFilter(), null, false).getSelectedFile();
            if (dbfile == null) {
                return;
            }
            String dbfileuri = dbfile.getAbsolutePath();
            dbfileuri = dbfileuri.replaceAll(".h2.db", "");
            String dburi = "jdbc:h2:" + dbfileuri + ";MV_STORE=FALSE;MVCC=FALSE";
            Properties connectionProperties = new Properties();
            connectionProperties.setProperty("user", "themis");
            connectionProperties.setProperty("password", "wNd92c-56dx");
            conn = DriverManager.getConnection(dburi, connectionProperties);
            Statement stmt = conn.createStatement();
            for (String t : tables = new String[]{"config", "tdtauser", "tdtauserlng", "tkeydocumenttype", "tkeydocumenttypelng", "tkeylanguage", "tkeylanguagelng", "tkeylist1", "tkeylist1lng", "tkeylist2", "tkeylist2lng", "tkeyobservationtype", "tkeyobservationtypelng", "tkeyobstype", "tkeyobstypelng", "tkeypermissionlevel", "tkeypermissionlevellng", "tkeypriority", "tkeyprioritylng", "tkeyrepeat", "tkeyrepeatlng", "tkeytopic", "tkeytopiclng", "tkeyuploaddetail", "tkeyuploaddetaillng", "tkeyworkflowstatus", "tkeyworkflowstatuslng", "tdtadrawing", "tdtaeleaction", "tdtaeleactionlng", "tdtaelecompany", "tdtaelecompanylng", "tdtaeleevent", "tdtaeleeventlng", "tdtaelefilter", "tdtaelefilterlng", "tdtaelehistory", "tdtaelehistorylng", "tdtaeleicon", "tdtaeleiconlng", "tdtaeleinfo", "tdtaeleinfolng", "tdtaelelocation", "tdtaelelocationgroup", "tdtaelelocationgrouplng", "tdtaelelocationlng", "tdtaelelocationtemplate", "tdtaelelocationtemplatelng", "tdtaelelog", "tdtaeleloglng", "tdtaelemeasuretemplate", "tdtaelemeasuretemplatelng", "tdtaelement", "tdtaelementhistory", "tdtaelementlng", "tdtaelementlock", "tdtaeleobservation", "tdtaeleobservationlng", "tdtaeleobservationtemplate", "tdtaeleobservationtemplatelng", "tdtaeleplan", "tdtaeleplanfile", "tdtaeleplanfilelng", "tdtaeleplanlng", "tdtaeleproject", "tdtaeleprojectlng", "tdtafileupload", "tdtagroup", "tdtagrouplng", "tdtakeytablenames", "tdtarelation", "tdtasystemlog", "treleventelement", "fk"}) {
                try {
                    this.tablesDone.add(t);
                    File f = new File(dbfile.getParentFile(), "tables/" + t + ".sql");
                    File f2 = new File(dbfile.getParentFile(), "tables2/" + t + ".sql");
                    f.getParentFile().mkdirs();
                    f2.getParentFile().mkdirs();
                    stmt.executeUpdate("runscript from '" + f2.getAbsolutePath() + "'");
                }
                catch (SQLException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        catch (SQLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.panelStandard = new JPanel();
        this.btnShowSQL = new JButton();
        this.btnDisableSpecialFeatures = new JButton();
        this.btnImportTemplates = new JButton();
        this.btnElementHistory = new JButton();
        this.btnSetWindowSize = new JButton();
        this.jPanel4 = new JPanel();
        this.jLabel14 = new JLabel();
        this.fldElementId = new JTextField();
        this.jButton11 = new JButton();
        this.btnCreateUploads = new JButton();
        this.panelCheckLicenseKey = new JPanel();
        this.fldLicenseType = new JComboBox();
        this.fldLicenseKey = new JTextField();
        this.btnCheckLicenseKey = new JButton();
        this.jPanel9 = new JPanel();
        this.jLabel26 = new JLabel();
        this.fldUsernameNeu = new JTextField();
        this.btnSetUsernameNeu = new JButton();
        this.jPanel6 = new JPanel();
        this.jLabel31 = new JLabel();
        this.fldUpdatePhase = new JComboBox();
        this.fldAppVersion = new JTextField();
        this.jButton13 = new JButton();
        this.jLabel21 = new JLabel();
        this.panelData = new JPanel();
        this.jLabel5 = new JLabel();
        this.jLabel20 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jLabel7 = new JLabel();
        this.fldCountBuilding = new JTextField();
        this.jLabel8 = new JLabel();
        this.fldCountPlan = new JTextField();
        this.jLabel3 = new JLabel();
        this.jLabel9 = new JLabel();
        this.fldCountLocation = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel10 = new JLabel();
        this.fldCountObservation = new JTextField();
        this.jLabel2 = new JLabel();
        this.jLabel11 = new JLabel();
        this.fldCountEvent = new JTextField();
        this.jLabel16 = new JLabel();
        this.chkCreateWithFoto = new JCheckBox();
        this.jButton7 = new JButton();
        this.jButton8 = new JButton();
        this.jButton16 = new JButton();
        this.jPanel3 = new JPanel();
        this.jLabel13 = new JLabel();
        this.jLabel6 = new JLabel();
        this.fldProjectExportDate = new JTextField();
        this.btnProjectExport = new JButton();
        this.btnImportProject = new JButton();
        this.jPanel5 = new JPanel();
        this.jLabel19 = new JLabel();
        this.jButton18 = new JButton();
        this.jLabel4 = new JLabel();
        this.panelFunctions = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.btnCheckUploads = new JButton();
        this.jButton10 = new JButton();
        this.jButton12 = new JButton();
        this.btnChangeToBsBuch = new JButton();
        this.btnCreateEmails = new JButton();
        this.jLabel15 = new JLabel();
        this.fldEmailAddress = new JTextField();
        this.jButton17 = new JButton();
        this.jButton19 = new JButton();
        this.btnMoveObservation = new JButton();
        this.jButton6 = new JButton();
        this.jButton5 = new JButton();
        this.jLabel17 = new JLabel();
        this.jLabel18 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.fldRecoverIds = new JTextArea();
        this.btnRecoverIds = new JButton();
        this.btnOpenDemo = new JButton();
        this.btnOpenJavaFx = new JButton();
        this.jLabel27 = new JLabel();
        this.panelCommand = new JPanel();
        this.fldCommand = new JTextField();
        this.btnCommandExe = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.fldCommandOutput = new JTextArea();
        this.setLayout(new BorderLayout());
        this.jTabbedPane1.setMinimumSize(new Dimension(5, 74));
        this.panelStandard.setLayout(new GridBagLayout());
        this.btnShowSQL.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnShowSQL, (String)NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.btnShowSQL.text"));
        this.btnShowSQL.setMinimumSize(new Dimension(5, 32));
        this.btnShowSQL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GridItPanel.this.btnShowSQLActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelStandard.add((Component)this.btnShowSQL, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btnDisableSpecialFeatures, (String)NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.btnDisableSpecialFeatures.text"));
        this.btnDisableSpecialFeatures.setMinimumSize(new Dimension(5, 32));
        this.btnDisableSpecialFeatures.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GridItPanel.this.btnDisableSpecialFeaturesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelStandard.add((Component)this.btnDisableSpecialFeatures, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btnImportTemplates, (String)NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.btnImportTemplates.text"));
        this.btnImportTemplates.setMinimumSize(new Dimension(5, 32));
        this.btnImportTemplates.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GridItPanel.this.btnImportTemplatesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelStandard.add((Component)this.btnImportTemplates, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btnElementHistory, (String)NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.btnElementHistory.text"));
        this.btnElementHistory.setMinimumSize(new Dimension(5, 32));
        this.btnElementHistory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GridItPanel.this.btnElementHistoryActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelStandard.add((Component)this.btnElementHistory, gridBagConstraints);
        this.btnSetWindowSize.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnSetWindowSize, (String)NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.btnSetWindowSize.text"));
        this.btnSetWindowSize.setMinimumSize(new Dimension(5, 32));
        this.btnSetWindowSize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GridItPanel.this.btnSetWindowSizeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelStandard.add((Component)this.btnSetWindowSize, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        this.jLabel14.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel14, (String)NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.jLabel14.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.jLabel14, gridBagConstraints);
        this.fldElementId.setText(NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.fldElementId.text"));
        this.fldElementId.setMinimumSize(new Dimension(5, 24));
        this.fldElementId.setPreferredSize(new Dimension(128, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.fldElementId, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton11, (String)NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.jButton11.text"));
        this.jButton11.setMinimumSize(new Dimension(5, 32));
        this.jButton11.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GridItPanel.this.jButton11ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel4.add((Component)this.jButton11, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelStandard.add((Component)this.jPanel4, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btnCreateUploads, (String)NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.btnCreateUploads.text"));
        this.btnCreateUploads.setMinimumSize(new Dimension(5, 32));
        this.btnCreateUploads.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GridItPanel.this.btnCreateUploadsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelStandard.add((Component)this.btnCreateUploads, gridBagConstraints);
        this.panelCheckLicenseKey.setLayout(new GridBagLayout());
        this.fldLicenseType.setModel(new DefaultComboBoxModel<String>(new String[]{"THEMIS", "THEMIS light", "VdS Betriebsbuch"}));
        this.fldLicenseType.setMinimumSize(new Dimension(5, 26));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelCheckLicenseKey.add(this.fldLicenseType, gridBagConstraints);
        this.fldLicenseKey.setText(NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.fldLicenseKey.text"));
        this.fldLicenseKey.setMinimumSize(new Dimension(5, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelCheckLicenseKey.add((Component)this.fldLicenseKey, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btnCheckLicenseKey, (String)NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.btnCheckLicenseKey.text"));
        this.btnCheckLicenseKey.setMinimumSize(new Dimension(5, 32));
        this.btnCheckLicenseKey.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GridItPanel.this.btnCheckLicenseKeyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelCheckLicenseKey.add((Component)this.btnCheckLicenseKey, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.panelStandard.add((Component)this.panelCheckLicenseKey, gridBagConstraints);
        this.jPanel9.setLayout(new GridBagLayout());
        this.jLabel26.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel26, (String)NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.jLabel26.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel9.add((Component)this.jLabel26, gridBagConstraints);
        this.fldUsernameNeu.setText(NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.fldUsernameNeu.text"));
        this.fldUsernameNeu.setMinimumSize(new Dimension(5, 24));
        this.fldUsernameNeu.setPreferredSize(new Dimension(128, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel9.add((Component)this.fldUsernameNeu, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btnSetUsernameNeu, (String)NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.btnSetUsernameNeu.text"));
        this.btnSetUsernameNeu.setMinimumSize(new Dimension(5, 32));
        this.btnSetUsernameNeu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GridItPanel.this.btnSetUsernameNeuActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel9.add((Component)this.btnSetUsernameNeu, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelStandard.add((Component)this.jPanel9, gridBagConstraints);
        this.jPanel6.setLayout(new GridBagLayout());
        this.jLabel31.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel31, (String)NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.jLabel31.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel6.add((Component)this.jLabel31, gridBagConstraints);
        this.fldUpdatePhase.setModel(new DefaultComboBoxModel<String>(new String[]{"PREPARE", "INIT", "OPEN"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        this.jPanel6.add(this.fldUpdatePhase, gridBagConstraints);
        this.fldAppVersion.setText(NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.fldAppVersion.text"));
        this.fldAppVersion.setMinimumSize(null);
        this.fldAppVersion.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel6.add((Component)this.fldAppVersion, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton13, (String)NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.jButton13.text_1"));
        this.jButton13.setMinimumSize(new Dimension(5, 32));
        this.jButton13.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GridItPanel.this.jButton13ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.ipady = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel6.add((Component)this.jButton13, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelStandard.add((Component)this.jPanel6, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel21, (String)NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.jLabel21.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.panelStandard.add((Component)this.jLabel21, gridBagConstraints);
        this.jTabbedPane1.addTab(NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.panelStandard.TabConstraints.tabTitle"), this.panelStandard);
        this.panelData.setLayout(new GridBagLayout());
        this.jLabel5.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.jLabel5.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelData.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel20.setForeground(new Color(153, 153, 153));
        Mnemonics.setLocalizedText((JLabel)this.jLabel20, (String)NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.jLabel20.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelData.add((Component)this.jLabel20, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.jLabel7.text"));
        this.jLabel7.setMinimumSize(new Dimension(5, 5));
        this.jLabel7.setPreferredSize(new Dimension(125, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.jLabel7, gridBagConstraints);
        this.fldCountBuilding.setText(NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.fldCountBuilding.text"));
        this.fldCountBuilding.setMinimumSize(new Dimension(5, 24));
        this.fldCountBuilding.setPreferredSize(new Dimension(87, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.fldCountBuilding, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel8, (String)NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.jLabel8.text"));
        this.jLabel8.setMinimumSize(new Dimension(5, 16));
        this.jLabel8.setPreferredSize(new Dimension(125, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.jLabel8, gridBagConstraints);
        this.fldCountPlan.setText(NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.fldCountPlan.text"));
        this.fldCountPlan.setMinimumSize(new Dimension(5, 24));
        this.fldCountPlan.setPreferredSize(new Dimension(87, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.fldCountPlan, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.jLabel3.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.jLabel3, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel9, (String)NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.jLabel9.text"));
        this.jLabel9.setMinimumSize(new Dimension(5, 16));
        this.jLabel9.setPreferredSize(new Dimension(125, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.jLabel9, gridBagConstraints);
        this.fldCountLocation.setText(NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.fldCountLocation.text"));
        this.fldCountLocation.setMinimumSize(new Dimension(5, 24));
        this.fldCountLocation.setPreferredSize(new Dimension(87, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.fldCountLocation, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.jLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel10, (String)NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.jLabel10.text"));
        this.jLabel10.setMinimumSize(new Dimension(5, 16));
        this.jLabel10.setPreferredSize(new Dimension(125, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.jLabel10, gridBagConstraints);
        this.fldCountObservation.setText(NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.fldCountObservation.text"));
        this.fldCountObservation.setMinimumSize(new Dimension(5, 24));
        this.fldCountObservation.setPreferredSize(new Dimension(87, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.fldCountObservation, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.jLabel2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.jLabel2, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel11, (String)NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.jLabel11.text"));
        this.jLabel11.setMinimumSize(new Dimension(5, 16));
        this.jLabel11.setPreferredSize(new Dimension(125, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.jLabel11, gridBagConstraints);
        this.fldCountEvent.setText(NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.fldCountEvent.text"));
        this.fldCountEvent.setMinimumSize(new Dimension(5, 24));
        this.fldCountEvent.setPreferredSize(new Dimension(87, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.fldCountEvent, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel16, (String)NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.jLabel16.text"));
        this.jLabel16.setMinimumSize(new Dimension(5, 16));
        this.jLabel16.setPreferredSize(new Dimension(125, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.jLabel16, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.chkCreateWithFoto, (String)NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.chkCreateWithFoto.text"));
        this.chkCreateWithFoto.setMinimumSize(new Dimension(10, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.chkCreateWithFoto, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton7, (String)NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.jButton7.text"));
        this.jButton7.setMinimumSize(new Dimension(5, 32));
        this.jButton7.setPreferredSize(new Dimension(250, 32));
        this.jButton7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GridItPanel.this.jButton7ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.jButton7, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelData.add((Component)this.jPanel2, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton8, (String)NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.jButton8.text"));
        this.jButton8.setMaximumSize(null);
        this.jButton8.setMinimumSize(null);
        this.jButton8.setPreferredSize(null);
        this.jButton8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GridItPanel.this.jButton8ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelData.add((Component)this.jButton8, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton16, (String)NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.jButton16.text"));
        this.jButton16.setMaximumSize(null);
        this.jButton16.setMinimumSize(null);
        this.jButton16.setPreferredSize(null);
        this.jButton16.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GridItPanel.this.jButton16ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelData.add((Component)this.jButton16, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.jLabel13.setForeground(new Color(153, 153, 153));
        Mnemonics.setLocalizedText((JLabel)this.jLabel13, (String)NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.jLabel13.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel3.add((Component)this.jLabel13, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.jLabel6.text_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel3.add((Component)this.jLabel6, gridBagConstraints);
        this.fldProjectExportDate.setText(NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.fldProjectExportDate.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.weightx = 1.0;
        this.jPanel3.add((Component)this.fldProjectExportDate, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btnProjectExport, (String)NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.btnProjectExport.text"));
        this.btnProjectExport.setMaximumSize(null);
        this.btnProjectExport.setMinimumSize(null);
        this.btnProjectExport.setPreferredSize(null);
        this.btnProjectExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GridItPanel.this.btnProjectExportActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel3.add((Component)this.btnProjectExport, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btnImportProject, (String)NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.btnImportProject.text"));
        this.btnImportProject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GridItPanel.this.btnImportProjectActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel3.add((Component)this.btnImportProject, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.panelData.add((Component)this.jPanel3, gridBagConstraints);
        this.jPanel5.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.panelData.add((Component)this.jPanel5, gridBagConstraints);
        this.jLabel19.setForeground(new Color(153, 153, 153));
        Mnemonics.setLocalizedText((JLabel)this.jLabel19, (String)NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.jLabel19.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelData.add((Component)this.jLabel19, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton18, (String)NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.jButton18.text_1"));
        this.jButton18.setMaximumSize(null);
        this.jButton18.setMinimumSize(null);
        this.jButton18.setPreferredSize(null);
        this.jButton18.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GridItPanel.this.jButton18ActionPerformed1(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelData.add((Component)this.jButton18, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.jLabel4.text_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelData.add((Component)this.jLabel4, gridBagConstraints);
        this.jTabbedPane1.addTab(NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.panelData.TabConstraints.tabTitle"), this.panelData);
        this.panelFunctions.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.btnCheckUploads, (String)NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.btnCheckUploads.text"));
        this.btnCheckUploads.setMinimumSize(null);
        this.btnCheckUploads.setPreferredSize(null);
        this.btnCheckUploads.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GridItPanel.this.btnCheckUploadsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.btnCheckUploads, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton10, (String)NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.jButton10.text"));
        this.jButton10.setMinimumSize(null);
        this.jButton10.setPreferredSize(null);
        this.jButton10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GridItPanel.this.jButton10ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.jButton10, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton12, (String)NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.jButton12.text"));
        this.jButton12.setMinimumSize(null);
        this.jButton12.setPreferredSize(null);
        this.jButton12.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GridItPanel.this.jButton12ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.jButton12, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btnChangeToBsBuch, (String)NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.btnChangeToBsBuch.text"));
        this.btnChangeToBsBuch.setMinimumSize(null);
        this.btnChangeToBsBuch.setPreferredSize(null);
        this.btnChangeToBsBuch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GridItPanel.this.btnChangeToBsBuchActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.btnChangeToBsBuch, gridBagConstraints);
        this.btnCreateEmails.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnCreateEmails, (String)NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.btnCreateEmails.text"));
        this.btnCreateEmails.setBorder(new SoftBevelBorder(0));
        this.btnCreateEmails.setMinimumSize(null);
        this.btnCreateEmails.setPreferredSize(null);
        this.btnCreateEmails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GridItPanel.this.btnCreateEmailsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.btnCreateEmails, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel15, (String)NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.jLabel15.text"));
        this.jLabel15.setMinimumSize(new Dimension(5, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.jLabel15, gridBagConstraints);
        this.fldEmailAddress.setText(NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.fldEmailAddress.text"));
        this.fldEmailAddress.setMinimumSize(new Dimension(5, 24));
        this.fldEmailAddress.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GridItPanel.this.fldEmailAddressActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.fldEmailAddress, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton17, (String)NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.jButton17.text"));
        this.jButton17.setMinimumSize(null);
        this.jButton17.setPreferredSize(null);
        this.jButton17.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GridItPanel.this.jButton17ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.jButton17, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton19, (String)NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.jButton18.text"));
        this.jButton19.setMinimumSize(null);
        this.jButton19.setPreferredSize(null);
        this.jButton19.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GridItPanel.this.jButton18ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.jButton19, gridBagConstraints);
        this.btnMoveObservation.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnMoveObservation, (String)NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.btnMoveObservation.text"));
        this.btnMoveObservation.setBorder(new SoftBevelBorder(0));
        this.btnMoveObservation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GridItPanel.this.btnMoveObservationActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.btnMoveObservation, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton6, (String)NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.jButton6.text"));
        this.jButton6.setMinimumSize(null);
        this.jButton6.setPreferredSize(null);
        this.jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GridItPanel.this.jButton6ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.jButton6, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton5, (String)NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.jButton5.text"));
        this.jButton5.setMinimumSize(null);
        this.jButton5.setPreferredSize(null);
        this.jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GridItPanel.this.jButton5ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.jButton5, gridBagConstraints);
        this.jLabel17.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel17, (String)NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.jLabel17.text"));
        this.jLabel17.setMinimumSize(new Dimension(5, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.jLabel17, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel18, (String)NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.jLabel18.text"));
        this.jLabel18.setMinimumSize(new Dimension(5, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.jLabel18, gridBagConstraints);
        this.jScrollPane1.setMinimumSize(new Dimension(10, 20));
        this.jScrollPane1.setPreferredSize(new Dimension(309, 83));
        this.fldRecoverIds.setColumns(20);
        this.fldRecoverIds.setRows(5);
        this.jScrollPane1.setViewportView(this.fldRecoverIds);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btnRecoverIds, (String)NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.btnRecoverIds.text_1"));
        this.btnRecoverIds.setMinimumSize(null);
        this.btnRecoverIds.setPreferredSize(null);
        this.btnRecoverIds.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GridItPanel.this.btnRecoverIdsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.btnRecoverIds, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btnOpenDemo, (String)NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.btnOpenDemo.text"));
        this.btnOpenDemo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GridItPanel.this.btnOpenDemoActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.btnOpenDemo, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btnOpenJavaFx, (String)NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.btnOpenJavaFx.text"));
        this.btnOpenJavaFx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GridItPanel.this.btnOpenJavaFxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.btnOpenJavaFx, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel27, (String)NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.jLabel27.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jLabel27, gridBagConstraints);
        this.jScrollPane3.setViewportView(this.jPanel1);
        this.panelFunctions.add((Component)this.jScrollPane3, "Center");
        this.jTabbedPane1.addTab(NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.panelFunctions.TabConstraints.tabTitle"), this.panelFunctions);
        this.fldCommand.setText(NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.fldCommand.text"));
        this.fldCommand.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GridItPanel.this.fldCommandActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.btnCommandExe, (String)NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.btnCommandExe.text"));
        this.btnCommandExe.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GridItPanel.this.btnCommandExeActionPerformed(evt);
            }
        });
        this.fldCommandOutput.setColumns(20);
        this.fldCommandOutput.setFont(new Font("Monospaced", 0, 10));
        this.fldCommandOutput.setRows(5);
        this.jScrollPane2.setViewportView(this.fldCommandOutput);
        GroupLayout panelCommandLayout = new GroupLayout(this.panelCommand);
        this.panelCommand.setLayout(panelCommandLayout);
        panelCommandLayout.setHorizontalGroup(panelCommandLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelCommandLayout.createSequentialGroup().addContainerGap().addGroup(panelCommandLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 321, Short.MAX_VALUE).addGroup(panelCommandLayout.createSequentialGroup().addComponent(this.fldCommand).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCommandExe))).addContainerGap()));
        panelCommandLayout.setVerticalGroup(panelCommandLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelCommandLayout.createSequentialGroup().addContainerGap().addGroup(panelCommandLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fldCommand, -2, -1, -2).addComponent(this.btnCommandExe)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 644, Short.MAX_VALUE).addContainerGap()));
        this.jTabbedPane1.addTab(NbBundle.getMessage(GridItPanel.class, (String)"GridItPanel.panelCommand.TabConstraints.tabTitle"), this.panelCommand);
        this.add((Component)this.jTabbedPane1, "Center");
    }

    private void btnCommandExeActionPerformed(ActionEvent evt) {
        String cmd = this.fldCommand.getText().trim();
        if (!"".equals(cmd)) {
            new ThemisCommand(cmd, (Terminal)new TextAreaTerminal());
        }
        this.fldCommand.setText("");
    }

    private void fldCommandActionPerformed(ActionEvent evt) {
        String cmd = this.fldCommand.getText().trim();
        if (!"".equals(cmd)) {
            new ThemisCommand(cmd, (Terminal)new TextAreaTerminal());
        }
        this.fldCommand.setText("");
    }

    private void btnRecoverIdsActionPerformed(ActionEvent evt) {
        String[] ids2;
        String[] ids;
        String[] ids1 = this.fldRecoverIds.getText().split(",");
        for (String id : ids = ids1.length > (ids2 = this.fldRecoverIds.getText().split("\n")).length ? ids1 : ids2) {
            try {
                ResultSet rs = this.app.getProject().getDatastorage().executeQueryForResultSet("select h.*,el.title from tdtaelementhistory AS h LEFT JOIN tdtaelementlng AS el ON (h.idelement=el.idelement) WHERE h.idelement=" + id + " ORDER BY savedate DESC LIMIT 1", true);
                if (rs.next()) {
                    String xml = Util.inflate((byte[])rs.getBytes("data"));
                    if (xml != null) {
                        CmsElement ele = this.app.getProject().loadElement(Long.parseLong(id), this.app.getProject().getUser());
                        ele.update(xml);
                        ele.save();
                        continue;
                    }
                    this.project.getLogger().warning("No XML found for ID " + id);
                    continue;
                }
                this.project.getLogger().warning("No record found for ID " + id);
            }
            catch (SQLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void jButton5ActionPerformed(ActionEvent evt) {
        Dialogs.getInstance().showErrorDialog("Nicht implementiert");
    }

    private void jButton6ActionPerformed(ActionEvent evt) {
        this.app.getProject().getLogger().setLevel(Level.ALL);
        this.app.getProject().getLogger().setLevel(Level.FINE);
        this.app.setPerformancetest(true);
    }

    private void btnMoveObservationActionPerformed(ActionEvent evt) {
        ArrayList ids = this.project.getSelectionManager().getSelectedObservationIds();
        ThemisTaskWithDialog.createTaskWithCounterAndCancel((String)"Beobachtungen werden migriert", ph -> {
            ph.switchToDeterminate(ids.size());
            Iterator iterator = ids.iterator();
            while (iterator.hasNext()) {
                long id = (Long)iterator.next();
                CmsObservation obs = (CmsObservation)this.project.loadElement(id, this.project.getUser());
                CmsLocation loc = this.project.createLocation(-1L);
                loc.setAttributeValue("title", obs.getTitle());
                loc.save();
                obs.setLocation(loc);
                obs.save();
                ph.increaseProgress(1);
            }
        });
    }

    private void jButton18ActionPerformed(ActionEvent evt) {
        ViewHelper.openExplorerTopComponent((ViewHelper.TC)ViewHelper.TC.TEMPLATEMATCHING);
    }

    private void jButton17ActionPerformed(ActionEvent evt) {
        try {
            File f = new ThemisFileDialog("Excel Datei w\u00e4hlen", ThemisFileDialog.DIALOGTYPE.SAVE, this.app.getPathExportFolder(), null, (FileFilter)new FileNameExtensionFilter("Microsoft Excel (*.xls, *.xlsx)", "xls", "xlsx"), null, false).getSelectedFile();
            if (f != null) {
                Workbook workbook = new Workbook(f.getAbsolutePath());
                workbook.save(f.getParent() + "/" + f.getName() + ".pdf", 13);
            }
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    private void fldEmailAddressActionPerformed(ActionEvent evt) {
    }

    private void btnCreateEmailsActionPerformed(ActionEvent evt) {
        new HtmlMailPanel().showDialog();
    }

    private void btnChangeToBsBuchActionPerformed(ActionEvent evt) {
        this.project.setProjectProperty("license.level", "5");
    }

    private void jButton12ActionPerformed(ActionEvent evt) {
        new EmailSyncPanel().showDialog();
    }

    private void jButton10ActionPerformed(ActionEvent evt) {
        JavaFxSwingDialog dlg = new JavaFxSwingDialog("texteditor", 800, 600);
        ThemisTextEditor2 fx2 = new ThemisTextEditor2();
        fx2.setText("<h2>Apollo 11</h2>Apollo 11 was the spaceflight that landed the first humans, Americans <a href='http://en.wikipedia.org/wiki/Neil_Armstrong'>Neil Armstrong</a> and <a href='http://en.wikipedia.org/wiki/Buzz_Aldrin'>Buzz Aldrin</a>, on the Moon on July 20, 1969, at 20:18 UTC. <b>Armstrong</b> became the first to step onto the lunar surface 6 hours later on July 21 at 02:56 UTC.");
        dlg.setContent((Node)fx2);
        dlg.show();
    }

    private void btnCheckUploadsActionPerformed(ActionEvent evt) {
        ArrayList notUsed = ThemisUtil.removeUnusedUploads();
        System.out.println("NOT USED: =================================");
        for (File f : notUsed) {
            System.out.println(f.getAbsolutePath());
        }
    }

    private void jButton18ActionPerformed1(ActionEvent evt) {
    }

    private void btnImportProjectActionPerformed(ActionEvent evt) {
        if (!ThemisApplication.getInstance().isProjectOpen()) {
            return;
        }
        File f = new ThemisFileDialog("Ordner ausw\u00e4hlen, der importiert werden soll", ThemisFileDialog.DIALOGTYPE.DIRECTORY, null, null, null, null, false).getSelectedFile();
        if (f != null) {
            ThemisTaskWithDialog.createTaskWithCounterAndCancel((String)"Projekt importieren", ph -> ThemisFile.importProject((File)f, (ProgressHandler)ph));
        }
    }

    private void btnProjectExportActionPerformed(ActionEvent evt) {
        File f = new ThemisFileDialog("Export-Ordner ausw\u00e4hlen", ThemisFileDialog.DIALOGTYPE.DIRECTORY, null, null, null, null, false).getSelectedFile();
        if (f != null) {
            ThemisTaskWithDialog.createTaskWithCounterAndCancel((String)"Projekt exportieren", ph -> {
                try {
                    Date dt = Util.parseDate((String)this.fldProjectExportDate.getText(), (String)Util.DATE_READ, (TimeZone)TimeZone.getDefault());
                    ThemisFile.exportProject((File)f, (Date)dt, (ProgressHandler)ph);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            });
        }
    }

    private void jButton16ActionPerformed(ActionEvent evt) {
        File f = new ThemisFileDialog("Datenbank-Sicherung ausw\u00e4hlen", ThemisFileDialog.DIALOGTYPE.OPEN, null, null, null, null, false).getSelectedFile();
        File f2 = null;
        if (f != null) {
            f2 = new ThemisFileDialog("Projektordner w\u00e4hlen", ThemisFileDialog.DIALOGTYPE.DIRECTORY, f.getParentFile().getParentFile(), null, null, null, false).getSelectedFile();
        }
        if (f != null && f2 != null) {
            ThemisApplication.getInstance().getProject().restoreDatabase(f, f2);
        }
    }

    private void jButton8ActionPerformed(ActionEvent evt) {
        this.backupDatabase();
    }

    private void jButton7ActionPerformed(ActionEvent evt) {
        int countDocument = 5;
        int countCompany = 5;
        int countBuilding = Integer.parseInt(this.fldCountBuilding.getText());
        int countPlan = Integer.parseInt(this.fldCountPlan.getText());
        int countLocation = Integer.parseInt(this.fldCountLocation.getText());
        int countObservation = Integer.parseInt(this.fldCountObservation.getText());
        int countEvent = Integer.parseInt(this.fldCountEvent.getText());
        boolean withFoto = this.chkCreateWithFoto.isSelected();
        this.createDummyData(countBuilding, countPlan, countCompany, countDocument, countEvent, countLocation, countObservation, withFoto);
    }

    private void jButton13ActionPerformed(ActionEvent evt) {
        String v = this.fldAppVersion.getText();
        int appversion = Util.parseInt((String)v, (int)-1);
        if (appversion > 0) {
            String phase;
            switch (phase = (String)this.fldUpdatePhase.getSelectedItem()) {
                case "PREPARE": {
                    ThemisProjectUpdater.getInstance().executeUpdate(ThemisProjectUpdater.Phase.PREPARE, appversion, null);
                    break;
                }
                case "INIT": {
                    ThemisProjectUpdater.getInstance().executeUpdate(ThemisProjectUpdater.Phase.INIT, appversion, null);
                    break;
                }
                case "OPEN": {
                    ThemisProjectUpdater.getInstance().executeUpdate(ThemisProjectUpdater.Phase.OPEN, appversion, null);
                }
            }
        }
    }

    private void btnSetUsernameNeuActionPerformed(ActionEvent evt) {
        String name = this.fldUsernameNeu.getText();
        if (!"".equals(name.trim())) {
            this.project.setUser(name);
            ThemisActionProvider.getInstance().invokeAction(ThemisAction.THEMIS_INITIALISATION_DONE);
        }
    }

    private void btnCheckLicenseKeyActionPerformed(ActionEvent evt) {
    }

    private void btnCreateUploadsActionPerformed(ActionEvent evt) {
        this.createUploads();
    }

    private void jButton11ActionPerformed(ActionEvent evt) {
        String id = this.fldElementId.getText();
        CmsElement element = this.project.loadElement(Long.parseLong(id), this.project.getUser());
        Dialogs.getInstance().showInfoDialog(element.toXML());
    }

    private void btnSetWindowSizeActionPerformed(ActionEvent evt) {
        Frame f = WindowManager.getDefault().getMainWindow();
        double w = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        double h = Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        System.out.println("-");
        System.out.println("Location: " + f.getLocation());
        System.out.println("LocationOnScreen: " + f.getLocationOnScreen());
        System.out.println("Screen: " + Toolkit.getDefaultToolkit().getScreenSize());
        System.out.println("Frame before: " + f.getSize());
        int d = 8;
        int tw = 1920;
        int th = 1080;
        int fw = (int)w + 2 * d;
        int fh = th * fw / tw;
        f.setSize(fw, fh);
        f.setLocation(-d, 0);
        System.out.println("Frame after: " + f.getSize());
    }

    private void btnElementHistoryActionPerformed(ActionEvent evt) {
        if (this.app.getProject().isOpen()) {
            JDialog dlg = new JDialog();
            dlg.getContentPane().add(new HistoryPanel(this.app.getProject().getDatastorage()));
            dlg.setDefaultCloseOperation(2);
            dlg.setResizable(true);
            dlg.pack();
            dlg.setVisible(true);
        } else {
            Dialogs.getInstance().showWarningDialog("no project open");
        }
    }

    private void btnImportTemplatesActionPerformed(ActionEvent evt) {
        TemplateImportTarget target = new TemplateImportTarget();
        ImportWizard2 panel = new ImportWizard2((ImportTarget)target);
        try {
            panel.showDialog();
        }
        catch (Exception ex) {
            ThemisApplication.getInstance().getDialog().showErrorDialog("EventReportAction.errorFileExists.text");
        }
    }

    private void btnDisableSpecialFeaturesActionPerformed(ActionEvent evt) {
        LicenseUtils.setNoSpecificClient();
    }

    private void btnShowSQLActionPerformed(ActionEvent evt) {
        if (this.app.getProject().isOpen()) {
            new SQLQueryPanel(this.app.getProject().getDatastorage()).showDialog();
        } else {
            Dialogs.getInstance().showWarningDialog("no project open");
        }
    }

    private void btnOpenDemoActionPerformed(ActionEvent evt) {
        UpdateManager updater = new UpdateManager();
        updater.updateJRE(false);
    }

    private void btnOpenJavaFxActionPerformed(ActionEvent evt) {
        Platform.setImplicitExit((boolean)false);
        String dialogCode = "javafx-test";
        JDialog swingDialog = new JDialog((Window)THEMIS.getMainWindow(), "JavaFx Test", Dialog.ModalityType.APPLICATION_MODAL);
        swingDialog.setDefaultCloseOperation(2);
        try {
            BufferedImage image = ImageHelper.loadImage((URL)JavaFxSwingDialog.class.getResource("/at/grid/themis/ontology/javafx/media/themis.gif"));
            swingDialog.setIconImage(image);
        }
        catch (IOException image) {
            // empty catch block
        }
        Dimension min = new Dimension(500, 300);
        Dimension pref = ThemisUtil.getWindowSize((String)dialogCode, (int)((int)min.getWidth()), (int)((int)min.getHeight()), (ThemisApplication)ThemisApplication.getInstance());
        VBox panel = new VBox();
        panel.setPadding(new javafx.geometry.Insets(5.0));
        panel.setSpacing(5.0);
        Label lblOne = new Label("JavaFx Tests");
        lblOne.setStyle("-fx-font: 16px \"Calibri\"; -fx-font-weight: bold;");
        lblOne.setMinHeight(Double.NEGATIVE_INFINITY);
        panel.getChildren().add((Object)lblOne);
        Label lblTwo = new Label("Accelerate your SaaS business by growing your wealth of contacts and learning new strategies to enhance profit margins.");
        lblTwo.setStyle("-fx-text-fill: grey");
        lblTwo.setWrapText(true);
        lblTwo.setMinHeight(Double.NEGATIVE_INFINITY);
        panel.getChildren().add((Object)lblTwo);
        Label lblThree = new Label("Being among the top internet conferences, leaders in the field of blockchain will convene at our event and brainstorm on groundbreaking developments as well as their impact.");
        lblThree.setStyle("-fx-text-fill: grey");
        lblThree.setWrapText(true);
        lblThree.setMinHeight(Double.NEGATIVE_INFINITY);
        panel.getChildren().add((Object)lblThree);
        TextArea fldOne = new TextArea();
        fldOne.setMinHeight(100.0);
        panel.getChildren().add((Object)fldOne);
        TextField fldTwo = new TextField();
        panel.getChildren().add((Object)fldTwo);
        TextArea fldThree = new TextArea();
        fldThree.setMinHeight(100.0);
        panel.getChildren().add((Object)fldThree);
        ListView lstOne = new ListView();
        lstOne.setMinHeight(100.0);
        for (int i = 0; i < 100; ++i) {
            lstOne.getItems().add((Object)("Item #" + String.valueOf(i)));
        }
        VBox.setVgrow((Node)lstOne, (Priority)Priority.ALWAYS);
        panel.getChildren().add((Object)lstOne);
        JFXPanel fxPanel = new JFXPanel();
        fxPanel.setMinimumSize(min);
        fxPanel.setPreferredSize(pref);
        fxPanel.setSize(pref);
        VBox dialogFrame = new VBox();
        ScrollPane scroll = new ScrollPane();
        scroll.setFitToHeight(true);
        scroll.setFitToWidth(true);
        scroll.setHbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        scroll.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        scroll.setFocusTraversable(false);
        scroll.setContent((Node)panel);
        VBox.setVgrow((Node)scroll, (Priority)Priority.ALWAYS);
        dialogFrame.getChildren().add((Object)scroll);
        dialogFrame.getChildren().add((Object)new Separator());
        HBox buttonBox = new HBox();
        buttonBox.setPadding(new javafx.geometry.Insets(5.0));
        buttonBox.setSpacing(5.0);
        buttonBox.setAlignment(Pos.CENTER);
        Button btnSave = new Button("Speichern");
        btnSave.setMinWidth(100.0);
        btnSave.setMinHeight(30.0);
        buttonBox.getChildren().add((Object)btnSave);
        Button btnCancel = new Button("Abbrechen");
        btnCancel.setMinWidth(100.0);
        btnCancel.setMinHeight(30.0);
        btnCancel.setOnAction(event -> {
            ThemisUtil.setWindowSize((String)dialogCode, (Dimension)swingDialog.getSize(), (ThemisApplication)ThemisApplication.getInstance());
            swingDialog.dispose();
        });
        buttonBox.getChildren().add((Object)btnCancel);
        dialogFrame.getChildren().add((Object)buttonBox);
        Scene scene = new Scene((Parent)dialogFrame);
        fxPanel.setScene(scene);
        swingDialog.setMinimumSize(fxPanel.getMinimumSize());
        swingDialog.setSize(fxPanel.getSize());
        swingDialog.setPreferredSize(fxPanel.getPreferredSize());
        swingDialog.add((Component)fxPanel);
        swingDialog.pack();
        swingDialog.setLocationRelativeTo(THEMIS.getMainWindow());
        swingDialog.setVisible(true);
    }

    private void updateAllTablesRemoveChar() {
        ThemisApplication.getLogger().info("starting with tdtaElementLng ...");
        int count = this.updatetable("tdtaelementlng", "summary");
        ThemisApplication.getLogger().info("... tdtaElementLng done, " + count + " replaced");
        ThemisApplication.getLogger().info("starting with tdtaeleobservation ...");
        count = this.updatetable("tdtaeleobservation", "description");
        ThemisApplication.getLogger().info("... tdtaeleobservation done, " + count + " replaced");
        ThemisApplication.getLogger().info("starting with tdtaelehistory ...");
        count = this.updatetable("tdtaelehistory", "description");
        ThemisApplication.getLogger().info("... tdtaelehistory done, " + count + " replaced");
        ThemisApplication.getLogger().info("starting with tdtaeleobservationtemplate ...");
        count = this.updatetable("tdtaeleobservationtemplate", "description");
        ThemisApplication.getLogger().info("... tdtaeleobservationtemplate done, " + count + " replaced");
    }

    private int updatetable(String tbl, String fld) {
        DataStorage ds = this.project.getDatastorage();
        String sql = "SELECT idelement," + fld + " FROM " + tbl + " WHERE " + fld + " LIKE '%\u0002%'";
        List recs = ds.executeQuery(sql, true).getResult();
        int count = 0;
        for (DataRecord rec : recs) {
            long id = rec.getLong("idelement");
            String s = rec.getString(fld);
            int l1 = s.length();
            int l2 = (s = s.replaceAll("\u0002", "")).length();
            if (l2 < l1) {
                ++count;
                ds.executeUpdate("UPDATE " + tbl + " SET " + fld + " = " + Util.toSqlString((String)s) + " WHERE idelement=" + id, false);
            }
            boolean bl = true;
        }
        return count;
    }

    private String getFolderContent(File f, int level) {
        Timer t = Timer.start();
        StringBuilder sb = new StringBuilder();
        System.out.println("Searching folder " + f.getAbsolutePath() + " ...");
        Object[] files = f.listFiles(pathname -> pathname.isDirectory() && !new File(pathname, "statistics.properties").exists());
        if (files != null) {
            Arrays.sort(files);
            for (Object file : files) {
                if (level >= 1) continue;
                this.getFolderContent((File)file, level + 1);
            }
            sb.append("... found " + files.length + " files at " + f.getAbsolutePath() + " in " + t.end() + " ms").append("\n");
        }
        return sb.toString();
    }

    private String getFolderContent2(File f, int level) {
        Timer t = Timer.start();
        StringBuilder sb = new StringBuilder();
        sb.append("Searching folder " + f.getAbsolutePath() + " ...").append("\n");
        Object[] files = f.listFiles(pathname -> pathname.isDirectory() && !ThemisProject.isProjectFolder((File)pathname));
        if (files != null) {
            Arrays.sort(files);
            for (Object file : files) {
                sb.append("found file " + ((File)file).getName()).append("\n");
                if (level >= 1) continue;
                this.getFolderContent((File)file, level + 1);
            }
            sb.append("... found " + files.length + " files at " + f.getAbsolutePath() + " in " + t.end() + " ms").append("\n");
        }
        return sb.toString();
    }

    private Properties getProperties(ZipFile zip, ZipEntry entry) throws IOException {
        InputStream inputStream = zip.getInputStream(entry);
        Properties props = new Properties();
        props.load(inputStream);
        inputStream.close();
        return props;
    }

    private Document getXmlDocument(ZipFile zip, ZipEntry entry) throws IOException, JDOMException {
        InputStream inputStream = zip.getInputStream(entry);
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(inputStream);
        return doc;
    }

    private CmsElement createElement(ZipFile zip, ZipEntry entry) throws IOException, JDOMException {
        InputStream inputStream = zip.getInputStream(entry);
        InputStreamReader reader = new InputStreamReader(inputStream, "UTF-8");
        InputSource is = new InputSource(reader);
        is.setEncoding("UTF-8");
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(is);
        CmsElement e = this.project.createElement(doc, this.project.getUser());
        return e;
    }

    class TextAreaTerminal
    implements Terminal {
        TextAreaTerminal() {
        }

        public void display(String text) {
            GridItPanel.this.fldCommandOutput.append("\n\n" + text);
        }

        public String getIdentification() {
            return "THEMIS";
        }
    }
}

