/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.special.grid;

import at.grid.cms.CmsApplication;
import at.grid.cms.attribute.UploadAttribute;
import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsUser;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.ontology.Closing;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisFolder;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.ThemisUtil;
import at.grid.themis.ontology.element.CmsIcon;
import at.grid.themis.ontology.javafx.JavaFxFactory;
import at.grid.themis.ontology.javafx.ThemisTaskWithFxDialog;
import at.grid.themis.ontology.template.TemplateManager;
import at.grid.util.ImageInfo;
import at.grid.util.ProgressHandler;
import at.grid.util.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import org.apache.commons.io.FilenameUtils;
import org.openide.util.Exceptions;

public class VdSIconsFxPane
extends ScrollPane {
    private ThemisApplication app = ThemisApplication.getInstance();
    private File tempFolder = new File(this.app.getApplicationDataTempFolder().getAbsolutePath() + "/" + Long.toString(new Date().getTime()));
    private ListView<File> iconsList;
    private File lastDirectory;
    private ArrayList<File> tooBigIcons = new ArrayList();
    private File template;
    private File destFolder;

    public VdSIconsFxPane() {
        this.render();
    }

    private void render() {
        this.setFitToHeight(true);
        this.setFitToWidth(true);
        this.setPadding(new Insets(16.0));
        VBox root = new VBox();
        root.setSpacing(16.0);
        Label heading = JavaFxFactory.createLabelHeading((String)"VdS Iconverwaltung");
        root.getChildren().add((Object)heading);
        GridPane pane = new GridPane();
        VBox.setVgrow((Node)pane, (Priority)Priority.ALWAYS);
        pane.setHgap(16.0);
        pane.setVgap(8.0);
        pane.getColumnConstraints().add((Object)JavaFxFactory.getColumnConstraintsLabel());
        pane.getColumnConstraints().add((Object)JavaFxFactory.getColumnConstraintsField());
        pane.getColumnConstraints().add((Object)JavaFxFactory.getColumnConstraintsButton());
        Label filesLabel = JavaFxFactory.createLabel((String)"VdS Icons");
        this.iconsList = new ListView();
        this.iconsList.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.iconsList.setMaxHeight(150.0);
        this.iconsList.setMaxWidth(Double.MAX_VALUE);
        this.iconsList.setCellFactory(p -> new ListCell<File>(){

            public void updateItem(File file, boolean empty) {
                super.updateItem((Object)file, empty);
                if (empty || file == null) {
                    this.setText(null);
                    this.setGraphic(null);
                } else {
                    this.setText(file.getName());
                    try {
                        ImageView icon = new ImageView(new Image((InputStream)new FileInputStream(file), 20.0, 20.0, false, false));
                        this.setGraphic((Node)icon);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        // empty catch block
                    }
                }
            }
        });
        this.iconsList.setOnDragOver(event -> {
            if (event.getGestureSource() != this.iconsList && event.getDragboard().hasFiles()) {
                event.acceptTransferModes(TransferMode.COPY_OR_MOVE);
            }
            event.consume();
        });
        this.iconsList.setOnDragDropped(event -> {
            Dragboard db = event.getDragboard();
            boolean success = false;
            if (db.hasFiles()) {
                List files = db.getFiles();
                this.addIconsToList(files);
                success = true;
            }
            event.setDropCompleted(success);
            event.consume();
        });
        GridPane.setRowSpan(this.iconsList, (Integer)2);
        Button add = JavaFxFactory.createButton((String)"Hinzuf\u00fcgen", e -> {
            List files;
            FileChooser chooser = new FileChooser();
            chooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("PNG files (*.png)", new String[]{"*.png"}));
            chooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("JPG files (*.jpg)", new String[]{"*.jpeg"}));
            if (this.lastDirectory != null) {
                chooser.setInitialDirectory(this.lastDirectory);
            }
            if ((files = chooser.showOpenMultipleDialog(null)) != null) {
                this.addIconsToList(files);
            }
        });
        add.setMinWidth(150.0);
        Button remove = JavaFxFactory.createButton((String)"Entfernen", e -> this.iconsList.getItems().removeAll((Collection)this.iconsList.getSelectionModel().getSelectedItems()));
        remove.setMinWidth(150.0);
        pane.addRow(0, new Node[]{filesLabel, this.iconsList, add});
        pane.addRow(1, new Node[]{remove});
        Label iconsCheck = JavaFxFactory.createLabel((String)"zu gro\u00dfe Icons");
        TextField iconsCheckFld = JavaFxFactory.createTextField((String)"-");
        iconsCheckFld.setDisable(true);
        Button check = JavaFxFactory.createButton((String)"\u00dcberpr\u00fcfen", e -> ThemisTaskWithFxDialog.createTask((String)"Icons werden \u00fcberpr\u00fcft ...", ph -> {
            try {
                this.tooBigIcons.clear();
                for (File f : this.iconsList.getItems()) {
                    ImageInfo info = new ImageInfo(f);
                    if (info.getLongSide() <= 120) continue;
                    this.tooBigIcons.add(f);
                }
                iconsCheckFld.setText(String.valueOf(this.tooBigIcons.size()) + " / " + String.valueOf(this.iconsList.getItems().size()));
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }));
        check.setMinWidth(150.0);
        pane.addRow(2, new Node[]{iconsCheck, iconsCheckFld, check});
        Button correct = JavaFxFactory.createButton((String)"Korrigieren", e -> ThemisTaskWithFxDialog.createTask((String)"Icons werden korrigiert ...", ph -> {
            try {
                ThemisUtil.updateImage(this.tooBigIcons, (int)100, (float)100.0f, (ProgressHandler)ph);
                iconsCheckFld.setText("-");
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }).withCounter());
        correct.setMinWidth(150.0);
        pane.addRow(3, new Node[]{new Region(), new Region(), correct});
        Label templateLabel = JavaFxFactory.createLabel((String)"Vorlage");
        TextField templateFld = JavaFxFactory.createTextField((String)"");
        templateFld.setDisable(true);
        Button choose = JavaFxFactory.createButton((String)"Ausw\u00e4hlen", e -> {
            File file;
            FileChooser chooser = new FileChooser();
            chooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Template (*.xlsx, *.xls, *.csv)", new String[]{"*.xlsx", "*.xls", "*.csv"}));
            if (this.lastDirectory != null) {
                chooser.setInitialDirectory(this.lastDirectory);
            }
            if ((file = chooser.showOpenDialog(null)) != null) {
                this.template = file;
                templateFld.setText(this.template.getName());
            }
        });
        choose.setMinWidth(150.0);
        pane.addRow(4, new Node[]{templateLabel, templateFld, choose});
        Label destFolderLabel = JavaFxFactory.createLabel((String)"Zielverzeichnis");
        TextField destFolderFld = JavaFxFactory.createTextField((String)"");
        destFolderFld.setDisable(true);
        Button chooseFolder = JavaFxFactory.createButton((String)"Ausw\u00e4hlen", e -> {
            File file;
            DirectoryChooser chooser = new DirectoryChooser();
            if (this.lastDirectory != null) {
                chooser.setInitialDirectory(this.lastDirectory);
            }
            if ((file = chooser.showDialog(null)) != null) {
                this.destFolder = file;
                destFolderFld.setText(this.destFolder.getPath());
            }
        });
        chooseFolder.setMinWidth(150.0);
        pane.addRow(5, new Node[]{destFolderLabel, destFolderFld, chooseFolder});
        root.getChildren().add((Object)pane);
        HBox controls = new HBox();
        controls.setSpacing(16.0);
        controls.setAlignment(Pos.CENTER);
        Button readIcon = JavaFxFactory.createButton((String)"Icons aktualisieren", e -> {
            if (this.destFolder == null) {
                Dialogs.getInstance().showWarningDialog("Kein Zielverzeichnis ausgew\u00e4hlt!");
                return;
            }
            ThemisTaskWithFxDialog.createTask((String)"Die Vorlage wird aktualisiert ...", ph -> {
                boolean loaded;
                String result;
                ThemisProject project = this.app.getProject();
                File folder = new File(this.tempFolder, "project");
                if (folder.exists()) {
                    folder.delete();
                }
                if ((result = project.createProject(new ThemisFolder(folder), null)) != null) {
                    Dialogs.getInstance().showErrorDialog(result);
                    return;
                }
                TemplateManager manager = project.getTemplateManger();
                if (this.template != null && !(loaded = manager.loadTemplatesFromXls(this.template))) {
                    Dialogs.getInstance().showErrorDialog("Die Vorlage konnte nicht geladen werden.");
                    return;
                }
                Map prevIcons = project.loadIcons();
                ObservableList newIcons = FXCollections.observableArrayList((Collection)this.iconsList.getItems());
                for (Map.Entry entry : prevIcons.entrySet()) {
                    Long id = (Long)entry.getKey();
                    CmsIcon icon = (CmsIcon)entry.getValue();
                    UploadAttribute upload = icon.getUploadAttribute("file");
                    if (!upload.hasUploads()) continue;
                    String filename = (String)upload.getFilenamesAsArrayList().get(0);
                    FilteredList matching = newIcons.filtered(t -> t.getName().equals(filename));
                    if (matching.isEmpty()) {
                        CmsElement.remove((CmsApplication)project, (long)id, (CmsUser)project.getUser());
                        continue;
                    }
                    File newIconFile = (File)matching.get(0);
                    icon.getUploadAttribute("file").clear();
                    icon.getUploadAttribute("file").addUpload(newIconFile);
                    icon.getUploadAttribute("file").removeDeletedItems();
                    project.getLogger().info("Icon with filename '" + newIconFile.getName() + "' replaced");
                    icon.save();
                    newIcons.remove((Object)newIconFile);
                }
                for (File newIcon : newIcons) {
                    CmsIcon tempIcon = (CmsIcon)project.createElement("icon");
                    tempIcon.setAttributeValue("title", FilenameUtils.removeExtension((String)newIcon.getName()));
                    tempIcon.getUploadAttribute("file").addUpload(newIcon);
                    project.getLogger().info("Icon with filename '" + newIcon.getName() + "' created");
                    tempIcon.save();
                }
                this.app.getSettings().setTemplateUseTexts(false);
                this.app.getSettings().setTemplateUseLists(false);
                this.app.getSettings().setTemplateUseIcons(true);
                this.app.getSettings().setTemplateUseSettings(false);
                this.app.getSettings().setTemplateUseContacts(false);
                this.app.getSettings().setTemplateUseDocuments(false);
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd_HHmmss");
                File newFile = new File(this.destFolder, format.format(new Date()) + "_VdS-Icons.xlsx");
                manager.saveTemplates(newFile);
                project.close(new Closing().withoutExport().withoutWaiting(), ph);
                this.tempFolder.delete();
            });
        });
        readIcon.setMinWidth(150.0);
        controls.getChildren().add((Object)readIcon);
        root.getChildren().add((Object)controls);
        this.setContent((Node)root);
    }

    private void addIconsToList(List<File> newIcons) {
        ObservableList icons = this.iconsList.getItems();
        icons.addAll(newIcons);
        ArrayList<File> withoutDuplicates = new ArrayList<File>(new HashSet(icons));
        withoutDuplicates.sort((a, b) -> a.getName().compareTo(b.getName()));
        withoutDuplicates.removeIf(t -> !Util.isImageFile((String)t.getAbsolutePath()));
        Platform.runLater(() -> {
            this.iconsList.getItems().clear();
            this.iconsList.getItems().addAll((Collection)withoutDuplicates);
            this.lastDirectory = ((File)withoutDuplicates.get(0)).getParentFile();
        });
    }

    public void populate() {
    }
}

