/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.special.ibs;

import at.grid.gui.Dialogs;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.api.ThemisFileDialog;
import at.grid.themis.application.api.ThemisProgressHandler;
import at.grid.themis.application.io.importer.ProjectImportTarget;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.importer.ThemisReaderCsv;
import at.grid.themis.ontology.importer.ThemisReaderGeneric;
import at.grid.themis.ontology.importer.ThemisReaderXlsx;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressRunnable;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class IbsPanel
extends JPanel {
    ThemisApplication app = ThemisApplication.getInstance();
    private JButton btnCheck;
    private JButton btnImport;
    private JButton btnSelectImportFolder;
    private JButton btnSelectProjectFolder;
    private JTextField fldImportFolder;
    private JTextField fldProjectFolder;
    private JLabel jLabel1;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JScrollPane jScrollPane1;
    private JList<String> lstFiles;

    public IbsPanel() {
        this.initComponents();
        this.populate();
        this.populateFiles();
    }

    protected void populate() {
        this.fldImportFolder.setText(this.app.getSettings().getProperty("custom.ibs.folderimport", null));
        this.fldProjectFolder.setText(this.app.getSettings().getProperty("custom.ibs.folderprojects", null));
    }

    private void populateFiles() {
        File[] files;
        ((DefaultListModel)this.lstFiles.getModel()).clear();
        String fn = this.fldImportFolder.getText();
        if ("".equals(fn)) {
            return;
        }
        File folder = new File(fn);
        if (!folder.isDirectory()) {
            Dialogs.showErrorDialog((String)"Der angegebene Ordner ist ung\u00fcltig!");
            return;
        }
        for (File f : files = folder.listFiles()) {
            if (f.isDirectory()) continue;
            ((DefaultListModel)this.lstFiles.getModel()).addElement(f.getName());
        }
    }

    private void importFiles() {
        String fn = this.fldImportFolder.getText();
        if ("".equals(fn)) {
            return;
        }
        final File folder = new File(fn);
        if (!folder.isDirectory()) {
            Dialogs.showErrorDialog((String)"Der angegebene Ordner ist ung\u00fcltig!");
            return;
        }
        final List<String> filenames = this.lstFiles.getSelectedValuesList();
        if (filenames.isEmpty()) {
            Dialogs.showErrorDialog((String)"Keine Dateien ausgew\u00e4hlt");
            return;
        }
        fn = this.fldProjectFolder.getText();
        final File projectFolder = "".equals(fn) ? null : new File(fn);
        String progressTitle = "Erstelle Projekte";
        BaseProgressUtils.showProgressDialogAndRun((ProgressRunnable)new ProgressRunnable<String>(){

            public String run(ProgressHandle ph) {
                ThemisProgressHandler tph = new ThemisProgressHandler(ph);
                tph.switchToDeterminate(filenames.size() + 1);
                int counter = 1;
                for (String fn : filenames) {
                    try {
                        ThemisReaderCsv r;
                        File f = new File(folder, fn);
                        tph.progress("Erstelle/aktualisiere Projekt aus '" + fn + "' (" + counter + " von " + filenames.size() + ")", counter++);
                        ProjectImportTarget importer = new ProjectImportTarget();
                        if (fn.toLowerCase().endsWith(".xlsx")) {
                            r = new ThemisReaderXlsx(1, 2);
                            r.setSheet(0);
                        } else {
                            r = new ThemisReaderCsv();
                        }
                        importer.setReader((ThemisReaderGeneric)r);
                        r.readFile(f);
                        if (projectFolder != null) {
                            importer.setProjectFolder(projectFolder);
                        }
                        importer.autoMap();
                        importer.runImport(null);
                    }
                    catch (IOException ex) {
                        Dialogs.showErrorDialog((String)"Fehler beim Erstellen bzw. aktualisieren der Projekte", (Exception)ex);
                    }
                }
                ph.finish();
                return null;
            }
        }, (String)progressTitle, (boolean)true);
    }

    private void initComponents() {
        this.jLabel5 = new JLabel();
        this.fldImportFolder = new JTextField();
        this.btnSelectImportFolder = new JButton();
        this.jLabel6 = new JLabel();
        this.fldProjectFolder = new JTextField();
        this.btnSelectProjectFolder = new JButton();
        this.btnCheck = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.lstFiles = new JList();
        this.btnImport = new JButton();
        this.jLabel1 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.jLabel5.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(IbsPanel.class, (String)"IbsPanel.jLabel5.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel5, gridBagConstraints);
        this.fldImportFolder.setText(NbBundle.getMessage(IbsPanel.class, (String)"IbsPanel.fldImportFolder.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 15;
        gridBagConstraints.ipady = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.fldImportFolder, gridBagConstraints);
        this.btnSelectImportFolder.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnSelectImportFolder, (String)NbBundle.getMessage(IbsPanel.class, (String)"IbsPanel.btnSelectImportFolder.text"));
        this.btnSelectImportFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IbsPanel.this.btnSelectImportFolderActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.btnSelectImportFolder, gridBagConstraints);
        this.jLabel6.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(IbsPanel.class, (String)"IbsPanel.jLabel6.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel6, gridBagConstraints);
        this.fldProjectFolder.setText(NbBundle.getMessage(IbsPanel.class, (String)"IbsPanel.fldProjectFolder.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 15;
        gridBagConstraints.ipady = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.fldProjectFolder, gridBagConstraints);
        this.btnSelectProjectFolder.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnSelectProjectFolder, (String)NbBundle.getMessage(IbsPanel.class, (String)"IbsPanel.btnSelectProjectFolder.text"));
        this.btnSelectProjectFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IbsPanel.this.btnSelectProjectFolderActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.btnSelectProjectFolder, gridBagConstraints);
        this.btnCheck.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnCheck, (String)NbBundle.getMessage(IbsPanel.class, (String)"IbsPanel.btnCheck.text"));
        this.btnCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IbsPanel.this.btnCheckActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 15;
        gridBagConstraints.ipady = 15;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.btnCheck, gridBagConstraints);
        this.jScrollPane1.setMinimumSize(new Dimension(100, 150));
        this.jScrollPane1.setPreferredSize(new Dimension(100, 150));
        this.lstFiles.setModel(new DefaultListModel());
        this.jScrollPane1.setViewportView(this.lstFiles);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.btnImport.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnImport, (String)NbBundle.getMessage(IbsPanel.class, (String)"IbsPanel.btnImport.text"));
        this.btnImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IbsPanel.this.btnImportActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 15;
        gridBagConstraints.ipady = 15;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.btnImport, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(IbsPanel.class, (String)"IbsPanel.jLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jLabel1, gridBagConstraints);
    }

    private void btnSelectImportFolderActionPerformed(ActionEvent evt) {
        File f;
        File froot = null;
        File fsel = null;
        String frootName = this.app.getSettings().getProperty("custom.ibs.folderimport", null);
        if (frootName != null) {
            fsel = new File(frootName);
            froot = fsel.getParentFile();
        }
        if ((f = new ThemisFileDialog("Verzeichnis ausw\u00e4hlen", ThemisFileDialog.DIALOGTYPE.DIRECTORY, froot, fsel, null, null, false).getSelectedFile()) != null) {
            this.fldImportFolder.setText(f.getAbsolutePath());
            this.app.getSettings().setProperty("custom.ibs.folderimport", f.getAbsolutePath());
            this.populateFiles();
        }
    }

    private void btnCheckActionPerformed(ActionEvent evt) {
        this.populateFiles();
    }

    private void btnImportActionPerformed(ActionEvent evt) {
        this.importFiles();
    }

    private void btnSelectProjectFolderActionPerformed(ActionEvent evt) {
        File f;
        File froot = null;
        String frootName = this.app.getSettings().getProperty("custom.ibs.folderprojects", null);
        if (frootName != null) {
            froot = new File(frootName);
        }
        if ((f = new ThemisFileDialog("Verzeichnis ausw\u00e4hlen", ThemisFileDialog.DIALOGTYPE.DIRECTORY, froot, null, null, null, false).getSelectedFile()) != null) {
            this.fldProjectFolder.setText(f.getAbsolutePath());
            this.app.getSettings().setProperty("custom.ibs.folderprojects", f.getAbsolutePath());
        }
    }
}

