/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.special.kaefer;

import at.grid.cms.content.UploadItem;
import at.grid.cms.element.CmsElementSummary;
import at.grid.cms.element.CmsUser;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.element.CmsProject;
import at.grid.themis.ontology.report.PdfParagraphFormat;
import at.grid.util.Util;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfPageEventHelper;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;

public class KaeferExporter {
    ByteArrayOutputStream fos = new ByteArrayOutputStream();
    Document document = null;
    PageEvent pageEvent = new PageEvent();
    int fontFamily = 1;
    PdfParagraphFormat formatText = new PdfParagraphFormat(new Font(this.fontFamily, 11.0f, 0), 4.0f, 4.0f);
    PdfParagraphFormat formatTableHeader = new PdfParagraphFormat(new Font(this.fontFamily, 9.0f, 1), 2.0f, 2.0f);
    PdfParagraphFormat formatTable = new PdfParagraphFormat(new Font(this.fontFamily, 9.0f, 0), 2.0f, 2.0f);
    PdfParagraphFormat formatTableSmall = new PdfParagraphFormat(new Font(this.fontFamily, 7.0f, 0), 2.0f, 2.0f);
    PdfParagraphFormat formatBold = new PdfParagraphFormat(new Font(this.fontFamily, 11.0f, 1), 4.0f, 4.0f);
    PdfParagraphFormat formatSmall = new PdfParagraphFormat(new Font(this.fontFamily, 10.0f, 0), 4.0f, 4.0f);
    PdfParagraphFormat formatFooter = new PdfParagraphFormat(new Font(this.fontFamily, 9.0f, 0), 0.0f, 0.0f);
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    private ArrayList<Long> observationIds = new ArrayList();
    private ArrayList<Long> locationIds = new ArrayList();

    public void exportToPdf(File f, CmsUser user) throws DocumentException {
        CmsProject projectElement = this.project.getProjectElement();
        this.document = new Document(PageSize.A4);
        this.fos = new ByteArrayOutputStream();
        PdfWriter writer = PdfWriter.getInstance((Document)this.document, (OutputStream)this.fos);
        writer.setPageEvent((PdfPageEvent)this.pageEvent);
        this.document.setMargins(50.0f, 50.0f, 25.0f, 25.0f);
        this.document.open();
        try {
            this.pageEvent.setHeader("Projekt: " + projectElement.getTitle());
            this.pageEvent.setFooter("erstellt mit der Software THEMIS, erstellt am " + Util.formatDate((Date)new Date(), (String)Util.DATETIME_READ, (TimeZone)TimeZone.getDefault()));
            PdfContentByte canvas = writer.getDirectContent();
            canvas.saveState();
            Image img = Image.getInstance((URL)this.getClass().getResource("themis-logo-4c.png"));
            img.scaleToFit(90.0f, 60.0f);
            img.setAbsolutePosition(450.0f, 800.0f);
            this.document.add((Element)img);
            canvas.addImage(img);
            canvas.restoreState();
            this.document.add((Element)this.createParagraph(" ", this.formatText));
            this.document.add((Element)this.createParagraph(" ", this.formatText));
            PdfPTable table = new PdfPTable(2);
            table.setWidthPercentage(100.0f);
            table.setWidths(new int[]{40, 100});
            table.setHorizontalAlignment(0);
            table.addCell(this.createTableCell("Projekt:", false, this.formatText, 0, 0));
            table.addCell(this.createTableCell(projectElement.getTitle(), false, this.formatBold, 0, 0));
            table.completeRow();
            this.document.add((Element)table);
            this.document.add((Element)this.createParagraph(" ", this.formatText));
            ArrayList locations = this.project.getLocations();
            for (CmsElementSummary ele : locations) {
                this.document.newPage();
                CmsLocation location = (CmsLocation)ele.getElement();
                PdfPTable locationtable = new PdfPTable(3);
                locationtable.setWidthPercentage(100.0f);
                locationtable.setWidths(new int[]{20, 30, 50});
                locationtable.setHeaderRows(0);
                locationtable.setHorizontalAlignment(0);
                PdfPCell cell = this.createTableCell(location.getTitle(), true, this.formatText, 0, 0);
                cell.setColspan(3);
                locationtable.addCell(cell);
                locationtable.completeRow();
                Iterator iterator = location.getRelationAttribute("observations").getElementIds().iterator();
                while (iterator.hasNext()) {
                    long obsId = (Long)iterator.next();
                    CmsObservation observation = (CmsObservation)this.project.loadElement(obsId, this.project.getUser());
                    cell = this.createTableCell("", false, this.formatText, 0, 0);
                    cell.setColspan(3);
                    locationtable.addCell(cell);
                    locationtable.completeRow();
                    locationtable.addCell(this.createTableCell("M " + location.getFullNumber() + "." + observation.getAttributeValue("number"), true, this.formatText, 0, 0));
                    cell = this.createTableCell(observation.getAttributeValue("description"), true, this.formatText, 0, 0);
                    cell.setColspan(2);
                    locationtable.addCell(cell);
                    locationtable.completeRow();
                    ArrayList images = observation.getUploads(true);
                    int imagecount = 0;
                    for (UploadItem item : images) {
                        if (item.getUploadDetail() != 2L) {
                            cell = this.createImageCell(item.getAbsolutePath());
                            if (imagecount == 0) {
                                cell.setColspan(2);
                            }
                            locationtable.addCell(cell);
                            ++imagecount;
                        }
                        if (imagecount != 2) continue;
                        break;
                    }
                    locationtable.completeRow();
                }
                this.document.add((Element)locationtable);
            }
            this.document.close();
            FileOutputStream file = new FileOutputStream(f);
            this.fos.writeTo(file);
            file.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected Paragraph createParagraph(String content, PdfParagraphFormat fmt) {
        Paragraph paragraph = new Paragraph(content, fmt.font);
        paragraph.setSpacingBefore(fmt.spacingBefore);
        paragraph.setSpacingAfter(fmt.spacingAfter);
        return paragraph;
    }

    protected PdfPCell createTableCell(String content, boolean border, PdfParagraphFormat fmt, int align, int indent) {
        return this.createTableCell(content, border, fmt, align, indent, null);
    }

    protected PdfPCell createTableCell(String content, boolean border, PdfParagraphFormat fmt, int align, int indent, Color c) {
        PdfPCell cell = new PdfPCell();
        if (border) {
            cell.setBorderWidth(0.8f);
        } else {
            cell.setBorder(0);
        }
        if (c != null) {
            cell.setBackgroundColor(c);
        }
        Paragraph p = new Paragraph(content, fmt.font);
        p.setAlignment(align);
        p.setSpacingAfter(0.0f);
        p.setSpacingBefore(0.0f);
        float i = 5.0f;
        cell.setPadding(i);
        cell.setUseBorderPadding(true);
        cell.setUseAscender(true);
        cell.setUseDescender(true);
        cell.addElement((Element)p);
        return cell;
    }

    public PdfPCell createImageCell(String path) throws DocumentException, IOException {
        try {
            Image img = Image.getInstance((String)path);
            PdfPCell cell = new PdfPCell(img, true);
            float i = 5.0f;
            cell.setPadding(i);
            cell.setUseBorderPadding(true);
            cell.setUseAscender(true);
            cell.setUseDescender(true);
            return cell;
        }
        catch (Exception e) {
            return this.createTableCell("<" + this.project.getResourceText("error.image-missing", this.app.getLocale()) + ">", true, this.formatTable, 2, 2);
        }
    }

    public PdfPCell createMultipleImageCell(ArrayList<UploadItem> items) throws DocumentException, IOException {
        PdfPCell cell = new PdfPCell();
        float i = 5.0f;
        cell.setPadding(i);
        cell.setUseBorderPadding(true);
        cell.setUseAscender(true);
        cell.setUseDescender(true);
        for (UploadItem item : items) {
            try {
                Image img = Image.getInstance((String)item.getFile().getAbsolutePath());
                img.setBorderWidth(2.0f);
                img.setBorderColor(Color.white);
                cell.addElement((Element)img);
                cell.addElement((Element)new Paragraph(""));
            }
            catch (Exception e) {
                cell.addElement((Element)new Paragraph("<" + this.project.getResourceText("error.image-missing", this.app.getLocale()) + ">"));
            }
        }
        return cell;
    }

    protected void insertImage(String label, Image image) throws DocumentException {
        PdfPTable table = new PdfPTable(2);
        table.setWidths(new int[]{25, 70});
        PdfPCell cell = new PdfPCell();
        cell.setBorder(0);
        cell.setPhrase(new Phrase(label, this.formatText.font));
        table.addCell(cell);
        cell.setImage(image);
        table.addCell(cell);
        table.completeRow();
        table.setHorizontalAlignment(0);
        this.document.add((Element)table);
    }

    class PageEvent
    extends PdfPageEventHelper {
        String header = "";
        String footer = "";

        public void setHeader(String h) {
            this.header = h;
        }

        public void setFooter(String h) {
            this.footer = h;
        }

        public void onEndPage(PdfWriter writer, Document document) {
            PdfContentByte cb = writer.getDirectContent();
            ColumnText.showTextAligned((PdfContentByte)cb, (int)1, (Phrase)new Paragraph(this.header, KaeferExporter.this.formatFooter.font), (float)((document.right() - document.left()) / 2.0f + document.leftMargin()), (float)(document.top() + 10.0f), (float)0.0f);
            ColumnText.showTextAligned((PdfContentByte)cb, (int)1, (Phrase)new Paragraph(this.footer, KaeferExporter.this.formatFooter.font), (float)((document.right() - document.left()) / 2.0f + document.leftMargin()), (float)(document.bottom() - 10.0f), (float)0.0f);
        }
    }
}

