/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.special.kempenkrause;

import at.grid.cms.storage.DataRecord;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.api.ThemisFileDialog;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.util.Util;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.SoftBevelBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressRunnable;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class KempenKrausePanel
extends JPanel {
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    File exportFile = null;
    File templateFile = null;
    File folder = null;
    private JButton btnCreate;
    private JButton btnSelectFolder;
    private JButton btnSelectTemplate;
    private JTextField fldFilename;
    private JTextField fldFolder;
    private JTextField fldRow;
    private JTextField fldTemplate;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel7;
    private JLabel jLabel8;

    public KempenKrausePanel() {
        this.initComponents();
    }

    private void createSpecialReport(ProgressHandle ph) {
        if (this.templateFile == null || !this.templateFile.isFile()) {
            Dialogs.getInstance().showErrorDialog("Keine Vorlage ausgew\u00e4hlt");
            return;
        }
        if (this.exportFile == null || this.exportFile.isDirectory()) {
            Dialogs.getInstance().showErrorDialog("Keine oder ung\u00fcltige Zieldatei ausgew\u00e4hlt");
            return;
        }
        try {
            HashMap content;
            int row0;
            XSSFWorkbook wb = (XSSFWorkbook)WorkbookFactory.create((InputStream)new FileInputStream(this.templateFile));
            XSSFSheet sheet = wb.getSheetAt(0);
            int countCols = 12;
            int rowBaseEbene1 = row0 = Util.parseInt((String)this.fldRow.getText(), (int)4) - 1;
            int rowBaseEbene2 = row0 + 1;
            int rowBaseData = row0 + 2;
            HashMap<String, HashMap> data = new HashMap<String, HashMap>();
            sheet.getHeader().setLeft(this.project.getProjectElement().getAttributeValue("projecttitle"));
            String projectNumber = this.project.getProjectElement().getAttributeValue("projectnumber");
            if (projectNumber != null && !"".equals(projectNumber)) {
                sheet.getHeader().setRight("Projektnummer: " + projectNumber);
            }
            sheet.getFooter().setRight("Stand: " + Util.formatDate((Date)new Date(), (String)Util.DATE_READ, (TimeZone)this.app.getTimeZone()));
            List obsRecs = this.app.getFilter().getFilteredObservations();
            int totalCount = obsRecs.size();
            if (ph != null) {
                this.project.getTemplateManger().getLocationGroups();
                for (DataRecord rec : this.project.getTemplateManger().getLocationGroups()) {
                    totalCount += this.project.getTemplateManger().getLocationGroups(rec.getLong("meta_id").longValue()).size();
                }
                ph.switchToDeterminate(totalCount);
                ph.setDisplayName("Daten werden extrahiert");
            }
            int count = 0;
            for (DataRecord obsRec : obsRecs) {
                Dataset ds;
                if (ph != null) {
                    ph.progress(count++);
                }
                String group = obsRec.getString("priority");
                String key = obsRec.getString("code");
                content = (HashMap)data.get(group);
                if (content == null) {
                    content = new HashMap();
                }
                if ((ds = (Dataset)content.get(key)) == null) {
                    ds = new Dataset(obsRec.getString("fullnumber"), obsRec.getString("observationdescription"), obsRec.getString("topic"), obsRec.getFloat("float1").floatValue(), obsRec.getString("observationtype"), obsRec.getFloat("float2").floatValue());
                } else {
                    ds.addPosition(obsRec.getString("fullnumber"), obsRec.getFloat("float1").floatValue());
                }
                content.put(key, ds);
                data.put(group, content);
            }
            int rowData = rowBaseData;
            int row1 = rowBaseEbene1;
            int row2 = rowBaseEbene2;
            boolean foundData1 = false;
            boolean foundData2 = false;
            for (DataRecord rec : this.project.getTemplateManger().getLocationGroups()) {
                float sum1 = 0.0f;
                float sum2 = 0.0f;
                foundData1 = false;
                foundData2 = false;
                boolean firstRec2 = true;
                for (DataRecord rec2 : this.project.getTemplateManger().getLocationGroups(rec.getLong("meta_id").longValue())) {
                    if (ph != null) {
                        ph.progress(count++);
                    }
                    sum2 = 0.0f;
                    content = (HashMap)data.get(rec2.getString("meta_title"));
                    if (content == null) continue;
                    foundData2 = !content.isEmpty();
                    foundData1 = foundData1 || foundData2;
                    for (Dataset ds0 : content.values()) {
                        sum2 += ds0.getGP();
                        for (int c = 0; c < 12; ++c) {
                            this.getCell((Sheet)sheet, rowData, rowBaseData, c);
                        }
                        this.setCellContent((Sheet)sheet, rowData, rowBaseData, 3, ds0.position);
                        this.setCellContent((Sheet)sheet, rowData, rowBaseData, 4, ds0.massnahme);
                        this.setCellContent((Sheet)sheet, rowData, rowBaseData, 5, ds0.prio);
                        this.setCellContent((Sheet)sheet, rowData, rowBaseData, 6, ds0.anzahl);
                        this.setCellContent((Sheet)sheet, rowData, rowBaseData, 7, ds0.einheit);
                        this.setCellContent((Sheet)sheet, rowData, rowBaseData, 8, ds0.ep);
                        this.setCellContent((Sheet)sheet, rowData, rowBaseData, 9, ds0.getGP());
                        ++rowData;
                    }
                    rowData += firstRec2 ? 2 : 1;
                    for (int c = 0; c < 12; ++c) {
                        this.getCell((Sheet)sheet, row2, rowBaseEbene2, c);
                    }
                    this.setCellContent((Sheet)sheet, row2, rowBaseEbene2, 1, rec2.get("meta_title"));
                    this.setCellContent((Sheet)sheet, row2, rowBaseEbene2, 2, rec2.get("description"));
                    this.setCellContent((Sheet)sheet, row2, rowBaseEbene2, 10, sum2);
                    row2 = rowData - 1;
                    sum1 += sum2;
                    firstRec2 = false;
                }
                if (!foundData2) continue;
                for (int c = 0; c < 12; ++c) {
                    this.getCell((Sheet)sheet, row1, rowBaseEbene1, c);
                }
                this.setCellContent((Sheet)sheet, row1, rowBaseEbene1, 0, rec.get("meta_title"));
                this.setCellContent((Sheet)sheet, row1, rowBaseEbene1, 2, rec.get("description"));
                this.setCellContent((Sheet)sheet, row1, rowBaseEbene1, 11, sum1);
                row1 = rowData - 2;
            }
            FileOutputStream fos = new FileOutputStream(this.exportFile);
            wb.write((OutputStream)fos);
            fos.close();
            wb.close();
        }
        catch (IOException ex) {
            Dialogs.getInstance().showErrorDialog("Es ist ein Fehler aufgetreten: " + ex.getMessage(), (Exception)ex);
            ex.printStackTrace();
        }
        catch (EncryptedDocumentException ex) {
            Dialogs.getInstance().showErrorDialog("Es ist ein Fehler aufgetreten: " + ex.getMessage(), (Exception)((Object)ex));
            ex.printStackTrace();
        }
        if (ph != null) {
            ph.finish();
        }
    }

    private void setCellContent(Sheet sheet, int r, int r0, int c, String v) {
        Cell cell = this.getCell(sheet, r, r0, c);
        if (cell != null) {
            cell.setCellValue(v);
        }
    }

    private void setCellContent(Sheet sheet, int r, int r0, int c, float v) {
        Cell cell = this.getCell(sheet, r, r0, c);
        if (cell != null) {
            cell.setCellValue((double)v);
        }
    }

    private Cell getCell(Sheet sheet, int r, int r0, int c) {
        Cell cell0;
        Row row0;
        Cell cell;
        Row row = sheet.getRow(r);
        if (row == null) {
            row = sheet.createRow(r);
        }
        if ((cell = row.getCell(c)) == null) {
            cell = row.createCell(c);
        }
        if ((row0 = sheet.getRow(r0)) != null && (cell0 = row0.getCell(c)) != null) {
            cell.setCellStyle(cell0.getCellStyle());
        }
        return cell;
    }

    private void initComponents() {
        this.jLabel15 = new JLabel();
        this.jLabel7 = new JLabel();
        this.fldTemplate = new JTextField();
        this.btnSelectTemplate = new JButton();
        this.jLabel8 = new JLabel();
        this.fldRow = new JTextField();
        this.jLabel13 = new JLabel();
        this.jLabel2 = new JLabel();
        this.fldFolder = new JTextField();
        this.jLabel3 = new JLabel();
        this.fldFilename = new JTextField();
        this.btnSelectFolder = new JButton();
        this.jLabel14 = new JLabel();
        this.btnCreate = new JButton();
        this.setLayout(new GridBagLayout());
        this.jLabel15.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel15, (String)NbBundle.getMessage(KempenKrausePanel.class, (String)"KempenKrausePanel.jLabel15.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel15, gridBagConstraints);
        this.jLabel7.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(KempenKrausePanel.class, (String)"KempenKrausePanel.jLabel7.text"));
        this.jLabel7.setPreferredSize(new Dimension(60, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel7, gridBagConstraints);
        this.fldTemplate.setEditable(false);
        this.fldTemplate.setFont(THEMIS.fontTextfield);
        this.fldTemplate.setText(NbBundle.getMessage(KempenKrausePanel.class, (String)"KempenKrausePanel.fldTemplate.text"));
        this.fldTemplate.setMinimumSize(new Dimension(5, 24));
        this.fldTemplate.setPreferredSize(new Dimension(6, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.fldTemplate, gridBagConstraints);
        this.btnSelectTemplate.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnSelectTemplate, (String)NbBundle.getMessage(KempenKrausePanel.class, (String)"KempenKrausePanel.btnSelectTemplate.text"));
        this.btnSelectTemplate.setBorder(new SoftBevelBorder(0));
        this.btnSelectTemplate.setMinimumSize(new Dimension(5, 22));
        this.btnSelectTemplate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KempenKrausePanel.this.btnSelectTemplateActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.btnSelectTemplate, gridBagConstraints);
        this.jLabel8.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel8, (String)NbBundle.getMessage(KempenKrausePanel.class, (String)"KempenKrausePanel.jLabel8.text"));
        this.jLabel8.setPreferredSize(new Dimension(60, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel8, gridBagConstraints);
        this.fldRow.setFont(THEMIS.fontTextfield);
        this.fldRow.setHorizontalAlignment(0);
        this.fldRow.setText(NbBundle.getMessage(KempenKrausePanel.class, (String)"KempenKrausePanel.fldRow.text"));
        this.fldRow.setMinimumSize(new Dimension(100, 30));
        this.fldRow.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.fldRow, gridBagConstraints);
        this.jLabel13.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel13, (String)NbBundle.getMessage(KempenKrausePanel.class, (String)"KempenKrausePanel.jLabel13.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel13, gridBagConstraints);
        this.jLabel2.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(KempenKrausePanel.class, (String)"KempenKrausePanel.jLabel2.text"));
        this.jLabel2.setPreferredSize(new Dimension(60, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.fldFolder.setEditable(false);
        this.fldFolder.setFont(THEMIS.fontTextfield);
        this.fldFolder.setText(NbBundle.getMessage(KempenKrausePanel.class, (String)"KempenKrausePanel.fldFolder.text"));
        this.fldFolder.setMinimumSize(new Dimension(100, 30));
        this.fldFolder.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.fldFolder, gridBagConstraints);
        this.jLabel3.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(KempenKrausePanel.class, (String)"KempenKrausePanel.jLabel3.text"));
        this.jLabel3.setPreferredSize(new Dimension(60, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.fldFilename.setFont(THEMIS.fontTextfield);
        this.fldFilename.setText(NbBundle.getMessage(KempenKrausePanel.class, (String)"KempenKrausePanel.fldFilename.text"));
        this.fldFilename.setMinimumSize(new Dimension(100, 30));
        this.fldFilename.setName("");
        this.fldFilename.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.fldFilename, gridBagConstraints);
        this.btnSelectFolder.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnSelectFolder, (String)NbBundle.getMessage(KempenKrausePanel.class, (String)"KempenKrausePanel.btnSelectFolder.text"));
        this.btnSelectFolder.setBorder(new SoftBevelBorder(0));
        this.btnSelectFolder.setMinimumSize(new Dimension(5, 22));
        this.btnSelectFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KempenKrausePanel.this.btnSelectFolderActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.btnSelectFolder, gridBagConstraints);
        this.jLabel14.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel14, (String)NbBundle.getMessage(KempenKrausePanel.class, (String)"KempenKrausePanel.jLabel14.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel14, gridBagConstraints);
        this.btnCreate.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnCreate, (String)NbBundle.getMessage(KempenKrausePanel.class, (String)"KempenKrausePanel.btnCreate.text"));
        this.btnCreate.setMinimumSize(new Dimension(150, 35));
        this.btnCreate.setPreferredSize(new Dimension(150, 35));
        this.btnCreate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KempenKrausePanel.this.btnCreateActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.btnCreate, gridBagConstraints);
    }

    private void btnSelectTemplateActionPerformed(ActionEvent evt) {
        File f = new ThemisFileDialog("Vorlage ausw\u00e4hlen", ThemisFileDialog.DIALOGTYPE.OPEN, this.folder, null, (FileFilter)new FileNameExtensionFilter(ThemisApplication.getInstance().getProject().getResourceText("dialog.load.protocol-template.excel"), "xlsx"), null, false).getSelectedFile();
        if (f == null) {
            this.fldTemplate.setText("");
            return;
        }
        if (!f.isFile() || f.isDirectory()) {
            Dialogs.getInstance().showWarningDialog("Keine Datei ausgew\u00e4hlt");
            return;
        }
        this.fldTemplate.setText(f.getAbsolutePath());
        this.templateFile = f;
        this.folder = f.getAbsoluteFile().getParentFile();
    }

    private void btnSelectFolderActionPerformed(ActionEvent evt) {
        File f = new ThemisFileDialog("Datei f\u00fcr Export ausw\u00e4hlen", ThemisFileDialog.DIALOGTYPE.SAVE, this.folder, null, THEMIS.getFileExtensionFilter((String)"xlsx", (String)"MS Excel"), "xlsx", false).getSelectedFile();
        if (f != null) {
            this.fldFolder.setText(f.getParentFile().getAbsolutePath());
            this.fldFilename.setText(f.getName());
            this.exportFile = f;
            this.folder = f.getAbsoluteFile().getParentFile();
        }
    }

    private void btnCreateActionPerformed(ActionEvent evt) {
        String progressTitle = "Spezialbericht erstellen";
        BaseProgressUtils.showProgressDialogAndRun((ProgressRunnable)new ProgressRunnable<String>(){

            public String run(ProgressHandle ph) {
                KempenKrausePanel.this.createSpecialReport(ph);
                if (KempenKrausePanel.this.exportFile.isFile()) {
                    int option = Dialogs.getInstance().showInfoOptionDialog("Bericht erfolgreich erstellt", "Sonderbericht", (Object[])new String[]{"Datei \u00f6ffnen", "Ordner zeigen", "Schlie\u00dfen"});
                    try {
                        if (option == 0) {
                            Desktop.getDesktop().open(KempenKrausePanel.this.exportFile);
                        } else if (option == 1) {
                            Desktop.getDesktop().open(KempenKrausePanel.this.exportFile.getParentFile());
                        }
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                } else {
                    Dialogs.getInstance().showErrorDialog("Es konnte keine Ausgabedatei erzeugt werden.");
                }
                return null;
            }
        }, (String)progressTitle, (boolean)true);
    }

    class Dataset {
        String position = null;
        String massnahme = null;
        String prio = null;
        float anzahl = 0.0f;
        String einheit = null;
        float ep = 0.0f;

        public Dataset(String pos, String massn, String pri, float anz, String einh, float ep) {
            this.position = pos;
            this.massnahme = massn;
            this.prio = pri;
            this.anzahl = anz;
            this.einheit = einh;
            this.ep = ep;
        }

        public Dataset addPosition(String pos, float anz) {
            this.position = this.position == null ? pos : this.position + ", " + pos;
            this.anzahl += anz;
            return this;
        }

        public float getGP() {
            return this.anzahl * this.ep;
        }
    }

    class Kostengruppe {
        int ebene = 0;
        float gp = 0.0f;

        Kostengruppe() {
        }
    }
}

