/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.special.kubus360;

import at.grid.cms.CmsApplication;
import at.grid.cms.element.CmsElement;
import at.grid.cms.element.CmsElementSummary;
import at.grid.cms.search.CmsSqlSearch;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.api.ThemisFileDialog;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.element.CmsProject;
import at.grid.themis.ontology.license.ThemisLicense;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.border.SoftBevelBorder;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class Kubus360Panel
extends JPanel {
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    ThemisLicense license = THEMIS.getLicense();
    private JButton btnExportToCAD;
    private JButton btnImportCAD;

    public Kubus360Panel() {
        this.initComponents();
    }

    private void exportToCad() {
        File f = new ThemisFileDialog("CSV-Datei ausw\u00e4hlen", ThemisFileDialog.DIALOGTYPE.OPEN, this.app.getPathExportKubus360(), null, THEMIS.getCsvFilter(), null, false).getSelectedFile();
        boolean overwriteFile = true;
        if (f != null && f.exists()) {
            overwriteFile = Dialogs.getInstance().showConfirmDialog(ResourceBundle.getBundle("at/grid/themis/special/kubus360/Bundle").getString("Kubus360Panel.overwriteFile.text"), ResourceBundle.getBundle("at/grid/themis/special/kubus360/Bundle").getString("Kubus360Panel.fileExists.text"));
        }
        if (f != null && overwriteFile) {
            try {
                this.app.setPathExportKubus360(f);
                CmsElement loc = this.project.getDefaultElement("location");
                CmsSqlSearch s = new CmsSqlSearch((CmsApplication)this.project, this.project.getUser(), false);
                s.setElementtypes("location");
                s.addSelectMeta();
                s.addSelectAttribute(loc.getAttribute("number"));
                s.setSort("ele.number");
                ArrayList ids = s.search().getResultIds();
                FileWriter fw = new FileWriter(f);
                fw.write(",Gebaeude,Geschoss,Bezeichnung,Nutzung,Boden,Boden-A in qm,Zustand Boden,Wandbekleidung,Umfang in m,Hoehe in m,Wand-A in qm,Zustand Wand,Deckenbekleidung,Decken-A in qm,Zustand Decke,Beschreibung Boden, Beschreibung Wand, Beschreibung Decke\n");
                CmsProject p = this.project.getProjectElement();
                Iterator iterator = ids.iterator();
                while (iterator.hasNext()) {
                    long id = (Long)iterator.next();
                    CmsElement ele = this.project.loadElement(id, this.project.getUser());
                    CmsElement wand = null;
                    CmsElement boden = null;
                    CmsElement decke = null;
                    for (CmsElementSummary e : ele.getRelationAttribute("observations").getElements()) {
                        if (e.isTrash()) continue;
                        if (e.getTitle().contains("Wand")) {
                            wand = e.getElement();
                            continue;
                        }
                        if (e.getTitle().contains("Boden")) {
                            boden = e.getElement();
                            continue;
                        }
                        if (!e.getTitle().contains("Decke")) continue;
                        decke = e.getElement();
                    }
                    fw.write("\"" + ele.getAttributeValue("number") + "\",");
                    fw.write("\"" + p.getAttributeValue("projectnumber") + "\",");
                    fw.write("\"" + ele.getRelationAttribute("plan").getFirstElementTitle() + "\",");
                    fw.write("\"" + ele.getAttributeValue("description") + "\",");
                    fw.write("\"" + ele.getAttributeValue("title") + "\",");
                    fw.write("\"" + (boden == null ? "" : boden.getAttributeValue("topic")) + "\",");
                    fw.write("\"" + ele.getAttributeValue("quantity") + "\",");
                    fw.write("\"" + (boden == null ? "" : boden.getAttributeValue("code")) + "\",");
                    fw.write("\"" + (wand == null ? "" : wand.getAttributeValue("observationtype")) + "\",");
                    fw.write("\"" + ele.getAttributeValue("code") + "\",");
                    fw.write("\"\",");
                    fw.write("\"\",");
                    fw.write("\"" + (wand == null ? "" : wand.getAttributeValue("code")) + "\",");
                    fw.write("\"" + (decke == null ? "" : decke.getAttributeValue("priority")) + "\",");
                    fw.write("\"\",");
                    fw.write("\"" + (decke == null ? "" : decke.getAttributeValue("code")) + "\"");
                    fw.write("\"" + (boden == null ? "" : boden.getAttributeValue("description")) + "\"");
                    fw.write("\"" + (wand == null ? "" : wand.getAttributeValue("description")) + "\"");
                    fw.write("\"" + (decke == null ? "" : decke.getAttributeValue("description")) + "\"");
                    fw.write("\n");
                }
                fw.close();
                Dialogs.getInstance().showInfoDialog(ResourceBundle.getBundle("at/grid/themis/special/kubus360/Bundle").getString("Kubus360Panel.successfullySaved.text"));
            }
            catch (IOException ex) {
                Dialogs.getInstance().showErrorDialog(ResourceBundle.getBundle("at/grid/themis/special/kubus360/Bundle").getString("Kubus360Panel.errorOccurred.text"), (Exception)ex);
            }
        }
    }

    private void initComponents() {
        this.btnExportToCAD = new JButton();
        this.btnImportCAD = new JButton();
        this.btnExportToCAD.setFont(THEMIS.fontButton);
        this.btnExportToCAD.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/special/media/exportToCAD24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnExportToCAD, (String)NbBundle.getMessage(Kubus360Panel.class, (String)"Kubus360Panel.btnExportToCAD.text"));
        this.btnExportToCAD.setBorder(new SoftBevelBorder(0));
        this.btnExportToCAD.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Kubus360Panel.this.btnExportToCADActionPerformed(evt);
            }
        });
        this.btnImportCAD.setFont(THEMIS.fontButton);
        this.btnImportCAD.setIcon(new ImageIcon(this.getClass().getResource("/at/grid/themis/special/media/exportToCAD24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnImportCAD, (String)NbBundle.getMessage(Kubus360Panel.class, (String)"Kubus360Panel.btnImportCAD.text"));
        this.btnImportCAD.setBorder(new SoftBevelBorder(0));
        this.btnImportCAD.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Kubus360Panel.this.btnImportCADActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnExportToCAD, -1, 380, Short.MAX_VALUE).addComponent(this.btnImportCAD, -1, 380, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.btnExportToCAD, -2, 35, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnImportCAD, -2, 35, -2).addContainerGap(207, Short.MAX_VALUE)));
    }

    private void btnExportToCADActionPerformed(ActionEvent evt) {
        if (!this.project.isOpen() && this.project == null) {
            Dialogs.getInstance().showWarningDialog(this.app.getProject().getResourceText("app.core.text.noproject", this.app.getLocale()));
            return;
        }
        try {
            this.exportToCad();
        }
        catch (Exception ex) {
            Dialogs.getInstance().showErrorDialog(ResourceBundle.getBundle("at/grid/themis/special/kubus360/Bundle").getString("Kubus360Panel.errorOccurred.text"), ex);
        }
    }

    private void btnImportCADActionPerformed(ActionEvent evt) {
        ThemisApplication app = ThemisApplication.getInstance();
        ThemisProject project = app.getProject();
        if (ThemisLicense.isActionDeniedForNoProject((ThemisApplication)app) || ThemisLicense.isActionDeniedForViewer((ThemisApplication)app) || ThemisLicense.isActionDeniedForBSbuch((ThemisApplication)app)) {
            return;
        }
        if (project.getCurrentEventId() < 0L) {
            Dialogs.getInstance().showWarningDialog(app.getProject().getResourceText("app.core.text.noevent", app.getLocale()));
        }
    }
}

