/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.special.kubus360;

import at.grid.cms.CmsApplication;
import at.grid.cms.element.CmsElementSummary;
import at.grid.cms.search.CmsBasicSearch;
import at.grid.cms.storage.DataRecord;
import at.grid.gui.SimpleGeometry;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.action.ThemisActionProvider;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.api.ThemisFileDialog;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.action.ThemisActionListener;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.license.ThemisLicense;
import at.grid.themis.special.kubus360.ImportAnalysisPanel;
import at.grid.util.Util;
import com.opencsv.CSVReader;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="LocationImportTopComponentKubus360", persistenceType=0)
public final class LocationImportTopComponentKubus360
extends TopComponent
implements ThemisActionListener {
    public static final int OHTER_REASON = 1;
    public static final int LOCATION_NUMBEWR_ALREADY_USED = 10;
    public static final int LOCATION_OUTSIDE_BOX = 11;
    public static final int LOCATION_IS_MARKER = 12;
    public static final int LOCATION_NOT_IN_PLAN = 13;
    public static final int LOCATION_HAS_NO_PLAN = 14;
    public static final int LOCATION_SAVED = 100;
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    ArrayList<LocationCsv> rows = new ArrayList();
    long planId = -1L;
    HashMap<String, Long> planMapping = new HashMap();
    HashMap<String, String> columnMapping = new HashMap();
    boolean hasPlanColumn = false;
    DefaultListModel<LocationCsv> locationModel = new DefaultListModel();
    boolean waitingForPoint = false;
    private JButton btnDelete;
    private JButton btnImport;
    private JButton btnSelectInPlan;
    private JCheckBox chkCreateObservation;
    private JCheckBox chkCurrentPlanOnly;
    private JCheckBox chkImportMarker;
    private JCheckBox chkIncludeNoPlan;
    private JCheckBox chkOnlyWithin;
    private JTextField fldFilename;
    private JComboBox fldPlan;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JLabel lblComment;
    private JLabel lblCount;
    private JLabel lblImage;
    private JLabel lblImport;
    private JLabel lblImportInfo;
    private JLabel lblKoordinaten;
    private JLabel lblPlan;
    private JLabel lblPlanSelect;
    private JLabel lblPlanSelect1;
    private JList locationList;
    private JPanel panelImport;

    public LocationImportTopComponentKubus360() {
        ThemisApplication.getInstance().getProject().getLogger().info("initialising " + ((Object)((Object)this)).getClass().getName() + " ...");
        this.initComponents();
        this.setName("Import KUBUS");
        this.setToolTipText("Importieren von Gegenst\u00e4nden aus dem CAD");
        THEMIS.getLicense();
        this.panelImport.setVisible(false);
        this.lblImportInfo.setVisible(false);
        ThemisActionProvider.getInstance().register((ThemisActionListener)this);
        ThemisApplication.getInstance().getProject().getLogger().info("... done initialising " + ((Object)((Object)this)).getClass().getName() + " - Version " + ThemisProject.VERSION);
    }

    public void onAction(ThemisAction action) {
        if (action.is(ThemisAction.CREATE_POINT_IN_PLAN_DONE)) {
            this.btnSelectInPlan.setEnabled(true);
            if (this.waitingForPoint) {
                this.waitingForPoint = false;
                SimpleGeometry geom = (SimpleGeometry)action.getReference();
                this.planId = action.getId();
                LocationCsv l = (LocationCsv)this.locationList.getSelectedValue();
                if (geom != null && l != null) {
                    l.setImageCoordinates(geom.getPoint().getX(), geom.getPoint().getY());
                    this.updateLocationList();
                    this.updateImportVisibility();
                }
            }
        } else if (action.is(ThemisAction.PROJECT_OPENED)) {
            this.updatePlanCombo();
        } else if (!action.is(ThemisAction.PROJECT_CLOSED) && action.is(ThemisAction.PLAN_SAVED)) {
            this.updatePlanCombo();
        }
    }

    protected void updateLocationList() {
        ((DefaultListModel)this.locationList.getModel()).removeAllElements();
        for (LocationCsv l : this.rows) {
            if ((this.planId >= 0L || l.planId >= 0L) && l.planId != this.planId) continue;
            ((DefaultListModel)this.locationList.getModel()).addElement(l);
        }
        this.locationList.update(this.locationList.getGraphics());
        this.lblCount.setText(ResourceBundle.getBundle("at/grid/themis/special/kubus360/Bundle").getString("LocationImportTopComponentKubus360.amount.text") + ((DefaultListModel)this.locationList.getModel()).getSize());
        this.updateImportVisibility();
    }

    public void updatePlanCombo() {
        if (!this.project.isOpen()) {
            return;
        }
        CmsBasicSearch s = new CmsBasicSearch((CmsApplication)this.project, this.project.getUser(), "plan");
        s.addSelectAttribute(this.project.getDefaultElement("plan").getAttribute("title"));
        List recs = s.search().getResult();
        this.planMapping.clear();
        DefaultComboBoxModel m = (DefaultComboBoxModel)this.fldPlan.getModel();
        m.removeAllElements();
        m.addElement(new CmsElementSummary(-1L, ResourceBundle.getBundle("at/grid/themis/special/kubus360/Bundle").getString("LocationImportTopComponentKubus360.noPlan.text"), this.app.getSystemLanguage(), (CmsApplication)this.project, this.project.getUser()));
        for (DataRecord rec : recs) {
            this.planMapping.put(rec.getString("plantitle"), rec.getLong("meta_id"));
            CmsElementSummary ele = new CmsElementSummary(rec.getLong("meta_id").longValue(), rec.getString("plantitle"), this.app.getSystemLanguage(), (CmsApplication)this.project, this.project.getUser());
            m.addElement(ele);
        }
        if (m.getSize() > 0) {
            this.fldPlan.setSelectedIndex(0);
        }
    }

    protected void updateImportVisibility() {
        int count = 0;
        for (LocationCsv ll : this.rows) {
            if (!ll.hasImgCoordinates || (this.planId >= 0L || ll.planId >= 0L) && this.planId != ll.planId) continue;
            ++count;
        }
        if (count == 2) {
            this.panelImport.setVisible(true);
        } else {
            this.panelImport.setVisible(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readCsvFile(File f) {
        CSVReader reader = null;
        try {
            reader = new CSVReader((Reader)new FileReader(f));
            this.fldFilename.setText(f.getName());
            String[] cols = reader.readNext();
            for (int ii = 0; ii < cols.length; ++ii) {
                if (!"".equals(cols[ii])) continue;
                cols[ii] = MessageFormat.format(ResourceBundle.getBundle("at/grid/themis/special/kubus360/Bundle").getString("LocationImportTopComponentKubus360.collumn.text"), ii);
            }
            String[] atts = new String[]{ResourceBundle.getBundle("at/grid/themis/special/kubus360/Bundle").getString("LocationImportTopComponentKubus360.colNumber.text"), ResourceBundle.getBundle("at/grid/themis/special/kubus360/Bundle").getString("LocationImportTopComponentKubus360.colMap.text"), ResourceBundle.getBundle("at/grid/themis/special/kubus360/Bundle").getString("LocationImportTopComponentKubus360.colX.text"), ResourceBundle.getBundle("at/grid/themis/special/kubus360/Bundle").getString("LocationImportTopComponentKubus360.colY.text"), ResourceBundle.getBundle("at/grid/themis/special/kubus360/Bundle").getString("LocationImportTopComponentKubus360.colTitel.text"), ResourceBundle.getBundle("at/grid/themis/special/kubus360/Bundle").getString("LocationImportTopComponentKubus360.colDescription.text"), ResourceBundle.getBundle("at/grid/themis/special/kubus360/Bundle").getString("LocationImportTopComponentKubus360.colAmount.text"), ResourceBundle.getBundle("at/grid/themis/special/kubus360/Bundle").getString("LocationImportTopComponentKubus360.colCode.text"), ResourceBundle.getBundle("at/grid/themis/special/kubus360/Bundle").getString("LocationImportTopComponentKubus360.colCode2.text")};
            ImportAnalysisPanel p = new ImportAnalysisPanel(cols, atts);
            if (!this.columnMapping.isEmpty()) {
                p.setMapping(this.columnMapping);
            }
            if (Dialogs.getInstance().showDialog((JPanel)p, ResourceBundle.getBundle("at/grid/themis/special/kubus360/Bundle").getString("LocationImportTopComponentKubus360.assignCollumns.text"))) {
                this.columnMapping = p.getMapping();
                this.hasPlanColumn = this.columnMapping.containsValue(ResourceBundle.getBundle("at/grid/themis/special/kubus360/Bundle").getString("LocationImportTopComponentKubus360.map.text"));
                int idxNumber = -1;
                int idxPlan = -1;
                int idxLocation = -1;
                int idxX = -1;
                int idxY = -1;
                int idxComment = -1;
                int idxQuantity = -1;
                int idxCode = -1;
                int idxCode2 = -1;
                for (int ii = 0; ii < cols.length; ++ii) {
                    String att = this.columnMapping.get(cols[ii]);
                    if (ResourceBundle.getBundle("at/grid/themis/special/kubus360/Bundle").getString("LocationImportTopComponentKubus360.colNumber.text").equals(att)) {
                        idxNumber = ii;
                        continue;
                    }
                    if (ResourceBundle.getBundle("at/grid/themis/special/kubus360/Bundle").getString("LocationImportTopComponentKubus360.colMap.text").equals(att)) {
                        idxPlan = ii;
                        continue;
                    }
                    if (ResourceBundle.getBundle("at/grid/themis/special/kubus360/Bundle").getString("LocationImportTopComponentKubus360.colX.text").equals(att)) {
                        idxX = ii;
                        continue;
                    }
                    if (ResourceBundle.getBundle("at/grid/themis/special/kubus360/Bundle").getString("LocationImportTopComponentKubus360.colY.text").equals(att)) {
                        idxY = ii;
                        continue;
                    }
                    if (ResourceBundle.getBundle("at/grid/themis/special/kubus360/Bundle").getString("LocationImportTopComponentKubus360.colTitel.text").equals(att)) {
                        idxLocation = ii;
                        continue;
                    }
                    if (ResourceBundle.getBundle("at/grid/themis/special/kubus360/Bundle").getString("LocationImportTopComponentKubus360.colDescription.text").equals(att)) {
                        idxComment = ii;
                        continue;
                    }
                    if (ResourceBundle.getBundle("at/grid/themis/special/kubus360/Bundle").getString("LocationImportTopComponentKubus360.colAmount.text").equals(att)) {
                        idxQuantity = ii;
                        continue;
                    }
                    if (ResourceBundle.getBundle("at/grid/themis/special/kubus360/Bundle").getString("LocationImportTopComponentKubus360.colCode.text").equals(att)) {
                        idxCode = ii;
                        continue;
                    }
                    if (!ResourceBundle.getBundle("at/grid/themis/special/kubus360/Bundle").getString("LocationImportTopComponentKubus360.colCode2.text").equals(att)) continue;
                    idxCode2 = ii;
                }
                if (idxX < 0) {
                    Dialogs.getInstance().showErrorDialog(this.project.getResourceText("error.importcad.col-x-missing", this.app.getLocale()));
                } else if (idxY < 0) {
                    Dialogs.getInstance().showErrorDialog(this.project.getResourceText("error.importcad.col-y-missing", this.app.getLocale()));
                } else if (idxLocation < 0) {
                    Dialogs.getInstance().showErrorDialog(this.project.getResourceText("error.importcad.location-missing", this.app.getLocale()));
                } else {
                    String[] nextLine;
                    this.rows.clear();
                    int lineNo = 1;
                    ArrayList<String> comments = new ArrayList<String>();
                    ArrayList errors = new ArrayList();
                    while ((nextLine = reader.readNext()) != null) {
                        LocationCsv row;
                        long linePlanId = -1L;
                        if (idxPlan >= 0 && idxPlan < nextLine.length) {
                            String plan = nextLine[idxPlan];
                            linePlanId = plan == null || this.planMapping.get(plan) == null ? -1L : this.planMapping.get(plan);
                        }
                        if (this.hasPlanColumn && linePlanId < 0L) {
                            comments.add(MessageFormat.format(ResourceBundle.getBundle("at/grid/themis/special/kubus360/Bundle").getString("LocationImportTopComponentKubus360.noPlanLoaded.text"), lineNo));
                        }
                        if ((row = new LocationCsv(idxNumber >= 0 && idxNumber < nextLine.length ? nextLine[idxNumber] : "", idxPlan >= 0 && idxPlan < nextLine.length ? nextLine[idxPlan] : "", linePlanId, idxLocation < nextLine.length ? nextLine[idxLocation] : "", idxX < nextLine.length ? nextLine[idxX] : "0", idxY < nextLine.length ? nextLine[idxY] : "0", idxComment >= 0 && idxComment < nextLine.length ? nextLine[idxComment] : "", idxQuantity >= 0 && idxQuantity < nextLine.length ? nextLine[idxQuantity] : "", idxCode >= 0 && idxCode < nextLine.length ? nextLine[idxCode] : "", idxCode2 >= 0 && idxCode2 < nextLine.length ? nextLine[idxCode2] : "")).getErrorMessage() == null) {
                            this.rows.add(row);
                        } else {
                            comments.add("Zeile " + lineNo + ": " + row.getErrorMessage());
                        }
                        ++lineNo;
                    }
                    StringBuilder sb = new StringBuilder(ResourceBundle.getBundle("at/grid/themis/special/kubus360/Bundle").getString("LocationImportTopComponentKubus360.problemsReadingData.text"));
                    if (!comments.isEmpty()) {
                        sb.append(ResourceBundle.getBundle("at/grid/themis/special/kubus360/Bundle").getString("LocationImportTopComponentKubus360.warningImport.text"));
                    }
                    for (String comment : comments) {
                        sb.append("<br>- ").append(comment);
                    }
                    if (!errors.isEmpty()) {
                        sb.append(ResourceBundle.getBundle("at/grid/themis/special/kubus360/Bundle").getString("LocationImportTopComponentKubus360.errorImportCancelled.text"));
                    }
                    for (String err : errors) {
                        sb.append("<br>- ").append(err);
                    }
                    if (comments.size() + errors.size() > 0) {
                        Dialogs.getInstance().showWarningDialog(sb.toString());
                    }
                    Collections.sort(this.rows);
                    this.updateLocationList();
                }
            }
        }
        catch (FileNotFoundException ex) {
            Dialogs.getInstance().showErrorDialog(ResourceBundle.getBundle("at/grid/themis/special/kubus360/Bundle").getString("LocationImportTopComponentKubus360.fileNotFound.text"), (Exception)ex);
        }
        catch (IOException ex) {
            Dialogs.getInstance().showErrorDialog(ResourceBundle.getBundle("at/grid/themis/special/kubus360/Bundle").getString("LocationImportTopComponentKubus360.errorReadingFile.text"), (Exception)ex);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Dialogs.getInstance().showErrorDialog(ResourceBundle.getBundle("at/grid/themis/special/kubus360/Bundle").getString("LocationImportTopComponentKubus360.errorOccurre.text"), ex);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    protected void importLocations() {
        if (ThemisLicense.isLicenseLevelLessThan((ThemisLicense.LicenseLevel)ThemisLicense.LicenseLevel.FULL)) {
            return;
        }
        ArrayList<LocationCsv> refs = new ArrayList<LocationCsv>();
        for (LocationCsv l : this.rows) {
            if (!l.hasImgCoordinates || this.chkCurrentPlanOnly.isSelected() && l.planId != this.planId) continue;
            refs.add(l);
        }
        if (refs.size() < 2) {
            return;
        }
        double dImgX = ((LocationCsv)refs.get((int)1)).imgX - ((LocationCsv)refs.get((int)0)).imgX;
        double dImgY = ((LocationCsv)refs.get((int)1)).imgY - ((LocationCsv)refs.get((int)0)).imgY;
        double dX = ((LocationCsv)refs.get((int)1)).x - ((LocationCsv)refs.get((int)0)).x;
        double dY = ((LocationCsv)refs.get((int)1)).y - ((LocationCsv)refs.get((int)0)).y;
        double transformX = dImgX / dX;
        double transformY = dImgY / dY;
        ArrayList<Long> locationnumbers = new ArrayList<Long>();
        List recs = this.project.getDatastorage().executeQuery("SELECT l.number FROM tdtaelelocation AS l INNER JOIN tdtaelement AS e ON (l.idelement=e.idelement) WHERE not e.deleted", true).getResult();
        for (DataRecord rec : recs) {
            locationnumbers.add(rec.getLong("number"));
        }
        int countNumberAlreadyDefined = 0;
        int countOutsideBox = 0;
        int countMarker = 0;
        int countNotInPlan = 0;
        int countNoPlan = 0;
        int countCreated = 0;
        for (LocationCsv l : this.rows) {
            int result = this.executeImport(refs, transformX, transformY, locationnumbers, l, false);
            switch (result) {
                case 100: {
                    ++countCreated;
                    break;
                }
                case 10: {
                    ++countNumberAlreadyDefined;
                    break;
                }
                case 11: {
                    ++countOutsideBox;
                    break;
                }
                case 12: {
                    ++countMarker;
                    break;
                }
                case 13: {
                    ++countNotInPlan;
                    break;
                }
                case 14: {
                    ++countNoPlan;
                }
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.rows.size() + ResourceBundle.getBundle("at/grid/themis/special/kubus360/Bundle").getString("LocationImportTopComponentKubus360.dataPrepared.text"));
        if (countNumberAlreadyDefined > 0) {
            sb.append("<br>").append(countNumberAlreadyDefined + ResourceBundle.getBundle("at/grid/themis/special/kubus360/Bundle").getString("LocationImportTopComponentKubus360.numerAlreadyUsed.text"));
        }
        if (countOutsideBox > 0) {
            sb.append("<br>").append(countOutsideBox + ResourceBundle.getBundle("at/grid/themis/special/kubus360/Bundle").getString("LocationImportTopComponentKubus360.markerOutside.text"));
        }
        if (countMarker > 0) {
            sb.append("<br>").append(countMarker + ResourceBundle.getBundle("at/grid/themis/special/kubus360/Bundle").getString("LocationImportTopComponentKubus360.markerNotImported.text"));
        }
        if (countNotInPlan > 0) {
            sb.append("<br>").append(countNotInPlan + ResourceBundle.getBundle("at/grid/themis/special/kubus360/Bundle").getString("LocationImportTopComponentKubus360.notInCurrentMap.text"));
        }
        if (countNoPlan > 0) {
            sb.append("<br>").append(countNoPlan + ResourceBundle.getBundle("at/grid/themis/special/kubus360/Bundle").getString("LocationImportTopComponentKubus360.noMapReference.text"));
        }
        if (Dialogs.getInstance().showConfirmDialog(sb.toString(), ResourceBundle.getBundle("at/grid/themis/special/kubus360/Bundle").getString("LocationImportTopComponentKubus360.checkImport.text"))) {
            for (LocationCsv l : this.rows) {
                if (this.executeImport(refs, transformX, transformY, locationnumbers, l, true) != 100) continue;
                ++countCreated;
            }
            Dialogs.getInstance().showInfoDialog(countCreated + ResourceBundle.getBundle("at/grid/themis/special/kubus360/Bundle").getString("LocationImportTopComponentKubus360.countImportedData.text"));
            ThemisActionProvider.getInstance().invokeAction(ThemisAction.LOCATION_OBSERVATION_SAVED);
        }
    }

    private int executeImport(ArrayList<LocationCsv> refs, double transformX, double transformY, ArrayList<Long> locationnumbers, LocationCsv l, boolean doSave) {
        double dX = l.x - refs.get((int)0).x;
        double dY = l.y - refs.get((int)0).y;
        l.imgX = refs.get((int)0).imgX + transformX * dX;
        l.imgY = refs.get((int)0).imgY + transformY * dY;
        double minX = Math.min(refs.get((int)0).x, refs.get((int)1).x);
        double maxX = Math.max(refs.get((int)0).x, refs.get((int)1).x);
        double minY = Math.min(refs.get((int)0).y, refs.get((int)1).y);
        double maxY = Math.max(refs.get((int)0).y, refs.get((int)1).y);
        if (this.chkOnlyWithin.isSelected() && (l.x < minX || l.x > maxX || l.y < minY || l.y > maxY)) {
            return 11;
        }
        if (!this.chkImportMarker.isSelected() && refs.contains(l)) {
            return 12;
        }
        long linePlanId = -1L;
        linePlanId = this.hasPlanColumn ? l.planId : this.planId;
        if (linePlanId < 0L && !this.chkIncludeNoPlan.isSelected()) {
            return 14;
        }
        if (this.chkCurrentPlanOnly.isSelected() && linePlanId != this.planId) {
            return 13;
        }
        if (locationnumbers.contains(l.number)) {
            return 10;
        }
        if (doSave) {
            CmsLocation loc = (CmsLocation)this.project.createElement("location");
            loc.setAttributeValue("title", l.name);
            loc.setAttributeValue("number", Long.toString(l.number));
            loc.setAttributeValue("description", l.comment);
            loc.setAttributeValue("position", "POINT(" + l.imgX + " " + l.imgY + ")");
            loc.setAttributeValue("quantity", l.quantity);
            loc.setAttributeValue("code", l.code);
            loc.setAttributeValue("code2", l.code2);
            if (linePlanId >= 0L) {
                loc.getRelationAttribute("plan").set(linePlanId);
            }
            loc.save();
            if (this.chkCreateObservation.isSelected()) {
                CmsObservation obs2 = (CmsObservation)this.project.createElement("observation");
                obs2.getRelationAttribute("location").set(loc.getId());
                obs2.setAttributeValue("title", "Wand");
                obs2.setAttributeValue("number", Integer.toString(3));
                if (linePlanId >= 0L) {
                    obs2.getRelationAttribute("plan").set(linePlanId);
                }
                obs2.save();
                CmsObservation obs1 = (CmsObservation)this.project.createElement("observation");
                obs1.getRelationAttribute("location").set(loc.getId());
                obs1.setAttributeValue("title", "Decke");
                obs1.setAttributeValue("number", Integer.toString(2));
                if (linePlanId >= 0L) {
                    obs1.getRelationAttribute("plan").set(linePlanId);
                }
                obs1.save();
                CmsObservation obs = (CmsObservation)this.project.createElement("observation");
                obs.getRelationAttribute("location").set(loc.getId());
                obs.setAttributeValue("title", "Boden");
                obs.setAttributeValue("number", Integer.toString(1));
                if (linePlanId >= 0L) {
                    obs.getRelationAttribute("plan").set(linePlanId);
                }
                obs.save();
            }
        }
        return 100;
    }

    private void initComponents() {
        this.jScrollPane2 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.fldFilename = new JTextField();
        this.jButton1 = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.locationList = new JList();
        this.btnSelectInPlan = new JButton();
        this.lblKoordinaten = new JLabel();
        this.lblComment = new JLabel();
        this.lblImage = new JLabel();
        this.btnDelete = new JButton();
        this.fldPlan = new JComboBox();
        this.jLabel4 = new JLabel();
        this.lblPlanSelect = new JLabel();
        this.lblPlan = new JLabel();
        this.lblCount = new JLabel();
        this.lblPlanSelect1 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.panelImport = new JPanel();
        this.chkImportMarker = new JCheckBox();
        this.lblImportInfo = new JLabel();
        this.chkOnlyWithin = new JCheckBox();
        this.btnImport = new JButton();
        this.lblImport = new JLabel();
        this.chkCurrentPlanOnly = new JCheckBox();
        this.chkCreateObservation = new JCheckBox();
        this.chkIncludeNoPlan = new JCheckBox();
        this.setBackground(new Color(240, 240, 240));
        this.setForeground(new Color(240, 240, 240));
        this.jLabel1.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(LocationImportTopComponentKubus360.class, (String)"LocationImportTopComponentKubus360.jLabel1.text"));
        this.fldFilename.setFont(THEMIS.fontTextfield);
        this.fldFilename.setText(NbBundle.getMessage(LocationImportTopComponentKubus360.class, (String)"LocationImportTopComponentKubus360.fldFilename.text"));
        this.jButton1.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(LocationImportTopComponentKubus360.class, (String)"LocationImportTopComponentKubus360.jButton1.text"));
        this.jButton1.setBorder(new SoftBevelBorder(0));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationImportTopComponentKubus360.this.jButton1ActionPerformed(evt);
            }
        });
        this.locationList.setFont(THEMIS.fontList);
        this.locationList.setModel(new DefaultListModel());
        this.locationList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                LocationImportTopComponentKubus360.this.locationListValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.locationList);
        this.btnSelectInPlan.setFont(THEMIS.fontButton);
        this.btnSelectInPlan.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/special/media/locate24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSelectInPlan, (String)NbBundle.getMessage(LocationImportTopComponentKubus360.class, (String)"LocationImportTopComponentKubus360.btnSelectInPlan.text"));
        this.btnSelectInPlan.setToolTipText(NbBundle.getMessage(LocationImportTopComponentKubus360.class, (String)"LocationImportTopComponentKubus360.btnSelectInPlan.toolTipText"));
        this.btnSelectInPlan.setBorder(new SoftBevelBorder(0));
        this.btnSelectInPlan.setPreferredSize(new Dimension(180, 35));
        this.btnSelectInPlan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationImportTopComponentKubus360.this.btnSelectInPlanActionPerformed(evt);
            }
        });
        this.lblKoordinaten.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblKoordinaten, (String)NbBundle.getMessage(LocationImportTopComponentKubus360.class, (String)"LocationImportTopComponentKubus360.lblKoordinaten.text"));
        this.lblComment.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblComment, (String)NbBundle.getMessage(LocationImportTopComponentKubus360.class, (String)"LocationImportTopComponentKubus360.lblComment.text"));
        this.lblImage.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblImage, (String)NbBundle.getMessage(LocationImportTopComponentKubus360.class, (String)"LocationImportTopComponentKubus360.lblImage.text"));
        this.btnDelete.setFont(THEMIS.fontButton);
        this.btnDelete.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/special/media/remove24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnDelete, (String)NbBundle.getMessage(LocationImportTopComponentKubus360.class, (String)"LocationImportTopComponentKubus360.btnDelete.text"));
        this.btnDelete.setToolTipText(NbBundle.getMessage(LocationImportTopComponentKubus360.class, (String)"LocationImportTopComponentKubus360.btnDelete.toolTipText"));
        this.btnDelete.setBorder(new SoftBevelBorder(0));
        this.btnDelete.setPreferredSize(new Dimension(180, 35));
        this.btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationImportTopComponentKubus360.this.btnDeleteActionPerformed(evt);
            }
        });
        this.fldPlan.setFont(THEMIS.fontList);
        this.fldPlan.setModel(new DefaultComboBoxModel());
        this.fldPlan.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                LocationImportTopComponentKubus360.this.fldPlanItemStateChanged(evt);
            }
        });
        this.jLabel4.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(LocationImportTopComponentKubus360.class, (String)"LocationImportTopComponentKubus360.jLabel4.text"));
        this.lblPlanSelect.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.lblPlanSelect, (String)NbBundle.getMessage(LocationImportTopComponentKubus360.class, (String)"LocationImportTopComponentKubus360.lblPlanSelect.text"));
        this.lblPlan.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblPlan, (String)NbBundle.getMessage(LocationImportTopComponentKubus360.class, (String)"LocationImportTopComponentKubus360.lblPlan.text"));
        this.lblCount.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblCount, (String)NbBundle.getMessage(LocationImportTopComponentKubus360.class, (String)"LocationImportTopComponentKubus360.lblCount.text"));
        this.lblPlanSelect1.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.lblPlanSelect1, (String)NbBundle.getMessage(LocationImportTopComponentKubus360.class, (String)"LocationImportTopComponentKubus360.lblPlanSelect1.text"));
        this.jLabel3.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(LocationImportTopComponentKubus360.class, (String)"LocationImportTopComponentKubus360.jLabel3.text"));
        this.jLabel5.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(LocationImportTopComponentKubus360.class, (String)"LocationImportTopComponentKubus360.jLabel5.text"));
        this.jLabel6.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(LocationImportTopComponentKubus360.class, (String)"LocationImportTopComponentKubus360.jLabel6.text"));
        this.chkImportMarker.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((AbstractButton)this.chkImportMarker, (String)NbBundle.getMessage(LocationImportTopComponentKubus360.class, (String)"LocationImportTopComponentKubus360.chkImportMarker.text"));
        this.chkImportMarker.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationImportTopComponentKubus360.this.chkImportMarkerActionPerformed(evt);
            }
        });
        this.lblImportInfo.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.lblImportInfo, (String)NbBundle.getMessage(LocationImportTopComponentKubus360.class, (String)"LocationImportTopComponentKubus360.lblImportInfo.text"));
        this.lblImportInfo.setPreferredSize(new Dimension(180, 14));
        this.chkOnlyWithin.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((AbstractButton)this.chkOnlyWithin, (String)NbBundle.getMessage(LocationImportTopComponentKubus360.class, (String)"LocationImportTopComponentKubus360.chkOnlyWithin.text"));
        this.chkOnlyWithin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationImportTopComponentKubus360.this.chkOnlyWithinActionPerformed(evt);
            }
        });
        this.btnImport.setFont(THEMIS.fontButton);
        this.btnImport.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/at/grid/themis/special/media/action_importCAD24.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnImport, (String)NbBundle.getMessage(LocationImportTopComponentKubus360.class, (String)"LocationImportTopComponentKubus360.btnImport.text"));
        this.btnImport.setToolTipText(NbBundle.getMessage(LocationImportTopComponentKubus360.class, (String)"LocationImportTopComponentKubus360.btnImport.toolTipText"));
        this.btnImport.setBorder(new SoftBevelBorder(0));
        this.btnImport.setPreferredSize(new Dimension(180, 35));
        this.btnImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocationImportTopComponentKubus360.this.btnImportActionPerformed(evt);
            }
        });
        this.lblImport.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.lblImport, (String)NbBundle.getMessage(LocationImportTopComponentKubus360.class, (String)"LocationImportTopComponentKubus360.lblImport.text"));
        this.chkCurrentPlanOnly.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((AbstractButton)this.chkCurrentPlanOnly, (String)NbBundle.getMessage(LocationImportTopComponentKubus360.class, (String)"LocationImportTopComponentKubus360.chkCurrentPlanOnly.text"));
        this.chkCreateObservation.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((AbstractButton)this.chkCreateObservation, (String)NbBundle.getMessage(LocationImportTopComponentKubus360.class, (String)"LocationImportTopComponentKubus360.chkCreateObservation.text"));
        this.chkIncludeNoPlan.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((AbstractButton)this.chkIncludeNoPlan, (String)NbBundle.getMessage(LocationImportTopComponentKubus360.class, (String)"LocationImportTopComponentKubus360.chkIncludeNoPlan.text"));
        GroupLayout panelImportLayout = new GroupLayout(this.panelImport);
        this.panelImport.setLayout(panelImportLayout);
        panelImportLayout.setHorizontalGroup(panelImportLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelImportLayout.createSequentialGroup().addGroup(panelImportLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblImport).addComponent(this.chkCurrentPlanOnly).addComponent(this.chkCreateObservation).addComponent(this.chkIncludeNoPlan)).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.chkOnlyWithin, -1, -1, Short.MAX_VALUE).addComponent(this.btnImport, -1, -1, Short.MAX_VALUE).addGroup(panelImportLayout.createSequentialGroup().addGroup(panelImportLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chkImportMarker, -1, -1, Short.MAX_VALUE).addGroup(panelImportLayout.createSequentialGroup().addComponent(this.lblImportInfo, -2, 180, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        panelImportLayout.setVerticalGroup(panelImportLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelImportLayout.createSequentialGroup().addComponent(this.lblImport).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.chkOnlyWithin).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkImportMarker).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkCurrentPlanOnly).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkCreateObservation).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkIncludeNoPlan).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnImport, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblImportInfo, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.panelImport, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel6, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel5, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel3, GroupLayout.Alignment.LEADING, -2, 99, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblCount, -1, -1, Short.MAX_VALUE).addComponent(this.lblKoordinaten, -1, -1, Short.MAX_VALUE).addComponent(this.lblComment, -1, -1, Short.MAX_VALUE).addComponent(this.lblImage, -1, -1, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addComponent(this.lblPlan, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.fldPlan, 0, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addComponent(this.btnSelectInPlan, -1, -1, Short.MAX_VALUE).addGap(14, 14, 14).addComponent(this.btnDelete, -1, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.fldFilename).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1, -2, 67, -2)).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel4, GroupLayout.Alignment.LEADING).addComponent(this.lblPlanSelect, GroupLayout.Alignment.LEADING).addComponent(this.lblPlanSelect1, GroupLayout.Alignment.LEADING)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1, -2, 30, -2).addComponent(this.fldFilename, -2, 30, -2).addComponent(this.jButton1, -2, 30, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblPlanSelect).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblPlan, -2, 30, -2).addComponent(this.fldPlan, -2, 30, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblPlanSelect1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.lblCount)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.lblKoordinaten)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.lblComment)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblImage).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnSelectInPlan, -2, 35, -2).addComponent(this.btnDelete, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.panelImport, -2, -1, -2).addContainerGap()));
        this.jScrollPane2.setViewportView(this.jPanel1);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 514, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, GroupLayout.Alignment.TRAILING, -1, 855, Short.MAX_VALUE));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app) || ThemisLicense.isActionDeniedForBSbuch((ThemisApplication)this.app)) {
            return;
        }
        try {
            File f = new ThemisFileDialog("CSV Datei \u00f6ffnen", ThemisFileDialog.DIALOGTYPE.OPEN, this.app.getDocumentImportFolder(), null, THEMIS.getCsvFilter(), null, false).getSelectedFile();
            if (f != null) {
                this.app.setDocumentImportFolder(f.getParentFile());
                this.readCsvFile(f);
            }
        }
        catch (Exception ex) {
            Dialogs.getInstance().showErrorDialog(ResourceBundle.getBundle("at/grid/themis/special/kubus360/Bundle").getString("LocationImportTopComponentKubus360.error.text"), ex);
        }
    }

    private void btnSelectInPlanActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app) || ThemisLicense.isActionDeniedForBSbuch((ThemisApplication)this.app)) {
            return;
        }
        this.waitingForPoint = true;
        this.btnSelectInPlan.setEnabled(false);
        ThemisActionProvider.getInstance().invokeAction(ThemisAction.CREATE_POINT_IN_PLAN_START.setReference((Object)this));
    }

    private void locationListValueChanged(ListSelectionEvent evt) {
        LocationCsv l = (LocationCsv)this.locationList.getSelectedValue();
        if (l != null) {
            this.lblKoordinaten.setText("X/Y: " + l.x + "/" + l.y);
            this.lblComment.setText(l.comment);
            this.lblImage.setText(l.hasImgCoordinates ? "Image X/Y: " + Util.round((double)l.imgX, (int)1) + "/" + Util.round((double)l.imgY, (int)1) : "");
        } else {
            this.lblKoordinaten.setText("");
            this.lblComment.setText("");
            this.lblImage.setText("");
        }
    }

    private void btnDeleteActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app) || ThemisLicense.isActionDeniedForBSbuch((ThemisApplication)this.app)) {
            return;
        }
        List list = this.locationList.getSelectedValuesList();
        if (list != null) {
            for (LocationCsv entry : list) {
                this.rows.remove(entry);
            }
            this.updateLocationList();
        }
    }

    private void btnImportActionPerformed(ActionEvent evt) {
        if (ThemisLicense.isActionDeniedForViewer((ThemisApplication)this.app) || ThemisLicense.isActionDeniedForBSbuch((ThemisApplication)this.app)) {
            return;
        }
        this.importLocations();
    }

    private void fldPlanItemStateChanged(ItemEvent evt) {
        CmsElementSummary ele = (CmsElementSummary)this.fldPlan.getSelectedItem();
        if (ele != null && this.planId != ele.getId()) {
            this.planId = ele.getId();
            ThemisActionProvider.getInstance().invokeAction(ThemisAction.PLAN_SELECTED.setId(this.planId));
            this.updateLocationList();
        }
    }

    private void chkOnlyWithinActionPerformed(ActionEvent evt) {
    }

    private void chkImportMarkerActionPerformed(ActionEvent evt) {
    }

    public void componentOpened() {
        this.updatePlanCombo();
        this.panelImport.setVisible(false);
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    class LocationCsv
    implements Comparable<LocationCsv> {
        long number;
        String plan;
        long planId;
        String name;
        double x;
        double y;
        String comment;
        double imgX;
        double imgY;
        boolean hasImgCoordinates = false;
        String errormessage = null;
        String quantity;
        String code;
        String code2;

        public LocationCsv(String number, String plan, long planId, String name, String x, String y, String comment, String quantity, String code, String code2) {
            if (x == null || "".equals(x)) {
                this.errormessage = ResourceBundle.getBundle("at/grid/themis/special/kubus360/Bundle").getString("LocationImportTopComponentKubus360.noXDefined.text");
                return;
            }
            if (y == null || "".equals(y)) {
                this.errormessage = ResourceBundle.getBundle("at/grid/themis/special/kubus360/Bundle").getString("LocationImportTopComponentKubus360.noYDefined.text");
                return;
            }
            this.number = number == null || "".equals(number) ? 0L : Long.parseLong(number);
            x = x.replaceAll(",", ".");
            y = y.replaceAll(",", ".");
            if (name == null || "".equals(name)) {
                name = ResourceBundle.getBundle("at/grid/themis/special/kubus360/Bundle").getString("LocationImportTopComponentKubus360.noTitle.text");
            }
            this.name = name;
            this.x = Double.parseDouble(x);
            this.y = Double.parseDouble(y);
            this.comment = comment;
            this.plan = plan == null ? "" : plan;
            this.planId = planId;
            this.quantity = quantity;
            this.code = code;
            this.code2 = code2;
        }

        public LocationCsv(String name, double x, double y, String c) {
            this.name = name;
            this.x = x;
            this.y = y;
            this.comment = c;
        }

        public String getErrorMessage() {
            return this.errormessage;
        }

        public String toString() {
            return (this.hasImgCoordinates ? "(*) " : "") + "[" + this.number + "] " + ("".equals(this.plan) ? "" : this.plan + ":") + this.name;
        }

        public void setImageCoordinates(double x, double y) {
            this.imgX = x;
            this.imgY = y;
            this.hasImgCoordinates = true;
        }

        @Override
        public int compareTo(LocationCsv o) {
            if (this.number == o.number) {
                return this.name.compareTo(o.name);
            }
            return o.number < this.number ? -1 : 1;
        }
    }
}

