/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.special.kyberna;

import at.grid.cms.content.UploadItem;
import at.grid.themis.application.EmailAuthenticationPanel;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.element.CmsEvent;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.util.EmailSendThread;
import com.sun.mail.imap.IMAPFolder;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.SoftBevelBorder;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class KybernaPanel
extends JPanel {
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    private JButton btnCreateEmails;
    private JButton btnReadEmails;
    private JTextField fldEmailAddress;
    private JLabel jLabel1;
    private JLabel jLabel15;

    public KybernaPanel() {
        this.initComponents();
        this.btnReadEmails.setVisible(false);
    }

    private void sendEmails() {
        if (!this.project.getSelectionManager().hasSelectedObservationIds()) {
            Dialogs.getInstance().showWarningDialog("Keine Beobachtungen ausgew\u00e4hlt");
            return;
        }
        EmailAuthenticationPanel panel = new EmailAuthenticationPanel();
        panel.populate();
        if (Dialogs.getInstance().showDialog((JPanel)panel, "E-Mail Server", new String[]{"OK", "Abbrechen"}) == 0) {
            panel.apply();
            String emailAuthUser = panel.getUser();
            String emailAuthPwd = panel.getPassword();
            String emailAddress = this.fldEmailAddress.getText();
            String smtp = this.app.getConfiguration("system.email.smtp");
            String port = this.app.getConfiguration("system.email.port", "587");
            String encrypt = this.app.getConfiguration("system.email.encrypt", "0");
            String emailFrom = this.app.getConfiguration("system.email.from", "");
            Iterator iterator = this.project.getSelectionManager().getSelectedObservationIds().iterator();
            while (iterator.hasNext()) {
                long obsId = (Long)iterator.next();
                CmsObservation obs = (CmsObservation)this.project.loadElement(obsId, this.project.getUser());
                CmsLocation loc = obs.getLocation();
                CmsEvent event = (CmsEvent)this.project.loadElement(obs.getLatestHistory().getEventId(), this.project.getUser());
                String emailText = loc.toFormattedString() + obs.toFormattedString();
                String emailBetreff = "themis " + this.project.getProjectElement().getUUID().toString() + " " + obs.getUUID().toString() + " [" + loc.getFullNumber() + "." + obs.getAttributeValue("number") + "]";
                EmailSendThread email = new EmailSendThread(emailBetreff, emailText);
                email.setServer(smtp, Integer.parseInt(port), Integer.parseInt(encrypt));
                email.addRecipient(emailAddress);
                email.setFrom(emailFrom);
                email.setAuthentication(emailAuthUser, emailAuthPwd);
                ArrayList uploads = obs.getUploads(true);
                for (UploadItem upload : uploads) {
                    email.addAttachment(upload.getFile());
                }
                email.send(false);
            }
        }
        Dialogs.getInstance().showInfoDialog("E-Mails versendet!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readEmails() throws MessagingException {
        String url = this.app.getConfiguration("system.email.smtp");
        EmailAuthenticationPanel panel = new EmailAuthenticationPanel();
        panel.populate();
        if (Dialogs.getInstance().showDialog((JPanel)panel, "E-Mail Server", new String[]{"OK", "Abbrechen"}) == 0) {
            panel.apply();
            String emailAuthUser = panel.getUser();
            String emailAuthPwd = panel.getPassword();
            Properties props = System.getProperties();
            props.setProperty("mail.store.protocol", "imaps");
            Session session = Session.getDefaultInstance((Properties)props, null);
            try (Store store = session.getStore("imaps");){
                System.out.println("Connecting to IMAP server: " + url);
                store.connect(url, emailAuthUser, emailAuthPwd);
                Folder root = store.getDefaultFolder();
                Folder[] folders = root.list();
                System.out.println("Select a folder");
                for (int i = 0; i < folders.length; ++i) {
                    System.out.println("\t" + folders[i].getName());
                }
                String folderName = "INBOX";
                IMAPFolder folder = (IMAPFolder)store.getFolder(folderName);
                long afterFolderSelectionTime = System.nanoTime();
                int totalNumberOfMessages = 0;
                try {
                    if (!folder.isOpen()) {
                        folder.open(1);
                    }
                    long largestUid = folder.getUIDNext() - 1L;
                    int chunkSize = 500;
                    for (long offset = 0L; offset < largestUid; offset += (long)chunkSize) {
                        long start = Math.max(1L, largestUid - offset - (long)chunkSize + 1L);
                        long end = Math.max(1L, largestUid - offset);
                        long beforeTime = System.nanoTime();
                        Message[] messages = folder.getMessagesByUID(start, end);
                        totalNumberOfMessages += messages.length;
                        System.out.println("found " + messages.length + " messages (took " + (System.nanoTime() - beforeTime) / 1000L / 1000L + " ms)");
                        beforeTime = System.nanoTime();
                        FetchProfile metadataProfile = new FetchProfile();
                        metadataProfile.add(FetchProfile.Item.FLAGS);
                        metadataProfile.add(FetchProfile.Item.ENVELOPE);
                        folder.fetch(messages, metadataProfile);
                        System.out.println("loaded messages (took " + (System.nanoTime() - beforeTime) / 1000L / 1000L + " ms)");
                        beforeTime = System.nanoTime();
                        for (int i = messages.length - 1; i >= 0; --i) {
                            Message message = messages[i];
                            long uid = folder.getUID(message);
                            boolean isRead = message.isSet(Flags.Flag.SEEN);
                            if (!isRead) {
                                System.out.print("\u001b[32m");
                            }
                            System.out.println("\t" + uid + "\t" + message.getSubject());
                            if (isRead) continue;
                            System.out.print("\u001b[0m");
                        }
                        System.out.println("Listed message (took " + (System.nanoTime() - beforeTime) / 1000L / 1000L + " ms)");
                    }
                }
                finally {
                    if (folder.isOpen()) {
                        folder.close(true);
                    }
                }
                System.out.println("\nListed all " + totalNumberOfMessages + " messages (took " + (System.nanoTime() - afterFolderSelectionTime) / 1000L / 1000L + " ms)");
            }
        }
    }

    private void initComponents() {
        this.btnCreateEmails = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel15 = new JLabel();
        this.fldEmailAddress = new JTextField();
        this.btnReadEmails = new JButton();
        this.btnCreateEmails.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnCreateEmails, (String)NbBundle.getMessage(KybernaPanel.class, (String)"KybernaPanel.btnCreateEmails.text"));
        this.btnCreateEmails.setBorder(new SoftBevelBorder(0));
        this.btnCreateEmails.setMinimumSize(new Dimension(5, 22));
        this.btnCreateEmails.setPreferredSize(new Dimension(197, 35));
        this.btnCreateEmails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KybernaPanel.this.btnCreateEmailsActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(KybernaPanel.class, (String)"KybernaPanel.jLabel1.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel15, (String)NbBundle.getMessage(KybernaPanel.class, (String)"KybernaPanel.jLabel15.text"));
        this.fldEmailAddress.setText(NbBundle.getMessage(KybernaPanel.class, (String)"KybernaPanel.fldEmailAddress.text"));
        this.fldEmailAddress.setMinimumSize(new Dimension(5, 24));
        this.fldEmailAddress.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KybernaPanel.this.fldEmailAddressActionPerformed(evt);
            }
        });
        this.btnReadEmails.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnReadEmails, (String)NbBundle.getMessage(KybernaPanel.class, (String)"KybernaPanel.btnReadEmails.text"));
        this.btnReadEmails.setBorder(new SoftBevelBorder(0));
        this.btnReadEmails.setMinimumSize(new Dimension(5, 22));
        this.btnReadEmails.setPreferredSize(new Dimension(197, 35));
        this.btnReadEmails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KybernaPanel.this.btnReadEmailsActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnCreateEmails, -1, 402, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel15).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fldEmailAddress, -1, -1, Short.MAX_VALUE)).addComponent(this.btnReadEmails, -1, 402, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel15).addComponent(this.fldEmailAddress, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCreateEmails, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnReadEmails, -2, -1, -2).addContainerGap(127, Short.MAX_VALUE)));
    }

    private void btnCreateEmailsActionPerformed(ActionEvent evt) {
        this.sendEmails();
    }

    private void fldEmailAddressActionPerformed(ActionEvent evt) {
    }

    private void btnReadEmailsActionPerformed(ActionEvent evt) {
        try {
            this.readEmails();
        }
        catch (MessagingException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

