/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.special.lippmann;

import at.grid.themis.application.THEMIS;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.javafx.JavaFxDialog;
import at.grid.themis.ontology.javafx.JavaFxSwingDialog;
import at.grid.themis.ontology.javafx.ThemisTaskWithFxDialog;
import at.grid.themis.ontology.javafx.io.ExportCsvFxPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javafx.scene.Node;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.SoftBevelBorder;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class LippmannPanel
extends JPanel {
    private final ThemisApplication app = ThemisApplication.getInstance();
    private final ThemisProject project = this.app.getProject();
    private JButton btnExportCSV;
    private JLabel jLabel8;
    private JPanel jPanel1;

    public LippmannPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.jLabel8 = new JLabel();
        this.btnExportCSV = new JButton();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.jLabel8.setFont(THEMIS.fontHeading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel8, (String)NbBundle.getMessage(LippmannPanel.class, (String)"LippmannPanel.jLabel8.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel8, gridBagConstraints);
        this.btnExportCSV.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnExportCSV, (String)NbBundle.getMessage(LippmannPanel.class, (String)"LippmannPanel.btnExportCSV.text"));
        this.btnExportCSV.setBorder(new SoftBevelBorder(0));
        this.btnExportCSV.setMinimumSize(new Dimension(60, 30));
        this.btnExportCSV.setPreferredSize(new Dimension(60, 30));
        this.btnExportCSV.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LippmannPanel.this.btnExportCSVActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.btnExportCSV, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void btnExportCSVActionPerformed(ActionEvent evt) {
        if (!this.project.isOpen()) {
            this.app.getDialog().showWarningDialog("Es ist kein Projekt ge\u00f6ffnet.");
            return;
        }
        JavaFxSwingDialog dlg = new JavaFxSwingDialog("csv-export", 850, 900);
        ExportCsvFxPanel panel = new ExportCsvFxPanel().populate();
        JavaFxDialog fx = new JavaFxDialog((Node)panel);
        fx.addSaveButton("Exportieren").setOnAction(ev -> ThemisTaskWithFxDialog.createTask((String)"csv-export.exporting", ph -> {
            panel.apply(ph);
            try {
                File file = panel.export(ph);
                if (file != null && file.exists()) {
                    SwingUtilities.invokeLater(() -> THEMIS.showFileResultDialog((File)file));
                }
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)e);
                this.app.getDialog().showErrorDialog("Export fehlgeschlagen!", e);
            }
        }));
        fx.addCancelButton("Abbrechen");
        dlg.setContent((Node)fx);
        dlg.show();
    }
}

