/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.special.oehmke;

import at.grid.themis.application.THEMIS;
import at.grid.themis.application.api.Dialogs;
import at.grid.themis.application.api.ThemisFileDialog;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.special.oehmke.OehmkeReportGenerator;
import at.grid.util.Util;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.SoftBevelBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.netbeans.api.progress.BaseProgressUtils;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class OehmkePanel
extends JPanel {
    ThemisApplication app = ThemisApplication.getInstance();
    private JButton btnExxport;
    private JButton btnSelectFolder;
    private JButton btnSelectTemplate;
    private JCheckBox chkCreateFolder;
    private JCheckBox chkOnlyDefects;
    private JComboBox<String> fldAusgabeArt;
    private JTextField fldBearbeiter;
    private JTextField fldBerichtNr;
    private JTextField fldFilename;
    private JTextField fldFolder;
    private JTextField fldTemplate;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;

    public OehmkePanel() {
        this.initComponents();
        this.populate();
    }

    public void populate() {
        File f = this.app.getPathExportFolder();
        if (f != null) {
            this.fldFolder.setText(f.getAbsolutePath());
        }
        String editor = this.app.getConfiguration("oehmke.export.editor", "");
        String filename = this.app.getConfiguration("oehmke.export.filename", "");
        String folder = this.app.getConfiguration("oehmke.export.folder", "");
        String nr = this.app.getConfiguration("oehmke.export.nr", "");
        int output = Integer.parseInt(this.app.getConfiguration("oehmke.export.output", "0"));
        String template = this.app.getConfiguration("oehmke.export.template", "");
        this.fldBearbeiter.setText(editor);
        this.fldFilename.setText(filename);
        this.fldFolder.setText(folder);
        this.fldBerichtNr.setText(nr);
        this.fldAusgabeArt.setSelectedIndex(output);
        this.fldTemplate.setText(template);
    }

    private void applySettings() {
        this.app.setConfiguration("oehmke.export.editor", this.fldBearbeiter.getText(), false);
        this.app.setConfiguration("oehmke.export.filename", this.fldFilename.getText(), false);
        this.app.setConfiguration("oehmke.export.folder", this.fldFolder.getText(), false);
        this.app.setConfiguration("oehmke.export.nr", this.fldBerichtNr.getText(), false);
        this.app.setConfiguration("oehmke.export.output", this.fldAusgabeArt.getSelectedIndex() + "", false);
        this.app.setConfiguration("oehmke.export.template", this.fldTemplate.getText(), true);
    }

    private void initComponents() {
        this.btnExxport = new JButton();
        this.jLabel1 = new JLabel();
        this.fldFolder = new JTextField();
        this.jLabel2 = new JLabel();
        this.btnSelectFolder = new JButton();
        this.jLabel3 = new JLabel();
        this.fldFilename = new JTextField();
        this.chkCreateFolder = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.jLabel4 = new JLabel();
        this.fldBearbeiter = new JTextField();
        this.jLabel5 = new JLabel();
        this.fldBerichtNr = new JTextField();
        this.jLabel6 = new JLabel();
        this.fldAusgabeArt = new JComboBox();
        this.jLabel7 = new JLabel();
        this.fldTemplate = new JTextField();
        this.btnSelectTemplate = new JButton();
        this.chkOnlyDefects = new JCheckBox();
        this.btnExxport.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnExxport, (String)NbBundle.getMessage(OehmkePanel.class, (String)"OehmkePanel.btnExxport.text"));
        this.btnExxport.setBorder(new SoftBevelBorder(0));
        this.btnExxport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OehmkePanel.this.btnExxportActionPerformed(evt);
            }
        });
        this.jLabel1.setFont(THEMIS.fontHeading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(OehmkePanel.class, (String)"OehmkePanel.jLabel1.text"));
        this.fldFolder.setEditable(false);
        this.fldFolder.setFont(THEMIS.fontTextfield);
        this.fldFolder.setText(NbBundle.getMessage(OehmkePanel.class, (String)"OehmkePanel.fldFolder.text"));
        this.fldFolder.setPreferredSize(new Dimension(6, 30));
        this.jLabel2.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(OehmkePanel.class, (String)"OehmkePanel.jLabel2.text"));
        this.jLabel2.setPreferredSize(new Dimension(60, 30));
        this.btnSelectFolder.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnSelectFolder, (String)NbBundle.getMessage(OehmkePanel.class, (String)"OehmkePanel.btnSelectFolder.text"));
        this.btnSelectFolder.setBorder(new SoftBevelBorder(0));
        this.btnSelectFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OehmkePanel.this.btnSelectFolderActionPerformed(evt);
            }
        });
        this.jLabel3.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(OehmkePanel.class, (String)"OehmkePanel.jLabel3.text"));
        this.jLabel3.setPreferredSize(new Dimension(60, 30));
        this.fldFilename.setFont(THEMIS.fontTextfield);
        this.fldFilename.setText(NbBundle.getMessage(OehmkePanel.class, (String)"OehmkePanel.fldFilename.text"));
        this.fldFilename.setPreferredSize(new Dimension(6, 30));
        Mnemonics.setLocalizedText((AbstractButton)this.chkCreateFolder, (String)NbBundle.getMessage(OehmkePanel.class, (String)"OehmkePanel.chkCreateFolder.text"));
        this.jLabel4.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(OehmkePanel.class, (String)"OehmkePanel.jLabel4.text"));
        this.jLabel4.setPreferredSize(new Dimension(60, 30));
        this.fldBearbeiter.setFont(THEMIS.fontTextfield);
        this.fldBearbeiter.setText(NbBundle.getMessage(OehmkePanel.class, (String)"OehmkePanel.fldBearbeiter.text"));
        this.fldBearbeiter.setPreferredSize(new Dimension(6, 30));
        this.jLabel5.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(OehmkePanel.class, (String)"OehmkePanel.jLabel5.text"));
        this.jLabel5.setPreferredSize(new Dimension(60, 30));
        this.fldBerichtNr.setFont(THEMIS.fontTextfield);
        this.fldBerichtNr.setText(NbBundle.getMessage(OehmkePanel.class, (String)"OehmkePanel.fldBerichtNr.text"));
        this.fldBerichtNr.setPreferredSize(new Dimension(6, 30));
        this.jLabel6.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(OehmkePanel.class, (String)"OehmkePanel.jLabel6.text"));
        this.jLabel6.setPreferredSize(new Dimension(60, 30));
        this.fldAusgabeArt.setModel(new DefaultComboBoxModel<String>(new String[]{"reduziert", "vollst\u00e4ndig"}));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel4, -2, 111, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fldBearbeiter, -1, -1, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel5, -2, 111, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fldBerichtNr, -1, -1, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel6, -2, 111, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fldAusgabeArt, 0, -1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4, -2, -1, -2).addComponent(this.fldBearbeiter, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5, -2, -1, -2).addComponent(this.fldBerichtNr, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6, -2, -1, -2).addComponent(this.fldAusgabeArt, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabel7.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(OehmkePanel.class, (String)"OehmkePanel.jLabel7.text"));
        this.jLabel7.setPreferredSize(new Dimension(60, 30));
        this.fldTemplate.setEditable(false);
        this.fldTemplate.setFont(THEMIS.fontTextfield);
        this.fldTemplate.setText(NbBundle.getMessage(OehmkePanel.class, (String)"OehmkePanel.fldTemplate.text"));
        this.fldTemplate.setPreferredSize(new Dimension(6, 30));
        this.btnSelectTemplate.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnSelectTemplate, (String)NbBundle.getMessage(OehmkePanel.class, (String)"OehmkePanel.btnSelectTemplate.text"));
        this.btnSelectTemplate.setBorder(new SoftBevelBorder(0));
        this.btnSelectTemplate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OehmkePanel.this.btnSelectTemplateActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.chkOnlyDefects, (String)NbBundle.getMessage(OehmkePanel.class, (String)"OehmkePanel.chkOnlyDefects.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnExxport, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel7, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel2, GroupLayout.Alignment.LEADING, -1, 107, Short.MAX_VALUE).addComponent(this.jLabel3, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.fldTemplate, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSelectTemplate, -2, 70, -2)).addGroup(layout.createSequentialGroup().addComponent(this.fldFolder, -1, 336, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSelectFolder, -2, 70, -2)).addComponent(this.fldFilename, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chkOnlyDefects).addComponent(this.chkCreateFolder)).addGap(0, 0, Short.MAX_VALUE))))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7, -2, -1, -2).addComponent(this.fldTemplate, -2, -1, -2).addComponent(this.btnSelectTemplate, -2, 30, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2, -2, -1, -2).addComponent(this.fldFolder, -2, -1, -2).addComponent(this.btnSelectFolder, -2, 30, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3, -2, -1, -2).addComponent(this.fldFilename, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkCreateFolder).addGap(4, 4, 4).addComponent(this.chkOnlyDefects).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnExxport, -2, 30, -2).addContainerGap(102, Short.MAX_VALUE)));
    }

    private void btnExxportActionPerformed(ActionEvent evt) {
        File f;
        if (ThemisApplication.getInstance().getProject().getCurrentEvent() == null) {
            ThemisApplication.getInstance().getDialog().showWarningDialog("app.core.text.noevent");
            return;
        }
        String templateName = this.fldTemplate.getText();
        if ("".equals(templateName)) {
            Dialogs.getInstance().showErrorDialog(ThemisApplication.getInstance().getProject().getResourceText("error.template-required"));
            return;
        }
        String folderName = this.fldFolder.getText();
        if ("".equals(folderName)) {
            Dialogs.getInstance().showErrorDialog(ThemisApplication.getInstance().getProject().getResourceText("error.folder-required"));
            return;
        }
        String fname = this.fldFilename.getText() + (this.fldFilename.getText().toLowerCase().endsWith(".docx") ? "" : ".docx");
        if ("".equals(fname.trim())) {
            Dialogs.getInstance().showErrorDialog(ThemisApplication.getInstance().getProject().getResourceText("error.filename-required"));
            return;
        }
        String fnameBase = Util.getFileNameWithoutExtension((File)new File(fname));
        File folder = new File(folderName);
        File file = f = this.chkCreateFolder.isSelected() ? new File(new File(folder, fnameBase), fname) : new File(folder, fname);
        if (f.exists()) {
            Dialogs.getInstance().showErrorDialog(ThemisApplication.getInstance().getProject().getResourceText("error.file-exists"));
            return;
        }
        final File templatefile = new File(this.fldTemplate.getText());
        this.applySettings();
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                f.getParentFile().mkdirs();
                try {
                    OehmkeReportGenerator r = new OehmkeReportGenerator(templatefile);
                    r.createReport(f, OehmkePanel.this.fldBearbeiter.getText(), OehmkePanel.this.fldBerichtNr.getText(), OehmkePanel.this.fldAusgabeArt.getSelectedIndex(), OehmkePanel.this.chkOnlyDefects.isSelected());
                    Dialogs.getInstance().showInfoDialog(ThemisApplication.getInstance().getProject().getResourceText("info.export-successful"));
                    Desktop.getDesktop().open(f);
                }
                catch (IOException ex) {
                    Dialogs.getInstance().showErrorDialog(ex.getMessage(), (Exception)ex);
                }
                catch (InvalidFormatException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        };
        BaseProgressUtils.showProgressDialogAndRun((Runnable)runner, (String)"Das Protokoll wird erzeugt ...");
    }

    private void btnSelectFolderActionPerformed(ActionEvent evt) {
        File f = new ThemisFileDialog("Ordner f\u00fcr Export ausw\u00e4hlen", ThemisFileDialog.DIALOGTYPE.DIRECTORY, ThemisApplication.getInstance().getPathExportFolder(), null, null, null, false).getSelectedFile();
        if (f != null) {
            this.fldFolder.setText(f.getAbsolutePath());
            ThemisApplication.getInstance().setPathExportFolder(f);
        }
    }

    private void btnSelectTemplateActionPerformed(ActionEvent evt) {
        File f = new ThemisFileDialog("Vorlage ausw\u00e4hlen", ThemisFileDialog.DIALOGTYPE.OPEN, ThemisApplication.getInstance().getSettings().getFolderReportTemplate().getValue(true), null, (FileFilter)new FileNameExtensionFilter(ThemisApplication.getInstance().getProject().getResourceText("dialog.load.protocol-template.word"), "docx"), null, false).getSelectedFile();
        if (f == null) {
            this.fldTemplate.setText("");
            return;
        }
        if (!f.isFile() || f.isDirectory()) {
            Dialogs.getInstance().showWarningDialog("Keine Datei ausgew\u00e4hlt");
            return;
        }
        this.fldTemplate.setText(f.getAbsolutePath());
    }
}

