/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.special.oehmke;

import at.grid.cms.attribute.DateAttribute;
import at.grid.cms.element.CmsElementSummary;
import at.grid.cms.storage.DataRecord;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.themis.ontology.element.CmsLocationgroup;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.filter.ThemisFilter;
import at.grid.themis.ontology.report.Placeholder;
import at.grid.util.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFStyles;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlCursor;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTOnOff;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTShd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STShd;

public class OehmkeReportGenerator {
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    XWPFDocument document;
    XWPFParagraph currentPara = null;
    boolean firstTableRow = true;
    public static Placeholder placeholder;

    public OehmkeReportGenerator(File template) throws FileNotFoundException, IOException {
        this.document = template.isFile() ? new XWPFDocument((InputStream)new FileInputStream(template)) : new XWPFDocument();
        XWPFStyles styles = this.document.getStyles();
    }

    /*
     * Could not resolve type clashes
     */
    public void createReport(File destinationFile, String bearbeiter, String berichtnr, int reporttype, boolean onlyDefects) throws IOException, InvalidFormatException {
        if (placeholder == null) {
            placeholder = new Placeholder(null);
        }
        placeholder.clearSpecialPlaceholder();
        placeholder.addSpecialPlaceholder("berichtnummer", berichtnr);
        placeholder.addSpecialPlaceholder("berichtbearbeiter", bearbeiter);
        placeholder.setEvent(this.project.getCurrentEvent());
        ThemisFilter filter = this.app.getFilter();
        filter.setTriggerEnabled(false);
        for (XWPFParagraph para : this.document.getParagraphs()) {
            StringBuilder sb = new StringBuilder();
            ArrayList<Integer> sbIndex = new ArrayList<Integer>();
            List runs = para.getRuns();
            int lastIndex = 0;
            Iterator iterator = runs.iterator();
            while (iterator.hasNext()) {
                XWPFRun run = (XWPFRun)iterator.next();
                String ss = run.getText(0);
                if (ss != null) {
                    int stringIndex = sb.length();
                    sb.append(ss);
                    lastIndex = sb.lastIndexOf(ss);
                    sbIndex.add(lastIndex);
                    if (lastIndex == stringIndex) continue;
                    boolean bl = true;
                    continue;
                }
                sbIndex.add(lastIndex);
            }
            ArrayList<String> placeholders = this.getPlaceholders(sb.toString());
            for (int ii = placeholders.size() - 1; ii >= 0; --ii) {
                String ph = "#!#" + placeholders.get(ii) + "#!#";
                int idx1 = sb.toString().lastIndexOf(ph);
                int idx2 = idx1 + ph.length();
                int runIdx1 = 0;
                int runIdx2 = 0;
                int lastSbIndex = -1;
                for (int jj = 0; jj < sbIndex.size(); ++jj) {
                    boolean sameSbIndex;
                    boolean bl = sameSbIndex = (Integer)sbIndex.get(jj) == lastSbIndex;
                    if ((Integer)sbIndex.get(jj) <= idx1 && !sameSbIndex) {
                        runIdx1 = jj;
                    }
                    if ((Integer)sbIndex.get(jj) < idx2 && !sameSbIndex) {
                        runIdx2 = jj;
                    }
                    lastSbIndex = (Integer)sbIndex.get(jj);
                }
                XWPFRun run1 = (XWPFRun)runs.get(runIdx1);
                String run1Text = run1.getText(0);
                int run1TextIndex = idx1 - (Integer)sbIndex.get(runIdx1);
                run1.setText(run1Text.substring(0, run1TextIndex) + ph, 0);
                String run1TextAfter = run1.getText(0);
                for (int jj = runIdx1 + 1; jj < runIdx2; ++jj) {
                    ((XWPFRun)runs.get(jj)).setText("", 0);
                }
                if (runIdx2 <= runIdx1) continue;
                XWPFRun run2 = (XWPFRun)runs.get(runIdx2);
                String run2Text = run2.getText(0);
                String run2TextSub = run2Text.substring(idx2 - (Integer)sbIndex.get(runIdx2));
                run2.setText(run2TextSub, 0);
            }
            for (XWPFRun run : para.getRuns()) {
                String replaceText;
                String t = run.getText(0);
                if ("#!#liste1#!#".equalsIgnoreCase(t)) {
                    this.currentPara = para;
                    run.setText("", 0);
                }
                if ((replaceText = this.applyPlaceholder(t)) != null) {
                    String[] lines = replaceText.split("\n");
                    run.setText(lines[0], 0);
                    for (int i = 1; i < lines.length; ++i) {
                        run.addBreak();
                        run.setText(lines[i]);
                    }
                    continue;
                }
                run.setText(null, 0);
            }
        }
        for (XWPFTable table : this.document.getTables()) {
            for (XWPFTableRow rw : table.getRows()) {
                for (XWPFTableCell cell : rw.getTableCells()) {
                    String stringIndex = cell.getText();
                }
            }
        }
        int headinglevel = 0;
        List groups1 = this.project.getTemplateManger().getLocationGroups();
        for (DataRecord group1 : groups1) {
            CmsLocationgroup grp = (CmsLocationgroup)this.project.loadElement(group1.getLong("meta_id").longValue(), this.project.getUser());
            if (grp.hasAttributeValue("chapter")) {
                XWPFParagraph pp = this.addParagraph(grp.getAttributeValue("title"), "berschrift1");
                headinglevel = 1;
            }
            this.addLocationsForGroup(group1.getLong("meta_id"), filter, headinglevel, reporttype, onlyDefects);
            List groups2 = this.project.getTemplateManger().getLocationGroups(group1.getLong("meta_id").longValue());
            HashMap<Long, CmsLocationgroup> groupsWithChapter = new HashMap<Long, CmsLocationgroup>();
            ArrayList<Long> groupsWithoutChapter = new ArrayList<Long>();
            for (DataRecord group2 : groups2) {
                grp = (CmsLocationgroup)this.project.loadElement(group2.getLong("meta_id").longValue(), this.project.getUser());
                long id = group2.getLong("meta_id");
                if (grp.hasAttributeValue("chapter")) {
                    groupsWithChapter.put(id, grp);
                    continue;
                }
                groupsWithoutChapter.add(id);
            }
            this.addLocationsForGroup(groupsWithoutChapter, filter, 1, reporttype, onlyDefects);
            ArrayList grps = new ArrayList(groupsWithChapter.entrySet());
            grps.sort(new Comparator<Map.Entry<Long, CmsLocationgroup>>(){

                @Override
                public int compare(Map.Entry<Long, CmsLocationgroup> o1, Map.Entry<Long, CmsLocationgroup> o2) {
                    CmsLocationgroup group1 = o1.getValue();
                    CmsLocationgroup group2 = o2.getValue();
                    String chapter1 = group1.getAttributeValue("chapter");
                    String chapter2 = group2.getAttributeValue("chapter");
                    return chapter1.compareTo(chapter2);
                }
            });
            for (Map.Entry grpEntry : grps) {
                grp = (CmsLocationgroup)grpEntry.getValue();
                XWPFParagraph pp = this.addParagraph(grp.getAttributeValue("title"), "berschrift2");
                this.addLocationsForGroup((Long)grpEntry.getKey(), filter, 2, reporttype, onlyDefects);
            }
        }
        if (this.currentPara != null) {
            this.currentPara.removeRun(0);
        }
        this.writeToFile(destinationFile);
        filter.clearAll();
        filter.setTriggerEnabled(true);
    }

    private int addLocationsForGroup(long idgroup, ThemisFilter filter, int headinglevel, int reporttype, boolean onlyDefects) {
        ArrayList<Long> groupids = new ArrayList<Long>();
        groupids.add(idgroup);
        return this.addLocationsForGroup(groupids, filter, headinglevel, reporttype, onlyDefects);
    }

    private int addLocationsForGroup(List<Long> groupids, ThemisFilter filter, int headinglevel, int reporttype, boolean onlyDefects) {
        String sort = "ele.number";
        ArrayList<DefectParagraph> defects = new ArrayList<DefectParagraph>();
        for (Long idgroup : groupids) {
            filter.getLocGroupId().setItem(idgroup.longValue(), (Object)this);
            List recs = filter.getFilteredLocations(sort, null, true);
            for (Object rec : recs) {
                if (rec == null) continue;
                CmsLocation loc = (CmsLocation)this.project.loadElement(rec.getLong("meta_id").longValue(), this.project.getUser());
                boolean separateLocParagraph = false;
                if (loc.isBuilding()) continue;
                String formatvorlage = "berschrift" + (headinglevel + 1);
                if (headinglevel == 1) {
                    formatvorlage = "berschrift2dnn";
                }
                StringBuilder locationDetails = new StringBuilder();
                boolean isMangel = false;
                if ("m".equalsIgnoreCase(loc.getAttributeValue(CmsLocation.TEXT2))) {
                    locationDetails.append(loc.getRelationAttribute("plan").isEmpty() ? "keine Angabe" : loc.getRelationAttribute("plan").getFirstElementTitle());
                    locationDetails.append(loc.hasAttributeValue(CmsLocation.TEXT1) ? ", " + loc.getText1() : "");
                    isMangel = true;
                } else if ("a".equalsIgnoreCase(loc.getAttributeValue(CmsLocation.TEXT2))) {
                    XWPFParagraph pp = this.addParagraph(loc.getAttributeValue("description"), formatvorlage);
                    separateLocParagraph = true;
                }
                if (separateLocParagraph) {
                    formatvorlage = "berschrift" + (headinglevel + 2);
                }
                List observations = loc.getRelationAttribute("observations").getElements();
                for (CmsElementSummary observation : observations) {
                    CmsObservation obs = (CmsObservation)observation.getElement();
                    if (obs.isTrash()) continue;
                    StringBuilder content = new StringBuilder();
                    int locNum = Integer.parseInt(loc.getAttributeValue("number"));
                    String obsFullNumber = " [#" + locNum + "." + obs.getAttributeValue("number") + "]";
                    if (obs.isOfType(1) || obs.isOfType(4)) {
                        if (obs.isDone()) {
                            if (reporttype == 0) {
                                content.append("erledigt");
                                if (isMangel) {
                                    content.append(obsFullNumber);
                                }
                            } else {
                                content.append(locationDetails.toString()).append(locationDetails.length() > 0 ? "\n" : "").append(obs.getAttributeValue("description"));
                                if (isMangel) {
                                    content.append(obsFullNumber);
                                }
                                content.append("\t").append("erledigt");
                            }
                        } else {
                            content.append(locationDetails.toString()).append(locationDetails.length() > 0 ? "\n" : "").append(obs.getAttributeValue("description"));
                            if (isMangel) {
                                content.append(obsFullNumber);
                            }
                            content.append("\t").append(obs.getAttributeValue("topic"));
                        }
                    } else {
                        content.append(locationDetails.toString()).append(locationDetails.length() > 0 ? "\n" : "").append(obs.getAttributeValue("description"));
                        if (isMangel) {
                            content.append(obsFullNumber);
                        }
                        content.append("\t");
                    }
                    if (isMangel) {
                        boolean show = true;
                        if (onlyDefects && !obs.isOfType(1)) {
                            show = false;
                        }
                        if (obs.isDone() && !obs.isOfType(1)) continue;
                        defects.add(new DefectParagraph(content.toString(), formatvorlage, show, obs, locNum));
                        continue;
                    }
                    XWPFParagraph xWPFParagraph = this.addParagraph(content.toString(), formatvorlage);
                }
            }
        }
        defects.sort(new Comparator<DefectParagraph>(){

            @Override
            public int compare(DefectParagraph o1, DefectParagraph o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                String mn1 = o1.getMangelnummer();
                String mn2 = o2.getMangelnummer();
                if (mn1 != null && !mn1.isEmpty() && mn2 != null && !mn2.isEmpty()) {
                    try {
                        int mn1Num = Integer.parseInt(mn1);
                        int mn2Num = Integer.parseInt(mn2);
                        return mn1Num - mn2Num;
                    }
                    catch (Exception e) {
                        return 0;
                    }
                }
                if (mn1 != null && !mn1.isEmpty()) {
                    return -1;
                }
                if (mn2 != null && !mn2.isEmpty()) {
                    return 1;
                }
                if (o1.isDefect() && o2.isDefect()) {
                    return o1.locNum - o2.locNum;
                }
                if (o1.isDefect()) {
                    return -1;
                }
                if (o2.isDefect()) {
                    return 1;
                }
                return o1.locNum - o2.locNum;
            }
        });
        int lastDefect = 0;
        for (DefectParagraph d : defects) {
            String mn;
            XWPFParagraph pp = this.addParagraph(d.content, d.formatvorlage);
            if (!d.show) {
                for (XWPFRun run : pp.getRuns()) {
                    CTOnOff onoffnull = CTOnOff.Factory.newInstance();
                    run.getCTR().addNewRPr().setVanish(onoffnull);
                }
                CTOnOff onoffnull = CTOnOff.Factory.newInstance();
                pp.getCTP().getPPr().addNewRPr().setVanish(onoffnull);
            }
            if ((mn = d.getMangelnummer()) != null && !mn.isEmpty()) {
                try {
                    int mnNum = Integer.parseInt(mn);
                    if (mnNum <= lastDefect) continue;
                    lastDefect = mnNum;
                }
                catch (Exception exception) {}
                continue;
            }
            if (!d.isDefect()) continue;
            d.setMangelnummer(++lastDefect);
        }
        return 0;
    }

    public XWPFParagraph addParagraph(String text, String format) {
        XWPFParagraph newP;
        if (this.currentPara == null) {
            newP = this.document.createParagraph();
        } else {
            XmlCursor cursor = this.currentPara.getCTP().newCursor();
            newP = this.document.insertNewParagraph(cursor);
        }
        if (format != null) {
            newP.setStyle(format);
        }
        this.setParagraphContent(newP, text);
        return newP;
    }

    public void setParagraphContent(XWPFParagraph p, String text) {
        if (text != null) {
            String[] tabs = text.split("\t");
            if (tabs.length > 0) {
                this.addParagraphLines(p, tabs[0]);
                for (int ii = 1; ii < tabs.length; ++ii) {
                    p.createRun().addTab();
                    this.addParagraphLines(p, tabs[ii]);
                }
            } else {
                this.addParagraphLines(p, text);
            }
        }
    }

    private void addParagraphLines(XWPFParagraph p, String text) {
        if (text != null) {
            String[] lines = text.split("\n");
            this.addRunWithOptionalBackground(p, lines[0]);
            for (int ii = 1; ii < lines.length; ++ii) {
                p.createRun().addBreak();
                this.addRunWithOptionalBackground(p, lines[ii]);
            }
        }
    }

    public void addRunWithOptionalBackground(XWPFParagraph p, String text) {
        if (text == null) {
            return;
        }
        String[] runs = text.split("###");
        boolean yellow = false;
        for (String r : runs) {
            if (yellow) {
                this.addRun(p, r, "FFFF00");
            } else {
                this.addRun(p, r);
            }
            yellow = !yellow;
        }
    }

    public XWPFRun addRun(XWPFParagraph p, String text) {
        return this.addRun(p, text, null);
    }

    public XWPFRun addRun(XWPFParagraph p, String txt, String color) {
        XWPFRun run = p.createRun();
        run.setText(txt);
        if (color != null) {
            CTShd cTShd = run.getCTR().addNewRPr().addNewShd();
            cTShd.setVal(STShd.CLEAR);
            cTShd.setColor((Object)"auto");
            cTShd.setFill((Object)color);
        }
        return run;
    }

    public void writeToFile(File f) throws FileNotFoundException, IOException {
        FileOutputStream out = new FileOutputStream(f);
        this.document.write((OutputStream)out);
        out.close();
    }

    public ArrayList<String> getPlaceholders(String text) {
        ArrayList<String> result = new ArrayList<String>();
        if (text != null) {
            int firstIndex = text.indexOf("#!#");
            int lastIndex = text.indexOf("#!#", firstIndex + 1);
            while (firstIndex >= 0 && lastIndex > firstIndex) {
                result.add(text.substring(firstIndex + 3, lastIndex));
                firstIndex = text.indexOf("#!#", lastIndex + 1);
                lastIndex = text.indexOf("#!#", firstIndex + 1);
            }
        }
        return result;
    }

    public String applyPlaceholder(String text) {
        ArrayList<String> placeholders = this.getPlaceholders(text);
        for (String ph : placeholders) {
            text = text.replaceAll("#!#" + ph + "#!#", placeholder.getPlaceholderContent(ph));
        }
        return text;
    }

    private class DefectParagraph {
        String content;
        String formatvorlage;
        boolean show;
        CmsObservation obs;
        int locNum;

        public DefectParagraph(String content, String formatvorlage, boolean show, CmsObservation obs, int locNum) {
            this.content = content;
            this.formatvorlage = formatvorlage;
            this.show = show;
            this.obs = obs;
            this.locNum = locNum;
        }

        public Date lastEdit() {
            DateAttribute att;
            if (this.obs != null && (att = this.obs.getDateAttribute("meta_lastedit")) != null) {
                return att.getDate();
            }
            return null;
        }

        public boolean isDefect() {
            if (this.obs != null) {
                return this.obs.isOfType(1);
            }
            return false;
        }

        public String getMangelnummer() {
            if (this.obs != null) {
                return this.obs.getAttributeValue("freetext3", null);
            }
            return null;
        }

        public void setMangelnummer(int mangelnummer) {
            if (this.obs != null) {
                this.obs.setAttributeValue("freetext3", Util.expandString((String)Integer.toString(mangelnummer), (String)"0", (int)3, (boolean)true));
                this.obs.save();
            }
        }
    }
}

