/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.special.oking;

import at.grid.cms.storage.DataRecord;
import at.grid.gui.Dialogs;
import at.grid.themis.application.THEMIS;
import at.grid.themis.application.action.ThemisActionProvider;
import at.grid.themis.application.api.ThemisFileDialog;
import at.grid.themis.application.api.ThemisProgressHandler;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.action.ThemisAction;
import at.grid.themis.ontology.action.ThemisActionListener;
import at.grid.themis.ontology.element.CmsReport;
import at.grid.themis.ontology.filter.ThemisFilter;
import at.grid.themis.ontology.filter.ThemisFilterBoolean;
import at.grid.themis.ontology.report.ReportTableLayout;
import at.grid.themis.special.oking.OkIngPdfReport;
import at.grid.util.ProgressHandler;
import at.grid.util.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.SoftBevelBorder;
import org.jdom.Element;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressRunnable;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class OkIngPanel
extends JPanel
implements ThemisActionListener {
    ThemisApplication app = ThemisApplication.getInstance();
    ThemisProject project = this.app.getProject();
    File exportFile = null;
    private JButton btnCreate;
    private JButton btnRefresh;
    private JButton btnSelectFolder;
    private JTextField fldDocMissing;
    private JTextField fldDocRequired;
    private JTextField fldFilename;
    private JTextField fldFolder;
    private JComboBox<ReportTableLayout> fldLayout;
    private JTextField fldLocRef;
    private JTextField fldLocTotal;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;

    public OkIngPanel() {
        this.initComponents();
        this.enableDialog();
        if (this.project.isOpen()) {
            this.populateTableLayouts();
            this.analyseProject();
            this.populateFilename();
        }
        ThemisActionProvider.getInstance().register((ThemisActionListener)this);
    }

    public void onAction(ThemisAction action) {
        switch (action.getAction()) {
            case 1100: {
                this.populateTableLayouts();
                this.analyseProject();
                this.populateFilename();
                this.enableDialog();
                break;
            }
            case 1101: {
                this.enableDialog();
            }
        }
    }

    private void enableDialog() {
        boolean isProject = this.project.isOpen();
        if (!isProject) {
            this.fldDocMissing.setText("");
            this.fldDocRequired.setText("");
            this.fldFilename.setText("");
            this.fldFolder.setText("");
            this.fldLocRef.setText("");
            this.fldLocTotal.setText("");
            this.fldLayout.removeAllItems();
        }
        this.btnCreate.setEnabled(isProject);
        this.btnRefresh.setEnabled(isProject);
        this.btnSelectFolder.setEnabled(isProject);
    }

    private void populateFilename() {
        String fn = this.project.getProperty("oking_exportfile", null);
        if (fn != null) {
            this.exportFile = new File(fn);
            this.fldFolder.setText(this.exportFile.getParentFile().getAbsolutePath());
            this.fldFilename.setText(this.exportFile.getName());
        }
    }

    private void populateTableLayouts() {
        String layoutName = this.project.getProperty("oking_tablelayout", "ok-ing_bauabnahme");
        this.fldLayout.removeAllItems();
        ReportTableLayout sel = null;
        CmsReport rep = new CmsReport();
        Element xml = this.app.getSettings().getXmlElement("/themis/project/custom/oking/reportspec", true);
        rep.setReportFromXml(xml);
        for (ReportTableLayout tl : this.project.getReportTableLayouts()) {
            this.fldLayout.addItem(tl);
            if (layoutName == null || !layoutName.equals(tl.getName())) continue;
            sel = tl;
        }
        if (sel != null) {
            this.fldLayout.setSelectedItem(sel);
        } else if (this.fldLayout.getItemCount() > 0) {
            this.fldLayout.setSelectedIndex(0);
        }
    }

    private void analyseProject() {
        ThemisFilter filter = this.app.getFilter().getCopy();
        filter.setTriggerEnabled(false);
        String sort = "locationgroupsort,ele.titel,ele.number,observation.number,observation.idelement";
        filter.getLocFlag1().setValue(ThemisFilterBoolean.ThemisFilterBooleanValue.YES, null);
        ArrayList locIds = filter.getFilteredLocationIds(sort, null, true);
        ArrayList obsIds = filter.getFilteredObservationIds(sort, null);
        int locTotal = this.project.getLocationCount();
        int locRef = locIds.size();
        this.fldLocTotal.setText(Integer.toString(locTotal));
        this.fldLocRef.setText(Integer.toString(locRef));
        String ids = Util.toSqlString((Iterable)obsIds);
        String sql = "SELECT count(o.idelement) AS count FROM tdtaEleObservation AS o WHERE o.idelement IN " + ids + " AND idobservationtype != 4";
        DataRecord rec = this.project.getDatastorage().executeQuery(sql, true).firstRow();
        this.fldDocRequired.setText(Integer.toString(obsIds.size()));
        if (rec != null) {
            this.fldDocMissing.setText(rec.get("count"));
        }
    }

    private void createSpecialReport() {
        if (this.exportFile == null) {
            Dialogs.showErrorDialog((String)"Es muss zuerst die Export-Datei definiert werden.");
            return;
        }
        if (this.fldLayout.getSelectedItem() == null) {
            Dialogs.showErrorDialog((String)"Es muss zuerst ein Layout f\u00fcr den Inhalt erstellt und ausgew\u00e4hlt werden.");
            return;
        }
        final String layoutName = ((ReportTableLayout)this.fldLayout.getSelectedItem()).getName();
        this.project.setProjectProperty("oking_tablelayout", layoutName);
        this.project.setProjectProperty("oking_exportfile", this.exportFile.getAbsolutePath());
        this.exportFile = new File(this.exportFile.getParentFile(), this.fldFilename.getText());
        String progressTitle = "Spezialausgabe wird erstellt";
        BaseProgressUtils.showProgressDialogAndRun((ProgressRunnable)new ProgressRunnable<String>(){

            public String run(ProgressHandle ph) {
                ThemisProgressHandler tph = new ThemisProgressHandler(ph);
                tph.switchToDeterminate(7);
                tph.setDisplayName("Spezialausgabe wird erstellt");
                CmsReport rep = new CmsReport();
                ReportTableLayout rtl = (ReportTableLayout)OkIngPanel.this.fldLayout.getSelectedItem();
                rtl.save();
                OkIngPdfReport pdf = new OkIngPdfReport(rep);
                pdf.setLayoutName(layoutName);
                pdf.exportToPdf(OkIngPanel.this.exportFile, rep, OkIngPanel.this.project.getUser(), (ProgressHandler)tph, 0, 6);
                tph.done();
                THEMIS.showFileResultDialog((File)OkIngPanel.this.exportFile);
                return null;
            }
        }, (String)progressTitle, (boolean)true);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.fldLocTotal = new JTextField();
        this.fldLocRef = new JTextField();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jLabel9 = new JLabel();
        this.fldDocRequired = new JTextField();
        this.fldDocMissing = new JTextField();
        this.btnRefresh = new JButton();
        this.jLabel4 = new JLabel();
        this.fldLayout = new JComboBox();
        this.jLabel13 = new JLabel();
        this.jLabel2 = new JLabel();
        this.fldFolder = new JTextField();
        this.jLabel3 = new JLabel();
        this.fldFilename = new JTextField();
        this.btnSelectFolder = new JButton();
        this.jLabel14 = new JLabel();
        this.btnCreate = new JButton();
        this.setLayout(new GridBagLayout());
        this.jLabel1.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(OkIngPanel.class, (String)"OkIngPanel.jLabel1.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel5.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(OkIngPanel.class, (String)"OkIngPanel.jLabel5.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel6.setFont(THEMIS.fontLabel);
        this.jLabel6.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(OkIngPanel.class, (String)"OkIngPanel.jLabel6.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.jPanel1.add((Component)this.jLabel6, gridBagConstraints);
        this.jLabel7.setFont(THEMIS.fontLabel);
        this.jLabel7.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(OkIngPanel.class, (String)"OkIngPanel.jLabel7.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.jPanel1.add((Component)this.jLabel7, gridBagConstraints);
        this.jLabel8.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel8, (String)NbBundle.getMessage(OkIngPanel.class, (String)"OkIngPanel.jLabel8.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.jLabel8, gridBagConstraints);
        this.fldLocTotal.setFont(THEMIS.fontTextfield);
        this.fldLocTotal.setHorizontalAlignment(0);
        this.fldLocTotal.setText(NbBundle.getMessage(OkIngPanel.class, (String)"OkIngPanel.fldLocTotal.text"));
        this.fldLocTotal.setMinimumSize(new Dimension(50, 30));
        this.fldLocTotal.setPreferredSize(new Dimension(50, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.fldLocTotal, gridBagConstraints);
        this.fldLocRef.setFont(THEMIS.fontTextfield);
        this.fldLocRef.setHorizontalAlignment(0);
        this.fldLocRef.setText(NbBundle.getMessage(OkIngPanel.class, (String)"OkIngPanel.fldLocRef.text"));
        this.fldLocRef.setMinimumSize(new Dimension(50, 30));
        this.fldLocRef.setPreferredSize(new Dimension(50, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.fldLocRef, gridBagConstraints);
        this.jLabel10.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel10, (String)NbBundle.getMessage(OkIngPanel.class, (String)"OkIngPanel.jLabel10.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.jLabel10, gridBagConstraints);
        this.jLabel11.setFont(THEMIS.fontLabel);
        this.jLabel11.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabel11, (String)NbBundle.getMessage(OkIngPanel.class, (String)"OkIngPanel.jLabel11.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.jPanel1.add((Component)this.jLabel11, gridBagConstraints);
        this.jLabel12.setFont(THEMIS.fontLabel);
        this.jLabel12.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabel12, (String)NbBundle.getMessage(OkIngPanel.class, (String)"OkIngPanel.jLabel12.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.jPanel1.add((Component)this.jLabel12, gridBagConstraints);
        this.jLabel9.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel9, (String)NbBundle.getMessage(OkIngPanel.class, (String)"OkIngPanel.jLabel9.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.jLabel9, gridBagConstraints);
        this.fldDocRequired.setFont(THEMIS.fontTextfield);
        this.fldDocRequired.setHorizontalAlignment(0);
        this.fldDocRequired.setText(NbBundle.getMessage(OkIngPanel.class, (String)"OkIngPanel.fldDocRequired.text"));
        this.fldDocRequired.setMinimumSize(new Dimension(50, 30));
        this.fldDocRequired.setPreferredSize(new Dimension(50, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.fldDocRequired, gridBagConstraints);
        this.fldDocMissing.setFont(THEMIS.fontTextfield);
        this.fldDocMissing.setHorizontalAlignment(0);
        this.fldDocMissing.setText(NbBundle.getMessage(OkIngPanel.class, (String)"OkIngPanel.fldDocMissing.text"));
        this.fldDocMissing.setMinimumSize(new Dimension(50, 30));
        this.fldDocMissing.setPreferredSize(new Dimension(50, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.fldDocMissing, gridBagConstraints);
        this.btnRefresh.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnRefresh, (String)NbBundle.getMessage(OkIngPanel.class, (String)"OkIngPanel.btnRefresh.text"));
        this.btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OkIngPanel.this.btnRefreshActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.btnRefresh, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jLabel4.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(OkIngPanel.class, (String)"OkIngPanel.jLabel4.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.fldLayout.setFont(THEMIS.fontList);
        this.fldLayout.setModel(new DefaultComboBoxModel());
        this.fldLayout.setMinimumSize(new Dimension(100, 30));
        this.fldLayout.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add(this.fldLayout, gridBagConstraints);
        this.jLabel13.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel13, (String)NbBundle.getMessage(OkIngPanel.class, (String)"OkIngPanel.jLabel13.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel13, gridBagConstraints);
        this.jLabel2.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(OkIngPanel.class, (String)"OkIngPanel.jLabel2.text"));
        this.jLabel2.setPreferredSize(new Dimension(60, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.fldFolder.setEditable(false);
        this.fldFolder.setFont(THEMIS.fontTextfield);
        this.fldFolder.setText(NbBundle.getMessage(OkIngPanel.class, (String)"OkIngPanel.fldFolder.text"));
        this.fldFolder.setMinimumSize(new Dimension(100, 30));
        this.fldFolder.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.fldFolder, gridBagConstraints);
        this.jLabel3.setFont(THEMIS.fontLabel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(OkIngPanel.class, (String)"OkIngPanel.jLabel3.text"));
        this.jLabel3.setPreferredSize(new Dimension(60, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.fldFilename.setFont(THEMIS.fontTextfield);
        this.fldFilename.setText(NbBundle.getMessage(OkIngPanel.class, (String)"OkIngPanel.text"));
        this.fldFilename.setMinimumSize(new Dimension(100, 30));
        this.fldFilename.setName("");
        this.fldFilename.setPreferredSize(new Dimension(100, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.fldFilename, gridBagConstraints);
        this.btnSelectFolder.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnSelectFolder, (String)NbBundle.getMessage(OkIngPanel.class, (String)"OkIngPanel.btnSelectFolder.text"));
        this.btnSelectFolder.setBorder(new SoftBevelBorder(0));
        this.btnSelectFolder.setMinimumSize(new Dimension(5, 22));
        this.btnSelectFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OkIngPanel.this.btnSelectFolderActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.btnSelectFolder, gridBagConstraints);
        this.jLabel14.setFont(THEMIS.fontSubheading);
        Mnemonics.setLocalizedText((JLabel)this.jLabel14, (String)NbBundle.getMessage(OkIngPanel.class, (String)"OkIngPanel.jLabel14.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel14, gridBagConstraints);
        this.btnCreate.setFont(THEMIS.fontButton);
        Mnemonics.setLocalizedText((AbstractButton)this.btnCreate, (String)NbBundle.getMessage(OkIngPanel.class, (String)"OkIngPanel.btnCreate.text"));
        this.btnCreate.setMinimumSize(new Dimension(150, 35));
        this.btnCreate.setPreferredSize(new Dimension(150, 35));
        this.btnCreate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OkIngPanel.this.btnCreateActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.btnCreate, gridBagConstraints);
    }

    private void btnCreateActionPerformed(ActionEvent evt) {
        this.createSpecialReport();
    }

    private void btnSelectFolderActionPerformed(ActionEvent evt) {
        File f = new ThemisFileDialog("Datei f\u00fcr Export ausw\u00e4hlen", ThemisFileDialog.DIALOGTYPE.SAVE, this.app.getPathExportFolder(), null, THEMIS.getPdfFilter(), "pdf", false).getSelectedFile();
        if (f != null) {
            this.fldFolder.setText(f.getParentFile().getAbsolutePath());
            this.fldFilename.setText(f.getName());
            this.exportFile = f;
        }
    }

    private void btnRefreshActionPerformed(ActionEvent evt) {
        this.populateTableLayouts();
        this.analyseProject();
    }
}

