/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.special.oking;

import at.grid.cms.attribute.KeyAttribute;
import at.grid.cms.content.Keytable;
import at.grid.cms.content.UploadItem;
import at.grid.cms.element.CmsElementSummary;
import at.grid.cms.element.CmsUser;
import at.grid.gui.Dialogs;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.element.CmsLocation;
import at.grid.themis.ontology.element.CmsLocationgroup;
import at.grid.themis.ontology.element.CmsObservation;
import at.grid.themis.ontology.element.CmsReport;
import at.grid.themis.ontology.filter.ThemisFilter;
import at.grid.themis.ontology.filter.ThemisFilterBoolean;
import at.grid.themis.ontology.report.PdfContentTitlepage;
import at.grid.themis.ontology.report.ReportGenerator;
import at.grid.themis.ontology.report.ReportTableLayout;
import at.grid.themis.ontology.report.pdf.PdfLayoutExporter;
import at.grid.util.ProgressHandler;
import at.grid.util.Util;
import com.lowagie.text.BadElementException;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import com.lowagie.text.pdf.PdfWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.util.Matrix;
import org.jdom.Content;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.util.Exceptions;

public class OkIngPdfReport
extends PdfLayoutExporter {
    File mainExportFile = null;
    Image logoImage = null;
    String layoutName = "ok-inb_bauabnahme";

    public OkIngPdfReport(CmsReport rep) {
        super(rep);
    }

    public void setLayoutName(String name) {
        this.layoutName = name;
    }

    public void exportToPdf0(File f, CmsReport repspec, CmsUser user, ProgressHandle ph, int phFrom, int phTo) {
        this.rep = repspec;
        org.jdom.Element xml = this.app.getSettings().getXmlElement("/themis/project/custom/oking/reportspec", true);
        this.rep.setReportFromXml(xml);
        ReportTableLayout tableLayout = this.project.getReportTableLayout(this.layoutName);
        if (tableLayout == null) {
            Dialogs.showErrorDialog((String)("Es ist kein Tabellenlayout mit dem Namen '" + this.layoutName + "' verf\u00fcgbar"));
            return;
        }
        tableLayout.setGroupNewTable(false);
        org.jdom.Element repAsXml = this.rep.getReportAsXml();
        this.app.getSettings().getXmlElement("/themis/project/custom/oking", true).removeChildren(repAsXml.getName());
        this.app.getSettings().getXmlElement("/themis/project/custom/oking", true).addContent((Content)repAsXml);
        this.rep.exportOnlyLocations = true;
        this.rep.pageFormat.footerRight = "";
        File content = new File(this.project.getTempfileLocation(), "content.pdf");
        if (content.isFile()) {
            content.delete();
        }
        super.exportToPdf(content, this.rep, user, null, phFrom, phTo);
    }

    public void exportToPdf(File f, CmsReport repspec, CmsUser user, ProgressHandler ph, int phFrom, int phTo) {
        File content;
        if (ph != null) {
            ph.progress("Vorbereitung", 1);
        }
        ThemisProject project = ThemisApplication.getInstance().getProject();
        File logofile = project.getProjectElement().getUploadAttribute("projectlogo").getFirstUploadItemFile();
        try {
            if (logofile != null) {
                this.logoImage = Image.getInstance((byte[])Files.readAllBytes(logofile.toPath()));
                if (this.logoImage != null) {
                    float scale = ReportGenerator.cmToPixel((float)4.0f) / this.logoImage.getWidth();
                    this.logoImage.scalePercent(100.0f * scale);
                }
            }
        }
        catch (BadElementException | IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        ArrayList<PDFSection> pdfSections = new ArrayList<PDFSection>();
        HashMap pagePerFile = new HashMap();
        PDFSection section = new PDFSection(-1L, "000title");
        pdfSections.add(section);
        this.mainExportFile = f;
        this.rep = repspec;
        org.jdom.Element xml = this.app.getSettings().getXmlElement("/themis/project/custom/oking/reportspec", true);
        this.rep.setReportFromXml(xml);
        ReportTableLayout tableLayout = project.getReportTableLayout(this.layoutName);
        if (tableLayout == null) {
            Dialogs.showErrorDialog((String)("Es ist kein Tabellenlayout mit dem Namen '" + this.layoutName + "' verf\u00fcgbar"));
            return;
        }
        tableLayout.setGroupNewTable(false);
        org.jdom.Element repAsXml = this.rep.getReportAsXml();
        this.app.getSettings().getXmlElement("/themis/project/custom/oking", true).removeChildren(repAsXml.getName());
        this.app.getSettings().getXmlElement("/themis/project/custom/oking", true).addContent((Content)repAsXml);
        this.rep.exportOnlyLocations = true;
        this.rep.pageFormat.footerRight = "";
        String sort = "locationgroupsort,ele.titel,ele.number,observation.number,observation.idelement";
        if (tableLayout.getSort() != null) {
            sort = tableLayout.getSort().getSql();
        }
        if (this.mainExportFile.isFile()) {
            if (!Dialogs.showConfirmDialog((String)"Die Datei existiert bereits - l\u00f6schen?")) {
                return;
            }
            this.mainExportFile.delete();
        }
        if (this.mainExportFile.isFile()) {
            Dialogs.showErrorDialog((String)"Die Ausgabedatei existiert bereits und kann nicht gel\u00f6scht werden.");
            return;
        }
        if (ph != null) {
            ph.progress("Daten werden erstellt", 2);
        }
        ThemisFilter filter = this.app.getFilter().getCopy();
        filter.setTriggerEnabled(false);
        filter.getLocFlag1().setValue(ThemisFilterBoolean.ThemisFilterBooleanValue.YES, null);
        this.rep.filter = filter;
        ArrayList locIds = filter.getFilteredLocationIds(sort, null, true);
        ArrayList obsIds = filter.getFilteredObservationIds(sort, null);
        PDFSection currentSection = null;
        CmsLocationgroup group = null;
        File blankPageFile = new File(project.getTempfileLocation(), "_blank-page.pdf");
        try {
            this.createBlankPage(blankPageFile);
        }
        catch (DocumentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        int mainchapter = 0;
        int subchapter = 0;
        long lastParentGroup = -1L;
        Iterator iterator = locIds.iterator();
        while (iterator.hasNext()) {
            long locId = (Long)iterator.next();
            CmsLocation cmsLocation = (CmsLocation)project.loadElement(locId, project.getUser());
            CmsElementSummary groupEle = cmsLocation.getRelationAttribute("locationgroup").getFirstElement();
            if (groupEle == null) continue;
            if (group == null || group.getId() != groupEle.getId()) {
                group = (CmsLocationgroup)groupEle.getElement();
                int grouplevel = group.getGroupLevel();
                if (grouplevel == 1) {
                    ++mainchapter;
                    subchapter = 1;
                    lastParentGroup = group.getId();
                } else if (lastParentGroup != group.getParentGroupId()) {
                    ++mainchapter;
                    subchapter = 1;
                    lastParentGroup = group.getParentGroupId();
                } else {
                    ++subchapter;
                }
                group.setAttributeValue("chapter", mainchapter + "." + subchapter);
                group.save();
            }
            currentSection = new PDFSection(groupEle.getId(), groupEle.getTitle());
            currentSection.setLocation(cmsLocation);
            try {
                File sectionPageFile = new File(project.getTempfileLocation(), locId + ".pdf");
                this.createSectionPage(sectionPageFile, group, cmsLocation.getTitle());
                currentSection.addFile(sectionPageFile);
                currentSection.addFile(blankPageFile);
            }
            catch (DocumentException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            project.getLogger().info("checking location ID " + locId + ": " + cmsLocation.getTitle());
            StringBuilder sb1 = new StringBuilder();
            StringBuilder sb2 = new StringBuilder();
            StringBuilder sb3 = new StringBuilder();
            StringBuilder sb4 = new StringBuilder();
            List obsForLocIds = cmsLocation.getRelationAttribute("observations").getElementIds();
            Iterator iterator2 = obsForLocIds.iterator();
            while (iterator2.hasNext()) {
                long obsId = (Long)iterator2.next();
                if (!obsIds.contains(obsId)) continue;
                CmsObservation obs = (CmsObservation)project.loadElement(obsId, project.getUser());
                String obstxt = obs.getAttributeValue("description");
                if (obstxt == null || "".equals(obstxt)) {
                    obstxt = obs.getTitle();
                }
                KeyAttribute cat = obs.getKeyAttribute(this.app.getSettings().getObservationAttribute("list1").getCmsCode());
                Keytable keytable = project.getKeytable(cat.getTableCode());
                int idx = keytable.getIds().indexOf(cat.getId());
                project.getLogger().info("... found content for column " + idx + ": " + obs.getTitle());
                switch (idx) {
                    case 0: {
                        sb1.append(sb1.length() == 0 ? "" : "\n\n").append(obstxt);
                        break;
                    }
                    case 1: {
                        sb2.append(sb2.length() == 0 ? "" : "\n\n").append(obstxt);
                        break;
                    }
                    case 2: {
                        sb3.append(sb3.length() == 0 ? "" : "\n\n").append(obstxt);
                        break;
                    }
                    case 3: {
                        sb4.append(sb4.length() == 0 ? "" : "\n\n").append(obstxt);
                    }
                }
                List infoIds = obs.getRelationAttribute("infos").getElementIds();
                ArrayList items = project.getDatastorage().getUploadItems(Util.toString((Iterable)infoIds, (String)","), "files");
                for (UploadItem item : items) {
                    currentSection.addFile(item.getFile());
                }
            }
            cmsLocation.setAttributeValue(this.app.getSettings().getLocationAttribute("longtext1").getCmsCode(), sb1.toString());
            cmsLocation.setAttributeValue(this.app.getSettings().getLocationAttribute("longtext2").getCmsCode(), sb2.toString());
            cmsLocation.setAttributeValue(this.app.getSettings().getLocationAttribute("longtext3").getCmsCode(), sb3.toString());
            cmsLocation.setAttributeValue(this.app.getSettings().getLocationAttribute("longtext4").getCmsCode(), sb4.toString());
            cmsLocation.save();
            pdfSections.add(currentSection);
        }
        if (ph != null) {
            ph.progress("Inhaltsverzeichnis wird erstmals erstellt", 3);
        }
        if ((content = new File(project.getTempfileLocation(), "content.pdf")).isFile()) {
            content.delete();
        }
        super.exportToPdf(content, this.rep, user, null, phFrom, phTo);
        ((PDFSection)pdfSections.get(0)).addFile(content);
        if (ph != null) {
            ph.progress("Seitenzahlen werden ermittelt", 4);
        }
        int currentPageNumber = 1;
        for (PDFSection pDFSection : pdfSections) {
            boolean evenPageCorrection = false;
            if (currentPageNumber % 2 == 0) {
                pDFSection.addFileAtBeginning(blankPageFile);
                ++currentPageNumber;
                evenPageCorrection = true;
            }
            pDFSection.updatePageNumber(currentPageNumber);
            for (File file : pDFSection.getFiles()) {
                try {
                    PDDocument d = PDDocument.load((File)file);
                    PDDocumentInformation info = d.getDocumentInformation();
                    int numberOfPages = d.getNumberOfPages();
                    currentPageNumber += numberOfPages;
                    d.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            if (!evenPageCorrection) continue;
            --currentPageNumber;
        }
        if (ph != null) {
            ph.progress("Inhaltsverzeichnis wird final erstellt", 5);
        }
        content.delete();
        this.rep.pageFormat.footerRight = "";
        super.exportToPdf(content, this.rep, user, null, phFrom, phTo);
        if (ph != null) {
            ph.progress("PDF wird zusammengef\u00fcgt", 6);
        }
        ArrayList<File> files = new ArrayList<File>();
        for (PDFSection sec : pdfSections) {
            files.addAll(sec.getFiles());
        }
        try {
            this.mainExportFile.delete();
            this.mergeDocuments(files, this.mainExportFile);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void createContent(CmsUser user) throws DocumentException {
        if (this.progress != null) {
            this.progress.setDisplayName("PDF wird erzeugt");
        }
        this.progressCurrent = this.progressFrom;
        this.createTitlepage(new PdfContentTitlepage());
        this.document.newPage();
        this.document.add((Element)this.createParagraph("Inhalt", this.formatHeading1));
        this.createTable(this.layoutName);
    }

    private void createSectionPage(File f, CmsLocationgroup group, String locTitle) throws DocumentException, FileNotFoundException, IOException {
        if (f.exists()) {
            f.delete();
        }
        Document doc = new Document(this.getPageSize());
        PdfWriter writer = PdfWriter.getInstance((Document)doc, (OutputStream)new FileOutputStream(f));
        doc.setMargins(ReportGenerator.cmToPixel((float)6.0f), ReportGenerator.cmToPixel((float)this.rep.pageFormat.borderRight), ReportGenerator.cmToPixel((float)10.0f), ReportGenerator.cmToPixel((float)this.rep.pageFormat.borderBottom));
        doc.open();
        if (group != null) {
            doc.add((Element)this.createParagraph(group.getAttributeValue("groupfullname"), this.formatTitle));
        }
        if (locTitle != null) {
            doc.add((Element)this.createParagraph(locTitle, this.formatTitle));
        }
        if (group == null && locTitle == null) {
            doc.add((Element)this.createParagraph(" ", this.formatText));
        }
        if (this.logoImage != null) {
            float logoX = this.getPageSize().getWidth() / 2.0f - this.logoImage.getScaledWidth() / 2.0f;
            float logoY = this.getPageSize().getHeight() - ReportGenerator.cmToPixel((float)2.0f) - this.logoImage.getScaledHeight();
            this.logoImage.setAbsolutePosition(logoX, logoY);
            writer.getDirectContent().addImage(this.logoImage, true);
        }
        doc.close();
    }

    private void createBlankPage(File f) throws DocumentException, FileNotFoundException, IOException {
        this.createSectionPage(f, null, null);
    }

    private void mergeDocuments(ArrayList<File> files, File outFile) throws IOException {
        File mergeFile = new File(this.project.getTempfileLocation(), outFile.getName());
        try {
            PDFMergerUtility ut = new PDFMergerUtility();
            for (File f : files) {
                ut.addSource(f);
            }
            ut.setDestinationFileName(mergeFile.getAbsolutePath());
            ut.mergeDocuments(MemoryUsageSetting.setupMainMemoryOnly());
        }
        catch (Exception ut) {
            // empty catch block
        }
        PDDocument doc = PDDocument.load((File)mergeFile);
        Object object = null;
        try {
            PDType1Font font = PDType1Font.HELVETICA_BOLD;
            float fontSize = 28.0f;
            int pagenumber = 1;
            for (PDPage page : doc.getPages()) {
                PDRectangle pageSize = page.getMediaBox();
                float pageWidth = pageSize.getWidth();
                float stringWidth = font.getStringWidth(Integer.toString(pagenumber)) * fontSize / 1000.0f;
                float posX = pageWidth - stringWidth - 50.0f;
                float posY = 20.0f;
                try (PDPageContentStream contentStream = new PDPageContentStream(doc, page, PDPageContentStream.AppendMode.APPEND, true, true);){
                    contentStream.beginText();
                    contentStream.setFont((PDFont)font, fontSize);
                    contentStream.setNonStrokingColor(255, 0, 0);
                    contentStream.setTextMatrix(Matrix.getTranslateInstance((float)posX, (float)posY));
                    contentStream.showText(Integer.toString(pagenumber));
                    contentStream.endText();
                }
                ++pagenumber;
            }
            doc.save(outFile);
            doc.close();
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (doc != null) {
                if (object != null) {
                    try {
                        doc.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    doc.close();
                }
            }
        }
    }

    class PDFSection {
        long idGroup = -1L;
        String title;
        ArrayList<File> files = new ArrayList();
        CmsLocation loc = null;
        int pageNumber = 0;

        public PDFSection(long id, String t) {
            this.title = t;
            this.idGroup = id;
        }

        public void updatePageNumber(int n) {
            this.pageNumber = n;
            if (this.loc != null) {
                this.loc.reload();
                this.loc.setAttributeValue("text4", Integer.toString(n));
                this.loc.save();
            }
        }

        public long getGroupId() {
            return this.idGroup;
        }

        public void setLocation(CmsLocation l) {
            this.loc = l;
        }

        public CmsLocation getLocation() {
            return this.loc;
        }

        public void cleareFiles() {
            this.files.clear();
        }

        public void addFile(File f) {
            this.files.add(f);
        }

        public void addFileAtBeginning(File f) {
            this.files.add(0, f);
        }

        public ArrayList<File> getFiles() {
            return this.files;
        }
    }
}

