/*
 * Decompiled with CFR 0.152.
 */
package at.grid.themis.special.securitas;

import at.grid.cms.element.CmsUser;
import at.grid.cms.storage.DataRecord;
import at.grid.themis.ontology.ThemisApplication;
import at.grid.themis.ontology.ThemisProject;
import at.grid.themis.ontology.element.CmsEvent;
import at.grid.themis.ontology.element.CmsReport;
import at.grid.themis.ontology.filter.ThemisFilter;
import at.grid.themis.ontology.report.ReportPageSetup;
import at.grid.themis.ontology.report.pdf.PdfExportBase;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import com.lowagie.text.pdf.PdfPCell;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;

public class PdfControlTableExporter
extends PdfExportBase {
    ArrayList<DataRecord> records = new ArrayList();
    boolean withTitlePage;
    int year;
    String col1 = "g.title";
    String col2 = "b.title";
    String groupAttribute = null;
    String groupText = null;
    boolean groupPagebreak = false;

    public PdfControlTableExporter(CmsReport rep) {
        this(rep, true, -1);
    }

    public PdfControlTableExporter(CmsReport rep, boolean withTitlePage, int year) {
        super(rep);
        this.withTitlePage = withTitlePage;
        this.year = year;
        this.rep.pageFormat = new ReportPageSetup();
        this.rep.pageFormat.orientation = ReportPageSetup.PageOrientation.LANDSCAPE;
        try {
            Image img;
            File logofile = this.project.getProjectElement().getUploadAttribute("projectlogo").getFirstUploadItemFile();
            if (logofile != null && (img = Image.getInstance((byte[])Files.readAllBytes(logofile.toPath()))) != null) {
                float height = img.getHeight();
                float heightCm = 2.54f * height / 72.0f;
                float scale = 1.5f / heightCm;
                this.rep.pageFormat.logoWidth = 2.54f * (img.getWidth() * scale) / 72.0f;
                this.getPageEvent().initialise(rep);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setCol1(String col1) {
        this.col1 = col1;
    }

    public void setCol2(String col2) {
        this.col2 = col2;
    }

    public void setGroup(String att, String txt) {
        this.groupAttribute = att;
        this.groupText = txt;
    }

    public void setGroupPagebreak(boolean flg) {
        this.groupPagebreak = flg;
    }

    public ArrayList<Long> getObservationList() {
        ArrayList<Long> result = new ArrayList<Long>();
        for (DataRecord rec : this.records) {
            result.add(rec.getLong("meta_id"));
        }
        return result;
    }

    public void createContent(CmsUser user) throws DocumentException {
        try {
            ThemisFilter filter = new ThemisFilter(ThemisApplication.getInstance());
            filter.setTriggerEnabled(false);
            filter.setControlFilter();
            this.records.addAll(filter.getFilteredObservations(null, null, false));
            ArrayList eventIds = this.project.getEventSearchResult(this.year).getResultIds();
            ArrayList<CmsEvent> events = new ArrayList<CmsEvent>();
            Iterator iterator = eventIds.iterator();
            while (iterator.hasNext()) {
                long id = (Long)iterator.next();
                events.add((CmsEvent)this.project.loadElement(id, this.project.getUser()));
            }
            int countTotal = this.records.size();
            this.progressStep = (this.progressTo - this.progressFrom) / (double)countTotal;
            this.progressCurrent = this.progressFrom;
            this.document.add((Element)this.createParagraph(" ", this.formatText));
            this.document.add((Element)this.createParagraph(" ", this.formatText));
            if (this.withTitlePage) {
                this.createTitlePage();
            } else {
                this.createTitle();
            }
            HashMap<Long, int[]> tbl = new HashMap<Long, int[]>();
            for (DataRecord rec : this.records) {
                int[] monthcount = new int[12];
                for (CmsEvent ev : events) {
                    int month;
                    ArrayList observationIds = ev.getObservationIds();
                    if (!observationIds.contains(rec.getLong("observationid"))) continue;
                    Date dt = ev.getDateAttribute("date").getDate();
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(dt);
                    int n = month = cal.get(2);
                    monthcount[n] = monthcount[n] + 1;
                }
                tbl.put(rec.getLong("observationid"), monthcount);
            }
            this.createAnnualControlTable(this.project, user, this.records, tbl);
            if (this.rep.hasSignature()) {
                this.document.add((Element)this.createParagraph(" ", this.formatText));
                this.createSignature();
            }
        }
        catch (Exception ex) {
            this.app.getDialog().showErrorDialog("error.report-pdf-generation", ex);
            ex.printStackTrace();
        }
    }

    private void createAnnualControlTable(ThemisProject project, CmsUser user, ArrayList<DataRecord> recs, HashMap<Long, int[]> tbl) throws DocumentException, IOException {
        int[] widths = new int[]{10, 10, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        int totalWidthObs = 0;
        for (int w : widths) {
            totalWidthObs += w;
        }
        String lastGroupValue = null;
        String currentGroupValue = null;
        Color headerColor = new Color(225, 225, 225);
        ArrayList<PdfPCell> headerCells = new ArrayList<PdfPCell>();
        headerCells.add(this.createPdfCell("Thema", this.formatTableHeader, 1.0f, 0, 2, headerColor, 5.0f));
        headerCells.add(this.createPdfCell("Kontrolle", this.formatTableHeader, 1.0f, 0, 2, headerColor, 5.0f));
        headerCells.add(this.createPdfCell("Intervall", this.formatTableHeader, 1.0f, 1, 2, headerColor, 5.0f));
        for (int ii = 1; ii <= 12; ++ii) {
            headerCells.add(this.createPdfCell(Integer.toString(ii), this.formatTableHeader, 1.0f, 1, 2, headerColor, 5.0f));
        }
        float pageWidth = this.getPageWidth();
        float[] colWidthCm = new float[widths.length];
        for (int i = 0; i < widths.length; ++i) {
            colWidthCm[i] = pageWidth * (float)widths[i] / (float)totalWidthObs;
        }
        Object colPixelsLoc = null;
        this.createTable(colWidthCm, 1);
        this.addHeader(headerCells, this.table);
        boolean firstRecord = true;
        boolean newGroup = true;
        for (DataRecord rec : recs) {
            this.progressCurrent += this.progressStep;
            if (this.progress != null) {
                this.progress.progress((int)this.progressCurrent);
            }
            if (this.groupAttribute != null) {
                currentGroupValue = this.ph.getPlaceholderContent(this.groupAttribute, rec);
                if (currentGroupValue != null && !currentGroupValue.equals(lastGroupValue) && !firstRecord) {
                    if (this.groupPagebreak) {
                        this.document.add((Element)this.table);
                        this.addPagebreak();
                        this.createTable(colWidthCm, 1);
                        this.addHeader(headerCells, this.table);
                    }
                    lastGroupValue = currentGroupValue;
                    newGroup = true;
                }
                firstRecord = false;
            }
            if (newGroup && currentGroupValue != null) {
                PdfPCell cell = this.createPdfCell(this.ph.apply(this.groupText, rec), this.formatTableHeading, 1.0f, 0, 2, new Color(245, 245, 245), 5.0f);
                cell.setColspan(15);
                this.table.addCell(cell);
            }
            newGroup = false;
            this.table.addCell(this.createPdfCell(this.ph.getPlaceholderContent(this.col1, rec), this.formatTable, 1.0f, 0, 2, Color.WHITE, 5.0f));
            this.table.addCell(this.createPdfCell(this.ph.getPlaceholderContent(this.col2, rec), this.formatTableSmall, 1.0f, 0, 2, Color.WHITE, 5.0f));
            String interval = "";
            Integer idrepeat = rec.getInt("idrepeat");
            if (idrepeat != null) {
                switch (idrepeat) {
                    case 1: {
                        interval = rec.getString("repeatcount") + " T";
                        break;
                    }
                    case 2: {
                        interval = rec.getString("repeatcount") + " W";
                        break;
                    }
                    case 3: {
                        interval = rec.getString("repeatcount") + " M";
                        break;
                    }
                    case 4: {
                        interval = rec.getString("repeatcount") + " J";
                    }
                }
            }
            this.table.addCell(this.createPdfCell(interval, this.formatTable, 1.0f, 1, 2, Color.WHITE, 5.0f));
            int[] months = tbl.get(rec.getLong("observationid"));
            for (int ii = 0; ii < 12; ++ii) {
                this.table.addCell(this.createPdfCell(months[ii] > 0 ? "X" : "", this.formatTable, 1.0f, 1, 2, Color.WHITE, 5.0f));
            }
            this.table.completeRow();
        }
        this.addTable();
        this.addPagebreak();
    }
}

